/******************************************************************************
 * Copyright(c) 2008 - 2010 Realtek Corporation. All rights reserved.
 *
 * Based on the r8180 driver, which is:
 * Copyright 2004-2005 Andrea Merello <andreamrl@tiscali.it>, et al.
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
******************************************************************************/

#ifndef _RTL_CORE_H
#define _RTL_CORE_H

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/slab.h>
#include <linux/netdevice.h>
#include <linux/pci.h>
#include <linux/etherdevice.h>
#include <linux/delay.h>
#include <linux/rtnetlink.h>	
#include <linux/wireless.h>
#include <linux/timer.h>
#include <linux/proc_fs.h>	
#include <linux/if_arp.h>
#include <linux/random.h>
#include <linux/version.h>
#include <asm/io.h>
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,27))
#include <asm/semaphore.h>
#endif
#include "../../ieee80211/ieee80211.h"

#ifdef ENABLE_DOT11D
#include "../../ieee80211/dot11d.h"
#endif

#ifdef RTL8192SE
#include "r8192S_phy.h"
#include "r8192S_phyreg.h"
#include "r8192S_firmware.h"
#include "r8192SE_hw.h"
#else
#include "r819xE_firmware.h"
#include "r8192E_hw.h"
#endif
#ifdef RTL8192SE
#include "rtl8192se.h"
#include "r8192S_led.h"
#include "r8192SE_def.h"
#elif defined RTL8190P || defined RTL8192E
#include "r8190P_def.h"
#endif
#include "r8192S_mp.h"
#include "rtl_debug.h"
#include "rtl_eeprom.h"
#include "rtl_ps.h"
#include "rtl_cam.h"

#define DRV_COPYRIGHT  "Copyright(c) 2008 - 2010 Realtek Corporation"
#define DRV_AUTHOR  "<wlanfae@realtek.com>"
#define DRV_VERSION "V 1.1"

#ifdef RTL8190P
#define DRV_NAME "rtl819xP"
#elif defined RTL8192E
#define DRV_NAME "rtl819xE"
#elif defined RTL8192SE
#define DRV_NAME "rtl819xSE"
#endif

#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0))
#define RTL_PCI_DEVICE(vend, dev, cfg) \
	.vendor = (vend), .device = (dev), \
	.subvendor = PCI_ANY_ID, .subdevice =PCI_ANY_ID , \
	.driver_data = (kernel_ulong_t)&(cfg)
#else
#define RTL_PCI_DEVICE(vend, dev, cfg) \
	.vendor = (vend), .device = (dev), \
	.subvendor = PCI_ANY_ID, .subdevice =PCI_ANY_ID
#endif

#define MAX_KEY_LEN     		61
#define KEY_BUF_SIZE    		5

#define TOTAL_CAM_ENTRY 	32
#define CAM_CONTENT_COUNT 	8

#ifndef BIT
#define BIT(_i)				(1<<(_i))
#endif

#define DMESG(x,a...)
#define DMESGW(x,a...)
#define DMESGE(x,a...)
extern u32 rt_global_debug_component;
#define RT_TRACE(component, x, args...) \
do { if(rt_global_debug_component & component) \
	printk(KERN_DEBUG DRV_NAME ":" x "\n" , \
	       ##args);\
}while(0);

                                       
#define RTL819x_DEBUG                  
#ifdef RTL819x_DEBUG                   
#define assert(expr) \
        if (!(expr)) {                                  \
                printk( "Assertion failed! %s,%s,%s,line=%d\n", \
                #expr,__FILE__,__FUNCTION__,__LINE__);          \
        }
#define RT_DEBUG_DATA(level, data, datalen)      \
        do{ if ((rt_global_debug_component & (level)) == (level))   \
                {       \
                        int _i;                                  \
                        u8* _pdata = (u8*) data;                 \
                        printk(KERN_DEBUG DRV_NAME ": %s()\n", __FUNCTION__);   \
                        for(_i=0; _i<(int)(datalen); _i++)                 \
                        {                                               \
                                printk("%2x ", _pdata[_i]);               \
                                if ((_i+1)%16 == 0) printk("\n");        \
                        }                               \
                        printk("\n");                   \
                }                                       \
        } while (0)  
#else
#define assert(expr) do {} while (0)
#define RT_DEBUG_DATA(level, data, datalen) do {} while(0)
#endif 

#ifdef _RTL8192_EXT_PATCH_
#define IS_UNDER_11N_AES_MODE(_ieee)  ((_ieee->pHTInfo->bCurrentHTSupport == true) &&\
					((_ieee->pairwise_key_type == KEY_TYPE_CCMP) || \
					 (_ieee->mesh_pairwise_key_type == KEY_TYPE_CCMP)))
#else
#define IS_UNDER_11N_AES_MODE(_ieee)  ((_ieee->pHTInfo->bCurrentHTSupport == true) &&\
					(_ieee->pairwise_key_type == KEY_TYPE_CCMP))
#endif

#define HAL_HW_PCI_REVISION_ID_8192PCIE 0x1
#define HAL_HW_PCI_REVISION_ID_8192SE 	0x10

#define RTL819X_DEFAULT_RF_TYPE 	RF_1T2R
#define IEEE80211_WATCH_DOG_TIME    	2000

#define MAX_DEV_ADDR_SIZE		8  /* support till 64 bit bus width OS */
#define MAX_FIRMWARE_INFORMATION_SIZE   32 
#define MAX_802_11_HEADER_LENGTH       	(40 + MAX_FIRMWARE_INFORMATION_SIZE)
#define ENCRYPTION_MAX_OVERHEAD		128
#define MAX_FRAGMENT_COUNT		8
#define MAX_TRANSMIT_BUFFER_SIZE  	(1600+(MAX_802_11_HEADER_LENGTH+ENCRYPTION_MAX_OVERHEAD)*MAX_FRAGMENT_COUNT) 

#define scrclng				4		

#define DEFAULT_FRAG_THRESHOLD 	2342U
#define MIN_FRAG_THRESHOLD     	256U
#define DEFAULT_BEACONINTERVAL 	0x64U

#define DEFAULT_SSID 		""
#define DEFAULT_RETRY_RTS	7
#define DEFAULT_RETRY_DATA 	7
#define PRISM_HDR_SIZE 		64

#define	PHY_RSSI_SLID_WIN_MAX		 	100

#define RTL_IOCTL_WPA_SUPPLICANT		SIOCIWFIRSTPRIV+30

#define TxBBGainTableLength 		        37
#define CCKTxBBGainTableLength 	                23

#define CHANNEL_PLAN_LEN			10
#define sCrcLng 		                4

#define NIC_SEND_HANG_THRESHOLD_NORMAL		4        
#define NIC_SEND_HANG_THRESHOLD_POWERSAVE 	8
#define MAX_TX_QUEUE				9 

#define MAX_RX_COUNT                            64
#define MAX_TX_QUEUE_COUNT                      9        

enum RTL_DEBUG {
	COMP_TRACE		= BIT0,	 
	COMP_DBG		= BIT1,	 
	COMP_INIT		= BIT2,	 
	COMP_RECV		= BIT3,	 
	COMP_SEND		= BIT4,	 
	COMP_CMD		= BIT5,	 
	COMP_POWER	        = BIT6,	 
	COMP_EPROM	        = BIT7,	 
	COMP_SWBW		= BIT8,	 
	COMP_SEC		= BIT9,	 
	COMP_LPS		= BIT10, 
	COMP_QOS		= BIT11, 
	COMP_RATE		= BIT12, 
	COMP_RXDESC	        = BIT13, 
	COMP_PHY		= BIT14, 
	COMP_DIG		= BIT15, 
	COMP_TXAGC		= BIT16, 
	COMP_HALDM	        = BIT17, 
	COMP_POWER_TRACKING	= BIT18, 
	COMP_CH		        = BIT19, 
	COMP_RF		        = BIT20, 
	COMP_FIRMWARE	        = BIT21, 
	COMP_HT		        = BIT22, 
	COMP_RESET		= BIT23,
	COMP_CMDPKT	        = BIT24,
	COMP_SCAN		= BIT25,
	COMP_PS		        = BIT26,
	COMP_DOWN		= BIT27, 
	COMP_INTR 		= BIT28, 
	COMP_LED		= BIT29, 
	COMP_MLME		= BIT30, 
	COMP_ERR		= BIT31  
};

typedef enum{
	NIC_UNKNOWN     = 0,
	NIC_8192E       = 1,
	NIC_8190P       = 2,
	NIC_8192SE      = 4,
	} nic_t;

typedef	enum _RT_EEPROM_TYPE{
	EEPROM_93C46,
	EEPROM_93C56,
	EEPROM_BOOT_EFUSE,
}RT_EEPROM_TYPE,*PRT_EEPROM_TYPE;

typedef enum _tag_TxCmd_Config_Index{
	TXCMD_TXRA_HISTORY_CTRL	        = 0xFF900000,
	TXCMD_RESET_TX_PKT_BUFF		= 0xFF900001,
	TXCMD_RESET_RX_PKT_BUFF		= 0xFF900002,
	TXCMD_SET_TX_DURATION		= 0xFF900003,
	TXCMD_SET_RX_RSSI		= 0xFF900004,
	TXCMD_SET_TX_PWR_TRACKING	= 0xFF900005,
	TXCMD_XXXX_CTRL,
}DCMD_TXCMD_OP;

typedef enum _RT_RF_TYPE_819xU{
        RF_TYPE_MIN = 0,
        RF_8225,
        RF_8256,
        RF_8258,
        RF_6052=4,		
        RF_PSEUDO_11N = 5,
}RT_RF_TYPE_819xU, *PRT_RF_TYPE_819xU;

typedef enum tag_Rf_Operatetion_State
{    
    RF_STEP_INIT = 0,
    RF_STEP_NORMAL,   
    RF_STEP_MAX
}RF_STEP_E;

typedef enum _RT_STATUS{
	RT_STATUS_SUCCESS,
	RT_STATUS_FAILURE,
	RT_STATUS_PENDING,
	RT_STATUS_RESOURCE
}RT_STATUS,*PRT_STATUS;

typedef enum _RT_CUSTOMER_ID
{
	RT_CID_DEFAULT          = 0,
	RT_CID_8187_ALPHA0      = 1,
	RT_CID_8187_SERCOMM_PS  = 2,
	RT_CID_8187_HW_LED      = 3,
	RT_CID_8187_NETGEAR     = 4,
	RT_CID_WHQL             = 5,
	RT_CID_819x_CAMEO       = 6, 
	RT_CID_819x_RUNTOP      = 7,
	RT_CID_819x_Senao       = 8,
	RT_CID_TOSHIBA          = 9,	
	RT_CID_819x_Netcore     = 10,
	RT_CID_Nettronix        = 11,
	RT_CID_DLINK            = 12,
	RT_CID_PRONET           = 13,
	RT_CID_COREGA           = 14,
	RT_CID_819x_ALPHA       = 15,
	RT_CID_819x_Sitecom     = 16,
	RT_CID_CCX              = 17, 
	RT_CID_819x_Lenovo      = 18,	
	RT_CID_819x_QMI         = 19,
	RT_CID_819x_Edimax_Belkin = 20,		
	RT_CID_819x_Sercomm_Belkin = 21,			
	RT_CID_819x_CAMEO1 = 22,
	RT_CID_819x_MSI = 23,
	RT_CID_819x_Acer = 24,
}RT_CUSTOMER_ID, *PRT_CUSTOMER_ID;

typedef enum _RT_OP_MODE{
	RT_OP_MODE_AP,
	RT_OP_MODE_INFRASTRUCTURE,
	RT_OP_MODE_IBSS,
	RT_OP_MODE_NO_LINK,
}RT_OP_MODE, *PRT_OP_MODE;

typedef enum _RESET_TYPE {
	RESET_TYPE_NORESET = 0x00,
	RESET_TYPE_NORMAL = 0x01,
	RESET_TYPE_SILENT = 0x02
} RESET_TYPE;

typedef enum _IC_INFERIORITY_8192S{
	IC_INFERIORITY_A            = 0, 
	IC_INFERIORITY_B            = 1, 
}IC_INFERIORITY_8192S, *PIC_INFERIORITY_8192S;

typedef enum _PCI_BRIDGE_VENDOR {
	PCI_BRIDGE_VENDOR_INTEL = 0x01,
	PCI_BRIDGE_VENDOR_ATI = 0x02,
	PCI_BRIDGE_VENDOR_AMD = 0x04,
	PCI_BRIDGE_VENDOR_SIS = 0x08,
	PCI_BRIDGE_VENDOR_UNKNOWN = 0x40,
	PCI_BRIDGE_VENDOR_MAX = 0x80
} PCI_BRIDGE_VENDOR;

typedef struct buffer
{
	struct buffer *next;
	u32 *buf;
	dma_addr_t dma;
	
} buffer;

typedef struct rtl_reg_debug{
        unsigned int  cmd;
        struct {
                unsigned char type;
                unsigned char addr;
                unsigned char page;
                unsigned char length;
        } head;
        unsigned char buf[0xff];
}rtl_reg_debug;

typedef struct _rt_9x_tx_rate_history {
	u32             cck[4];
	u32             ofdm[8];
	u32             ht_mcs[4][16];
}rt_tx_rahis_t, *prt_tx_rahis_t;

typedef	struct _RT_SMOOTH_DATA_4RF {
	char	elements[4][100];
	u32	index;			
	u32	TotalNum;		
	u32	TotalVal[4];		
}RT_SMOOTH_DATA_4RF, *PRT_SMOOTH_DATA_4RF;

#ifdef _RTL8192_EXT_PATCH_
typedef	struct _RT_SMOOTH_DATA {
	u32	elements[100];	
	u32	index;			
	u32	TotalNum;		
	u32	TotalVal;		
}RT_SMOOTH_DATA, *PRT_SMOOTH_DATA;
#endif
typedef struct Stats
{
	unsigned long txrdu;
	unsigned long rxrdu;
	unsigned long rxok;
	unsigned long rxframgment;
	unsigned long rxcmdpkt[4];		
	unsigned long rxurberr;
	unsigned long rxstaterr;
	unsigned long rxcrcerrmin;
	unsigned long rxcrcerrmid;
	unsigned long rxcrcerrmax;
	unsigned long received_rate_histogram[4][32];	
	unsigned long received_preamble_GI[2][32];		
	unsigned long	rx_AMPDUsize_histogram[5]; 
	unsigned long rx_AMPDUnum_histogram[5]; 
	unsigned long numpacket_matchbssid;	
	unsigned long numpacket_toself;		
	unsigned long num_process_phyinfo;		
	unsigned long numqry_phystatus;
	unsigned long numqry_phystatusCCK;
	unsigned long numqry_phystatusHT;
	unsigned long received_bwtype[5];              
	unsigned long txnperr;
	unsigned long txnpdrop;
	unsigned long txresumed;
	unsigned long rxoverflow;
	unsigned long rxint;
	unsigned long txnpokint;
	unsigned long ints;
	unsigned long shints;
	unsigned long txoverflow;
	unsigned long txlpokint;
	unsigned long txlpdrop;
	unsigned long txlperr;
	unsigned long txbeokint;
	unsigned long txbedrop;
	unsigned long txbeerr;
	unsigned long txbkokint;
	unsigned long txbkdrop;
	unsigned long txbkerr;
	unsigned long txviokint;
	unsigned long txvidrop;
	unsigned long txvierr;
	unsigned long txvookint;
	unsigned long txvodrop;
	unsigned long txvoerr;
	unsigned long txbeaconokint;
	unsigned long txbeacondrop;
	unsigned long txbeaconerr;
	unsigned long txmanageokint;
	unsigned long txmanagedrop;
	unsigned long txmanageerr;
	unsigned long txcmdpktokint;
	unsigned long txdatapkt;
	unsigned long txfeedback;
	unsigned long txfeedbackok;
	unsigned long txoktotal;
	unsigned long txokbytestotal;
	unsigned long txokinperiod;
	unsigned long txmulticast;
	unsigned long txbytesmulticast;
	unsigned long txbroadcast;
	unsigned long txbytesbroadcast;
	unsigned long txunicast;
	unsigned long txbytesunicast;
	unsigned long rxbytesunicast;
	unsigned long txfeedbackfail;
	unsigned long txerrtotal;
	unsigned long txerrbytestotal;
	unsigned long txerrmulticast;
	unsigned long txerrbroadcast;
	unsigned long txerrunicast;
	unsigned long txretrycount;
	unsigned long txfeedbackretry;
	u8			last_packet_rate;
	unsigned long slide_signal_strength[100];
	unsigned long slide_evm[100];
	unsigned long	slide_rssi_total;	
	unsigned long slide_evm_total;	
	long signal_strength; 
	long signal_quality;
	long last_signal_strength_inpercent;
	long	recv_signal_power;	
	u8 rx_rssi_percentage[4];
	u8 rx_evm_percentage[2];
	long rxSNRdB[4];
	rt_tx_rahis_t txrate;
	u32 Slide_Beacon_pwdb[100];	
	u32 Slide_Beacon_Total;		
	RT_SMOOTH_DATA_4RF		cck_adc_pwdb;
	u32	CurrentShowTxate;
#ifdef _RTL8192_EXT_PATCH_
	u32 RssiCalculateCnt;
	RT_SMOOTH_DATA	ui_rssi;
	RT_SMOOTH_DATA ui_link_quality;
#endif
} Stats;

typedef struct 	ChnlAccessSetting {
	u16 SIFS_Timer;
	u16 DIFS_Timer; 
	u16 SlotTimeTimer;
	u16 EIFS_Timer;
	u16 CWminIndex;
	u16 CWmaxIndex;
}*PCHANNEL_ACCESS_SETTING,CHANNEL_ACCESS_SETTING;


typedef struct _txbbgain_struct
{
	long	txbb_iq_amplifygain;
	u32	txbbgain_value;
} txbbgain_struct, *ptxbbgain_struct;

typedef struct _ccktxbbgain_struct
{
	u8	ccktxbb_valuearray[8];
} ccktxbbgain_struct,*pccktxbbgain_struct;

typedef struct _init_gain
{
	u8				xaagccore1;
	u8				xbagccore1;
	u8				xcagccore1;
	u8				xdagccore1;
	u8				cca;

} init_gain, *pinit_gain;

typedef struct _tx_ring{
	u32 * desc;
	u8 nStuckCount;
	struct _tx_ring * next;
}__attribute__ ((packed)) tx_ring, * ptx_ring;

struct rtl8192_tx_ring {
    tx_desc *desc;
    dma_addr_t dma;
    unsigned int idx;
    unsigned int entries;
    struct sk_buff_head queue;
};



struct rtl819x_ops{
	nic_t nic_type;
	void (* get_eeprom_size)(struct net_device* dev);
	bool (* initialize_adapter)(struct net_device* dev);
	void (*link_change)(struct net_device* dev);
	void (* tx_fill_descriptor)(struct net_device* dev, tx_desc * tx_desc, cb_desc * cb_desc, struct sk_buff *skb);
	void (* tx_fill_cmd_descriptor)(struct net_device* dev, tx_desc_cmd * entry, cb_desc * cb_desc, struct sk_buff *skb); 
	bool (* rx_query_status_descriptor)(struct net_device* dev, struct ieee80211_rx_stats*  stats, rx_desc *pdesc, struct sk_buff* skb);
	void (* stop_adapter)(struct net_device *dev, bool reset);
#ifdef RTL8192SE
	void (* update_ratr_table)(struct net_device* dev,u8* pMcsRate,struct sta_info* pEntry);
#else
	void (* update_ratr_table)(struct net_device* dev);
#endif
};

typedef struct r8192_priv
{
	struct pci_dev *pdev;
#ifdef RTL8192SE
	struct pci_dev *bridge_pdev;
#endif	
#ifdef _RTL8192_EXT_PATCH_
	u8      rssi_level;
#endif	
	struct rtl819x_ops* ops;
	bool bfirst_init;
	LOG_INTERRUPT_8190_T InterruptLog;
	bool bIgnoreSilentReset;
	u32 	SilentResetRxSoltNum;
	u32	SilentResetRxSlotIndex;
#ifdef RTL8192SE
	u32	SilentResetRxStuckEvent[MAX_SILENT_RESET_RX_SLOT_NUM];
#endif
	RT_CUSTOMER_ID CustomerID;
	bool	being_init_adapter;
	bool	sw_radio_on;
	u8	IC_Cut;
	int irq;
	short irq_enabled;
	struct ieee80211_device *ieee80211;
	u8 Rf_Mode;
	nic_t card_8192; 
	u8 card_8192_version; 
	short enable_gpio0;
	enum card_type {PCI,MINIPCI,CARDBUS,USB}card_type;
	short hw_plcp_len;
	short plcp_preamble_mode;
	u8 ScanDelay;	
	spinlock_t irq_lock;
	spinlock_t irq_th_lock;
	spinlock_t tx_lock;
	spinlock_t rf_ps_lock;
	spinlock_t rw_lock;
#ifdef RTL8192SE_CONFIG_ASPM_OR_D3
	spinlock_t D3_lock;
#endif
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,16))
	struct semaphore mutex;
#else
	struct mutex mutex;
#endif
	bool ps_force;
	spinlock_t rf_lock; 
	spinlock_t ps_lock;

	u32 irq_mask[2];
	short chan;
	short sens;
	short max_sens;
	u32 rx_prevlen;
	rx_desc *rx_ring;
	dma_addr_t rx_ring_dma;
	unsigned int rx_idx;
	struct sk_buff *rx_buf[MAX_RX_COUNT];
	int rxringcount;
	u16 rxbuffersize;

	struct sk_buff *rx_skb;
	u32 *rxring;
	u32 *rxringtail;
	dma_addr_t rxringdma;
	struct buffer *rxbuffer;
	struct buffer *rxbufferhead;
	short rx_skb_complete;
	struct rtl8192_tx_ring tx_ring[MAX_TX_QUEUE_COUNT];
	int txringcount;
	int txbuffsize;
	int txfwbuffersize;
	struct tasklet_struct irq_rx_tasklet;
	struct tasklet_struct irq_tx_tasklet;
	struct tasklet_struct irq_prepare_beacon_tasklet;
	struct buffer *txmapbufs;
	struct buffer *txbkpbufs;
	struct buffer *txbepbufs;
	struct buffer *txvipbufs;	
	struct buffer *txvopbufs;
	struct buffer *txcmdbufs;
	struct buffer *txmapbufstail;
	struct buffer *txbkpbufstail;
	struct buffer *txbepbufstail;
	struct buffer *txvipbufstail;      
	struct buffer *txvopbufstail;
	struct buffer *txcmdbufstail;
	ptx_ring txbeaconringtail;
	dma_addr_t txbeaconringdma;
	ptx_ring txbeaconring;
	int txbeaconcount;
	struct buffer *txbeaconbufs;
	struct buffer *txbeaconbufstail;
	ptx_ring txmapring;
	ptx_ring txbkpring;
	ptx_ring txbepring;
	ptx_ring txvipring;
	ptx_ring txvopring;
	ptx_ring txcmdring;
	ptx_ring txmapringtail;
	ptx_ring txbkpringtail;
	ptx_ring txbepringtail;
	ptx_ring txvipringtail;
	ptx_ring txvopringtail;
	ptx_ring txcmdringtail;
	ptx_ring txmapringhead;
	ptx_ring txbkpringhead;
	ptx_ring txbepringhead;
	ptx_ring txvipringhead;
	ptx_ring txvopringhead;
	ptx_ring txcmdringhead;
	dma_addr_t txmapringdma;
	dma_addr_t txbkpringdma;
	dma_addr_t txbepringdma;
	dma_addr_t txvipringdma;
	dma_addr_t txvopringdma;
	dma_addr_t txcmdringdma;
	short up;
	short up_first_time;
#ifdef _RTL8192_EXT_PATCH_
	short mesh_up;
#endif
	short crcmon; 
	struct semaphore wx_sem;
	struct semaphore rf_sem; 
	u8 rf_type; 
	RT_RF_TYPE_819xU rf_chip;
	char nick[IW_ESSID_MAX_SIZE + 1];

	short (*rf_set_sens)(struct net_device *dev,short sens);
	u8 (*rf_set_chan)(struct net_device *dev,u8 ch);
	void (*rf_close)(struct net_device *dev);
	void (*rf_init)(struct net_device *dev);
	short promisc;	
	/*stats*/
	struct Stats stats;
	struct iw_statistics wstats;
	struct proc_dir_entry *dir_dev;

	struct sk_buff_head rx_queue;
	struct sk_buff_head skb_queue;
	work_struct_rsl qos_activate;
	short  tx_urb_index;
	atomic_t tx_pending[0x10];

	struct urb *rxurb_task;

	u16	ShortRetryLimit;
	u16	LongRetryLimit;
	u32	TransmitConfig;
	u8	RegCWinMin;		
#ifdef _RTL8192_EXT_PATCH_
	u32     NumTxUnicast; 
	u8      keepAliveLevel; 
#endif	

	u32     LastRxDescTSFHigh;
	u32     LastRxDescTSFLow;


	u16	EarlyRxThreshold;
	u32	ReceiveConfig;
	u8	AcmControl;

	u8	RFProgType;

	u8 retry_data;
	u8 retry_rts;
	u16 rts;

	struct 	ChnlAccessSetting  ChannelAccessSetting;

	work_struct_rsl reset_wq;

#ifdef CONFIG_RTLWIFI_DEBUGFS
	rtl_fs_debug *debug;
#endif /* CONFIG_IWLWIFI_DEBUGFS */

	/**********************************************************/
	u16	basic_rate;
	u8	short_preamble;
	u8 	slot_time;
	u16 SifsTime;
	u8 RegWirelessMode;
	prt_firmware		pFirmware;
	rtl819x_loopback_e	LoopbackMode;
	firmware_source_e	firmware_source;
	u16 rf_pathmap;
	bool AutoloadFailFlag;
	short epromtype;
	u16 eeprom_vid;
	u16 eeprom_did;
	u16 eeprom_svid;
	u16 eeprom_smid;
	u8  eeprom_CustomerID;
	u16  eeprom_ChannelPlan;
	u8 eeprom_version;
	u8					EfuseMap[2][HWSET_MAX_SIZE_92S];
	u16					EfuseUsedBytes;
	u8					EfuseUsedPercentage;

#ifdef EFUSE_REPG_WORKAROUND 
	bool					efuse_RePGSec1Flag;
	u8					efuse_RePGData[8];
#endif
	u8 EEPROMRegulatory;
	u8 EEPROMPwrGroup[2][3];
	u8 EEPROMOptional;	
	u8 ThermalValue;
	long EntryMinUndecoratedSmoothedPWDB;
	long EntryMaxUndecoratedSmoothedPWDB;
	u8 DynamicTxHighPowerLvl;  
	u8 LastDTPLvl;
	u32 CurrentRATR0;
	FALSE_ALARM_STATISTICS FalseAlmCnt;

	bool bInformFWDriverControlDM;
	u8 PwrGroupHT20[2][14];
	u8 PwrGroupHT40[2][14];
	u16 FwCmdIOMap;
	u32 FwCmdIOParam;
	bool bSupportASPM; 
	u32 RfRegChnlVal[2];
	u8 DMFlag; 
	u8 DM_Type; 
	u8 ShowRateMode;
	u8 RATRTableBitmap;

#if (EEPROM_OLD_FORMAT_SUPPORT == 1)
	u8					EEPROMTxPowerLevelCCK[14];		
	u8					EEPROMTxPowerLevelOFDM24G[14];	
	u8					EEPROMTxPowerLevelOFDM5G[24];	
#else
	u8					RfCckChnlAreaTxPwr[2][3];	
	u8					RfOfdmChnlAreaTxPwr1T[2][3];	
	u8					RfOfdmChnlAreaTxPwr2T[2][3];	
#endif	
	u8					EEPROMRfACCKChnl1TxPwLevel[3];	
	u8					EEPROMRfAOfdmChnlTxPwLevel[3];
	u8					EEPROMRfCCCKChnl1TxPwLevel[3];	
	u8					EEPROMRfCOfdmChnlTxPwLevel[3];

	u16 EEPROMTxPowerDiff;
	u16 EEPROMAntPwDiff;		
	u8 EEPROMThermalMeter;
	u8 EEPROMPwDiff;
	u8 EEPROMCrystalCap;
	u8 EEPROMBluetoothCoexist;	
	u8 EEPROMBoardType;
	u8 EEPROM_Def_Ver;
	u8 EEPROMHT2T_TxPwr[6];			
	u8 EEPROMTSSI_A;
	u8 EEPROMTSSI_B;
	u8 EEPROMTxPowerLevelCCK_V1[3];
	u8 EEPROMLegacyHTTxPowerDiff;	
	bool bTXPowerDataReadFromEEPORM;
	u16 RegChannelPlan; 
	u16 ChannelPlan;
	bool bChnlPlanFromHW;
	bool RegRfOff;
	bool isRFOff;
	bool bInPowerSaveMode;
	u8	bHwRfOffAction;	
	BB_REGISTER_DEFINITION_T	PHYRegDef[4];	
	u8					pwrGroupCnt;
#ifdef RTL8192SE
	u32	MCSTxPowerLevelOriginalOffset[4][7];
#else
	u32	MCSTxPowerLevelOriginalOffset[6];
#endif
	u32	CCKTxPowerLevelOriginalOffset;
	u8	TxPowerLevelCCK[14];			
	u8	TxPowerLevelCCK_A[14];			
	u8 	TxPowerLevelCCK_C[14];
	u8	TxPowerLevelOFDM24G[14];		
	u8	TxPowerLevelOFDM5G[14];			
	u8	TxPowerLevelOFDM24G_A[14];	
	u8	TxPowerLevelOFDM24G_C[14];	
	u8	LegacyHTTxPowerDiff;			
	u8	TxPowerDiff;
	s8	RF_C_TxPwDiff;					
	s8	RF_B_TxPwDiff;
	u8 	RfTxPwrLevelCck[2][14];
	u8	RfTxPwrLevelOfdm1T[2][14];
	u8	RfTxPwrLevelOfdm2T[2][14];
	u8	AntennaTxPwDiff[3];				
	u8	TxPwrHt20Diff[2][14];				
	u8	TxPwrLegacyHtDiff[2][14];		
#if 0
	u8	TxPwrbandEdgeHt40[2][2];		
	u8	TxPwrbandEdgeHt20[2][2];		
	u8	TxPwrbandEdgeLegacyOfdm[2][2];	
#endif
	u8	TxPwrSafetyFlag;				
	u8	HT2T_TxPwr_A[14]; 				
	u8	HT2T_TxPwr_B[14]; 				
	u8	CurrentCckTxPwrIdx;
	u8 	CurrentOfdm24GTxPwrIdx;

	u8	CrystalCap;						
	u8	ThermalMeter[2];	
	u8      BluetoothCoexist;
	IC_INFERIORITY_8192S IC_Class;

	u8	CckPwEnl;
	u16	TSSI_13dBm;
	u32 	Pwr_Track;
	u8				CCKPresentAttentuation_20Mdefault;
	u8				CCKPresentAttentuation_40Mdefault;
	char				CCKPresentAttentuation_difference;
	char				CCKPresentAttentuation;
	u8	bCckHighPower;
	long	undecorated_smoothed_pwdb;
	long	undecorated_smoothed_cck_adc_pwdb[4];
	u8	SwChnlInProgress;
	u8 	SwChnlStage;
	u8	SwChnlStep;
	u8	SetBWModeInProgress;
	HT_CHANNEL_WIDTH		CurrentChannelBW;

	u8	nCur40MhzPrimeSC;	
	u32					RfReg0Value[4];
	u8 					NumTotalRFPath;	
	bool 				brfpath_rxenable[4];
	struct timer_list watch_dog_timer;	

	bool	bdynamic_txpower;  
	bool	bDynamicTxHighPower;  
	bool	bDynamicTxLowPower;  
	bool	bLastDTPFlag_High;
	bool	bLastDTPFlag_Low;

	bool	bstore_last_dtpflag;
	bool	bstart_txctrl_bydtp;   
	rate_adaptive rate_adaptive;
	txbbgain_struct txbbgain_table[TxBBGainTableLength];
	u8			   txpower_count;
	bool			   btxpower_trackingInit;
	u8			   OFDM_index;
	u8			   CCK_index;
	u8			   Record_CCK_20Mindex;
	u8			   Record_CCK_40Mindex;
	ccktxbbgain_struct	cck_txbbgain_table[CCKTxBBGainTableLength];
	ccktxbbgain_struct	cck_txbbgain_ch14_table[CCKTxBBGainTableLength];
	u8 rfa_txpowertrackingindex;
	u8 rfa_txpowertrackingindex_real;
	u8 rfa_txpowertracking_default;
	u8 rfc_txpowertrackingindex;
	u8 rfc_txpowertrackingindex_real;
	u8 rfc_txpowertracking_default;
	bool btxpower_tracking;
	bool bcck_in_ch14;

	init_gain initgain_backup;
	u8 		DefaultInitialGain[4];
	bool		bis_any_nonbepkts;
	bool		bcurrent_turbo_EDCA;

	bool SetFwCmdInProgress; 
	u8 CurrentFwCmdIO;

	u8 	MidHighPwrTHR_L1;
	u8 	MidHighPwrTHR_L2;


	bool		bis_cur_rdlstate;
	struct timer_list fsync_timer;
	bool bfsync_processing;	
	u32 	rate_record;
	u32 	rateCountDiffRecord;
	u32	ContiuneDiffCount;
	bool bswitch_fsync;

	u8	framesync;
	u32 	framesyncC34;
	u8   	framesyncMonitor;
	u16 	nrxAMPDU_size;
	u8 	nrxAMPDU_aggr_num;

	u32 last_rxdesc_tsf_high;
	u32 last_rxdesc_tsf_low;

	bool bHwRadioOff;
	bool pwrdown;
	bool blinked_ingpio;
	bool aspm_clkreq_enable;
	u32 pci_bridge_vendor;
	u8 RegHostPciASPMSetting;
	int PciBridgeASPMRegOffset;
	u8 PciBridgeLinkCtrlReg;
	u8 RegDevicePciASPMSetting;
	int ASPMRegOffset;
	int ClkReqOffset;
	u8 LinkCtrlReg;

	bool RFChangeInProgress; 
	bool SetRFPowerStateInProgress;
	bool bdisable_nic;
	RT_OP_MODE OpMode;
	u32 reset_count;
	bool bpbc_pressed;
	u32 txpower_checkcnt;
	u32 txpower_tracking_callback_cnt;
	u8 thermal_read_val[40];
	u8 thermal_readback_index;
	u32 ccktxpower_adjustcnt_not_ch14;
	u32 ccktxpower_adjustcnt_ch14;
	u8 tx_fwinfo_force_subcarriermode;
	u8 tx_fwinfo_force_subcarrierval;

	RESET_TYPE	ResetProgress;
	bool		bForcedSilentReset;
	bool		bDisableNormalResetCheck;
	u16		TxCounter;
	u16		RxCounter;
	int		IrpPendingCount;
	bool		bResetInProgress;
	bool		force_reset;
	bool		force_lps;
	u8		InitialGainOperateType;
#ifdef RTL8192SE
	LED_STRATEGY_8190	LedStrategy;  
	LED_8190			SwLed0;
	LED_8190			SwLed1;
#endif
	delayed_work_struct_rsl update_beacon_wq;
	delayed_work_struct_rsl watch_dog_wq;    
	delayed_work_struct_rsl txpower_tracking_wq;
	delayed_work_struct_rsl rfpath_check_wq;
	delayed_work_struct_rsl gpio_change_rf_wq;
	delayed_work_struct_rsl initialgain_operate_wq;
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)  
	struct workqueue_struct *priv_wq;
#else
	u32 *priv_wq;
#endif
	struct timer_list gpio_polling_timer;
	u8     polling_timer_on;
	bool bDriverIsGoingToUnload;
#ifdef _RTL8192_EXT_PATCH_
	struct mshclass			*mshobj;
#endif

	bool	chan_forced;
	bool bSingleCarrier;
	bool RegBoard;
	bool	bCckContTx; 
 	bool	bOfdmContTx; 
	bool	bStartContTx; 
	u8	RegPaModel; 
	u8	btMpCckTxPower; 
	u8	btMpOfdmTxPower; 

	u32	MptActType; 	
	u32	MptIoOffset; 
	u32	MptIoValue; 
	u32	MptRfPath;

	u32	MptBandWidth;			
	u32	MptRateIndex;			
	u8	MptChannelToSw; 		
	u32  MptRCR;
}r8192_priv;


#ifdef _RTL8192_EXT_PATCH_
struct meshdev_priv {
	struct net_device_stats stats;
	struct ieee80211_device *ieee80211;
	struct r8192_priv * priv;
};
#endif

extern const struct ethtool_ops rtl819x_ethtool_ops;

#ifdef RTL8192SE
void rtl8192se_get_eeprom_size(struct net_device* dev);
bool rtl8192se_adapter_start(struct net_device* dev);
void rtl8192se_link_change(struct net_device *dev);
void  rtl8192se_tx_fill_cmd_desc(struct net_device* dev, tx_desc_cmd * entry, cb_desc * cb_desc, struct sk_buff* skb);
void  rtl8192se_tx_fill_desc(struct net_device* dev, tx_desc * pDesc, cb_desc * cb_desc, struct sk_buff* skb);
bool rtl8192se_rx_query_status_desc(struct net_device* dev, struct ieee80211_rx_stats*  stats, rx_desc *pdesc, struct sk_buff* skb);
void rtl8192se_rtx_disable(struct net_device *dev, bool bReset);
void rtl8192se_update_ratr_table(struct net_device* dev,u8* pMcsRate,struct sta_info* pEntry);
bool rtl8192se_check_ht_cap(struct net_device* dev, struct sta_info *sta, struct ieee80211_network* net);
#else
void rtl8192_get_eeprom_size(struct net_device* dev);
bool rtl8192_adapter_start(struct net_device *dev);
void rtl8192_link_change(struct net_device *dev);
void  rtl8192_tx_fill_cmd_desc(struct net_device* dev, tx_desc_cmd * entry, cb_desc * cb_desc, struct sk_buff* skb);
void  rtl8192_tx_fill_desc(struct net_device* dev, tx_desc * pdesc, cb_desc * cb_desc, struct sk_buff* skb);
bool rtl8192_rx_query_status_desc(struct net_device* dev, struct ieee80211_rx_stats*  stats, rx_desc *pdesc, struct sk_buff* skb);
void rtl8192_rtx_disable(struct net_device *dev, bool reset);
void rtl8192_update_ratr_table(struct net_device* dev);
#endif

bool init_firmware(struct net_device *dev);
void rtl819xE_tx_cmd(struct net_device *dev, struct sk_buff *skb);
short rtl8192_tx(struct net_device *dev, struct sk_buff* skb);
u8 read_nic_byte(struct net_device *dev, int x);
u8 read_nic_byte_E(struct net_device *dev, int x);
u32 read_nic_dword(struct net_device *dev, int x);
u16 read_nic_word(struct net_device *dev, int x) ;
void write_nic_byte(struct net_device *dev, int x,u8 y);
void write_nic_byte_E(struct net_device *dev, int x,u8 y);
void write_nic_word(struct net_device *dev, int x,u16 y);
void write_nic_dword(struct net_device *dev, int x,u32 y);
void force_pci_posting(struct net_device *dev);

void rtl8192_rx_enable(struct net_device *);
void rtl8192_tx_enable(struct net_device *);

void rtl8192_disassociate(struct net_device *dev);
void rtl8185_set_rf_pins_enable(struct net_device *dev,u32 a);

int rtl8192_hard_start_xmit(struct sk_buff *skb,struct net_device *dev);
void rtl8192_hard_data_xmit(struct sk_buff *skb, struct net_device *dev, int rate);
void rtl8192_data_hard_stop(struct net_device *dev);
void rtl8192_data_hard_resume(struct net_device *dev);
void rtl8192_restart(void *data);
void rtl819x_watchdog_wqcallback(void *data);
void rtl8192_hw_sleep_wq (void *data);
void watch_dog_timer_callback(unsigned long data);
void rtl8192_irq_rx_tasklet(struct r8192_priv *priv);
void rtl8192_irq_tx_tasklet(struct r8192_priv *priv);
void rtl8192_update_msr(struct net_device *dev);
int rtl8192_down(struct net_device *dev,bool shutdownrf);
int rtl8192_up(struct net_device *dev);
void rtl8192_commit(struct net_device *dev);
void rtl8192_set_chan(struct net_device *dev,short ch);

void rtl8192_start_beacon(struct net_device *dev);

extern void firmware_init_param(struct net_device *dev);
extern bool cmpk_message_handle_tx(struct net_device *dev, u8* codevirtualaddress, u32 packettype, u32 buffer_len);
void rtl8192_hw_wakeup_wq(void *data);

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,18)
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
void rtl8192_interrupt(int irq, void *netdev, struct pt_regs *regs);
#else
irqreturn_t rtl8192_interrupt(int irq, void *netdev, struct pt_regs *regs);
#endif
#else
irqreturn_t rtl8192_interrupt(int irq, void *netdev);
#endif

short rtl8192_pci_initdescring(struct net_device *dev);

void rtl8192_cancel_deferred_work(struct r8192_priv* priv);

#ifdef _RTL8192_EXT_PATCH_
int _rtl8192_up(struct net_device *dev,bool is_silent_reset);
#else
int _rtl8192_up(struct net_device *dev);
#endif

short rtl8192_is_tx_queue_empty(struct net_device *dev);
#ifdef RTL8192SE
void rtl8192_irq_disable(struct net_device *dev);
#ifndef _RTL8192_EXT_PATCH_
void UpdateHalRAMask8192SE(struct net_device* dev,bool bMulticast, u8 macId, u8* MacAddr, u8* pEntry, u8 rssi_level);
#else
void UpdateHalRAMask8192SE(struct net_device* dev, bool bMulticast, u8 macId, u8* MacAddr, u8 wirelessMode, 	u8 rssi_level);
#endif
void GetHwReg8192SE(struct net_device *dev,u8 variable,u8* val);
void SetHwReg8192SE(struct net_device *dev,u8 variable,u8* val);
void SwLedOn(struct net_device *dev , PLED_8190 pLed);
void SwLedOff(struct net_device *dev, PLED_8190 pLed);
void Adhoc_InitRateAdaptive(struct net_device *dev,struct sta_info  *pEntry);
void SetBeaconRelatedRegisters8192SE(struct net_device *dev);

#if LINUX_VERSION_CODE >=KERNEL_VERSION(2,6,20)
void rtl8192se_check_tsf_wq(struct work_struct * work);
void rtl8192se_update_peer_ratr_table_wq(struct work_struct * work);
#else
void rtl8192se_check_tsf_wq(struct net_device *dev);
void rtl8192se_update_peer_ratr_table_wq(struct net_device *dev);
#endif
#endif

void check_rfctrl_gpio_timer(unsigned long data);
bool NicIFEnableNIC(struct net_device* dev);
RT_STATUS NicIFDisableNIC(struct net_device* dev);
u8 HalSetSysClk8192SE(struct net_device *dev, u8 Data);
void gen_RefreshLedState(struct net_device *dev);
#ifdef _RTL8192_EXT_PATCH_
#ifdef MESH_ABBR_HANDSHK_SUPPORT
extern int r8192_mesh_set_enc_ext(struct net_device *dev, struct iw_point *encoding, struct iw_encode_ext *ext, u8 *addr);
#endif
#endif
#define IS_HARDWARE_TYPE_8192SE(dev) (((struct r8192_priv*)ieee80211_priv(dev))->card_8192 == NIC_8192SE)
extern void dm_InitRateAdaptiveMask(struct net_device * dev);

void tx_timeout(struct net_device *dev);
void rtl8192_pci_resetdescring(struct net_device *dev);
void rtl8192_SetWirelessMode(struct net_device* dev, u8 wireless_mode);
void rtl8192_irq_enable(struct net_device *dev);
void rtl8192_config_rate(struct net_device* dev, u16* rate_config);
void rtl8192_update_cap(struct net_device* dev, u16 cap);
u8 QueryIsShort(u8 TxHT, u8 TxRate, cb_desc *tcb_desc);
u8 MapHwQueueToFirmwareQueue(u8 QueueID, u8 priority);
void UpdateReceivedRateHistogramStatistics8190(struct net_device *dev, struct ieee80211_rx_stats *pstats);
void UpdateRxPktTimeStamp8190 (struct net_device *dev, struct ieee80211_rx_stats *stats);
void TranslateRxSignalStuff819xpci(struct net_device *dev, struct sk_buff *skb, 
		struct ieee80211_rx_stats * pstats, prx_desc pdesc, prx_fwinfo pdrvinfo);
#endif


