/******************************************************************************
 * Copyright(c) 2008 - 2010 Realtek Corporation. All rights reserved.
 *
 * Based on the r8180 driver, which is:
 * Copyright 2004-2005 Andrea Merello <andreamrl@tiscali.it>, et al.
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
******************************************************************************/
#undef LOOP_TEST
#undef RX_DONT_PASS_UL
#undef DEBUG_EPROM
#undef DEBUG_RX_VERBOSE
#undef DUMMY_RX
#undef DEBUG_ZERO_RX
#undef DEBUG_RX_SKB
#undef DEBUG_TX_FRAG
#undef DEBUG_RX_FRAG
#undef DEBUG_TX_FILLDESC
#undef DEBUG_TX
#undef DEBUG_IRQ
#undef DEBUG_RX
#undef DEBUG_RXALLOC
#undef DEBUG_REGISTERS
#undef DEBUG_RING
#undef DEBUG_IRQ_TASKLET
#undef DEBUG_TX_ALLOC
#undef DEBUG_TX_DESC

#include <asm/uaccess.h>
#include <linux/pci.h>
#include "rtl_core.h"
#ifdef RTL8192SE
#include "r8192S_phy.h" 
#include "r8192S_phyreg.h"
#include "r8192S_rtl6052.h"
#include "r8192S_Efuse.h"
#else
#include "r819xE_phy.h" 
#include "r819xE_phyreg.h"
#include "r8190_rtl8256.h" 
#include "r819xE_cmdpkt.h"
#endif

#include "rtl_wx.h"
#include "r8192E_dm.h"

#ifdef CONFIG_PM_RTL
#include "rtl_pm.h"
#endif

#ifdef _RTL8192_EXT_PATCH_
#include "../../mshclass/msh_class.h"
#include "rtl_mesh.h"
#endif

int hwwep = 1; 
static int channels = 0x3fff;
#ifdef _RTL8192_EXT_PATCH_
char* ifname = "ra%d";
#else
char* ifname = "wlan%d";
#endif

u32 rt_global_debug_component = \
				COMP_DOWN	|
				COMP_SEC	|
				COMP_ERR ; 

#ifdef RTL8192SE
struct rtl819x_ops rtl8192se_ops = {
	.nic_type = NIC_8192SE,
	.get_eeprom_size = rtl8192se_get_eeprom_size,
	.initialize_adapter = rtl8192se_adapter_start,
	.link_change = rtl8192se_link_change,
	.tx_fill_descriptor = rtl8192se_tx_fill_desc,
	.tx_fill_cmd_descriptor = rtl8192se_tx_fill_cmd_desc,
	.rx_query_status_descriptor = rtl8192se_rx_query_status_desc,
	.stop_adapter = rtl8192se_rtx_disable,
	.update_ratr_table = rtl8192se_update_ratr_table,
};
#else
struct rtl819x_ops rtl819xp_ops = {
	.nic_type = NIC_UNKNOWN,
	.get_eeprom_size = rtl8192_get_eeprom_size,
	.initialize_adapter = rtl8192_adapter_start,
	.link_change = rtl8192_link_change,
	.tx_fill_descriptor = rtl8192_tx_fill_desc,
	.tx_fill_cmd_descriptor = rtl8192_tx_fill_cmd_desc,
	.rx_query_status_descriptor = rtl8192_rx_query_status_desc,
	.stop_adapter = rtl8192_rtx_disable,
	.update_ratr_table = rtl8192_update_ratr_table,
};
#endif

static struct pci_device_id rtl8192_pci_id_tbl[] __devinitdata = {
#ifdef RTL8190P
	/* Realtek */
	/* Dlink */
	{RTL_PCI_DEVICE(0x10ec, 0x8190, rtl819xp_ops)},
	/* Corega */
	{RTL_PCI_DEVICE(0x07aa, 0x0045, rtl819xp_ops)},
	{RTL_PCI_DEVICE(0x07aa, 0x0046, rtl819xp_ops)},
#elif defined(RTL8192E)
	/* Realtek */
	{RTL_PCI_DEVICE(0x10ec, 0x8192, rtl819xp_ops)},
	/* Corega */
	{RTL_PCI_DEVICE(0x07aa, 0x0044, rtl819xp_ops)},
	{RTL_PCI_DEVICE(0x07aa, 0x0047, rtl819xp_ops)},
#else	/*8192SE*/
	{RTL_PCI_DEVICE(0x10ec, 0x8171, rtl8192se_ops)},
	{RTL_PCI_DEVICE(0x10ec, 0x8172, rtl8192se_ops)},
	{RTL_PCI_DEVICE(0x10ec, 0x8173, rtl8192se_ops)},
	{RTL_PCI_DEVICE(0x10ec, 0x8174, rtl8192se_ops)},
#endif
	{}
};
MODULE_DEVICE_TABLE(pci, rtl8192_pci_id_tbl);

static int __devinit rtl8192_pci_probe(struct pci_dev *pdev,
			 const struct pci_device_id *id);
static void __devexit rtl8192_pci_disconnect(struct pci_dev *pdev);

static struct pci_driver rtl8192_pci_driver = {
	.name		= DRV_NAME,	          /* Driver name   */
	.id_table	= rtl8192_pci_id_tbl,	          /* PCI_ID table  */
	.probe		= rtl8192_pci_probe,	          /* probe fn      */
	.remove		= __devexit_p(rtl8192_pci_disconnect),	  /* remove fn     */
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 5, 0)
#ifdef CONFIG_PM_RTL
	.suspend	= rtl8192E_suspend,	          /* PM suspend fn */
	.resume		= rtl8192E_resume,                 /* PM resume fn  */
#else
	.suspend	= NULL,			          /* PM suspend fn */
	.resume      	= NULL,			          /* PM resume fn  */
#endif
#endif
};

/****************************************************************************
   -----------------------------IO STUFF-------------------------
*****************************************************************************/
#ifdef CONFIG_RTL8180_IO_MAP
u8 read_nic_byte(struct net_device *dev, int x) 
{
        return 0xff&inb(dev->base_addr +x);
}

u32 read_nic_dword(struct net_device *dev, int x) 
{
        return inl(dev->base_addr +x);
}

u16 read_nic_word(struct net_device *dev, int x) 
{
        return inw(dev->base_addr +x);
}

void write_nic_byte(struct net_device *dev, int x,u8 y)
{
        outb(y&0xff,dev->base_addr +x);
}

void write_nic_word(struct net_device *dev, int x,u16 y)
{
        outw(y,dev->base_addr +x);
}

void write_nic_dword(struct net_device *dev, int x,u32 y)
{
        outl(y,dev->base_addr +x);
}
#else /* RTL_IO_MAP */
u8 read_nic_byte(struct net_device *dev, int x) 
{
#ifdef CONFIG_LOCK_READ_AND_WRITE
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);	
	unsigned long flags;
	u8 val = 0;	

	spin_lock_irqsave(&priv->rw_lock, flags);
	val = 0xff&readb((u8*)dev->mem_start +x);
	spin_unlock_irqrestore(&priv->rw_lock, flags);
	
	return val;
#else
        return 0xff&readb((u8*)dev->mem_start +x);
#endif
}

u32 read_nic_dword(struct net_device *dev, int x) 
{
#ifdef CONFIG_LOCK_READ_AND_WRITE
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);	
	unsigned long flags;
	u32 val = 0;	
	
	spin_lock_irqsave(&priv->rw_lock, flags);
	val = readl((u8*)dev->mem_start +x);
	spin_unlock_irqrestore(&priv->rw_lock, flags);

	return val;
#else
        return readl((u8*)dev->mem_start +x);
#endif
}

u16 read_nic_word(struct net_device *dev, int x) 
{
#ifdef CONFIG_LOCK_READ_AND_WRITE
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);	
	unsigned long flags;
	u16 val = 0;	
	
	spin_lock_irqsave(&priv->rw_lock, flags);
	val = readw((u8*)dev->mem_start +x);
	spin_unlock_irqrestore(&priv->rw_lock, flags);

	return val;
#else
        return readw((u8*)dev->mem_start +x);
#endif
}

void write_nic_byte(struct net_device *dev, int x,u8 y)
{
#ifdef CONFIG_LOCK_READ_AND_WRITE
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);	
	unsigned long flags;
	
	spin_lock_irqsave(&priv->rw_lock, flags);
        writeb(y,(u8*)dev->mem_start +x);
	spin_unlock_irqrestore(&priv->rw_lock, flags);
#else
        writeb(y,(u8*)dev->mem_start +x);
#endif
}

void write_nic_dword(struct net_device *dev, int x,u32 y)
{
#ifdef CONFIG_LOCK_READ_AND_WRITE
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);	
	unsigned long flags;
	
	spin_lock_irqsave(&priv->rw_lock, flags);
        writel(y,(u8*)dev->mem_start +x);
	spin_unlock_irqrestore(&priv->rw_lock, flags);
#else
        writel(y,(u8*)dev->mem_start +x);
#endif
}

void write_nic_word(struct net_device *dev, int x,u16 y) 
{
#ifdef CONFIG_LOCK_READ_AND_WRITE
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);	
	unsigned long flags;
	
	spin_lock_irqsave(&priv->rw_lock, flags);
        writew(y,(u8*)dev->mem_start +x);
	spin_unlock_irqrestore(&priv->rw_lock, flags);
#else
        writew(y,(u8*)dev->mem_start +x);
#endif
}
#endif /* RTL_IO_MAP */

/****************************************************************************
   -----------------------------GENERAL FUNCTION-------------------------
*****************************************************************************/
short get_nic_desc_num(struct net_device *dev, int prio)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    struct rtl8192_tx_ring *ring = &priv->tx_ring[prio];

    /* For now, we reserved two free descriptor as a safety boundary 
     * between the tail and the head 
     */
    if((prio == MGNT_QUEUE) &&(skb_queue_len(&ring->queue)>10))
    	printk("-----[%d]---------ring->idx=%d queue_len=%d---------\n",
			prio,ring->idx, skb_queue_len(&ring->queue));
    return skb_queue_len(&ring->queue);
}

short check_nic_enough_desc(struct net_device *dev, int prio)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    struct rtl8192_tx_ring *ring = &priv->tx_ring[prio];

    if (ring->entries - skb_queue_len(&ring->queue) >= 2) {
        return 1;
    } else {
        return 0;
    }
}

void tx_timeout(struct net_device *dev)
{
    struct r8192_priv *priv = ieee80211_priv(dev);

#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0))
    schedule_work(&priv->reset_wq);
#else
    schedule_task(&priv->reset_wq);
#endif
    printk("TXTIMEOUT");
}

void rtl8192_irq_enable(struct net_device *dev)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);	
	priv->irq_enabled = 1;
	write_nic_dword(dev,INTA_MASK, priv->irq_mask[0]);
#ifdef RTL8192SE	
	write_nic_dword(dev,INTA_MASK+4, priv->irq_mask[1]&0x3F);
#endif	
}

void rtl8192_irq_disable(struct net_device *dev)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);	

	write_nic_dword(dev,INTA_MASK,0);
#ifdef RTL8192SE	
	write_nic_dword(dev,INTA_MASK + 4,0);
#endif	
	priv->irq_enabled = 0;
}

void rtl8192_irq_clear(struct net_device *dev)
{
	u32 tmp = 0;
	tmp = read_nic_dword(dev, ISR);	
	write_nic_dword(dev, ISR, tmp);
}


void rtl8192_set_chan(struct net_device *dev,short ch)
{
    struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);

    RT_TRACE(COMP_CH, "=====>%s()====ch:%d\n", __FUNCTION__, ch);	
    if (priv->chan_forced)
		return;

    priv->chan = ch;


#ifndef LOOP_TEST	


    if (priv->rf_set_chan)
        priv->rf_set_chan(dev,priv->chan);
#endif
}

void rtl8192_update_msr(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	u8 msr;
	LED_CTL_MODE	LedAction = LED_CTL_NO_LINK;
	msr  = read_nic_byte(dev, MSR);
	msr &= ~ MSR_LINK_MASK;
	
	switch (priv->ieee80211->iw_mode) {
	case IW_MODE_INFRA:
		if (priv->ieee80211->state == IEEE80211_LINKED)
			msr |= (MSR_LINK_MANAGED << MSR_LINK_SHIFT);
		else
			msr |= (MSR_LINK_NONE << MSR_LINK_SHIFT);
		LedAction = LED_CTL_LINK;
		break;
	case IW_MODE_ADHOC:
		if (priv->ieee80211->state == IEEE80211_LINKED)
			msr |= (MSR_LINK_ADHOC << MSR_LINK_SHIFT);
		else
			msr |= (MSR_LINK_NONE << MSR_LINK_SHIFT);
		break;
	case IW_MODE_MASTER:
		if (priv->ieee80211->state == IEEE80211_LINKED)
			msr |= (MSR_LINK_MASTER << MSR_LINK_SHIFT);
		else
			msr |= (MSR_LINK_NONE << MSR_LINK_SHIFT);
		break;
#ifdef _RTL8192_EXT_PATCH_
	case IW_MODE_MESH:
		printk("%s: only_mesh=%d state=%d\n", __FUNCTION__, 
				priv->ieee80211->only_mesh, priv->ieee80211->mesh_state);
		if (priv->ieee80211->only_mesh) {
			if (priv->ieee80211->mesh_state == IEEE80211_MESH_LINKED)
				msr |= (MSR_LINK_MASTER<<MSR_LINK_SHIFT); 
			else
				msr |= (MSR_LINK_NONE<<MSR_LINK_SHIFT);
		} else {
			if (priv->ieee80211->mesh_state == IEEE80211_MESH_LINKED) {
				msr |= (MSR_LINK_ADHOC << MSR_LINK_SHIFT);
				if (priv->ieee80211->state == IEEE80211_LINKED)
					msr |= (MSR_LINK_MANAGED << MSR_LINK_SHIFT);
			} else {	
				msr |= (MSR_LINK_NONE << MSR_LINK_SHIFT);
			}
		}
		break;
#endif			
	default:
		break;
	}

	write_nic_byte(dev, MSR, msr);
	if(priv->ieee80211->LedControlHandler)
		priv->ieee80211->LedControlHandler(dev, LedAction);
}

void rtl8192_update_cap(struct net_device* dev, u16 cap)
{
	u32 tmp = 0;
	struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_network *net = &priv->ieee80211->current_network;

	priv->short_preamble = cap & WLAN_CAPABILITY_SHORT_PREAMBLE;
	tmp = priv->basic_rate;
	if (priv->short_preamble)
		tmp |= BRSR_AckShortPmb;
#ifndef RTL8192SE	
	write_nic_dword(dev, RRSR, tmp);
#endif
#define SHORT_SLOT_TIME 9
#define NON_SHORT_SLOT_TIME 20
	if (net->mode & (IEEE_G|IEEE_N_24G)) {
		u8 slot_time = 0;
		if ((cap & WLAN_CAPABILITY_SHORT_SLOT) && 
		    (!priv->ieee80211->pHTInfo->bCurrentRT2RTLongSlotTime)) {
			slot_time = SHORT_SLOT_TIME;
		} else {
			slot_time = NON_SHORT_SLOT_TIME;
		}
		priv->slot_time = slot_time;
		write_nic_byte(dev, SLOT_TIME, slot_time);
	}

}

static struct ieee80211_qos_parameters def_qos_parameters = {
        {3,3,3,3},
        {7,7,7,7},
        {2,2,2,2},
        {0,0,0,0},
        {0,0,0,0} 
};

void rtl8192_update_beacon(void *data)
{
#if LINUX_VERSION_CODE >=KERNEL_VERSION(2,6,20)
	struct r8192_priv *priv = container_of_work_rsl(data, struct r8192_priv, update_beacon_wq.work);
	struct net_device *dev = priv->ieee80211->dev;
#else
	struct net_device *dev = (struct net_device *)data;
        struct r8192_priv *priv = ieee80211_priv(dev);
#endif
 	struct ieee80211_device* ieee = priv->ieee80211;
	struct ieee80211_network* net = &ieee->current_network;

	if (ieee->pHTInfo->bCurrentHTSupport)
		HTUpdateSelfAndPeerSetting(ieee, net);
	ieee->pHTInfo->bCurrentRT2RTLongSlotTime = net->bssht.bdRT2RTLongSlotTime;
	ieee->pHTInfo->RT2RT_HT_Mode = net->bssht.RT2RT_HT_Mode;
	rtl8192_update_cap(dev, net->capability);
}

int WDCAPARA_ADD[] = {EDCAPARA_BE,EDCAPARA_BK,EDCAPARA_VI,EDCAPARA_VO};
void rtl8192_qos_activate(void *data)
{
#if LINUX_VERSION_CODE >=KERNEL_VERSION(2,6,20)
	struct r8192_priv *priv = container_of_work_rsl(data, struct r8192_priv, qos_activate);
	struct net_device *dev = priv->ieee80211->dev;
#else
	struct net_device *dev = (struct net_device *)data;
	struct r8192_priv *priv = ieee80211_priv(dev);
#endif
        struct ieee80211_qos_parameters *qos_parameters = &priv->ieee80211->current_network.qos_data.parameters;
        u8 mode = priv->ieee80211->current_network.mode;
	u8  u1bAIFS;
	u32 u4bAcParam;
        int i;

        if (priv == NULL)
                return;

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,16))
	down(&priv->mutex);
#else
        mutex_lock(&priv->mutex);
#endif
        if(priv->ieee80211->state != IEEE80211_LINKED)
		goto success;
	RT_TRACE(COMP_QOS,"qos active process with associate response received\n");
	for (i = 0; i <  QOS_QUEUE_NUM; i++) {
		u1bAIFS = qos_parameters->aifs[i] * ((mode&(IEEE_G|IEEE_N_24G)) ?9:20) + aSifsTime; 
		u4bAcParam = ((((u32)(qos_parameters->tx_op_limit[i]))<< AC_PARAM_TXOP_LIMIT_OFFSET)|
				(((u32)(qos_parameters->cw_max[i]))<< AC_PARAM_ECW_MAX_OFFSET)|
				(((u32)(qos_parameters->cw_min[i]))<< AC_PARAM_ECW_MIN_OFFSET)|
				((u32)u1bAIFS << AC_PARAM_AIFS_OFFSET));
		printk("===>u4bAcParam:%x, ", u4bAcParam);
		write_nic_dword(dev, WDCAPARA_ADD[i], u4bAcParam);
	}

success:
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,16))
	up(&priv->mutex);
#else
        mutex_unlock(&priv->mutex);
#endif
}

static int rtl8192_qos_handle_probe_response(struct r8192_priv *priv,
		int active_network,
		struct ieee80211_network *network)
{
	int ret = 0;
	u32 size = sizeof(struct ieee80211_qos_parameters);

	if(priv->ieee80211->state !=IEEE80211_LINKED)
                return ret;

#ifdef _RTL8192_EXT_PATCH_
	if (!((priv->ieee80211->iw_mode == IW_MODE_INFRA ) || 
	      ((priv->ieee80211->iw_mode == IW_MODE_MESH) && (priv->ieee80211->only_mesh == 0))))
#else
	if ((priv->ieee80211->iw_mode != IW_MODE_INFRA)) 
#endif
		return ret;

	if (network->flags & NETWORK_HAS_QOS_MASK) {
		if (active_network &&
				(network->flags & NETWORK_HAS_QOS_PARAMETERS))
			network->qos_data.active = network->qos_data.supported;

		if ((network->qos_data.active == 1) && (active_network == 1) &&
				(network->flags & NETWORK_HAS_QOS_PARAMETERS) &&
				(network->qos_data.old_param_count !=
				 network->qos_data.param_count)) {
			network->qos_data.old_param_count =
				network->qos_data.param_count;
                         priv->ieee80211->wmm_acm = network->qos_data.wmm_acm;
			queue_work_rsl(priv->priv_wq, &priv->qos_activate);
			RT_TRACE (COMP_QOS, "QoS parameters change call "
					"qos_activate\n");
		}
	} else {
		memcpy(&priv->ieee80211->current_network.qos_data.parameters,\
		       &def_qos_parameters, size);

		if ((network->qos_data.active == 1) && (active_network == 1)) {
			queue_work_rsl(priv->priv_wq, &priv->qos_activate);
			RT_TRACE(COMP_QOS, "QoS was disabled call qos_activate \n");
		}
		network->qos_data.active = 0;
		network->qos_data.supported = 0;
	}

	return 0;
}

static int rtl8192_handle_beacon(struct net_device * dev,
                              struct ieee80211_beacon * beacon,
                              struct ieee80211_network * network)
{
	struct r8192_priv *priv = ieee80211_priv(dev);

	rtl8192_qos_handle_probe_response(priv,1,network);

	queue_delayed_work_rsl(priv->priv_wq, &priv->update_beacon_wq, 0);
	return 0;

}

static int rtl8192_qos_association_resp(struct r8192_priv *priv,
                                    struct ieee80211_network *network)
{
        int ret = 0;
        unsigned long flags;
        u32 size = sizeof(struct ieee80211_qos_parameters);
        int set_qos_param = 0;

        if ((priv == NULL) || (network == NULL))
                return ret;

	if(priv->ieee80211->state !=IEEE80211_LINKED)
                return ret;

#ifdef _RTL8192_EXT_PATCH_
	if (!((priv->ieee80211->iw_mode == IW_MODE_INFRA ) || 
	      ((priv->ieee80211->iw_mode == IW_MODE_MESH) && (priv->ieee80211->only_mesh == 0))))
#else
	if ((priv->ieee80211->iw_mode != IW_MODE_INFRA)) 
#endif
                return ret;

        spin_lock_irqsave(&priv->ieee80211->lock, flags);
	if (network->flags & NETWORK_HAS_QOS_PARAMETERS) {
		memcpy(&priv->ieee80211->current_network.qos_data.parameters,\
			 &network->qos_data.parameters,\
			sizeof(struct ieee80211_qos_parameters));
		priv->ieee80211->current_network.qos_data.active = 1;
                priv->ieee80211->wmm_acm = network->qos_data.wmm_acm;
#if 0
		if((priv->ieee80211->current_network.qos_data.param_count != \
					network->qos_data.param_count))
#endif
		 {
                        set_qos_param = 1;
			priv->ieee80211->current_network.qos_data.old_param_count = \
				 priv->ieee80211->current_network.qos_data.param_count;
			priv->ieee80211->current_network.qos_data.param_count = \
			     	 network->qos_data.param_count;
		}
        } else {
		memcpy(&priv->ieee80211->current_network.qos_data.parameters,\
		       &def_qos_parameters, size);
		priv->ieee80211->current_network.qos_data.active = 0;
		priv->ieee80211->current_network.qos_data.supported = 0;
                set_qos_param = 1;
        }

        spin_unlock_irqrestore(&priv->ieee80211->lock, flags);

	RT_TRACE(COMP_QOS, "%s: network->flags = %d,%d\n", __FUNCTION__,
			network->flags ,priv->ieee80211->current_network.qos_data.active);
	if (set_qos_param == 1) {
		dm_init_edca_turbo(priv->ieee80211->dev);
		queue_work_rsl(priv->priv_wq, &priv->qos_activate);
	}
        return ret;
}

static int rtl8192_handle_assoc_response(struct net_device *dev,
                                     struct ieee80211_assoc_response_frame *resp,
                                     struct ieee80211_network *network)
{
        struct r8192_priv *priv = ieee80211_priv(dev);
        rtl8192_qos_association_resp(priv, network);
        return 0;
}

void rtl8192_prepare_beacon(struct r8192_priv *priv)
{
#ifdef _RTL8192_EXT_PATCH_
	struct net_device *dev = priv->ieee80211->dev;
#endif
	struct sk_buff *skb;
	cb_desc *tcb_desc; 

	skb = ieee80211_get_beacon(priv->ieee80211);
	tcb_desc = (cb_desc *)(skb->cb + 8);
#ifdef _RTL8192_EXT_PATCH_
	memset(skb->cb, 0, sizeof(skb->cb));
#endif
	tcb_desc->queue_index = BEACON_QUEUE;
	tcb_desc->data_rate = 2;
	tcb_desc->RATRIndex = 7;
	tcb_desc->bTxDisableRateFallBack = 1;
	tcb_desc->bTxUseDriverAssingedRate = 1;
#ifdef _RTL8192_EXT_PATCH_
	tcb_desc->bTxEnableFwCalcDur = 0;
	memcpy((unsigned char *)(skb->cb),&dev,sizeof(dev));
#endif
	skb_push(skb, priv->ieee80211->tx_headroom);	
	if(skb){
		rtl8192_tx(priv->ieee80211->dev,skb);
	}
}

void rtl8192_stop_beacon(struct net_device *dev)
{
}

void rtl8192_config_rate(struct net_device* dev, u16* rate_config)
{
	 struct r8192_priv *priv = ieee80211_priv(dev);
	 struct ieee80211_network *net;
	 u8 i=0, basic_rate = 0;
#ifdef _RTL8192_EXT_PATCH_	
	if(priv->ieee80211->iw_mode == IW_MODE_MESH)
		net = & priv->ieee80211->current_mesh_network;
	else
		net = & priv->ieee80211->current_network;
#else	
	net = & priv->ieee80211->current_network;
#endif

	 for (i = 0; i < net->rates_len; i++) {
		 basic_rate = net->rates[i] & 0x7f;
		 switch (basic_rate) {
		 case MGN_1M:	
			 *rate_config |= RRSR_1M;	
			 break;
		 case MGN_2M:	
			 *rate_config |= RRSR_2M;	
			 break;
		 case MGN_5_5M:	
			 *rate_config |= RRSR_5_5M;	
			 break;
		 case MGN_11M:	
			 *rate_config |= RRSR_11M;	
			 break;
		 case MGN_6M:	
			 *rate_config |= RRSR_6M;	
			 break;
		 case MGN_9M:	
			 *rate_config |= RRSR_9M;	
			 break;
		 case MGN_12M:	
			 *rate_config |= RRSR_12M;	
			 break;
		 case MGN_18M:	
			 *rate_config |= RRSR_18M;	
			 break;
		 case MGN_24M:	
			 *rate_config |= RRSR_24M;	
			 break;
		 case MGN_36M:	
			 *rate_config |= RRSR_36M;	
			 break;
		 case MGN_48M:	
			 *rate_config |= RRSR_48M;	
			 break;
		 case MGN_54M:	
			 *rate_config |= RRSR_54M;	
			 break;
		 }
	 }

	 for (i = 0; i < net->rates_ex_len; i++) {
		 basic_rate = net->rates_ex[i] & 0x7f;
		 switch (basic_rate) {
		 case MGN_1M:	
			 *rate_config |= RRSR_1M;	
			 break;
		 case MGN_2M:	
			 *rate_config |= RRSR_2M;	
			 break;
		 case MGN_5_5M:	
			 *rate_config |= RRSR_5_5M;	
			 break;
		 case MGN_11M:	
			 *rate_config |= RRSR_11M;	
			 break;
		 case MGN_6M:	
			 *rate_config |= RRSR_6M;	
			 break;
		 case MGN_9M:	
			 *rate_config |= RRSR_9M;	
			 break;
		 case MGN_12M:	
			 *rate_config |= RRSR_12M;	
			 break;
		 case MGN_18M:	
			 *rate_config |= RRSR_18M;	
			 break;
		 case MGN_24M:	
			 *rate_config |= RRSR_24M;	
			 break;
		 case MGN_36M:	
			 *rate_config |= RRSR_36M;	
			 break;
		 case MGN_48M:	
			 *rate_config |= RRSR_48M;	
			 break;
		 case MGN_54M:	
			 *rate_config |= RRSR_54M;	
			 break;
		 }
	 }
}

bool GetNmodeSupportBySecCfg8190Pci(struct net_device *dev)
{
#ifdef RTL8192SE
	return true;
#else
	struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_device *ieee = priv->ieee80211;
	if (ieee->ieee80211_ap_sec_type && 
	   (ieee->ieee80211_ap_sec_type(priv->ieee80211)&(SEC_ALG_WEP|SEC_ALG_TKIP))) {
		return false;
	} else {
		return true;
	}
#endif
}

void rtl8192_refresh_supportrate(struct r8192_priv* priv)
{
	struct ieee80211_device* ieee = priv->ieee80211;
	if (ieee->mode == WIRELESS_MODE_N_24G || ieee->mode == WIRELESS_MODE_N_5G) {
		memcpy(ieee->Regdot11HTOperationalRateSet, ieee->RegHTSuppRateSet, 16);
		memcpy(ieee->Regdot11TxHTOperationalRateSet, ieee->RegHTSuppRateSet, 16);
#ifdef RTL8192SE
		if(priv->rf_type == RF_1T1R) {
			ieee->Regdot11HTOperationalRateSet[1] = 0;
		}
		if(priv->rf_type == RF_1T1R || priv->rf_type == RF_1T2R)
		{
			ieee->Regdot11TxHTOperationalRateSet[1] = 0;
		}

            if(priv->ieee80211->b1SSSupport == true) {
                ieee->Regdot11HTOperationalRateSet[1] = 0;
            }
#endif
	} else {
		memset(ieee->Regdot11HTOperationalRateSet, 0, 16);
	}
	return;
}

u8 rtl8192_getSupportedWireleeMode(struct net_device*dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	u8 ret = 0;

	switch(priv->rf_chip) {
	case RF_8225:
	case RF_8256:
	case RF_6052:
	case RF_PSEUDO_11N:
		ret = (WIRELESS_MODE_N_24G|WIRELESS_MODE_G | WIRELESS_MODE_B);
		break;
	case RF_8258:
		ret = (WIRELESS_MODE_A | WIRELESS_MODE_N_5G);
		break;
	default:
		ret = WIRELESS_MODE_B;
		break;
	}
	return ret;
}

void rtl8192_SetWirelessMode(struct net_device* dev, u8 wireless_mode)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	u8 bSupportMode = rtl8192_getSupportedWireleeMode(dev);

	printk("===>%s(), wireless_mode:0x%x, support_mode:0x%x\n", __FUNCTION__, wireless_mode, bSupportMode);
#if 0
	if(	(wireless_mode != WIRELESS_MODE_B) && 
		(wireless_mode != WIRELESS_MODE_G) &&
		(wireless_mode != WIRELESS_MODE_A) &&
		(wireless_mode != WIRELESS_MODE_AUTO) &&
		(wireless_mode != WIRELESS_MODE_N_24G) &&
		(wireless_mode != WIRELESS_MODE_N_5G) ) 
	{
		wireless_mode = WIRELESS_MODE_AUTO;
	}
#endif
	if ((wireless_mode == WIRELESS_MODE_AUTO) || ((wireless_mode & bSupportMode) == 0)) {
		if (bSupportMode & WIRELESS_MODE_N_24G) {
			wireless_mode = WIRELESS_MODE_N_24G;
		} else if (bSupportMode & WIRELESS_MODE_N_5G) {
			wireless_mode = WIRELESS_MODE_N_5G;
		} else if((bSupportMode & WIRELESS_MODE_A)) {
			wireless_mode = WIRELESS_MODE_A;
		} else if((bSupportMode & WIRELESS_MODE_G)) {
			wireless_mode = WIRELESS_MODE_G;
		} else if((bSupportMode & WIRELESS_MODE_B)) {
			wireless_mode = WIRELESS_MODE_B;
		} else {
			RT_TRACE(COMP_ERR, "%s(), No valid wireless mode supported (%x)!!!\n",
				       	__FUNCTION__, bSupportMode);
			wireless_mode = WIRELESS_MODE_B;
		}
	}

#ifdef _RTL8192_EXT_PATCH_
	if ((wireless_mode & WIRELESS_MODE_N_24G) == WIRELESS_MODE_N_24G)
		wireless_mode = WIRELESS_MODE_N_24G;
	else if((wireless_mode & WIRELESS_MODE_N_5G) == WIRELESS_MODE_N_5G)
		wireless_mode = WIRELESS_MODE_N_5G;
	else if ((wireless_mode & WIRELESS_MODE_A) == WIRELESS_MODE_A)
		wireless_mode = WIRELESS_MODE_A;
	else if ((wireless_mode & WIRELESS_MODE_G) == WIRELESS_MODE_G)
		wireless_mode = WIRELESS_MODE_G;
	else
		wireless_mode = WIRELESS_MODE_B;
#else
	if ((wireless_mode & (WIRELESS_MODE_B | WIRELESS_MODE_G)) == (WIRELESS_MODE_G | WIRELESS_MODE_B))
		wireless_mode = WIRELESS_MODE_G;
#endif

#ifdef RTL8192SE
	write_nic_word(dev, SIFS_OFDM, 0x0e0e); 
#endif
	priv->ieee80211->mode = wireless_mode;
	
	if ((wireless_mode == WIRELESS_MODE_N_24G) ||  (wireless_mode == WIRELESS_MODE_N_5G)){
		priv->ieee80211->pHTInfo->bEnableHT = 1;	
                printk("<===%s(), wireless_mode:%x, bEnableHT = 1\n", __FUNCTION__,wireless_mode);
        }else{
		priv->ieee80211->pHTInfo->bEnableHT = 0;
                printk("<===%s(), wireless_mode:%x, bEnableHT = 0\n", __FUNCTION__,wireless_mode);
        }
	RT_TRACE(COMP_INIT, "Current Wireless Mode is %x\n", wireless_mode);
	rtl8192_refresh_supportrate(priv);
}

bool GetHalfNmodeSupportByAPs819xPci(struct net_device* dev)
{
#ifdef RTL8192SE
	return false;
#else	
	bool			Reval;
	struct r8192_priv* priv = ieee80211_priv(dev);
	struct ieee80211_device* ieee = priv->ieee80211;
	
	if(ieee->bHalfWirelessN24GMode == true)
		Reval = true;
	else
		Reval =  false;

	return Reval;
#endif
}

#ifdef _RTL8192_EXT_PATCH_
#define KEEP_ALIVE_INTERVAL 				20 
#define DEFAULT_KEEP_ALIVE_LEVEL			1
#endif
static void rtl8192_init_priv_variable(struct net_device* dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
#ifdef RTL8192SE
	PRT_POWER_SAVE_CONTROL	pPSC = (PRT_POWER_SAVE_CONTROL)(&(priv->ieee80211->PowerSaveControl));
	int pos;
	u8 value;
#endif
	u8 i;
	priv->polling_timer_on = 0;
	priv->up_first_time = 1;
	priv->blinked_ingpio = false;
	priv->bDriverIsGoingToUnload = false;
	priv->being_init_adapter = false;
        priv->sw_radio_on = true;
	priv->bdisable_nic = false;
	priv->bfirst_init = false;
	priv->txringcount = 64;
	priv->rxbuffersize = 9100;
	priv->rxringcount = MAX_RX_COUNT;
	priv->irq_enabled=0;
	priv->chan = 1; 
	priv->RegWirelessMode = WIRELESS_MODE_AUTO;
	priv->RegChannelPlan = 0xf;
	priv->nrxAMPDU_size = 0;
	priv->nrxAMPDU_aggr_num = 0;
	priv->last_rxdesc_tsf_high = 0;
	priv->last_rxdesc_tsf_low = 0;
	priv->ieee80211->mode = WIRELESS_MODE_AUTO; 
	priv->ieee80211->iw_mode = IW_MODE_INFRA;
	priv->ieee80211->ieee_up=0;
	priv->retry_rts = DEFAULT_RETRY_RTS;
	priv->retry_data = DEFAULT_RETRY_DATA;
	priv->ieee80211->rts = DEFAULT_RTS_THRESHOLD;
	priv->ieee80211->rate = 110; 
	priv->ieee80211->short_slot = 1;
	priv->promisc = (dev->flags & IFF_PROMISC) ? 1:0;
	priv->bcck_in_ch14 = false;
	priv->bfsync_processing  = false;
	priv->CCKPresentAttentuation = 0;
	priv->rfa_txpowertrackingindex = 0;
	priv->rfc_txpowertrackingindex = 0;
	priv->CckPwEnl = 6;
	priv->ScanDelay = 50;
	priv->ResetProgress = RESET_TYPE_NORESET;
	priv->bForcedSilentReset = 0;
	priv->bDisableNormalResetCheck = false;
	priv->force_reset = false;
	memset(priv->ieee80211->swcamtable,0,sizeof(SW_CAM_TABLE)*32);
#ifdef _RTL8192_EXT_PATCH_
	priv->ieee80211->mesh_security_setting = 0;
	memset(priv->ieee80211->swmeshcamtable,0,sizeof(SW_CAM_TABLE)*32);
#endif
	memset(&priv->InterruptLog,0,sizeof(LOG_INTERRUPT_8190_T));
	priv->RxCounter = 0;
        priv->ieee80211->wx_set_enc = 0;
	priv->bHwRadioOff = false;
	priv->RegRfOff = 0;
	priv->isRFOff = false;
	priv->bInPowerSaveMode = false;
	priv->ieee80211->RfOffReason = 0;
	priv->RFChangeInProgress = false;
	priv->bHwRfOffAction = 0;
	priv->SetRFPowerStateInProgress = false;
	priv->ieee80211->PowerSaveControl.bInactivePs = true;
	priv->ieee80211->PowerSaveControl.bIPSModeBackup = false;
	priv->ieee80211->PowerSaveControl.bLeisurePs = true;
	priv->ieee80211->PowerSaveControl.bFwCtrlLPS = false;
	priv->ieee80211->LPSDelayCnt = 0;
        priv->ieee80211->sta_sleep = 0;
	priv->ieee80211->eRFPowerState = eRfOn;
#ifdef _RTL8192_EXT_PATCH_
	priv->NumTxUnicast = 0;
	priv->keepAliveLevel = DEFAULT_KEEP_ALIVE_LEVEL;
#endif
	priv->txpower_checkcnt = 0;
	priv->thermal_readback_index =0;
	priv->txpower_tracking_callback_cnt = 0;
	priv->ccktxpower_adjustcnt_ch14 = 0;
	priv->ccktxpower_adjustcnt_not_ch14 = 0;
	priv->pwrGroupCnt = 0;
#ifdef _RTL8192_EXT_PATCH_
	priv->FwCmdIOMap = 0;
	priv->FwCmdIOParam = 0;
	priv->ThermalValue = 0;
	priv->DMFlag = 0;
	priv->rssi_level = 0;
	priv->ieee80211->bUseRAMask = 0;
#endif
#ifdef RTL8192SE
	for(i = 0; i<PEER_MAX_ASSOC; i++)
		priv->ieee80211->peer_assoc_list[i]=NULL;
	priv->RATRTableBitmap = 0;
	priv->ieee80211->amsdu_in_process = 0;
	
	priv->bridge_pdev = priv->pdev->bus->self;
	switch (priv->bridge_pdev->vendor) {
	case PCI_VENDOR_ID_INTEL:
		priv->pci_bridge_vendor = PCI_BRIDGE_VENDOR_INTEL;
			break;
	case PCI_VENDOR_ID_SI:
		priv->pci_bridge_vendor = PCI_BRIDGE_VENDOR_SIS;
			break;
	default:
		priv->pci_bridge_vendor = 0;
		break;
	}

#ifdef RTL8192SE_CONFIG_ASPM_OR_D3
	if (priv->pci_bridge_vendor & (PCI_BRIDGE_VENDOR_INTEL | PCI_BRIDGE_VENDOR_SIS)) {
		priv->aspm_clkreq_enable = true;
		priv->RegHostPciASPMSetting = 0x02;
		pos = pci_find_capability(priv->bridge_pdev, PCI_CAP_ID_EXP);
		priv->PciBridgeASPMRegOffset = pos + PCI_EXP_LNKCTL;
		pci_read_config_byte(priv->bridge_pdev, pos + PCI_EXP_LNKCTL, &value);
		priv->PciBridgeLinkCtrlReg = value;

		priv->RegDevicePciASPMSetting = 0x03;
		pos = pci_find_capability(priv->pdev, PCI_CAP_ID_EXP);
		priv->ASPMRegOffset = pos + PCI_EXP_LNKCTL;
		priv->ClkReqOffset = pos + PCI_EXP_LNKCTL + 1;
		pci_read_config_byte(priv->pdev, pos + PCI_EXP_LNKCTL, &value);
		priv->LinkCtrlReg = value;
	} else {
		priv->aspm_clkreq_enable = false;
	}
#endif	
#endif	
	priv->ieee80211->current_network.beacon_interval = DEFAULT_BEACONINTERVAL;	
	priv->ieee80211->iw_mode = IW_MODE_INFRA;
#ifdef _ENABLE_SW_BEACON
	priv->ieee80211->softmac_features  = IEEE_SOFTMAC_SCAN | 
		IEEE_SOFTMAC_ASSOCIATE | IEEE_SOFTMAC_PROBERQ | 
		IEEE_SOFTMAC_PROBERS | IEEE_SOFTMAC_TX_QUEUE  |
		IEEE_SOFTMAC_BEACONS;
#else	
	priv->ieee80211->softmac_features  = IEEE_SOFTMAC_SCAN | 
		IEEE_SOFTMAC_ASSOCIATE | IEEE_SOFTMAC_PROBERQ | 
		IEEE_SOFTMAC_PROBERS | IEEE_SOFTMAC_TX_QUEUE /* |
		IEEE_SOFTMAC_BEACONS*/;
#endif
	priv->ieee80211->active_scan = 1;
	priv->ieee80211->be_scan_inprogress = false;
	priv->ieee80211->modulation = IEEE80211_CCK_MODULATION | IEEE80211_OFDM_MODULATION;
	priv->ieee80211->host_encrypt = 1;
	priv->ieee80211->host_decrypt = 1;
#ifdef _RTL8192_EXT_PATCH_
	priv->ieee80211->start_send_beacons = NULL;
	priv->ieee80211->stop_send_beacons = NULL;
#else	
	priv->ieee80211->start_send_beacons = rtl8192_start_beacon;
	priv->ieee80211->stop_send_beacons = rtl8192_stop_beacon;
#endif	
	priv->ieee80211->softmac_hard_start_xmit = rtl8192_hard_start_xmit;
	priv->ieee80211->set_chan = rtl8192_set_chan;
	priv->ieee80211->link_change = priv->ops->link_change;
	priv->ieee80211->softmac_data_hard_start_xmit = rtl8192_hard_data_xmit;
	priv->ieee80211->data_hard_stop = rtl8192_data_hard_stop;
	priv->ieee80211->data_hard_resume = rtl8192_data_hard_resume;
	priv->ieee80211->fts = DEFAULT_FRAG_THRESHOLD;
	priv->ieee80211->check_nic_enough_desc = check_nic_enough_desc;	
	priv->ieee80211->get_nic_desc_num = get_nic_desc_num;	
	priv->ieee80211->MaxMssDensity = 0;
	priv->ieee80211->MinSpaceCfg = 0;
#ifdef _RTL8192_EXT_PATCH_
#ifdef MESH_ABBR_HANDSHK_SUPPORT
	priv->ieee80211->set_mesh_key = r8192_mesh_set_enc_ext;
#endif
#endif
#ifdef RTL8192SE
	priv->ieee80211->tx_headroom = 0;
#else
	priv->ieee80211->tx_headroom = sizeof(TX_FWINFO_8190PCI);
#endif
	priv->ieee80211->qos_support = 1;
	priv->ieee80211->dot11PowerSaveMode = eActive;
	priv->ieee80211->SetBWModeHandler = rtl8192_SetBWMode;
	priv->ieee80211->handle_assoc_response = rtl8192_handle_assoc_response;
	priv->ieee80211->handle_beacon = rtl8192_handle_beacon;
#ifndef RTL8190P
	priv->ieee80211->sta_wake_up = rtl8192_hw_wakeup;
	priv->ieee80211->enter_sleep_state = rtl8192_hw_to_sleep;
	priv->ieee80211->ps_is_queue_empty = rtl8192_is_tx_queue_empty;
#else
	priv->ieee80211->sta_wake_up = NULL;
	priv->ieee80211->enter_sleep_state = NULL;
	priv->ieee80211->ps_is_queue_empty = NULL;
#endif
	priv->ieee80211->GetNmodeSupportBySecCfg = GetNmodeSupportBySecCfg8190Pci;
	priv->ieee80211->SetWirelessMode = rtl8192_SetWirelessMode;
	priv->ieee80211->GetHalfNmodeSupportByAPsHandler = GetHalfNmodeSupportByAPs819xPci;
#ifdef RTL8192SE	
 	priv->ieee80211->SetBeaconRelatedRegistersHandler = SetBeaconRelatedRegisters8192SE;
	priv->ieee80211->Adhoc_InitRateAdaptive = Adhoc_InitRateAdaptive;
	priv->ieee80211->check_ht_cap = rtl8192se_check_ht_cap;
	priv->ieee80211->SetHwRegHandler = SetHwReg8192SE;
#ifndef _RTL8192_EXT_PATCH_
	priv->ieee80211->GetHwRegHandler = GetHwReg8192SE;
#endif
	priv->ieee80211->SetFwCmdHandler = rtl8192se_set_fw_cmd;
	priv->ieee80211->UpdateHalRAMaskHandler = UpdateHalRAMask8192SE;
	priv->ieee80211->rtl_11n_user_show_rates = rtl8192_11n_user_show_rates;
	pPSC->RegRfPsLevel |= RT_RF_OFF_LEVL_HALT_NIC;
	pPSC->RegRfPsLevel |= RT_RF_OFF_LEVL_CLK_REQ;
	pPSC->RegRfPsLevel |= RT_RF_OFF_LEVL_ASPM;
	pPSC->RegRfPsLevel |= RT_RF_LPS_LEVEL_ASPM;

	pPSC->RegMaxLPSAwakeIntvl = 5;
#ifdef ENABLE_IPS
	priv->ieee80211->ieee80211_ips_leave_wq = ieee80211_ips_leave_wq;
	priv->ieee80211->ieee80211_ips_leave = ieee80211_ips_leave;
#endif
#else
	priv->ieee80211->SetHwRegHandler = NULL;
	priv->ieee80211->SetFwCmdHandler = NULL;
	priv->ieee80211->InitialGainHandler = InitialGain819xPci;
#ifdef ENABLE_IPS
	priv->ieee80211->ieee80211_ips_leave_wq = ieee80211_ips_leave_wq;
	priv->ieee80211->ieee80211_ips_leave = ieee80211_ips_leave;
#endif
#endif	
#ifdef ENABLE_LPS
	priv->ieee80211->LeisurePSLeave = LeisurePSLeave;
#endif
#ifdef RTL8192SE
        priv->ieee80211->LedControlHandler = LedControl8192SE;
#else
        priv->ieee80211->LedControlHandler = NULL;
#endif
	priv->MidHighPwrTHR_L1 = 0x3B;
	priv->MidHighPwrTHR_L2 = 0x40;

	priv->card_type = PCI;

	priv->ShortRetryLimit = 0x30;
	priv->LongRetryLimit = 0x30;
	priv->EarlyRxThreshold = 7;
	priv->enable_gpio0 = 0;

	priv->TransmitConfig = 0;
#ifdef RTL8192SE	
	priv->ReceiveConfig = 
	RCR_APPFCS | RCR_APWRMGT | /*RCR_ADD3 |*/
	RCR_AMF	| RCR_ADF | RCR_APP_MIC | RCR_APP_ICV |
       RCR_AICV	| RCR_ACRC32	|				
	RCR_AB 		| RCR_AM		|				
     	RCR_APM 	|  								
     	/*RCR_AAP		|*/	 						
     	RCR_APP_PHYST_STAFF | RCR_APP_PHYST_RXFF |	
	(priv->EarlyRxThreshold<<RCR_FIFO_OFFSET)	;
	
#ifdef _ENABLE_SW_BEACON
	priv->irq_mask[0] = 
	(IMR_ROK | IMR_VODOK | IMR_VIDOK | IMR_BEDOK | IMR_BKDOK |		\
	IMR_HCCADOK | IMR_MGNTDOK | IMR_COMDOK | IMR_HIGHDOK | 					\
	IMR_BDOK | IMR_RXCMDOK | /*IMR_TIMEOUT0 |*/ IMR_RDU | IMR_RXFOVW/*	|			\
	IMR_BcnInt| IMR_TXFOVW | IMR_TBDOK | IMR_TBDER*/);
#else
	priv->irq_mask[0] = 
	(IMR_ROK | IMR_VODOK | IMR_VIDOK | IMR_BEDOK | IMR_BKDOK |		\
	IMR_HCCADOK | IMR_MGNTDOK | IMR_COMDOK | IMR_HIGHDOK | 					\
	IMR_BDOK | IMR_RXCMDOK | /*IMR_TIMEOUT0 |*/ IMR_RDU | IMR_RXFOVW	|		\
	 IMR_BcnInt/*| IMR_TXFOVW*/ /*| IMR_TBDOK | IMR_TBDER*/);
#endif
	priv->irq_mask[1] = 0;/* IMR_TBDOK | IMR_TBDER*/
#else
	priv->ReceiveConfig = RCR_ADD3	|
		RCR_AMF | RCR_ADF |		
		RCR_AICV |	
		RCR_AB | RCR_AM | RCR_APM |	
		RCR_AAP | ((u32)7<<RCR_MXDMA_OFFSET) |
		((u32)7 << RCR_FIFO_OFFSET) | RCR_ONLYERLPKT;

	priv->irq_mask[0] = 	(u32)(IMR_ROK | IMR_VODOK | IMR_VIDOK | IMR_BEDOK | IMR_BKDOK |\
				IMR_HCCADOK | IMR_MGNTDOK | IMR_COMDOK | IMR_HIGHDOK |\
				IMR_BDOK | IMR_RXCMDOK | IMR_TIMEOUT0 | IMR_RDU | IMR_RXFOVW	|\
				IMR_TXFOVW | IMR_BcnInt | IMR_TBDOK | IMR_TBDER);
#endif
	priv->AcmControl = 0;	
	priv->pFirmware = (rt_firmware*)vmalloc(sizeof(rt_firmware));
	if (priv->pFirmware)
	memset(priv->pFirmware, 0, sizeof(rt_firmware));

        skb_queue_head_init(&priv->rx_queue);
	skb_queue_head_init(&priv->skb_queue);

	for(i = 0; i < MAX_QUEUE_SIZE; i++) {
		skb_queue_head_init(&priv->ieee80211->skb_waitQ [i]);
	}
	for(i = 0; i < MAX_QUEUE_SIZE; i++) {
		skb_queue_head_init(&priv->ieee80211->skb_aggQ [i]);
	}
	priv->rf_set_chan = rtl8192_phy_SwChnl;	

#ifdef _RTL8192_EXT_PATCH_
	priv->ieee80211->set_key_for_AP = rtl8192_set_key_for_AP;
	memset(priv->ieee80211->swmeshratrtable,0,8*(sizeof(SW_RATR_TABLE)));
	priv->ieee80211->mesh_amsdu_in_process = 0;
	priv->ieee80211->HwSecCamBitMap = 0;
	memset(priv->ieee80211->HwSecCamStaAddr,0,TOTAL_CAM_ENTRY * ETH_ALEN); 
	priv->ieee80211->LinkingPeerBitMap = 0;
	memset(priv->ieee80211->LinkingPeerAddr,0,TOTAL_CAM_ENTRY * ETH_ALEN); 
	memset(priv->ieee80211->peer_AID_Addr,0,30 * ETH_ALEN);
	priv->ieee80211->peer_AID_bitmap = 0;
	priv->ieee80211->backup_channel = 1;
	priv->ieee80211->del_hwsec_cam_entry = rtl8192_del_hwsec_cam_entry; 
	priv->ieee80211->set_key_for_peer = meshdev_set_key_for_peer;
	priv->ieee80211->meshscanning = 0;
	priv->ieee80211->hostname_len = 0;
	memset(priv->ieee80211->hostname, 0, sizeof(priv->ieee80211->hostname));
	priv->ieee80211->meshScanMode = 0;
	priv->ieee80211->currentRate = 0xffffffff;
	priv->mshobj = alloc_mshobj(priv);
	printk("priv is %p,mshobj is %p\n",priv,priv->mshobj);

	if (priv->mshobj) {
		priv->ieee80211->ext_patch_ieee80211_start_protocol = 
			priv->mshobj->ext_patch_ieee80211_start_protocol;
		priv->ieee80211->ext_patch_ieee80211_stop_protocol = 
			priv->mshobj->ext_patch_ieee80211_stop_protocol;
		priv->ieee80211->ext_patch_ieee80211_start_mesh = 
			priv->mshobj->ext_patch_ieee80211_start_mesh;
		priv->ieee80211->ext_patch_ieee80211_probe_req_1 = 
			priv->mshobj->ext_patch_ieee80211_probe_req_1;
		priv->ieee80211->ext_patch_ieee80211_probe_req_2 = 
			priv->mshobj->ext_patch_ieee80211_probe_req_2;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_auth = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_auth;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_deauth = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_deauth;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_peerlink_open = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_peerlink_open;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_peerlink_confirm = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_peerlink_confirm;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_peerlink_close = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_peerlink_close;
		priv->ieee80211->ext_patch_ieee80211_close_all_peerlink = 
			priv->mshobj->ext_patch_ieee80211_close_all_peerlink;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_linkmetric_report = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_linkmetric_report;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_linkmetric_req = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_linkmetric_req;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_preq = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_preq;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_prep = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_prep;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_perr = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_perr;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_rann = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_rann;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_pann = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_pann;
		priv->ieee80211->ext_patch_ieee80211_ext_stop_scan_wq_set_channel = 
			priv->mshobj->ext_patch_ieee80211_ext_stop_scan_wq_set_channel;
		priv->ieee80211->ext_patch_r819x_wx_set_mesh_chan = 
			priv->mshobj->ext_patch_r819x_wx_set_mesh_chan;
		priv->ieee80211->ext_patch_r819x_wx_set_channel = 
			priv->mshobj->ext_patch_r819x_wx_set_channel;
		priv->ieee80211->ext_patch_ieee80211_process_probe_response_1 = 
			priv->mshobj->ext_patch_ieee80211_process_probe_response_1;
		priv->ieee80211->ext_patch_ieee80211_rx_mgt_on_probe_req = 
			priv->mshobj->ext_patch_ieee80211_rx_mgt_on_probe_req;
		priv->ieee80211->ext_patch_ieee80211_rx_mgt_update_expire = 
			priv->mshobj->ext_patch_ieee80211_rx_mgt_update_expire;
		priv->ieee80211->ext_patch_get_beacon_get_probersp = 
			priv->mshobj->ext_patch_get_beacon_get_probersp;
		priv->ieee80211->ext_patch_ieee80211_rx_on_rx = 
			priv->mshobj->ext_patch_ieee80211_rx_on_rx;		
		priv->ieee80211->ext_patch_ieee80211_rx_frame_get_hdrlen = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_get_hdrlen;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_get_mac_hdrlen = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_get_mac_hdrlen;
		priv->ieee80211->ext_patch_ieee80211_rx_frame_get_mesh_hdrlen_llc = 
			priv->mshobj->ext_patch_ieee80211_rx_frame_get_mesh_hdrlen_llc;
		priv->ieee80211->ext_patch_ieee80211_rx_is_valid_framectl = 
			priv->mshobj->ext_patch_ieee80211_rx_is_valid_framectl;
		priv->ieee80211->ext_patch_ieee80211_softmac_xmit_get_rate = 
			priv->mshobj->ext_patch_ieee80211_softmac_xmit_get_rate;
		/* added by david for setting acl dynamically */
		priv->ieee80211->ext_patch_ieee80211_acl_query = 
			priv->mshobj->ext_patch_ieee80211_acl_query;
		priv->ieee80211->ext_patch_ieee80211_tx_data = 
			priv->mshobj->ext_patch_ieee80211_tx_data;
		priv->ieee80211->ext_patch_ieee80211_is_mesh = 
			priv->mshobj->ext_patch_ieee80211_is_mesh;
		priv->ieee80211->ext_patch_ieee80211_create_crypt_for_peer = 
			priv->mshobj->ext_patch_ieee80211_create_crypt_for_peer;
		priv->ieee80211->ext_patch_ieee80211_get_peermp_htinfo = 
			priv->mshobj->ext_patch_ieee80211_get_peermp_htinfo;
		priv->ieee80211->ext_patch_ieee80211_update_ratr_mask = 
			priv->mshobj->ext_patch_ieee80211_update_ratr_mask;
#ifdef MESH_ATH_2
		priv->ieee80211->ext_patch_ieee80211_send_ath_commit = 
			priv->mshobj->ext_patch_ieee80211_send_ath_commit;
		priv->ieee80211->ext_patch_ieee80211_send_ath_confirm = 
			priv->mshobj->ext_patch_ieee80211_send_ath_confirm;
		priv->ieee80211->ext_patch_ieee80211_rx_ath_commit = 
			priv->mshobj->ext_patch_ieee80211_rx_ath_commit;
		priv->ieee80211->ext_patch_ieee80211_rx_ath_confirm = 
			priv->mshobj->ext_patch_ieee80211_rx_ath_confirm;
#endif
	}
	for (i = 0; i < MAX_QUEUE_SIZE; i++) {
		skb_queue_head_init(&priv->ieee80211->skb_meshaggQ[i]);
	}
#endif 

}	

static void rtl8192_init_priv_lock(struct r8192_priv* priv)
{
	spin_lock_init(&priv->tx_lock);
	spin_lock_init(&priv->irq_lock);
	spin_lock_init(&priv->irq_th_lock);
	spin_lock_init(&priv->rf_ps_lock);
	spin_lock_init(&priv->ps_lock);
	spin_lock_init(&priv->rf_lock);
#ifdef RTL8192SE_CONFIG_ASPM_OR_D3
	spin_lock_init(&priv->D3_lock);
#endif
	sema_init(&priv->wx_sem,1);
	sema_init(&priv->rf_sem,1);
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,16))
	sema_init(&priv->mutex, 1);
#else
	mutex_init(&priv->mutex);
#endif
}

static void rtl8192_init_priv_task(struct net_device* dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);	

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)	
#ifdef PF_SYNCTHREAD
	priv->priv_wq = create_workqueue(DRV_NAME,0);
#else	
	priv->priv_wq = create_workqueue(DRV_NAME);
#endif
#endif
	INIT_WORK_RSL(&priv->reset_wq,  (void*)rtl8192_restart, dev);
#ifdef ENABLE_IPS
	INIT_WORK_RSL(&priv->ieee80211->ips_leave_wq, (void*)IPSLeave_wq, dev);  
#endif
	INIT_DELAYED_WORK_RSL(&priv->watch_dog_wq, (void*)rtl819x_watchdog_wqcallback, dev);
	INIT_DELAYED_WORK_RSL(&priv->txpower_tracking_wq,  (void*)dm_txpower_trackingcallback, dev);
	INIT_DELAYED_WORK_RSL(&priv->rfpath_check_wq,  (void*)dm_rf_pathcheck_workitemcallback, dev);
	INIT_DELAYED_WORK_RSL(&priv->update_beacon_wq, (void*)rtl8192_update_beacon, dev);
	INIT_WORK_RSL(&priv->qos_activate, (void*)rtl8192_qos_activate, dev);
#ifndef RTL8190P	
	INIT_DELAYED_WORK_RSL(&priv->ieee80211->hw_wakeup_wq,(void*) rtl8192_hw_wakeup_wq, dev);
	INIT_DELAYED_WORK_RSL(&priv->ieee80211->hw_sleep_wq,(void*) rtl8192_hw_sleep_wq, dev);
#endif
#ifdef RTL8192SE
	INIT_DELAYED_WORK_RSL(&priv->ieee80211->check_tsf_wq,(void*)rtl8192se_check_tsf_wq, dev);
	INIT_DELAYED_WORK_RSL(&priv->ieee80211->update_assoc_sta_info_wq, 
			(void*)rtl8192se_update_peer_ratr_table_wq, dev);
#endif
#ifdef _RTL8192_EXT_PATCH_
	INIT_WORK_RSL(&priv->ieee80211->ext_create_crypt_for_peers_wq, (void*)msh_create_crypt_for_peers_wq, dev);
	INIT_WORK_RSL(&priv->ieee80211->ext_path_sel_ops_wq,(void*) path_sel_ops_wq, dev);
	INIT_WORK_RSL(&priv->ieee80211->ext_update_extchnloffset_wq, 
			(void*) meshdev_update_ext_chnl_offset_as_client, dev);
#ifdef	MESH_ABBR_HANDSHK_SUPPORT
	INIT_DELAYED_WORK_RSL(&priv->ieee80211->ext_wx_set_key_wq, (void*)ext_mesh_set_key_wq,priv->ieee80211);
#endif
#endif
	tasklet_init(&priv->irq_rx_tasklet,
	     (void(*)(unsigned long))rtl8192_irq_rx_tasklet,
	     (unsigned long)priv);
	tasklet_init(&priv->irq_tx_tasklet,
	     (void(*)(unsigned long))rtl8192_irq_tx_tasklet,
	     (unsigned long)priv);
        tasklet_init(&priv->irq_prepare_beacon_tasklet,
                (void(*)(unsigned long))rtl8192_prepare_beacon,
                (unsigned long)priv);
}

short rtl8192_get_channel_map(struct net_device * dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
#ifdef ENABLE_DOT11D
	if ((priv->rf_chip != RF_8225) && (priv->rf_chip != RF_8256) 
			&& (priv->rf_chip != RF_6052)) {
		RT_TRACE(COMP_ERR, "%s: unknown rf chip, can't set channel map\n", __FUNCTION__);
		return -1;
	}
		
	if (priv->ChannelPlan > COUNTRY_CODE_MAX) {
		printk("rtl819x_init:Error channel plan! Set to default.\n");
		priv->ChannelPlan= COUNTRY_CODE_FCC;
	}
	RT_TRACE(COMP_INIT, "Channel plan is %d\n",priv->ChannelPlan);
		
	Dot11d_Init(priv->ieee80211);
	Dot11d_Channelmap(priv->ChannelPlan, priv->ieee80211);
#else
	int ch,i;
	if(!channels){
		DMESG("No channels, aborting");
		return -1;
	}

	ch = channels;
	priv->ChannelPlan = 0;
	for (i = 1; i <= 14; i++) {
		(priv->ieee80211->channel_map)[i] = (u8)(ch & 0x01);
		ch >>= 1;
	}
	priv->ieee80211->IbssStartChnl= 10;
	priv->ieee80211->ibss_maxjoin_chal = 14;
#endif
	return 0;
}

void check_rfctrl_gpio_timer(unsigned long data);
short rtl8192_init(struct net_device *dev)
{		
	struct r8192_priv *priv = ieee80211_priv(dev);

	memset(&(priv->stats),0,sizeof(struct Stats));
#ifdef CONFIG_MP
	rtl8192_init_mp(dev);
#endif	
	rtl8192_init_priv_variable(dev);
	rtl8192_init_priv_lock(priv);
	rtl8192_init_priv_task(dev);
	priv->ops->get_eeprom_size(dev);
#ifdef RTL8190P
	strcpy(priv->nick, "rtl8190p");
#elif defined(RTL8192E)
	strcpy(priv->nick, "rtl8192E");
#else	
	if (priv->rf_type == RF_1T1R) 
		strcpy(priv->nick, "rtl8191SEVA1");
	else if (priv->rf_type == RF_1T2R)
		strcpy(priv->nick, "rtl8191SEVA2");
	else
		strcpy(priv->nick, "rtl8192SE");
#endif	
	rtl8192_get_channel_map(dev);
	init_hal_dm(dev);

#ifdef RTL8192SE
	InitSwLeds(dev);
#endif
	setup_timer(&priv->watch_dog_timer,
		    watch_dog_timer_callback, 
		    (unsigned long) dev);

	setup_timer(&priv->gpio_polling_timer, 
		    check_rfctrl_gpio_timer,
		    (unsigned long)dev);

	rtl8192_irq_disable(dev);
#if defined(IRQF_SHARED)
        if (request_irq(dev->irq, (void*)rtl8192_interrupt, IRQF_SHARED, dev->name, dev)) {
#else
        if (request_irq(dev->irq, (void *)rtl8192_interrupt, SA_SHIRQ, dev->name, dev)) {
#endif
		printk("Error allocating IRQ %d",dev->irq);
		return -1;
	} else { 
		priv->irq=dev->irq;
		printk("IRQ %d",dev->irq);
	}

	if (rtl8192_pci_initdescring(dev) != 0) { 
		printk("Endopoints initialization failed");
		return -1;
	}

	return 0;
}

void rtl8192_start_beacon(struct net_device *dev)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	struct ieee80211_network *net = &priv->ieee80211->current_network;
	u16 BcnTimeCfg = 0;
        u16 BcnCW = 6;
        u16 BcnIFS = 0xf;

	DMESG("Enabling beacon TX");
	rtl8192_irq_disable(dev);

	write_nic_word(dev, ATIMWND, 2);

	write_nic_word(dev, BCN_INTERVAL, net->beacon_interval);
#ifdef _RTL8192_EXT_PATCH_
	PHY_SetBeaconHwReg(dev, net->beacon_interval);
#endif
#ifdef RTL8192SE
	write_nic_word(dev, BCN_DRV_EARLY_INT, 10<<4);
#else
	write_nic_word(dev, BCN_DRV_EARLY_INT, 10);
#endif
	write_nic_word(dev, BCN_DMATIME, 256); 

	write_nic_byte(dev, BCN_ERR_THRESH, 100);	
	
	BcnTimeCfg |= BcnCW<<BCN_TCFG_CW_SHIFT;
	BcnTimeCfg |= BcnIFS<<BCN_TCFG_IFS;
	write_nic_word(dev, BCN_TCFG, BcnTimeCfg);
	rtl8192_irq_enable(dev);
}

/***************************************************************************
    -------------------------------WATCHDOG STUFF---------------------------
***************************************************************************/
short rtl8192_is_tx_queue_empty(struct net_device *dev)
{
	int i=0;
	struct r8192_priv *priv = ieee80211_priv(dev);
	for (i=0; i<=MGNT_QUEUE; i++)
	{
		if ((i== TXCMD_QUEUE) || (i == HCCA_QUEUE) )
			continue;
		if (skb_queue_len(&(&priv->tx_ring[i])->queue) > 0){
			printk("===>tx queue is not empty:%d, %d\n", i, skb_queue_len(&(&priv->tx_ring[i])->queue));
			return 0;
		}
	}
	return 1;
}

bool HalTxCheckStuck819xPci(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	bool   	bStuck = false;
#if defined(RTL8192E) || defined(RTL8190P)
	u16    RegTxCounter = read_nic_word(dev, 0x128);
#elif defined (RTL8192SE)
	u16 	RegTxCounter = read_nic_word(dev, 0x366);
#else
	u16 	RegTxCounter = priv->TxCounter + 1;
 	WARN_ON(1);	
#endif

	RT_TRACE(COMP_RESET, "%s():RegTxCounter is %d,TxCounter is %d\n", 
			__FUNCTION__,RegTxCounter,priv->TxCounter);

	if(priv->TxCounter == RegTxCounter)
		bStuck = true;

	priv->TxCounter = RegTxCounter;

	return bStuck;
}
RESET_TYPE
TxCheckStuck(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	u8			QueueID;
	u8			ResetThreshold = NIC_SEND_HANG_THRESHOLD_POWERSAVE;
	bool			bCheckFwTxCnt = false;
	struct rtl8192_tx_ring  *ring = NULL;
	struct sk_buff* skb = NULL;
	cb_desc * tcb_desc = NULL;
	unsigned long flags = 0;
	
#if 0
	switch (priv->ieee80211->dot11PowerSaveMode)
	{
		case eActive:		
			ResetThreshold = NIC_SEND_HANG_THRESHOLD_NORMAL;
			break;
		case eMaxPs:		
			ResetThreshold = NIC_SEND_HANG_THRESHOLD_POWERSAVE;
			break;
		case eFastPs:	
			ResetThreshold = NIC_SEND_HANG_THRESHOLD_POWERSAVE;
			break;
		default:
			break;
	}
#else
	switch (priv->ieee80211->ps)
	{
		case IEEE80211_PS_DISABLED:		
			ResetThreshold = NIC_SEND_HANG_THRESHOLD_NORMAL;
			break;
		case (IEEE80211_PS_MBCAST|IEEE80211_PS_UNICAST):		
			ResetThreshold = NIC_SEND_HANG_THRESHOLD_POWERSAVE;
			break;
		default:
			ResetThreshold = NIC_SEND_HANG_THRESHOLD_POWERSAVE;
			break;
	}
#endif
	spin_lock_irqsave(&priv->irq_th_lock,flags);
	for(QueueID = 0; QueueID < MAX_TX_QUEUE; QueueID++)
	{

	
		if(QueueID == TXCMD_QUEUE)
			continue;

		ring = &priv->tx_ring[QueueID];

		if(skb_queue_len(&ring->queue) == 0)
			continue;
		else
		{
			skb = (&ring->queue)->next;
			tcb_desc = (cb_desc *)(skb->cb + MAX_DEV_ADDR_SIZE);
			tcb_desc->nStuckCount++;
			bCheckFwTxCnt = true;
			#ifdef RTL8192SE
			if(tcb_desc->nStuckCount > ResetThreshold)
			{
				RT_TRACE( COMP_RESET, "TxCheckStuck(): Need silent reset because nStuckCount > ResetThreshold.\n" );
                                spin_unlock_irqrestore(&priv->irq_th_lock,flags);				
				return RESET_TYPE_SILENT;
			}
			bCheckFwTxCnt = false;
			#endif
		}
	}
	spin_unlock_irqrestore(&priv->irq_th_lock,flags);
	if(bCheckFwTxCnt) {
		if (HalTxCheckStuck819xPci(dev))
		{
			RT_TRACE(COMP_RESET, "TxCheckStuck(): Fw indicates no Tx condition! \n");
			return RESET_TYPE_SILENT;
		}
	}

	return RESET_TYPE_NORESET;
}

#ifdef RTL8192SE
bool HalRxCheckStuck8192SE(struct net_device *dev)
{
	
	struct r8192_priv *priv = ieee80211_priv(dev);
	u16 				RegRxCounter = (u16)(priv->InterruptLog.nIMR_ROK&0xffff);
	bool				bStuck = false;
	u32 				SlotIndex = 0, TotalRxStuckCount = 0;
	u8				i;


	SlotIndex = (priv->SilentResetRxSlotIndex++)%priv->SilentResetRxSoltNum;

	if(priv->RxCounter==RegRxCounter)
	{		
		priv->SilentResetRxStuckEvent[SlotIndex] = 1;

		for( i = 0; i < priv->SilentResetRxSoltNum ; i++ )
			TotalRxStuckCount += priv->SilentResetRxStuckEvent[i];

		if(TotalRxStuckCount  == priv->SilentResetRxSoltNum)
		{
			bStuck = true;
			for( i = 0; i < priv->SilentResetRxSoltNum ; i++ )
				TotalRxStuckCount += priv->SilentResetRxStuckEvent[i];
		}


	} else {
		priv->SilentResetRxStuckEvent[SlotIndex] = 0;
	}

	priv->RxCounter = RegRxCounter;

	return bStuck;
}
#endif
#if defined(RTL8192E) || defined(RTL8190P)
bool HalRxCheckStuck8190Pci(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	u16 		  RegRxCounter = read_nic_word(dev, 0x130);
	bool		  bStuck = false;
	static u8	  rx_chk_cnt = 0;

	RT_TRACE(COMP_RESET,"%s(): RegRxCounter is %d,RxCounter is %d\n", 
			__FUNCTION__, RegRxCounter,priv->RxCounter);
	rx_chk_cnt++;
	if(priv->undecorated_smoothed_pwdb >= (RateAdaptiveTH_High+5))
	{
		rx_chk_cnt = 0;	
	} else if ((priv->undecorated_smoothed_pwdb < (RateAdaptiveTH_High+5)) &&
		(((priv->CurrentChannelBW != HT_CHANNEL_WIDTH_20) && 
		  (priv->undecorated_smoothed_pwdb >= RateAdaptiveTH_Low_40M)) ||
		((priv->CurrentChannelBW == HT_CHANNEL_WIDTH_20) && 
		 (priv->undecorated_smoothed_pwdb>=RateAdaptiveTH_Low_20M)))) {
		if (rx_chk_cnt < 2) {
			return bStuck;
		} else {
			rx_chk_cnt = 0;
		}
	} else if((((priv->CurrentChannelBW != HT_CHANNEL_WIDTH_20) && 
		  (priv->undecorated_smoothed_pwdb < RateAdaptiveTH_Low_40M)) ||
		((priv->CurrentChannelBW == HT_CHANNEL_WIDTH_20) && 
		 (priv->undecorated_smoothed_pwdb < RateAdaptiveTH_Low_20M))) &&
		priv->undecorated_smoothed_pwdb >= VeryLowRSSI) {
		if (rx_chk_cnt < 4) {
			return bStuck;
		} else {
			rx_chk_cnt = 0;
		}
	} else {
		if(rx_chk_cnt < 8) {
			return bStuck;
		} else {
			rx_chk_cnt = 0;
		}
	}

	if(priv->RxCounter==RegRxCounter)
		bStuck = true;

	priv->RxCounter = RegRxCounter;

	return bStuck;
}
#endif
RESET_TYPE RxCheckStuck(struct net_device *dev)
{
#ifdef RTL8192SE
	if(HalRxCheckStuck8192SE(dev))
#else
	if(HalRxCheckStuck8190Pci(dev))
#endif
	{
		RT_TRACE(COMP_RESET, "RxStuck Condition\n");
		return RESET_TYPE_SILENT;
	}
	
	return RESET_TYPE_NORESET;
}

RESET_TYPE
rtl819x_ifcheck_resetornot(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	RESET_TYPE	TxResetType = RESET_TYPE_NORESET;
	RESET_TYPE	RxResetType = RESET_TYPE_NORESET;
	RT_RF_POWER_STATE 	rfState;
	
	rfState = priv->ieee80211->eRFPowerState;
	
	if(rfState == eRfOn)
	TxResetType = TxCheckStuck(dev);
	if( rfState == eRfOn && 
		/*ADAPTER_TEST_STATUS_FLAG(dev, ADAPTER_STATUS_FW_DOWNLOAD_FAILURE)) &&*/
		(priv->ieee80211->iw_mode == IW_MODE_INFRA) && (priv->ieee80211->state == IEEE80211_LINKED)) {

		RxResetType = RxCheckStuck(dev);
	}
	RT_TRACE(COMP_RESET,"%s(): TxResetType is %d, RxResetType is %d\n",__FUNCTION__,TxResetType,RxResetType);
	if(TxResetType==RESET_TYPE_NORMAL || RxResetType==RESET_TYPE_NORMAL)
		return RESET_TYPE_NORMAL;
	else if(TxResetType==RESET_TYPE_SILENT || RxResetType==RESET_TYPE_SILENT)
		return RESET_TYPE_SILENT;
	else
		return RESET_TYPE_NORESET;

}

void rtl819x_ifsilentreset(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	u8	reset_times = 0;
	int reset_status = 0;
	struct ieee80211_device *ieee = priv->ieee80211;
	unsigned long flag;
#ifdef _RTL8192_EXT_PATCH_
	bool wlansilentreset = false,meshsilentreset = false;
	u8 backup_channel_wlan = 1,backup_channel_mesh = 1;
	u8 updateBW = 0;
	u8 bserverHT = 0;
	int i=0;
#endif	
		
	if(priv->ResetProgress==RESET_TYPE_NORESET) {

		RT_TRACE(COMP_RESET,"=========>Reset progress!! \n");
		
		priv->ResetProgress = RESET_TYPE_SILENT;
		spin_lock_irqsave(&priv->rf_ps_lock,flag);
		if(priv->RFChangeInProgress)
		{
			spin_unlock_irqrestore(&priv->rf_ps_lock,flag);
			goto END;
		}
		priv->RFChangeInProgress = true;
		priv->bResetInProgress = true;
		spin_unlock_irqrestore(&priv->rf_ps_lock,flag);
RESET_START:	
		down(&priv->wx_sem);	
#ifdef ENABLE_LPS
                if(priv->ieee80211->state == IEEE80211_LINKED)
                    LeisurePSLeave(dev);
#endif
#ifdef _RTL8192_EXT_PATCH_
		if((priv->up == 0) && (priv->mesh_up == 0))
#else
		if(priv->up == 0) 
#endif
		{
			RT_TRACE(COMP_ERR,"%s():the driver is not up! return\n",__FUNCTION__);
			up(&priv->wx_sem);
			return ;
		}
#ifdef _RTL8192_EXT_PATCH_
		if(priv->up == 1)
		{
			printk("================>wlansilentreset is true\n");
			wlansilentreset = true;
			priv->up = 0;
		}
		if(priv->mesh_up == 1)
		{
			printk("================>meshsilentreset is true\n");
			meshsilentreset = true;
			priv->mesh_up = 0;
		}
#else
		priv->up = 0;
#endif
		RT_TRACE(COMP_RESET,"%s():======>start to down the driver\n",__FUNCTION__);
		mdelay(1000);
		RT_TRACE(COMP_RESET,"%s():111111111111111111111111======>start to down the driver\n",__FUNCTION__);
		if(!netif_queue_stopped(dev))
			netif_stop_queue(dev);
#ifndef RTL8192SE
		dm_backup_dynamic_mechanism_state(dev);
#endif
		rtl8192_irq_disable(dev);
		del_timer_sync(&priv->watch_dog_timer);	
		rtl8192_cancel_deferred_work(priv);
		deinit_hal_dm(dev);
		ieee->sync_scan_hurryup = 1;
#ifdef _RTL8192_EXT_PATCH_
		backup_channel_wlan = ieee->current_network.channel;
		backup_channel_mesh = ieee->current_mesh_network.channel;
		if((ieee->state == IEEE80211_LINKED) && ((ieee->iw_mode == IW_MODE_INFRA) || (ieee->iw_mode == IW_MODE_ADHOC)))
		{
			printk("====>down, infra or adhoc\n");
			SEM_DOWN_IEEE_WX(&ieee->wx_sem);
			printk("ieee->state is IEEE80211_LINKED\n");
			ieee80211_stop_send_beacons(priv->ieee80211);
			del_timer_sync(&ieee->associate_timer);
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)	
			cancel_delayed_work(&ieee->associate_retry_wq);	
#endif	
			ieee80211_stop_scan(ieee);
			netif_carrier_off(dev);
			SEM_UP_IEEE_WX(&ieee->wx_sem);
		}
		else if((ieee->state == IEEE80211_LINKED) && (ieee->iw_mode == IW_MODE_MESH) && (!ieee->only_mesh))
		{
			printk("====>down, wlan server\n");
			SEM_DOWN_IEEE_WX(&ieee->wx_sem);
			printk("ieee->state is IEEE80211_LINKED\n");
			ieee80211_stop_send_beacons(priv->ieee80211);
			del_timer_sync(&ieee->associate_timer);
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)	
			cancel_delayed_work(&ieee->associate_retry_wq);	
#endif	
			ieee80211_stop_scan(ieee);
			netif_carrier_off(dev);
			SEM_UP_IEEE_WX(&ieee->wx_sem);
			if(priv->mshobj->ext_patch_ieee80211_stop_protocol)
				priv->mshobj->ext_patch_ieee80211_stop_protocol(ieee,1);
		}
		else if((ieee->iw_mode == IW_MODE_MESH) && (!ieee->only_mesh))
		{
			printk("====>down, eth0 server\n");
			if(priv->mshobj->ext_patch_ieee80211_stop_protocol)
				priv->mshobj->ext_patch_ieee80211_stop_protocol(ieee,1);
		}
		else if((ieee->iw_mode == IW_MODE_MESH) && (ieee->only_mesh))
		{
			printk("====>down, p2p or client\n");
			if(priv->mshobj->ext_patch_ieee80211_stop_protocol)
				priv->mshobj->ext_patch_ieee80211_stop_protocol(ieee,1);
		}
		else{
			printk("====>down, no link\n");
			printk("ieee->state is NOT LINKED\n");
			ieee80211_softmac_stop_protocol(priv->ieee80211,0,true);		
		}
#else
		if(ieee->state == IEEE80211_LINKED)
		{
			SEM_DOWN_IEEE_WX(&ieee->wx_sem);
			printk("ieee->state is IEEE80211_LINKED\n");
			ieee80211_stop_send_beacons(priv->ieee80211);
			del_timer_sync(&ieee->associate_timer);
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)	
			cancel_delayed_work(&ieee->associate_retry_wq);	
#endif	
			ieee80211_stop_scan(ieee);
			netif_carrier_off(dev);
			SEM_UP_IEEE_WX(&ieee->wx_sem);
		}
		else{
			printk("ieee->state is NOT LINKED\n");
			ieee80211_softmac_stop_protocol(priv->ieee80211,true);		
		}
#endif
#ifdef RTL8190P
		priv->ops->stop_adapter(dev, true);
#endif
		up(&priv->wx_sem);
		RT_TRACE(COMP_RESET,"%s():<==========down process is finished\n",__FUNCTION__);	
		RT_TRACE(COMP_RESET,"%s():===========>start to up the driver\n",__FUNCTION__);
#ifdef _RTL8192_EXT_PATCH_
		if(wlansilentreset == true){
			reset_status = _rtl8192_up(dev,true);
		}
		if(meshsilentreset == true)
			reset_status = meshdev_up(ieee->meshdev,true);
#else
		reset_status = _rtl8192_up(dev);
#endif		
		RT_TRACE(COMP_RESET,"%s():<===========up process is finished\n",__FUNCTION__);
		if(reset_status == -1)
		{
			if(reset_times < 3)
			{
				reset_times++;
				goto RESET_START;
			}
			else
			{
				RT_TRACE(COMP_ERR," ERR!!! %s():  Reset Failed!!\n",__FUNCTION__);
			}
		}
		ieee->is_silent_reset = 1;
		spin_lock_irqsave(&priv->rf_ps_lock,flag);
		priv->RFChangeInProgress = false;
		spin_unlock_irqrestore(&priv->rf_ps_lock,flag);
		EnableHWSecurityConfig8192(dev);
#ifdef _RTL8192_EXT_PATCH_
		ieee->current_network.channel = backup_channel_wlan;
		ieee->current_mesh_network.channel = backup_channel_mesh;
#endif
		if(ieee->state == IEEE80211_LINKED && ieee->iw_mode == IW_MODE_INFRA)
		{
			ieee->set_chan(ieee->dev, ieee->current_network.channel);
		
			queue_work_rsl(ieee->wq, &ieee->associate_complete_wq);
	
		}
		else if(ieee->state == IEEE80211_LINKED && ieee->iw_mode == IW_MODE_ADHOC)
		{
			ieee->set_chan(ieee->dev, ieee->current_network.channel);
			ieee->link_change(ieee->dev);
	
			notify_wx_assoc_event(ieee);
	
			ieee80211_start_send_beacons(ieee);
	
			if (ieee->data_hard_resume)
				ieee->data_hard_resume(ieee->dev);
			netif_carrier_on(ieee->dev);
		}
#ifdef _RTL8192_EXT_PATCH_
		else if((ieee->state == IEEE80211_LINKED) && (ieee->iw_mode == IW_MODE_MESH) && (!ieee->only_mesh))
		{	
			printk("===>up, wlan0 server\n");
			ieee->set_chan(ieee->dev, ieee->current_network.channel);
		
			queue_work_rsl(ieee->wq, &ieee->associate_complete_wq);
			if (ieee->current_mesh_network.beacon_interval == 0)
				ieee->current_mesh_network.beacon_interval = 100;
			ieee->link_change(ieee->dev);
			if(priv->mshobj->ext_patch_ieee80211_start_protocol)
				priv->mshobj->ext_patch_ieee80211_start_protocol(ieee);
		}
		else if((ieee->iw_mode == IW_MODE_MESH) && (!ieee->only_mesh))
		{
			printk("===>up, eth0 server\n");
			if (ieee->current_mesh_network.beacon_interval == 0)
				ieee->current_mesh_network.beacon_interval = 100;
			ieee->link_change(ieee->dev);
			if(priv->mshobj->ext_patch_ieee80211_start_protocol)
				priv->mshobj->ext_patch_ieee80211_start_protocol(ieee);
			ieee->current_network.channel = ieee->current_mesh_network.channel; 
			if(ieee->pHTInfo->bCurBW40MHz)
				HTSetConnectBwMode(ieee, HT_CHANNEL_WIDTH_20_40, (ieee->current_mesh_network.channel<=6)?HT_EXTCHNL_OFFSET_UPPER:HT_EXTCHNL_OFFSET_LOWER);  
			else
				HTSetConnectBwMode(ieee, HT_CHANNEL_WIDTH_20, (ieee->current_mesh_network.channel<=6)?HT_EXTCHNL_OFFSET_UPPER:HT_EXTCHNL_OFFSET_LOWER);  
		}
		else if((ieee->iw_mode == IW_MODE_MESH) && (ieee->only_mesh))
		{
			printk("===>up, p2p or client\n");
			if (ieee->current_mesh_network.beacon_interval == 0)
				ieee->current_mesh_network.beacon_interval = 100;
			ieee->link_change(ieee->dev);
			if(priv->mshobj->ext_patch_ieee80211_start_protocol)
				priv->mshobj->ext_patch_ieee80211_start_protocol(ieee);
			if(ieee->p2pmode)
			{
				ieee->current_network.channel = ieee->current_mesh_network.channel; 
				if(ieee->pHTInfo->bCurBW40MHz)
					HTSetConnectBwMode(ieee, HT_CHANNEL_WIDTH_20_40, (ieee->current_mesh_network.channel<=6)?HT_EXTCHNL_OFFSET_UPPER:HT_EXTCHNL_OFFSET_LOWER);  
				else
					HTSetConnectBwMode(ieee, HT_CHANNEL_WIDTH_20, (ieee->current_mesh_network.channel<=6)?HT_EXTCHNL_OFFSET_UPPER:HT_EXTCHNL_OFFSET_LOWER);  
			}
			else
			{
				updateBW=priv->mshobj->ext_patch_r819x_wx_update_beacon(dev,&bserverHT);
				printk("$$$$$$ Cur_networ.chan=%d, cur_mesh_net.chan=%d,bserverHT=%d\n", ieee->current_network.channel,ieee->current_mesh_network.channel,bserverHT);
				if(updateBW == 1)
				{
					if(bserverHT == 0)
					{
						printk("===>server is not HT supported,set 20M\n");
						HTSetConnectBwMode(ieee, HT_CHANNEL_WIDTH_20, HT_EXTCHNL_OFFSET_NO_EXT);  
					}
					else
					{
						printk("===>updateBW is 1,bCurBW40MHz is %d,ieee->serverExtChlOffset is %d\n",ieee->pHTInfo->bCurBW40MHz,ieee->serverExtChlOffset);		
						if(ieee->pHTInfo->bCurBW40MHz)
							HTSetConnectBwMode(ieee, HT_CHANNEL_WIDTH_20_40, ieee->serverExtChlOffset);  
						else
							HTSetConnectBwMode(ieee, HT_CHANNEL_WIDTH_20, ieee->serverExtChlOffset);  
					}
				}
				else
				{
					printk("===>there is no same hostname server, ERR!!!\n");
				}
			}
				
		}
#endif
#ifdef TO_DO_LIST
		else if(Adapter->MgntInfo.mActingAsAp)
		{
			AP_StartApRequest((PVOID)Adapter);
			Adapter->HalFunc.ResetHalRATRTableHandler(Adapter);
		}
#endif
		
#ifdef TO_DO_LIST
		if(Adapter->MgntInfo.mActingAsAp)
			AP_CamRestoreAllEntry(Adapter);
		else
#endif
#ifdef _RTL8192_EXT_PATCH_
		if(wlansilentreset){
			printk("==========>wlansilentreset\n");
			CamRestoreEachIFEntry(dev,0);
		}
		if(meshsilentreset){
			printk("==========>meshsilentreset\n");
			CamRestoreEachIFEntry(dev,1);
			for(i=0;i<8;i++)
			{
				if(ieee->swmeshratrtable[i].bused == true)
				{
					printk("====>restore ratr table: index=%d,value=%x\n",i,ieee->swmeshratrtable[i].ratr_value);
					write_nic_dword(dev,ARFR0+i*4,ieee->swmeshratrtable[i].ratr_value);
				}
			}
		}
#else
		CamRestoreAllEntry(dev);
#endif
#ifndef RTL8192SE
		dm_restore_dynamic_mechanism_state(dev);
#endif
END:
		priv->ResetProgress = RESET_TYPE_NORESET;
		priv->reset_count++;

		priv->bForcedSilentReset =false;
		priv->bResetInProgress = false;

#ifdef RTL8190P
		write_nic_byte(dev, UFWP, 1);	
#endif
		RT_TRACE(COMP_RESET, "Reset finished!! ====>[%d]\n", priv->reset_count);
	}
}

void rtl819x_update_rxcounts(struct r8192_priv *priv,
			     u32 *TotalRxBcnNum,
			     u32 *TotalRxDataNum)	
{
	u16 			SlotIndex;
	u8			i;

	*TotalRxBcnNum = 0;
	*TotalRxDataNum = 0;

	SlotIndex = (priv->ieee80211->LinkDetectInfo.SlotIndex++)%(priv->ieee80211->LinkDetectInfo.SlotNum);
	priv->ieee80211->LinkDetectInfo.RxBcnNum[SlotIndex] = priv->ieee80211->LinkDetectInfo.NumRecvBcnInPeriod;
	priv->ieee80211->LinkDetectInfo.RxDataNum[SlotIndex] = priv->ieee80211->LinkDetectInfo.NumRecvDataInPeriod;
	for (i = 0; i < priv->ieee80211->LinkDetectInfo.SlotNum; i++) {	
		*TotalRxBcnNum += priv->ieee80211->LinkDetectInfo.RxBcnNum[i];
		*TotalRxDataNum += priv->ieee80211->LinkDetectInfo.RxDataNum[i];
	}
}

#ifdef _RTL8192_EXT_PATCH_
static void MgntLinkKeepAlive(struct r8192_priv *priv )
{
	if (priv->keepAliveLevel == 0)
		return;

	if((priv->ieee80211->state == IEEE80211_LINKED) && (!priv->ieee80211->is_roaming))
	{
		
		if ( (priv->keepAliveLevel== 2) ||
			(priv->ieee80211->LinkDetectInfo.LastNumTxUnicast == priv->NumTxUnicast && 
			priv->ieee80211->LinkDetectInfo.NumRxUnicastOkInPeriod == 0)
			)
		{
			priv->ieee80211->LinkDetectInfo.IdleCount++;	

			if(priv->ieee80211->LinkDetectInfo.IdleCount >= ((KEEP_ALIVE_INTERVAL / RT_CHECK_FOR_HANG_PERIOD)-1) )
			{
				priv->ieee80211->LinkDetectInfo.IdleCount = 0;
				ieee80211_sta_ps_send_null_frame(priv->ieee80211, false);
			}
		}
		else
		{
			priv->ieee80211->LinkDetectInfo.IdleCount = 0;
		}
		priv->ieee80211->LinkDetectInfo.LastNumTxUnicast = priv->NumTxUnicast; 
		priv->ieee80211->LinkDetectInfo.LastNumRxUnicast = priv->ieee80211->LinkDetectInfo.NumRxUnicastOkInPeriod;
	}
}
#endif

void	rtl819x_watchdog_wqcallback(void *data)
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,20))
	struct r8192_priv *priv = container_of_dwork_rsl(data,struct r8192_priv,watch_dog_wq);
	struct net_device *dev = priv->ieee80211->dev;
#else
	struct net_device *dev = (struct net_device *)data;
	struct r8192_priv *priv = ieee80211_priv(dev);
#endif
	struct ieee80211_device* ieee = priv->ieee80211;
	RESET_TYPE	ResetType = RESET_TYPE_NORESET;
	static u8	check_reset_cnt = 0;
#ifdef _RTL8192_EXT_PATCH_
	static u8	last_reset_count = 0;
#endif
	unsigned long flags;
	PRT_POWER_SAVE_CONTROL pPSC = (PRT_POWER_SAVE_CONTROL)(&(priv->ieee80211->PowerSaveControl));
	bool bBusyTraffic = false;
	bool bEnterPS = false;
#ifdef _RTL8192_EXT_PATCH_
	if(((!priv->up) && (!priv->mesh_up)) || (priv->bHwRadioOff == true))
#else
	if((!priv->up) || (priv->bHwRadioOff == true))
#endif
		return;
	hal_dm_watchdog(dev);
#ifdef ENABLE_IPS
	if(ieee->actscanning == false){
		if((ieee->iw_mode == IW_MODE_INFRA) && (ieee->state == IEEE80211_NOLINK) &&\
		    (ieee->eRFPowerState == eRfOn)&&!ieee->is_set_key &&\
		    (!ieee->proto_stoppping) && !ieee->wx_set_enc
#ifdef CONFIG_RTLWIFI_DEBUGFS	    
		    && (!priv->debug->hw_holding)
#endif		    
		 ){
			if(ieee->PowerSaveControl.ReturnPoint == IPS_CALLBACK_NONE){
				printk("====================>haha:IPSEnter()\n");
				IPSEnter(dev);	
			}
		}
	}
#endif
#ifdef _RTL8192_EXT_PATCH_
	MgntLinkKeepAlive(priv);
#endif
	{
		if((ieee->state == IEEE80211_LINKED) && (ieee->iw_mode == IW_MODE_INFRA))
		{
			if(	ieee->LinkDetectInfo.NumRxOkInPeriod> 100 ||
				ieee->LinkDetectInfo.NumTxOkInPeriod> 100 ) {
				bBusyTraffic = true;
			}
			if(	((ieee->LinkDetectInfo.NumRxUnicastOkInPeriod + ieee->LinkDetectInfo.NumTxOkInPeriod) > 8 ) ||
				(ieee->LinkDetectInfo.NumRxUnicastOkInPeriod > 2) )
			{
				bEnterPS= false;
			}
			else
			{
				bEnterPS= true;
			}

			RT_TRACE(COMP_LPS,"***bEnterPS = %d\n", bEnterPS);
#ifdef ENABLE_LPS
			if(bEnterPS)
			{
				LeisurePSEnter(dev);
			}
			else
			{
				LeisurePSLeave(dev);
			}
		
		}
		else
		{
			RT_TRACE(COMP_LPS,"====>no link LPS leave\n");
			LeisurePSLeave(dev);
		}
#else
		}
#endif
	       ieee->LinkDetectInfo.NumRxOkInPeriod = 0;
	       ieee->LinkDetectInfo.NumTxOkInPeriod = 0;
	       ieee->LinkDetectInfo.NumRxUnicastOkInPeriod = 0;
	       ieee->LinkDetectInfo.bBusyTraffic = bBusyTraffic;
	}
	{
#ifdef RTL8192SE
		if(priv->ieee80211->iw_mode == IW_MODE_ADHOC)
			IbssAgeFunction(ieee);
#endif
			
		if(ieee->state == IEEE80211_LINKED && ieee->iw_mode == IW_MODE_INFRA)
		{
			u32	TotalRxBcnNum = 0;
			u32	TotalRxDataNum = 0;	

			rtl819x_update_rxcounts(priv, &TotalRxBcnNum, &TotalRxDataNum);
			if((TotalRxBcnNum+TotalRxDataNum) == 0)
			{
				if( ieee->eRFPowerState == eRfOff)
					RT_TRACE(COMP_ERR,"========>%s()\n",__FUNCTION__);
				printk("===>%s(): AP is power off,connect another one\n",__FUNCTION__);
				ieee->state = IEEE80211_ASSOCIATING;
				RemovePeerTS(priv->ieee80211,priv->ieee80211->current_network.bssid);
				ieee->is_roaming = true;
				ieee->is_set_key = false;
                             ieee->link_change(dev);
			     if(ieee->LedControlHandler)
				ieee->LedControlHandler(ieee->dev, LED_CTL_START_TO_LINK); 
				queue_delayed_work_rsl(ieee->wq, &ieee->associate_procedure_wq, 0);

			}
		}
	      ieee->LinkDetectInfo.NumRecvBcnInPeriod=0;
              ieee->LinkDetectInfo.NumRecvDataInPeriod=0;
		
	}
	spin_lock_irqsave(&priv->tx_lock,flags);
	if((check_reset_cnt++ >= 3) && (!ieee->is_roaming) && 
			(!priv->RFChangeInProgress) && (!pPSC->bSwRfProcessing))
	{
    		ResetType = rtl819x_ifcheck_resetornot(dev);
#ifdef _RTL8192_EXT_PATCH_
		if(check_reset_cnt == 0xFF)
#endif
		check_reset_cnt = 3;
	}
	spin_unlock_irqrestore(&priv->tx_lock,flags);
	if(!priv->bDisableNormalResetCheck && ResetType == RESET_TYPE_NORMAL)
	{
		priv->ResetProgress = RESET_TYPE_NORMAL;
		RT_TRACE(COMP_RESET,"%s(): NOMAL RESET\n",__FUNCTION__);
		return;
	}
#ifdef _RTL8192_EXT_PATCH_
	if( ((priv->force_reset) || (!priv->bDisableNormalResetCheck && ResetType==RESET_TYPE_SILENT))) 
	{
			if(check_reset_cnt != (last_reset_count + 1)){
				printk("=======================>%s: Resume firmware\n", __FUNCTION__);
				r8192se_resume_firm(dev);	
				last_reset_count = check_reset_cnt;
			}else{
				printk("=======================>%s: Silent Reset\n", __FUNCTION__);
				rtl819x_ifsilentreset(dev);
			}
	}
#else
	if( ((priv->force_reset) || (!priv->bDisableNormalResetCheck && ResetType==RESET_TYPE_SILENT))) 
	{
		rtl819x_ifsilentreset(dev);
	}
#endif
	priv->force_reset = false;
	priv->bForcedSilentReset = false;
	priv->bResetInProgress = false;
	RT_TRACE(COMP_TRACE, " <==RtUsbCheckForHangWorkItemCallback()\n");
	
}

void watch_dog_timer_callback(unsigned long data)
{
	struct r8192_priv *priv = ieee80211_priv((struct net_device *) data);
	queue_delayed_work_rsl(priv->priv_wq,&priv->watch_dog_wq,0);
	mod_timer(&priv->watch_dog_timer, jiffies + MSECS(IEEE80211_WATCH_DOG_TIME));
}

/****************************************************************************
 ---------------------------- NIC TX/RX STUFF---------------------------
*****************************************************************************/
void rtl8192_rx_enable(struct net_device *dev)
{
    struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
    write_nic_dword(dev, RDQDA,priv->rx_ring_dma);
}

 #ifdef RTL8192SE
u32 TX_DESC_BASE[] = {TBKDA, TBEDA, TVIDA, TVODA, TBDA, TCDA, TMDA, THPDA, HDA};
 #else
u32 TX_DESC_BASE[] = {BKQDA, BEQDA, VIQDA, VOQDA, HCCAQDA, CQDA, MQDA, HQDA, BQDA}; 
 #endif
void rtl8192_tx_enable(struct net_device *dev)
{
    struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
    u32 i;
    for (i = 0; i < MAX_TX_QUEUE_COUNT; i++)
        write_nic_dword(dev, TX_DESC_BASE[i], priv->tx_ring[i].dma);

    ieee80211_reset_queue(priv->ieee80211);
}

#if 0
void rtl8192_beacon_tx_enable(struct net_device *dev)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	u32 reg;

	reg = read_nic_dword(priv->ieee80211->dev,INTA_MASK);

	reg |= (IMR_BcnInt | IMR_BcnInt | IMR_TBDOK | IMR_TBDER);
	write_nic_byte(dev,reg);	
}
#endif

static void rtl8192_free_rx_ring(struct net_device *dev)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    int i;

    for (i = 0; i < priv->rxringcount; i++) {
        struct sk_buff *skb = priv->rx_buf[i];
        if (!skb)
            continue;

        pci_unmap_single(priv->pdev,
                *((dma_addr_t *)skb->cb),
                priv->rxbuffersize, PCI_DMA_FROMDEVICE);
        kfree_skb(skb);
    }

    pci_free_consistent(priv->pdev, sizeof(*priv->rx_ring) * priv->rxringcount,
            priv->rx_ring, priv->rx_ring_dma);
    priv->rx_ring = NULL;
}

static void rtl8192_free_tx_ring(struct net_device *dev, unsigned int prio)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    struct rtl8192_tx_ring *ring = &priv->tx_ring[prio];

    while (skb_queue_len(&ring->queue)) {
        tx_desc *entry = &ring->desc[ring->idx];
        struct sk_buff *skb = __skb_dequeue(&ring->queue);

        pci_unmap_single(priv->pdev, le32_to_cpu(entry->TxBuffAddr),
                skb->len, PCI_DMA_TODEVICE);
        kfree_skb(skb);
        ring->idx = (ring->idx + 1) % ring->entries;
    }

    pci_free_consistent(priv->pdev, sizeof(*ring->desc)*ring->entries,
            ring->desc, ring->dma);
    ring->desc = NULL;
}


void rtl8192_beacon_disable(struct net_device *dev) 
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	u32 reg;

	reg = read_nic_dword(priv->ieee80211->dev,INTA_MASK);

	reg &= ~(IMR_BcnInt | IMR_BcnInt | IMR_TBDOK | IMR_TBDER);
	write_nic_dword(priv->ieee80211->dev, INTA_MASK, reg);	
}


void rtl8192_data_hard_stop(struct net_device *dev)
{
	#if 0
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	priv->dma_poll_mask |= (1<<TX_DMA_STOP_LOWPRIORITY_SHIFT);
	rtl8192_set_mode(dev,EPROM_CMD_CONFIG);
	write_nic_byte(dev,TX_DMA_POLLING,priv->dma_poll_mask);
	rtl8192_set_mode(dev,EPROM_CMD_NORMAL);
	#endif
}


void rtl8192_data_hard_resume(struct net_device *dev)
{
	#if 0
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	priv->dma_poll_mask &= ~(1<<TX_DMA_STOP_LOWPRIORITY_SHIFT);
	rtl8192_set_mode(dev,EPROM_CMD_CONFIG);
	write_nic_byte(dev,TX_DMA_POLLING,priv->dma_poll_mask);
	rtl8192_set_mode(dev,EPROM_CMD_NORMAL);
	#endif
}

void rtl8192_hard_data_xmit(struct sk_buff *skb, struct net_device *dev, int rate)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	int ret;
	cb_desc *tcb_desc = (cb_desc *)(skb->cb + MAX_DEV_ADDR_SIZE);
	u8 queue_index = tcb_desc->queue_index;
	
#ifdef _RTL8192_EXT_PATCH_
	if((priv->bHwRadioOff == true)||((!priv->up)&& (!priv->mesh_up)))
#else
	if((priv->bHwRadioOff == true)||(!priv->up))
#endif
	{
		kfree_skb(skb);
		return;	
	}
	
	assert(queue_index != TXCMD_QUEUE);


        memcpy((unsigned char *)(skb->cb),&dev,sizeof(dev));
#if 0
	tcb_desc->RATRIndex = 7;
	tcb_desc->bTxDisableRateFallBack = 1;
	tcb_desc->bTxUseDriverAssingedRate = 1;
	tcb_desc->bTxEnableFwCalcDur = 1;
#endif
	skb_push(skb, priv->ieee80211->tx_headroom);
	ret = rtl8192_tx(dev, skb);
	if(ret != 0) {
		kfree_skb(skb);
	};

	if(queue_index!=MGNT_QUEUE) {
	priv->ieee80211->stats.tx_bytes+=(skb->len - priv->ieee80211->tx_headroom);
	priv->ieee80211->stats.tx_packets++;
	}


	return;
}

int rtl8192_hard_start_xmit(struct sk_buff *skb,struct net_device *dev)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);

	
	int ret;
        cb_desc *tcb_desc = (cb_desc *)(skb->cb + MAX_DEV_ADDR_SIZE);
        u8 queue_index = tcb_desc->queue_index;

        if(queue_index != TXCMD_QUEUE){
#ifdef _RTL8192_EXT_PATCH_
		if((priv->bHwRadioOff == true)||((!priv->up)&& (!priv->mesh_up)))
#else
		if((priv->bHwRadioOff == true)||(!priv->up))
#endif
		{
                kfree_skb(skb);
                return 0;	
            }
        }

	
        memcpy((unsigned char *)(skb->cb),&dev,sizeof(dev));
	if(queue_index == TXCMD_QUEUE) {
		rtl819xE_tx_cmd(dev, skb);
		ret = 0;
		return ret;
	} else {
		tcb_desc->RATRIndex = 7;
		tcb_desc->bTxDisableRateFallBack = 1;
		tcb_desc->bTxUseDriverAssingedRate = 1;
		tcb_desc->bTxEnableFwCalcDur = 1;
		skb_push(skb, priv->ieee80211->tx_headroom);
		ret = rtl8192_tx(dev, skb);
		if(ret != 0) {
			kfree_skb(skb);
		};
	}
	
	
	
	return ret;

}

void rtl8192_tx_isr(struct net_device *dev, int prio)
{
    struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);

    struct rtl8192_tx_ring *ring = &priv->tx_ring[prio];

    while (skb_queue_len(&ring->queue)) {
        tx_desc *entry = &ring->desc[ring->idx];
        struct sk_buff *skb;

        if(prio != BEACON_QUEUE) {
            if(entry->OWN)
                return;
            ring->idx = (ring->idx + 1) % ring->entries;
        }

        skb = __skb_dequeue(&ring->queue);
        pci_unmap_single(priv->pdev, le32_to_cpu(entry->TxBuffAddr),
                skb->len, PCI_DMA_TODEVICE);

        kfree_skb(skb);
    }
    if(prio == MGNT_QUEUE)
             ;
    if(prio != BEACON_QUEUE) {
        tasklet_schedule(&priv->irq_tx_tasklet);
    }

}


u8 MapHwQueueToFirmwareQueue(u8 QueueID, u8 priority)
{
	u8 QueueSelect = 0x0;       

	switch(QueueID) {
#if defined RTL8192E || defined RTL8190P
		case BE_QUEUE:
			QueueSelect = QSLT_BE;  
			break;

		case BK_QUEUE:
			QueueSelect = QSLT_BK;  
			break;

		case VO_QUEUE:
			QueueSelect = QSLT_VO;  
			break;

		case VI_QUEUE:
			QueueSelect = QSLT_VI;  
			break;
		case MGNT_QUEUE:
			QueueSelect = QSLT_MGNT;
			break;
		case BEACON_QUEUE:
			QueueSelect = QSLT_BEACON;
			break;
		case TXCMD_QUEUE:
			QueueSelect = QSLT_CMD;
			break;
		case HIGH_QUEUE:
			QueueSelect = QSLT_HIGH;
			break;
#elif defined RTL8192SE
		case BE_QUEUE:
			QueueSelect = priority; 
			break;
		case BK_QUEUE:
			QueueSelect = priority; 
			break;
		case VO_QUEUE:
			QueueSelect = priority; 
			break;
		case VI_QUEUE:
			QueueSelect = priority; 
			break;
		case MGNT_QUEUE:
			QueueSelect = QSLT_BE;
			break;
		case BEACON_QUEUE:
			QueueSelect = QSLT_BEACON;
			break;
		case TXCMD_QUEUE:
			QueueSelect = QSLT_CMD;
			break;
		case HIGH_QUEUE:
			QueueSelect = QSLT_HIGH;
			break;
#endif
		default:
			RT_TRACE(COMP_ERR, "TransmitTCB(): Impossible Queue Selection: %d \n", QueueID);
			break;
	}
	return QueueSelect;
}

void rtl819xE_tx_cmd(struct net_device *dev, struct sk_buff *skb)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    struct rtl8192_tx_ring *ring;
    tx_desc_cmd* entry;
    unsigned int idx;
    cb_desc *tcb_desc;
    unsigned long flags;

    spin_lock_irqsave(&priv->irq_th_lock,flags);
    ring = &priv->tx_ring[TXCMD_QUEUE];

    idx = (ring->idx + skb_queue_len(&ring->queue)) % ring->entries;
    entry = (tx_desc_cmd*) &ring->desc[idx];

    tcb_desc = (cb_desc *)(skb->cb + MAX_DEV_ADDR_SIZE);
    
    priv->ops->tx_fill_cmd_descriptor(dev, entry, tcb_desc, skb);

    __skb_queue_tail(&ring->queue, skb);
    spin_unlock_irqrestore(&priv->irq_th_lock,flags);

#ifndef RTL8192SE
    write_nic_byte(dev, TPPoll, TPPoll_CQ);
#endif
    return;
}

short rtl8192_tx(struct net_device *dev, struct sk_buff* skb)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    struct rtl8192_tx_ring  *ring;
    unsigned long flags;
    cb_desc *tcb_desc = (cb_desc *)(skb->cb + MAX_DEV_ADDR_SIZE);
    tx_desc *pdesc = NULL;
    struct ieee80211_hdr_1addr * header = NULL;
    u16 fc=0, type=0,stype=0;
    bool  multi_addr=false,broad_addr=false,uni_addr=false;
    u8*   pda_addr = NULL;
    int   idx;
    u32 fwinfo_size = 0;

    priv->ieee80211->bAwakePktSent = true;
	
#ifdef RTL8192SE
    fwinfo_size = 0;
#else
    fwinfo_size = sizeof(TX_FWINFO_8190PCI);
#endif
    header = (struct ieee80211_hdr_1addr *)(((u8*)skb->data) + fwinfo_size);
    fc = header->frame_ctl;
    type = WLAN_FC_GET_TYPE(fc);
    stype = WLAN_FC_GET_STYPE(fc);
    pda_addr = header->addr1;
    if(is_multicast_ether_addr(pda_addr))
        multi_addr = true;
    else if(is_broadcast_ether_addr(pda_addr))
        broad_addr = true;
    else {
#ifdef _RTL8192_EXT_PATCH_
        priv->NumTxUnicast++;
#endif
        uni_addr = true;
    }
    if(uni_addr)
        priv->stats.txbytesunicast += skb->len - fwinfo_size;
    else if(multi_addr)
        priv->stats.txbytesmulticast += skb->len - fwinfo_size;
    else 
        priv->stats.txbytesbroadcast += skb->len - fwinfo_size;

    spin_lock_irqsave(&priv->irq_th_lock,flags);
    ring = &priv->tx_ring[tcb_desc->queue_index];
    if (tcb_desc->queue_index != BEACON_QUEUE) {
        idx = (ring->idx + skb_queue_len(&ring->queue)) % ring->entries;
    } else {
        idx = 0;
    }

    pdesc = &ring->desc[idx];
    if((pdesc->OWN == 1) && (tcb_desc->queue_index != BEACON_QUEUE)) {
	    RT_TRACE(COMP_ERR,"No more TX desc@%d, ring->idx = %d,idx = %d,%x", \
			    tcb_desc->queue_index,ring->idx, idx,skb->len);
            spin_unlock_irqrestore(&priv->irq_th_lock,flags);
	    return skb->len;
    } 
    if(tcb_desc->queue_index == MGNT_QUEUE)
    {
    }
    if(type == IEEE80211_FTYPE_DATA){
	    if(priv->ieee80211->LedControlHandler)
			priv->ieee80211->LedControlHandler(dev, LED_CTL_TX);
    }
    priv->ops->tx_fill_descriptor(dev, pdesc, tcb_desc, skb);
    __skb_queue_tail(&ring->queue, skb);
    pdesc->OWN = 1;
    spin_unlock_irqrestore(&priv->irq_th_lock,flags);
    dev->trans_start = jiffies;
#ifdef _RTL8192_EXT_PATCH_
    if(tcb_desc->queue_index != BEACON_QUEUE)
#endif
    write_nic_word(dev,TPPoll,0x01<<tcb_desc->queue_index);
    return 0;	
}

short rtl8192_alloc_rx_desc_ring(struct net_device *dev)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    rx_desc *entry = NULL;
    int i;

    priv->rx_ring = pci_alloc_consistent(priv->pdev,
            sizeof(*priv->rx_ring) * priv->rxringcount, &priv->rx_ring_dma);

    if (!priv->rx_ring || (unsigned long)priv->rx_ring & 0xFF) {
        RT_TRACE(COMP_ERR,"Cannot allocate RX ring\n");
        return -ENOMEM;
    }

    memset(priv->rx_ring, 0, sizeof(*priv->rx_ring) * priv->rxringcount);
    priv->rx_idx = 0;

    for (i = 0; i < priv->rxringcount; i++) {
        struct sk_buff *skb = dev_alloc_skb(priv->rxbuffersize);
        dma_addr_t *mapping;
        entry = &priv->rx_ring[i];
        if (!skb)
            return 0;
        skb->dev = dev;
        priv->rx_buf[i] = skb;
        mapping = (dma_addr_t *)skb->cb;
        *mapping = pci_map_single(priv->pdev, skb_tail_pointer(skb),
                priv->rxbuffersize, PCI_DMA_FROMDEVICE);

        entry->BufferAddress = cpu_to_le32(*mapping);

        entry->Length = priv->rxbuffersize;
        entry->OWN = 1;
    }

    entry->EOR = 1;
    return 0;
}

static int rtl8192_alloc_tx_desc_ring(struct net_device *dev,
        unsigned int prio, unsigned int entries)
{
    struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
    tx_desc *ring;
    dma_addr_t dma;
    int i;

    ring = pci_alloc_consistent(priv->pdev, sizeof(*ring) * entries, &dma);
    if (!ring || (unsigned long)ring & 0xFF) {
        RT_TRACE(COMP_ERR, "Cannot allocate TX ring (prio = %d)\n", prio);
        return -ENOMEM;
    }

    memset(ring, 0, sizeof(*ring)*entries);
    priv->tx_ring[prio].desc = ring;
    priv->tx_ring[prio].dma = dma;
    priv->tx_ring[prio].idx = 0;
    priv->tx_ring[prio].entries = entries;
    skb_queue_head_init(&priv->tx_ring[prio].queue);

    for (i = 0; i < entries; i++)
        ring[i].NextDescAddress =
            cpu_to_le32((u32)dma + ((i + 1) % entries) * sizeof(*ring));

    return 0;
}

                    
short rtl8192_pci_initdescring(struct net_device *dev)
{
    u32 ret;
    int i;
    struct r8192_priv *priv = ieee80211_priv(dev);

    ret = rtl8192_alloc_rx_desc_ring(dev);
    if (ret) {
        return ret;
    }
    

    for (i = 0; i < MAX_TX_QUEUE_COUNT; i++) {
        if ((ret = rtl8192_alloc_tx_desc_ring(dev, i, priv->txringcount)))
            goto err_free_rings;
    }

#if 0
    if ((ret = rtl8192_alloc_tx_desc_ring(dev, MAX_TX_QUEUE_COUNT - 1, 2)))
        goto err_free_rings;
#endif    

    return 0;

err_free_rings:
    rtl8192_free_rx_ring(dev);
    for (i = 0; i < MAX_TX_QUEUE_COUNT; i++)
        if (priv->tx_ring[i].desc)
            rtl8192_free_tx_ring(dev, i);
    return 1;
}

void rtl8192_pci_resetdescring(struct net_device *dev)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    int i;
    unsigned long flags = 0;
    if(priv->rx_ring) {
        rx_desc *entry = NULL;
        for (i = 0; i < priv->rxringcount; i++) {
            entry = &priv->rx_ring[i];
            entry->OWN = 1;
        }
        priv->rx_idx = 0;
    }

    spin_lock_irqsave(&priv->irq_th_lock,flags);
    for (i = 0; i < MAX_TX_QUEUE_COUNT; i++) {
        if (priv->tx_ring[i].desc) {
            struct rtl8192_tx_ring *ring = &priv->tx_ring[i];

            while (skb_queue_len(&ring->queue)) {
                tx_desc *entry = &ring->desc[ring->idx];
                struct sk_buff *skb = __skb_dequeue(&ring->queue);

                pci_unmap_single(priv->pdev, le32_to_cpu(entry->TxBuffAddr),
                        skb->len, PCI_DMA_TODEVICE);
                kfree_skb(skb);
                ring->idx = (ring->idx + 1) % ring->entries;
            }
            ring->idx = 0;
        }
    }
    spin_unlock_irqrestore(&priv->irq_th_lock,flags);
}

#if defined RTL8190P || defined RTL8192E
u8 HwRateToMRate90(bool bIsHT, u8 rate)
{
	u8  ret_rate = 0x02;

	if(!bIsHT) {
		switch(rate) {
			case DESC90_RATE1M:   ret_rate = MGN_1M;         break;
			case DESC90_RATE2M:   ret_rate = MGN_2M;         break;
			case DESC90_RATE5_5M: ret_rate = MGN_5_5M;       break;
			case DESC90_RATE11M:  ret_rate = MGN_11M;        break;
			case DESC90_RATE6M:   ret_rate = MGN_6M;         break;
			case DESC90_RATE9M:   ret_rate = MGN_9M;         break;
			case DESC90_RATE12M:  ret_rate = MGN_12M;        break;
			case DESC90_RATE18M:  ret_rate = MGN_18M;        break;
			case DESC90_RATE24M:  ret_rate = MGN_24M;        break;
			case DESC90_RATE36M:  ret_rate = MGN_36M;        break;
			case DESC90_RATE48M:  ret_rate = MGN_48M;        break;
			case DESC90_RATE54M:  ret_rate = MGN_54M;        break;

			default:
					      RT_TRACE(COMP_RECV, "HwRateToMRate90(): Non supported Rate [%x], bIsHT = %d!!!\n", rate, bIsHT);
					      break;
		}

	} else {
		switch(rate) {
			case DESC90_RATEMCS0:   ret_rate = MGN_MCS0;    break;
			case DESC90_RATEMCS1:   ret_rate = MGN_MCS1;    break;
			case DESC90_RATEMCS2:   ret_rate = MGN_MCS2;    break;
			case DESC90_RATEMCS3:   ret_rate = MGN_MCS3;    break;
			case DESC90_RATEMCS4:   ret_rate = MGN_MCS4;    break;
			case DESC90_RATEMCS5:   ret_rate = MGN_MCS5;    break;
			case DESC90_RATEMCS6:   ret_rate = MGN_MCS6;    break;
			case DESC90_RATEMCS7:   ret_rate = MGN_MCS7;    break;
			case DESC90_RATEMCS8:   ret_rate = MGN_MCS8;    break;
			case DESC90_RATEMCS9:   ret_rate = MGN_MCS9;    break;
			case DESC90_RATEMCS10:  ret_rate = MGN_MCS10;   break;
			case DESC90_RATEMCS11:  ret_rate = MGN_MCS11;   break;
			case DESC90_RATEMCS12:  ret_rate = MGN_MCS12;   break;
			case DESC90_RATEMCS13:  ret_rate = MGN_MCS13;   break;
			case DESC90_RATEMCS14:  ret_rate = MGN_MCS14;   break;
			case DESC90_RATEMCS15:  ret_rate = MGN_MCS15;   break;
			case DESC90_RATEMCS32:  ret_rate = (0x80|0x20); break;

			default:
						RT_TRACE(COMP_RECV, "HwRateToMRate90(): Non supported Rate [%x], bIsHT = %d!!!\n",rate, bIsHT);
						break;
		}
	}

	return ret_rate;
}
#endif
void UpdateRxPktTimeStamp8190 (struct net_device *dev, struct ieee80211_rx_stats *stats)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);

	if(stats->bIsAMPDU && !stats->bFirstMPDU) {
		stats->mac_time[0] = priv->LastRxDescTSFLow;
		stats->mac_time[1] = priv->LastRxDescTSFHigh;
	} else {
		priv->LastRxDescTSFLow = stats->mac_time[0];
		priv->LastRxDescTSFHigh = stats->mac_time[1];
	}
}

#ifdef _RTL8192_EXT_PATCH_
long rtl819x_translate_todbm(struct r8192_priv * priv, u8 signal_strength_index	)
#else
long rtl819x_translate_todbm(u8 signal_strength_index	)
#endif
{
	long	signal_power; 

#ifdef _RTL8192_EXT_PATCH_
	if(priv->CustomerID == RT_CID_819x_Lenovo)
	{	
		signal_power = (long)signal_strength_index;
		if(signal_power >= 45)
			signal_power -= 110;
		else
		{
			signal_power = ((signal_power*6)/10);
			signal_power -= 93;
		}
		return signal_power;
	}
#endif
	signal_power = (long)((signal_strength_index + 1) >> 1); 
	signal_power -= 95; 

	return signal_power;
}

#ifdef _RTL8192_EXT_PATCH_
void rtl819x_update_rxsignalstatistics8192S(
	struct r8192_priv * priv,
	struct ieee80211_rx_stats * pstats
	)
{
	int	weighting = 0;


	if(priv->stats.recv_signal_power == 0)
		priv->stats.recv_signal_power = pstats->RecvSignalPower;

	if(pstats->RecvSignalPower > priv->stats.recv_signal_power)
		weighting = 5;
	else if(pstats->RecvSignalPower < priv->stats.recv_signal_power)
		weighting = (-5);
	priv->stats.recv_signal_power = (priv->stats.recv_signal_power * 5 + pstats->RecvSignalPower + weighting) / 6;

}	
#endif
void
rtl819x_update_rxsignalstatistics8190pci(
	struct r8192_priv * priv,
	struct ieee80211_rx_stats * pprevious_stats
	)
{
	int weighting = 0;


	if(priv->stats.recv_signal_power == 0)
		priv->stats.recv_signal_power = pprevious_stats->RecvSignalPower;

	if(pprevious_stats->RecvSignalPower > priv->stats.recv_signal_power)
		weighting = 5;
	else if(pprevious_stats->RecvSignalPower < priv->stats.recv_signal_power)
		weighting = (-5);
	priv->stats.recv_signal_power = (priv->stats.recv_signal_power * 5 + pprevious_stats->RecvSignalPower + weighting) / 6;
}

void
rtl8190_process_cck_rxpathsel(
	struct r8192_priv * priv,
	struct ieee80211_rx_stats * pprevious_stats
	)
{
#ifdef RTL8190P	
	char				last_cck_adc_pwdb[4]={0,0,0,0};
	u8				i;
		if(priv->rf_type == RF_2T4R && DM_RxPathSelTable.Enable)
		{
			if(pprevious_stats->bIsCCK && 
				(pprevious_stats->bPacketToSelf ||pprevious_stats->bPacketBeacon))
			{
				if(priv->stats.cck_adc_pwdb.TotalNum++ >= PHY_RSSI_SLID_WIN_MAX)
				{
					priv->stats.cck_adc_pwdb.TotalNum = PHY_RSSI_SLID_WIN_MAX;
					for(i=RF90_PATH_A; i<RF90_PATH_MAX; i++)
					{
						last_cck_adc_pwdb[i] = priv->stats.cck_adc_pwdb.elements[i][priv->stats.cck_adc_pwdb.index];
						priv->stats.cck_adc_pwdb.TotalVal[i] -= last_cck_adc_pwdb[i];
					}
				}
				for(i=RF90_PATH_A; i<RF90_PATH_MAX; i++)
				{
					priv->stats.cck_adc_pwdb.TotalVal[i] += pprevious_stats->cck_adc_pwdb[i];
					priv->stats.cck_adc_pwdb.elements[i][priv->stats.cck_adc_pwdb.index] = pprevious_stats->cck_adc_pwdb[i];
				}
				priv->stats.cck_adc_pwdb.index++;
				if(priv->stats.cck_adc_pwdb.index >= PHY_RSSI_SLID_WIN_MAX)
					priv->stats.cck_adc_pwdb.index = 0;

				for(i=RF90_PATH_A; i<RF90_PATH_MAX; i++)
				{
					DM_RxPathSelTable.cck_pwdb_sta[i] = priv->stats.cck_adc_pwdb.TotalVal[i]/priv->stats.cck_adc_pwdb.TotalNum;
				}

				for(i=RF90_PATH_A; i<RF90_PATH_MAX; i++)
				{
					if(pprevious_stats->cck_adc_pwdb[i]  > (char)priv->undecorated_smoothed_cck_adc_pwdb[i])
					{
						priv->undecorated_smoothed_cck_adc_pwdb[i] = 
							( (priv->undecorated_smoothed_cck_adc_pwdb[i]*(Rx_Smooth_Factor-1)) + 
							(pprevious_stats->cck_adc_pwdb[i])) /(Rx_Smooth_Factor);
						priv->undecorated_smoothed_cck_adc_pwdb[i] = priv->undecorated_smoothed_cck_adc_pwdb[i] + 1;
					}
					else
					{
						priv->undecorated_smoothed_cck_adc_pwdb[i] = 
							( (priv->undecorated_smoothed_cck_adc_pwdb[i]*(Rx_Smooth_Factor-1)) + 
							(pprevious_stats->cck_adc_pwdb[i])) /(Rx_Smooth_Factor);
					}
				}
			}
		}
#endif
}

#ifdef _RTL8192_EXT_PATCH_
void Process_UI_RSSI_8192S(struct r8192_priv * priv,struct ieee80211_rx_stats * pstats)
{
	u8			rfPath;
	u32			last_rssi, tmpVal;

	if(pstats->bPacketToSelf || pstats->bPacketBeacon)
	{
		priv->stats.RssiCalculateCnt++;	
		if(priv->stats.ui_rssi.TotalNum++ >= PHY_RSSI_SLID_WIN_MAX)
		{
			priv->stats.ui_rssi.TotalNum = PHY_RSSI_SLID_WIN_MAX;
			last_rssi = priv->stats.ui_rssi.elements[priv->stats.ui_rssi.index];
			priv->stats.ui_rssi.TotalVal -= last_rssi;
		}
		priv->stats.ui_rssi.TotalVal += pstats->SignalStrength;
	
		priv->stats.ui_rssi.elements[priv->stats.ui_rssi.index++] = pstats->SignalStrength;
		if(priv->stats.ui_rssi.index >= PHY_RSSI_SLID_WIN_MAX)
			priv->stats.ui_rssi.index = 0;
	
		tmpVal = priv->stats.ui_rssi.TotalVal/priv->stats.ui_rssi.TotalNum;
		priv->stats.signal_strength = rtl819x_translate_todbm(priv, (u8)tmpVal);

	}

	if(!pstats->bIsCCK && pstats->bPacketToSelf)
	{
		for (rfPath = RF90_PATH_A; rfPath < priv->NumTotalRFPath; rfPath++)
		{
			if (!rtl8192_phy_CheckIsLegalRFPath(priv->ieee80211->dev, rfPath))
				continue;
			RT_TRACE(COMP_DBG, "pstats->RxMIMOSignalStrength[%d]  = %d \n", rfPath, pstats->RxMIMOSignalStrength[rfPath] );

			if(priv->stats.rx_rssi_percentage[rfPath] == 0)	
			{
				priv->stats.rx_rssi_percentage[rfPath] = pstats->RxMIMOSignalStrength[rfPath];
			}
			
			if(pstats->RxMIMOSignalStrength[rfPath]  > priv->stats.rx_rssi_percentage[rfPath])
			{
				priv->stats.rx_rssi_percentage[rfPath] = 
					( (priv->stats.rx_rssi_percentage[rfPath]*(Rx_Smooth_Factor-1)) + 
					(pstats->RxMIMOSignalStrength[rfPath])) /(Rx_Smooth_Factor);
				priv->stats.rx_rssi_percentage[rfPath] = priv->stats.rx_rssi_percentage[rfPath] + 1;
			}
			else
			{
				priv->stats.rx_rssi_percentage[rfPath] = 
					( (priv->stats.rx_rssi_percentage[rfPath]*(Rx_Smooth_Factor-1)) + 
					(pstats->RxMIMOSignalStrength[rfPath])) /(Rx_Smooth_Factor);
			}
			RT_TRACE(COMP_DBG, "priv->stats.rx_rssi_percentage[%d]  = %d \n",rfPath, priv->stats.rx_rssi_percentage[rfPath] );
		}
	}
	
}	

void Process_PWDB_8192S(struct r8192_priv * priv,struct ieee80211_rx_stats * pstats,struct ieee80211_network* pnet)
{
	long	UndecoratedSmoothedPWDB=0;

	if(pnet){
		if(priv->mshobj->ext_patch_get_peermp_rssi_param)
		UndecoratedSmoothedPWDB = priv->mshobj->ext_patch_get_peermp_rssi_param(pnet);
	}
	else
		UndecoratedSmoothedPWDB = priv->undecorated_smoothed_pwdb;

	if(pstats->bPacketToSelf || pstats->bPacketBeacon)
	{
		if(UndecoratedSmoothedPWDB < 0)	
		{
			UndecoratedSmoothedPWDB = pstats->RxPWDBAll;
		}
		
		if(pstats->RxPWDBAll > (u32)UndecoratedSmoothedPWDB)
		{
			UndecoratedSmoothedPWDB = 	
					( ((UndecoratedSmoothedPWDB)*(Rx_Smooth_Factor-1)) + 
					(pstats->RxPWDBAll)) /(Rx_Smooth_Factor);
			UndecoratedSmoothedPWDB = UndecoratedSmoothedPWDB + 1;
		}
		else
		{
			UndecoratedSmoothedPWDB = 	
					( ((UndecoratedSmoothedPWDB)*(Rx_Smooth_Factor-1)) + 
					(pstats->RxPWDBAll)) /(Rx_Smooth_Factor);
		}
		if(pnet)
		{
			if(priv->mshobj->ext_patch_set_peermp_rssi_param)
				priv->mshobj->ext_patch_set_peermp_rssi_param(pnet,UndecoratedSmoothedPWDB);
		}
		else
		{
			priv->undecorated_smoothed_pwdb = UndecoratedSmoothedPWDB;
		}
		rtl819x_update_rxsignalstatistics8192S(priv, pstats);
	}
}

void Process_UiLinkQuality8192S(struct r8192_priv * priv,struct ieee80211_rx_stats * pstats)
{
	u32	last_evm=0, nSpatialStream, tmpVal;

	if(pstats->SignalQuality != 0)	
	{
		if (pstats->bPacketToSelf || pstats->bPacketBeacon)
		{
			if(priv->stats.ui_link_quality.TotalNum++ >= PHY_LINKQUALITY_SLID_WIN_MAX)
			{
				priv->stats.ui_link_quality.TotalNum = PHY_LINKQUALITY_SLID_WIN_MAX;
				last_evm = priv->stats.ui_link_quality.elements[priv->stats.ui_link_quality.index];
				priv->stats.ui_link_quality.TotalVal -= last_evm;
			}
			priv->stats.ui_link_quality.TotalVal += pstats->SignalQuality;

			priv->stats.ui_link_quality.elements[priv->stats.ui_link_quality.index++] = pstats->SignalQuality;
			if(priv->stats.ui_link_quality.index >= PHY_LINKQUALITY_SLID_WIN_MAX)
				priv->stats.ui_link_quality.index = 0;


			tmpVal = priv->stats.ui_link_quality.TotalVal/priv->stats.ui_link_quality.TotalNum;
			priv->stats.signal_quality = tmpVal;
			priv->stats.last_signal_strength_inpercent = tmpVal;
		
			for(nSpatialStream = 0; nSpatialStream<2 ; nSpatialStream++)	
			{
				if(pstats->RxMIMOSignalQuality[nSpatialStream] != -1)
				{
					if(priv->stats.rx_evm_percentage[nSpatialStream] == 0)	
					{
						priv->stats.rx_evm_percentage[nSpatialStream] = pstats->RxMIMOSignalQuality[nSpatialStream];
					}
					priv->stats.rx_evm_percentage[nSpatialStream] = 
					( (priv->stats.rx_evm_percentage[nSpatialStream]*(Rx_Smooth_Factor-1)) + 
					(pstats->RxMIMOSignalQuality[nSpatialStream]* 1)) /(Rx_Smooth_Factor);
				}
			}
		}
	}
	else
		;
	
}	
#endif
#ifdef _RTL8192_EXT_PATCH_
void rtl8192_process_phyinfo(struct r8192_priv * priv, u8* buffer,struct ieee80211_rx_stats * pcurrent_stats,struct ieee80211_network * pnet)
#else
void rtl8192_process_phyinfo(struct r8192_priv * priv, u8* buffer,struct ieee80211_rx_stats * pprevious_stats, struct ieee80211_rx_stats * pcurrent_stats)
#endif
{
#ifdef _RTL8192_EXT_PATCH_
	if(!pcurrent_stats->bPacketMatchBSSID)
		return;
	Process_UI_RSSI_8192S(priv, pcurrent_stats);
	Process_PWDB_8192S(priv, pcurrent_stats, pnet);
	Process_UiLinkQuality8192S(priv, pcurrent_stats);	
#else
	bool bcheck = false;
	u8	rfpath;
	u32 nspatial_stream, tmp_val;
	static u32 slide_rssi_index=0, slide_rssi_statistics=0; 
	static u32 slide_evm_index=0, slide_evm_statistics=0;
	static u32 last_rssi=0, last_evm=0;
	static u32 slide_beacon_adc_pwdb_index=0, slide_beacon_adc_pwdb_statistics=0;
	static u32 last_beacon_adc_pwdb=0;

	struct ieee80211_hdr_3addr *hdr;
	u16 sc ;
	unsigned int frag,seq;
	hdr = (struct ieee80211_hdr_3addr *)buffer;
	sc = le16_to_cpu(hdr->seq_ctl);
	frag = WLAN_GET_SEQ_FRAG(sc);
	seq = WLAN_GET_SEQ_SEQ(sc);
	pcurrent_stats->Seq_Num = seq;
	if(!pprevious_stats->bIsAMPDU)
	{
		bcheck = true;
	}else 
	{
#if 0
		if( !pcurrent_stats->bIsAMPDU || pcurrent_stats->bFirstMPDU)
			bcheck = true;
#endif
	}
		
	if(slide_rssi_statistics++ >= PHY_RSSI_SLID_WIN_MAX)
	{
		slide_rssi_statistics = PHY_RSSI_SLID_WIN_MAX;
		last_rssi = priv->stats.slide_signal_strength[slide_rssi_index];
		priv->stats.slide_rssi_total -= last_rssi;
	}
	priv->stats.slide_rssi_total += pprevious_stats->SignalStrength;
	
	priv->stats.slide_signal_strength[slide_rssi_index++] = pprevious_stats->SignalStrength;
	if(slide_rssi_index >= PHY_RSSI_SLID_WIN_MAX)
		slide_rssi_index = 0;
	
	tmp_val = priv->stats.slide_rssi_total/slide_rssi_statistics;
	priv->stats.signal_strength = rtl819x_translate_todbm((u8)tmp_val);
	pcurrent_stats->rssi = priv->stats.signal_strength;
	if(!pprevious_stats->bPacketMatchBSSID)
	{
		if(!pprevious_stats->bToSelfBA)
			return;
	}
	
	if(!bcheck)
		return;

	rtl8190_process_cck_rxpathsel(priv,pprevious_stats);

	priv->stats.num_process_phyinfo++;
#if 0
	if(slide_rssi_statistics++ >= PHY_RSSI_SLID_WIN_MAX)
	{
		slide_rssi_statistics = PHY_RSSI_SLID_WIN_MAX;
		last_rssi = priv->stats.slide_signal_strength[slide_rssi_index];
		priv->stats.slide_rssi_total -= last_rssi;
	}
	priv->stats.slide_rssi_total += pprevious_stats->SignalStrength;
	
	priv->stats.slide_signal_strength[slide_rssi_index++] = pprevious_stats->SignalStrength;
	if(slide_rssi_index >= PHY_RSSI_SLID_WIN_MAX)
		slide_rssi_index = 0;
	
	tmp_val = priv->stats.slide_rssi_total/slide_rssi_statistics;
	priv->stats.signal_strength = rtl819x_translate_todbm((u8)tmp_val);

#endif
	if(!pprevious_stats->bIsCCK && pprevious_stats->bPacketToSelf)
	{
		for (rfpath = RF90_PATH_A; rfpath < RF90_PATH_C; rfpath++)
		{
			if (!rtl8192_phy_CheckIsLegalRFPath(priv->ieee80211->dev, rfpath))
				continue;
			RT_TRACE(COMP_DBG,"Jacken -> pPreviousstats->RxMIMOSignalStrength[rfpath]  = %d \n" ,pprevious_stats->RxMIMOSignalStrength[rfpath] );		 
			if(priv->stats.rx_rssi_percentage[rfpath] == 0)
			{
				priv->stats.rx_rssi_percentage[rfpath] = pprevious_stats->RxMIMOSignalStrength[rfpath];
			}	
			if(pprevious_stats->RxMIMOSignalStrength[rfpath]  > priv->stats.rx_rssi_percentage[rfpath])
			{
				priv->stats.rx_rssi_percentage[rfpath] = 
					( (priv->stats.rx_rssi_percentage[rfpath]*(Rx_Smooth_Factor-1)) + 
					(pprevious_stats->RxMIMOSignalStrength[rfpath])) /(Rx_Smooth_Factor);
				priv->stats.rx_rssi_percentage[rfpath] = priv->stats.rx_rssi_percentage[rfpath]  + 1;
			}
			else
			{
				priv->stats.rx_rssi_percentage[rfpath] = 
					( (priv->stats.rx_rssi_percentage[rfpath]*(Rx_Smooth_Factor-1)) + 
					(pprevious_stats->RxMIMOSignalStrength[rfpath])) /(Rx_Smooth_Factor);
			}	
			RT_TRACE(COMP_DBG,"Jacken -> priv->RxStats.RxRSSIPercentage[rfPath]  = %d \n" ,priv->stats.rx_rssi_percentage[rfpath] );
		}		
	}
	
	
	if(pprevious_stats->bPacketBeacon)
	{
		if(slide_beacon_adc_pwdb_statistics++ >= PHY_Beacon_RSSI_SLID_WIN_MAX)
		{
			slide_beacon_adc_pwdb_statistics = PHY_Beacon_RSSI_SLID_WIN_MAX;	
			last_beacon_adc_pwdb = priv->stats.Slide_Beacon_pwdb[slide_beacon_adc_pwdb_index];
			priv->stats.Slide_Beacon_Total -= last_beacon_adc_pwdb;
		}
		priv->stats.Slide_Beacon_Total += pprevious_stats->RxPWDBAll;
		priv->stats.Slide_Beacon_pwdb[slide_beacon_adc_pwdb_index] = pprevious_stats->RxPWDBAll;
		slide_beacon_adc_pwdb_index++;
		if(slide_beacon_adc_pwdb_index >= PHY_Beacon_RSSI_SLID_WIN_MAX)
			slide_beacon_adc_pwdb_index = 0;
		pprevious_stats->RxPWDBAll = priv->stats.Slide_Beacon_Total/slide_beacon_adc_pwdb_statistics;
		if(pprevious_stats->RxPWDBAll >= 3)
			pprevious_stats->RxPWDBAll -= 3;
	}

	RT_TRACE(COMP_RXDESC, "Smooth %s PWDB = %d\n", 
				pprevious_stats->bIsCCK? "CCK": "OFDM",
				pprevious_stats->RxPWDBAll);

	if(pprevious_stats->bPacketToSelf || pprevious_stats->bPacketBeacon || pprevious_stats->bToSelfBA)
	{
		if(priv->undecorated_smoothed_pwdb < 0)	
		{
			priv->undecorated_smoothed_pwdb = pprevious_stats->RxPWDBAll;
		}
#if 1
		if(pprevious_stats->RxPWDBAll > (u32)priv->undecorated_smoothed_pwdb)
		{
			priv->undecorated_smoothed_pwdb =	
					( ((priv->undecorated_smoothed_pwdb)*(Rx_Smooth_Factor-1)) + 
					(pprevious_stats->RxPWDBAll)) /(Rx_Smooth_Factor);
			priv->undecorated_smoothed_pwdb = priv->undecorated_smoothed_pwdb + 1;
		}
		else
		{
			priv->undecorated_smoothed_pwdb =	
					( ((priv->undecorated_smoothed_pwdb)*(Rx_Smooth_Factor-1)) + 
					(pprevious_stats->RxPWDBAll)) /(Rx_Smooth_Factor);
		}
#else
		if(pPreviousRfd->Status.RxPWDBAll > (u32)pHalData->UndecoratedSmoothedPWDB)
		{
			pHalData->UndecoratedSmoothedPWDB = 	
					( ((pHalData->UndecoratedSmoothedPWDB)* 5) + (pPreviousRfd->Status.RxPWDBAll)) / 6;
			pHalData->UndecoratedSmoothedPWDB = pHalData->UndecoratedSmoothedPWDB + 1;
		}
		else
		{
			pHalData->UndecoratedSmoothedPWDB = 	
					( ((pHalData->UndecoratedSmoothedPWDB)* 5) + (pPreviousRfd->Status.RxPWDBAll)) / 6;
		}		
#endif
		rtl819x_update_rxsignalstatistics8190pci(priv,pprevious_stats);
	}

	if(pprevious_stats->SignalQuality == 0)
	{
	}
	else
	{
		if(pprevious_stats->bPacketToSelf || pprevious_stats->bPacketBeacon || pprevious_stats->bToSelfBA){
			if(slide_evm_statistics++ >= PHY_RSSI_SLID_WIN_MAX){
				slide_evm_statistics = PHY_RSSI_SLID_WIN_MAX;
				last_evm = priv->stats.slide_evm[slide_evm_index];
				priv->stats.slide_evm_total -= last_evm;
			}
	
			priv->stats.slide_evm_total += pprevious_stats->SignalQuality;
	
			priv->stats.slide_evm[slide_evm_index++] = pprevious_stats->SignalQuality;
			if(slide_evm_index >= PHY_RSSI_SLID_WIN_MAX)
				slide_evm_index = 0;
	
			tmp_val = priv->stats.slide_evm_total/slide_evm_statistics;
			priv->stats.signal_quality = tmp_val;
			priv->stats.last_signal_strength_inpercent = tmp_val;
		}

		if(pprevious_stats->bPacketToSelf || pprevious_stats->bPacketBeacon || pprevious_stats->bToSelfBA)
		{
			for(nspatial_stream = 0; nspatial_stream<2 ; nspatial_stream++) 
			{
				if(pprevious_stats->RxMIMOSignalQuality[nspatial_stream] != -1)
				{
					if(priv->stats.rx_evm_percentage[nspatial_stream] == 0)	
					{
						priv->stats.rx_evm_percentage[nspatial_stream] = pprevious_stats->RxMIMOSignalQuality[nspatial_stream];
					}
					priv->stats.rx_evm_percentage[nspatial_stream] = 
						( (priv->stats.rx_evm_percentage[nspatial_stream]* (Rx_Smooth_Factor-1)) + 
						(pprevious_stats->RxMIMOSignalQuality[nspatial_stream]* 1)) / (Rx_Smooth_Factor);
				}
			}
		}
	}
#endif
	
}

static u8 rtl819x_query_rxpwrpercentage(
	char		antpower
	)
{
	if ((antpower <= -100) || (antpower >= 20))
	{
		return	0;
	}
	else if (antpower >= 0)
	{
		return	100;
	}
	else
	{
		return	(100+antpower);
	}
	
}	/* QueryRxPwrPercentage */

static u8 
rtl819x_evm_dbtopercentage(
	char value
	)
{
	char ret_val;
	
	ret_val = value;
	
	if(ret_val >= 0)
		ret_val = 0;
	if(ret_val <= -33)
		ret_val = -33;
	ret_val = 0 - ret_val;
	ret_val*=3;
	if(ret_val == 99)
		ret_val = 100;
	return(ret_val);
}
long
rtl819x_signal_scale_mapping(struct r8192_priv * priv,
	long currsig
	)
{
	long retsig;

#ifdef RTL8192SE
	if(priv->CustomerID == RT_CID_819x_Lenovo)
	{
		return currsig;
	}
	else if(priv->CustomerID == RT_CID_819x_Netcore)
	{	
		if(currsig >= 31 && currsig <= 100)
		{
			retsig = 100;
		}	
		else if(currsig >= 21 && currsig <= 30)
		{
			retsig = 90 + ((currsig - 20) / 1);
		}
		else if(currsig >= 11 && currsig <= 20)
		{
			retsig = 80 + ((currsig - 10) / 1);
		}
		else if(currsig >= 7 && currsig <= 10)
		{
			retsig = 69 + (currsig - 7);
		}
		else if(currsig == 6)
		{
			retsig = 54;
		}
		else if(currsig == 5)
		{
			retsig = 45;
		}
		else if(currsig == 4)
		{
			retsig = 36;
		}
		else if(currsig == 3)
		{
			retsig = 27;
		}
		else if(currsig == 2)
		{
			retsig = 18;
		}
		else if(currsig == 1)
		{
			retsig = 9;
		}
		else
		{
			retsig = currsig;
		}
		return retsig;
	}
#endif

	if(currsig >= 61 && currsig <= 100)
	{
		retsig = 90 + ((currsig - 60) / 4);
	}
	else if(currsig >= 41 && currsig <= 60)
	{
		retsig = 78 + ((currsig - 40) / 2);
	}
	else if(currsig >= 31 && currsig <= 40)
	{
		retsig = 66 + (currsig - 30);
	}
	else if(currsig >= 21 && currsig <= 30)
	{
		retsig = 54 + (currsig - 20);
	}
	else if(currsig >= 5 && currsig <= 20)
	{
		retsig = 42 + (((currsig - 5) * 2) / 3);
	}
	else if(currsig == 4)
	{
		retsig = 36;
	}
	else if(currsig == 3)
	{
		retsig = 27;
	}
	else if(currsig == 2)
	{
		retsig = 18;
	}
	else if(currsig == 1)
	{
		retsig = 9;
	}
	else
	{
		retsig = currsig;
	}
	
	return retsig;
}
#ifdef RTL8192SE
#define 	rx_hal_is_cck_rate(_pdesc)\
			(_pdesc->RxMCS == DESC92S_RATE1M ||\
			 _pdesc->RxMCS == DESC92S_RATE2M ||\
			 _pdesc->RxMCS == DESC92S_RATE5_5M ||\
			 _pdesc->RxMCS == DESC92S_RATE11M)
#ifdef _RTL8192_EXT_PATCH_
static void rtl8192_query_rxphystatus(
	struct r8192_priv * priv,
	struct ieee80211_rx_stats * pstats,
	prx_desc  pdesc,	
	prx_fwinfo   pDrvInfo,
	bool bpacket_match_bssid,
	bool bpacket_toself,
	bool bPacketBeacon
	)
{
	bool is_cck_rate;
	phy_sts_cck_8192s_t* cck_buf;
	u8 rx_pwr_all=0, rx_pwr[4], rf_rx_num=0, EVM, PWDB_ALL;
	u8 i, max_spatial_stream;
	u32 rssi, total_rssi = 0;
	u8 cck_highpwr = 0;
	is_cck_rate = rx_hal_is_cck_rate(pdesc);

	pstats->bPacketMatchBSSID = bpacket_match_bssid;
	pstats->bPacketToSelf = bpacket_toself;
	pstats->bIsCCK = is_cck_rate;
	pstats->bPacketBeacon = bPacketBeacon;

	pstats->RxMIMOSignalQuality[0] = -1;
	pstats->RxMIMOSignalQuality[1] = -1;

	if (is_cck_rate){
		u8 report;
			
		cck_buf = (phy_sts_cck_8192s_t*)pDrvInfo;

		if(priv->ieee80211->eRFPowerState == eRfOn)
			cck_highpwr = (u8)priv->bCckHighPower;
		else
			cck_highpwr = false;
		if (!cck_highpwr){
			report = cck_buf->cck_agc_rpt & 0xc0;
			report = report >> 6;
			switch(report){
				case 0x3:
					rx_pwr_all = -40 - (cck_buf->cck_agc_rpt&0x3e);
					break;
				case 0x2:
					rx_pwr_all = -20 - (cck_buf->cck_agc_rpt&0x3e);
					break;
				case 0x1:
					rx_pwr_all = -2 - (cck_buf->cck_agc_rpt&0x3e);
					break;
				case 0x0:
					rx_pwr_all = 14 - (cck_buf->cck_agc_rpt&0x3e);
					break;
			}
		}
		else{
			report = pDrvInfo->cfosho[0] & 0x60;
			report = report >> 5;
			switch(report){
				case 0x3:
					rx_pwr_all = -40 - ((cck_buf->cck_agc_rpt & 0x1f)<<1);
					break;
				case 0x2:
					rx_pwr_all = -20 - ((cck_buf->cck_agc_rpt & 0x1f)<<1);
					break;
				case 0x1:
					rx_pwr_all = -2 - ((cck_buf->cck_agc_rpt & 0x1f)<<1);
					break;
				case 0x0:
					rx_pwr_all = 14 - ((cck_buf->cck_agc_rpt & 0x1f)<<1);
					break;
			}
		}

		PWDB_ALL= rtl819x_query_rxpwrpercentage(rx_pwr_all);
		{
			PWDB_ALL+=6;
			if(PWDB_ALL > 100)
				PWDB_ALL = 100;
			if(PWDB_ALL > 34 && PWDB_ALL <= 42)
				PWDB_ALL -= 2;
			else if(PWDB_ALL > 26 && PWDB_ALL <= 34)
				PWDB_ALL -= 6;
			else if(PWDB_ALL > 14 && PWDB_ALL <= 26)
				PWDB_ALL -= 8;
			else if(PWDB_ALL > 4 && PWDB_ALL <= 14)
				PWDB_ALL -= 4;
		}
		pstats->RxPWDBAll = PWDB_ALL;
		pstats->RecvSignalPower = rx_pwr_all;

		if (bpacket_match_bssid){
			u8 sq;
			if(priv->CustomerID == RT_CID_819x_Lenovo)		
			{
				if(PWDB_ALL >= 50)
					sq = 100;
				else if(PWDB_ALL >= 35 && PWDB_ALL < 50)
					sq = 80;
				else if(PWDB_ALL >= 22 && PWDB_ALL < 35)
					sq = 60;
				else if(PWDB_ALL >= 18 && PWDB_ALL < 22)
					sq = 40;
				else
					sq = 20;
			}
			else
			{
			if (pstats->RxPWDBAll > 40)
				sq = 100;
			else{
				sq = cck_buf->sq_rpt;
				if (sq > 64)
					sq = 0;
				else if(sq < 20)
					sq = 100;
				else
					sq = ((64-sq)*100)/44;
			}
			}
			pstats->SignalQuality = sq;
			pstats->RxMIMOSignalQuality[0] = sq;
			pstats->RxMIMOSignalQuality[1] = -1;
		}
	}
	else{
		priv->brfpath_rxenable[0] = priv->brfpath_rxenable[1] = true;

		for (i=RF90_PATH_A; i<RF90_PATH_MAX; i++){
			if (priv->brfpath_rxenable[i])
				rf_rx_num ++;

			rx_pwr[i] = ((pDrvInfo->gain_trsw[i]&0x3f)*2) - 110;
			rssi = rtl819x_query_rxpwrpercentage(rx_pwr[i]);
			total_rssi += rssi;

			priv->stats.rxSNRdB[i] = (long)(pDrvInfo->rxsnr[i]/2);

			if (bpacket_match_bssid){
				pstats->RxMIMOSignalStrength[i] = (u8)rssi;
				if(priv->CustomerID == RT_CID_819x_Lenovo)
				{
					u8	SQ;
					
					if(i == 0)
					{
						if(rssi >= 50)
							SQ = 100;
						else if(rssi >= 35 && rssi < 50)
							SQ = 80;
						else if(rssi >= 22 && rssi < 35)
							SQ = 60;
						else if(rssi >= 18 && rssi < 22)
							SQ = 40;
						else
							SQ = 20;
						pstats->SignalQuality = SQ;
			}
		}
			}
		}
		rx_pwr_all = ((pDrvInfo->pwdb_all >> 1) & 0x7f) - 106;
		PWDB_ALL = rtl819x_query_rxpwrpercentage(rx_pwr_all);

		pstats->RxPWDBAll = PWDB_ALL;
		pstats->RxPower = rx_pwr_all;
		pstats->RecvSignalPower = rx_pwr_all;

		if(priv->CustomerID != RT_CID_819x_Lenovo){	
		if (pdesc->RxHT && pdesc->RxMCS >= DESC92S_RATEMCS8 && pdesc->RxMCS <= DESC92S_RATEMCS15)
			max_spatial_stream = 2;
		else
			max_spatial_stream = 1;

		for(i=0; i<max_spatial_stream; i++){
			EVM = rtl819x_evm_dbtopercentage(pDrvInfo->rxevm[i]);

			if (bpacket_match_bssid)
			{
				if (i==0)
						pstats->SignalQuality = (u8)(EVM & 0xff);
					pstats->RxMIMOSignalQuality[i] = (u8)(EVM&0xff);
				}
			}
		}
#if 1
		if (pdesc->BandWidth)
			priv->stats.received_bwtype[1+pDrvInfo->rxsc]++;
		else
			priv->stats.received_bwtype[0]++;
#endif
	}

	if (is_cck_rate){
		pstats->SignalStrength = (u8)(rtl819x_signal_scale_mapping(priv,PWDB_ALL));
	}
	else {
		if (rf_rx_num != 0)
			pstats->SignalStrength = (u8)(rtl819x_signal_scale_mapping(priv,total_rssi/=rf_rx_num));
	}
}
#else
static void rtl8192_query_rxphystatus(
	struct r8192_priv * priv,
	struct ieee80211_rx_stats * pstats,
	prx_desc  pdesc,	
	prx_fwinfo   pDrvInfo,
	struct ieee80211_rx_stats * precord_stats,
	bool bpacket_match_bssid,
	bool bpacket_toself,
	bool bPacketBeacon,
	bool bToSelfBA
	)
{
	bool is_cck_rate;
	phy_sts_cck_8192s_t* cck_buf;
	s8 rx_pwr_all=0, rx_pwr[4]; 
	u8 rf_rx_num=0, EVM, PWDB_ALL;
	u8 i, max_spatial_stream;
	u32 rssi, total_rssi = 0;

	is_cck_rate = rx_hal_is_cck_rate(pdesc);

	memset(precord_stats, 0, sizeof(struct ieee80211_rx_stats));
	pstats->bPacketMatchBSSID = precord_stats->bPacketMatchBSSID = bpacket_match_bssid;
	pstats->bPacketToSelf = precord_stats->bPacketToSelf = bpacket_toself;
	pstats->bIsCCK = precord_stats->bIsCCK = is_cck_rate;
	pstats->bPacketBeacon = precord_stats->bPacketBeacon = bPacketBeacon;
	pstats->bToSelfBA = precord_stats->bToSelfBA = bToSelfBA;
	pstats->bIsCCK = precord_stats->bIsCCK = is_cck_rate;

	pstats->RxMIMOSignalQuality[0] = -1;
	pstats->RxMIMOSignalQuality[1] = -1;
	precord_stats->RxMIMOSignalQuality[0] = -1;
	precord_stats->RxMIMOSignalQuality[1] = -1;

	if (is_cck_rate){
		u8 report, cck_highpwr;
			
		cck_buf = (phy_sts_cck_8192s_t*)pDrvInfo;

		if(!priv->bInPowerSaveMode)
		cck_highpwr = (u8)rtl8192_QueryBBReg(priv->ieee80211->dev, rFPGA0_XA_HSSIParameter2, BIT9);
		else
			cck_highpwr = false;
		if (!cck_highpwr){
			report = cck_buf->cck_agc_rpt & 0xc0;
			report = report >> 6;
			switch(report){
				case 0x3:
					rx_pwr_all = -35 - (cck_buf->cck_agc_rpt&0x3e);
					break;
				case 0x2:
					rx_pwr_all = -23 - (cck_buf->cck_agc_rpt&0x3e);
					break;
				case 0x1:
					rx_pwr_all = -11 - (cck_buf->cck_agc_rpt&0x3e);
					break;
				case 0x0:
					rx_pwr_all = 8 - (cck_buf->cck_agc_rpt&0x3e);
					break;
			}
		}
		else{
			report = pDrvInfo->cfosho[0] & 0x60;
			report = report >> 5;
			switch(report){
				case 0x3:
					rx_pwr_all = -35 - ((cck_buf->cck_agc_rpt & 0x1f)<<1);
					break;
				case 0x2:
					rx_pwr_all = -23 - ((cck_buf->cck_agc_rpt & 0x1f)<<1);
					break;
				case 0x1:
					rx_pwr_all = -11 - ((cck_buf->cck_agc_rpt & 0x1f)<<1);
					break;
				case 0x0:
					rx_pwr_all = -8 - ((cck_buf->cck_agc_rpt & 0x1f)<<1);
					break;
			}
		}

		PWDB_ALL= rtl819x_query_rxpwrpercentage(rx_pwr_all);
		pstats->RxPWDBAll = precord_stats->RxPWDBAll = PWDB_ALL;
		pstats->RecvSignalPower = rx_pwr_all;

		if (bpacket_match_bssid){
			u8 sq;
			if (pstats->RxPWDBAll > 40)
				sq = 100;
			else{
				sq = cck_buf->sq_rpt;
				if (sq > 64)
					sq = 0;
				else if(sq < 20)
					sq = 100;
				else
					sq = ((64-sq)*100)/44;
			}
			pstats->SignalQuality = precord_stats->SignalQuality = sq;
			pstats->RxMIMOSignalQuality[0] = precord_stats->RxMIMOSignalQuality[0] = sq;
			pstats->RxMIMOSignalQuality[1] = precord_stats->RxMIMOSignalQuality[1] = -1;
		}
	}
	else{
		priv->brfpath_rxenable[0] = priv->brfpath_rxenable[1] = true;

		for (i=RF90_PATH_A; i<RF90_PATH_MAX; i++){
			if (priv->brfpath_rxenable[i])
				rf_rx_num ++;

			rx_pwr[i] = ((pDrvInfo->gain_trsw[i]&0x3f)*2) - 110;
			rssi = rtl819x_query_rxpwrpercentage(rx_pwr[i]);
			total_rssi += rssi;

			priv->stats.rxSNRdB[i] = (long)(pDrvInfo->rxsnr[i]/2);

			if (bpacket_match_bssid){
				pstats->RxMIMOSignalStrength[i] = (u8)rssi;
				precord_stats->RxMIMOSignalStrength [i] = (u8)rssi;
			}
		}

		rx_pwr_all = ((pDrvInfo->pwdb_all >> 1) & 0x7f) - 0x106;
		PWDB_ALL = rtl819x_query_rxpwrpercentage(rx_pwr_all);

		pstats->RxPWDBAll = precord_stats->RxPWDBAll = PWDB_ALL;
		pstats->RxPower = precord_stats->RxPower = rx_pwr_all;
		pstats->RecvSignalPower = precord_stats->RecvSignalPower = rx_pwr_all;

		if (pdesc->RxHT && pdesc->RxMCS >= DESC92S_RATEMCS8 && pdesc->RxMCS <= DESC92S_RATEMCS15)
			max_spatial_stream = 2;
		else
			max_spatial_stream = 1;

		for(i=0; i<max_spatial_stream; i++){
			EVM = rtl819x_evm_dbtopercentage(pDrvInfo->rxevm[i]);

			if (bpacket_match_bssid)
			{
				if (i==0)
					pstats->SignalQuality = 
					precord_stats->SignalQuality = (u8)(EVM&0xff);
				pstats->RxMIMOSignalQuality[i] =
				precord_stats->RxMIMOSignalQuality[i] = (u8)(EVM&0xff);
			}
		}
#if 0
		if (pdesc->BW)
			priv->stats.received_bwtype[1+pDrvInfo->rxsc]++;
		else
			priv->stats.received_bwtype[0]++;
#endif
	}

	if (is_cck_rate)
		pstats->SignalStrength = 
		precord_stats->SignalStrength = (u8)(rtl819x_signal_scale_mapping(priv,PWDB_ALL));
	else
		if (rf_rx_num != 0)
			pstats->SignalStrength = 
			precord_stats->SignalStrength = (u8)(rtl819x_signal_scale_mapping(priv,total_rssi/=rf_rx_num));

}
#endif
#else 
#define 	rx_hal_is_cck_rate(_pdrvinfo)\
			(_pdrvinfo->RxRate == DESC90_RATE1M ||\
			_pdrvinfo->RxRate == DESC90_RATE2M ||\
			_pdrvinfo->RxRate == DESC90_RATE5_5M ||\
			_pdrvinfo->RxRate == DESC90_RATE11M) &&\
			!_pdrvinfo->RxHT
static void rtl8192_query_rxphystatus(
	struct r8192_priv * priv,
	struct ieee80211_rx_stats * pstats,
	prx_desc  pdesc,	
	prx_fwinfo   pdrvinfo,
	struct ieee80211_rx_stats * precord_stats,
	bool bpacket_match_bssid,
	bool bpacket_toself,
	bool bPacketBeacon,
	bool bToSelfBA
	)
{	
	phy_sts_ofdm_819xpci_t* pofdm_buf;
	phy_sts_cck_819xpci_t	*	pcck_buf;
	phy_ofdm_rx_status_rxsc_sgien_exintfflag* prxsc;
	u8				*prxpkt;
	u8				i,max_spatial_stream, tmp_rxsnr, tmp_rxevm, rxsc_sgien_exflg;
	char				rx_pwr[4], rx_pwr_all=0;
	char				rx_snrX, rx_evmX;
	u8				evm, pwdb_all;
	u32 			RSSI, total_rssi=0;
	u8				is_cck_rate=0;
	u8				rf_rx_num = 0;

	static	u8		check_reg824 = 0;
	static	u32		reg824_bit9 = 0;

	priv->stats.numqry_phystatus++;


	is_cck_rate = rx_hal_is_cck_rate(pdrvinfo);
	memset(precord_stats, 0, sizeof(struct ieee80211_rx_stats));
	pstats->bPacketMatchBSSID = precord_stats->bPacketMatchBSSID = bpacket_match_bssid;
	pstats->bPacketToSelf = precord_stats->bPacketToSelf = bpacket_toself;
	pstats->bIsCCK = precord_stats->bIsCCK = is_cck_rate;
	pstats->bPacketBeacon = precord_stats->bPacketBeacon = bPacketBeacon;
	pstats->bToSelfBA = precord_stats->bToSelfBA = bToSelfBA;
	if(check_reg824 == 0)
	{	
		reg824_bit9 = rtl8192_QueryBBReg(priv->ieee80211->dev, rFPGA0_XA_HSSIParameter2, 0x200);
		check_reg824 = 1;	
	}


	prxpkt = (u8*)pdrvinfo; 
	
	prxpkt += sizeof(rx_fwinfo);	
	
	pcck_buf = (phy_sts_cck_819xpci_t *)prxpkt;
	pofdm_buf = (phy_sts_ofdm_819xpci_t *)prxpkt;			
			
	pstats->RxMIMOSignalQuality[0] = -1;
	pstats->RxMIMOSignalQuality[1] = -1;
	precord_stats->RxMIMOSignalQuality[0] = -1;
	precord_stats->RxMIMOSignalQuality[1] = -1;
			
	if(is_cck_rate)
	{

		u8 report;
#ifdef RTL8190P
		u8 tmp_pwdb; 
		char cck_adc_pwdb[4];
#endif
		priv->stats.numqry_phystatusCCK++;

#ifdef RTL8190P	
		if(priv->rf_type == RF_2T4R && DM_RxPathSelTable.Enable && bpacket_match_bssid)
		{
			for(i=RF90_PATH_A; i<RF90_PATH_MAX; i++)
			{
				tmp_pwdb = pcck_buf->adc_pwdb_X[i];
				cck_adc_pwdb[i] = (char)tmp_pwdb;
				cck_adc_pwdb[i] /= 2;
				pstats->cck_adc_pwdb[i] = precord_stats->cck_adc_pwdb[i] = cck_adc_pwdb[i];
			}
		}
#endif

		if(!reg824_bit9)
		{
			report = pcck_buf->cck_agc_rpt & 0xc0;
			report = report>>6;
			switch(report)
			{
				case 0x3:
					rx_pwr_all = -35 - (pcck_buf->cck_agc_rpt & 0x3e);
					break;
				case 0x2:
					rx_pwr_all = -23 - (pcck_buf->cck_agc_rpt & 0x3e);
					break;
				case 0x1:
					rx_pwr_all = -11 - (pcck_buf->cck_agc_rpt & 0x3e);
					break;
				case 0x0:
					rx_pwr_all = 8 - (pcck_buf->cck_agc_rpt & 0x3e);
					break;
			}
		}
		else
		{
			report = pcck_buf->cck_agc_rpt & 0x60;
			report = report>>5;
			switch(report)
			{
				case 0x3:
					rx_pwr_all = -35 - ((pcck_buf->cck_agc_rpt & 0x1f)<<1) ;
					break;
				case 0x2:
					rx_pwr_all = -23 - ((pcck_buf->cck_agc_rpt & 0x1f)<<1);
					break;
				case 0x1:
					rx_pwr_all = -11 - ((pcck_buf->cck_agc_rpt & 0x1f)<<1) ;
					break;
				case 0x0:
					rx_pwr_all = -8 - ((pcck_buf->cck_agc_rpt & 0x1f)<<1) ;
					break;
			}
		}

		pwdb_all = rtl819x_query_rxpwrpercentage(rx_pwr_all);
		pstats->RxPWDBAll = precord_stats->RxPWDBAll = pwdb_all;
		pstats->RecvSignalPower = rx_pwr_all;

		if(bpacket_match_bssid)
		{
			u8	sq;

			if(pstats->RxPWDBAll > 40)
			{
				sq = 100;
			}else
			{
				sq = pcck_buf->sq_rpt;
				
				if(pcck_buf->sq_rpt > 64)
					sq = 0;
				else if (pcck_buf->sq_rpt < 20)
					sq = 100;
				else
					sq = ((64-sq) * 100) / 44;
			}
			pstats->SignalQuality = precord_stats->SignalQuality = sq;
			pstats->RxMIMOSignalQuality[0] = precord_stats->RxMIMOSignalQuality[0] = sq;
			pstats->RxMIMOSignalQuality[1] = precord_stats->RxMIMOSignalQuality[1] = -1;
		}
	}
	else
	{
		priv->stats.numqry_phystatusHT++;
		for(i=RF90_PATH_A; i<RF90_PATH_MAX; i++)
		{
			if (priv->brfpath_rxenable[i])
				rf_rx_num++;

#ifdef RTL8190P	   
			rx_pwr[i] = ((pofdm_buf->trsw_gain_X[i]&0x3F)*2) - 106;
#else
			rx_pwr[i] = ((pofdm_buf->trsw_gain_X[i]&0x3F)*2) - 110;
#endif

			tmp_rxsnr = pofdm_buf->rxsnr_X[i];
			rx_snrX = (char)(tmp_rxsnr);
			rx_snrX /= 2;
			priv->stats.rxSNRdB[i] = (long)rx_snrX;
			
			RSSI = rtl819x_query_rxpwrpercentage(rx_pwr[i]);	
			if (priv->brfpath_rxenable[i])
				total_rssi += RSSI;

			if(bpacket_match_bssid)
			{
				pstats->RxMIMOSignalStrength[i] =(u8) RSSI;
				precord_stats->RxMIMOSignalStrength[i] =(u8) RSSI;
			}
		}
		
		
		rx_pwr_all = (((pofdm_buf->pwdb_all ) >> 1 )& 0x7f) -106;
		pwdb_all = rtl819x_query_rxpwrpercentage(rx_pwr_all);	

		pstats->RxPWDBAll = precord_stats->RxPWDBAll = pwdb_all;
		pstats->RxPower = precord_stats->RxPower =	rx_pwr_all;
		pstats->RecvSignalPower = rx_pwr_all;
		if(pdrvinfo->RxHT && pdrvinfo->RxRate>=DESC90_RATEMCS8 &&
			pdrvinfo->RxRate<=DESC90_RATEMCS15)
			max_spatial_stream = 2; 
		else
			max_spatial_stream = 1; 

		for(i=0; i<max_spatial_stream; i++)
		{
			tmp_rxevm = pofdm_buf->rxevm_X[i];
			rx_evmX = (char)(tmp_rxevm);
			
			rx_evmX /= 2;	

			evm = rtl819x_evm_dbtopercentage(rx_evmX);
#if 0			
			EVM = SignalScaleMapping(EVM);
#endif
			if(bpacket_match_bssid)
			{
				if(i==0) 
					pstats->SignalQuality = precord_stats->SignalQuality = (u8)(evm & 0xff);
				pstats->RxMIMOSignalQuality[i] = precord_stats->RxMIMOSignalQuality[i] = (u8)(evm & 0xff);
			}
		}

		
		rxsc_sgien_exflg = pofdm_buf->rxsc_sgien_exflg;
		prxsc = (phy_ofdm_rx_status_rxsc_sgien_exintfflag *)&rxsc_sgien_exflg;
		if(pdrvinfo->BW)	
			priv->stats.received_bwtype[1+prxsc->rxsc]++;
		else				
			priv->stats.received_bwtype[0]++;
	}

	if(is_cck_rate)
	{
		pstats->SignalStrength = precord_stats->SignalStrength = (u8)(rtl819x_signal_scale_mapping(priv,(long)pwdb_all));
		
	}
	else
	{
		if (rf_rx_num != 0)
			pstats->SignalStrength = precord_stats->SignalStrength = (u8)(rtl819x_signal_scale_mapping(priv,(long)(total_rssi/=rf_rx_num))); 	
	}
}	

#endif 

void
rtl8192_record_rxdesc_forlateruse(
	struct ieee80211_rx_stats * psrc_stats,
	struct ieee80211_rx_stats * ptarget_stats
)
{
	ptarget_stats->bIsAMPDU = psrc_stats->bIsAMPDU;
	ptarget_stats->bFirstMPDU = psrc_stats->bFirstMPDU;
}


void TranslateRxSignalStuff819xpci(struct net_device *dev, 
        struct sk_buff *skb,
        struct ieee80211_rx_stats * pstats,
        prx_desc pdesc,	
        prx_fwinfo pdrvinfo)
{
    struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
    bool bpacket_match_bssid, bpacket_toself;
    bool bPacketBeacon=false;
    struct ieee80211_hdr_3addr *hdr;
#ifdef _RTL8192_EXT_PATCH_
    struct ieee80211_network* pnet=NULL;
#else
    bool bToSelfBA=false;
    static struct ieee80211_rx_stats  previous_stats;
#endif
    u16 fc,type;


    u8* tmp_buf;
    u8	*praddr;
#ifdef _RTL8192_EXT_PATCH_
    u8	*psaddr;
#endif

    tmp_buf = skb->data + pstats->RxDrvInfoSize + pstats->RxBufShift;

    hdr = (struct ieee80211_hdr_3addr *)tmp_buf;
    fc = le16_to_cpu(hdr->frame_ctl);
    type = WLAN_FC_GET_TYPE(fc);	
    praddr = hdr->addr1;

#ifdef _RTL8192_EXT_PATCH_
    psaddr = hdr->addr2;
    if((priv->ieee80211->iw_mode == IW_MODE_MESH) && (priv->mshobj->ext_patch_get_mpinfo))
		pnet = priv->mshobj->ext_patch_get_mpinfo(dev,psaddr);	
#endif
#ifdef _RTL8192_EXT_PATCH_
    bpacket_match_bssid = ((IEEE80211_FTYPE_CTL != type) && (!pstats->bHwError) && (!pstats->bCRC)&& (!pstats->bICV));
    if(pnet){
        bpacket_match_bssid = bpacket_match_bssid;
    }
    else{
        bpacket_match_bssid = bpacket_match_bssid &&
            (!compare_ether_addr(priv->ieee80211->current_network.bssid, 
				 (fc & IEEE80211_FCTL_TODS)? hdr->addr1 : 
				 (fc & IEEE80211_FCTL_FROMDS )? hdr->addr2 : hdr->addr3));
    }
#else
    bpacket_match_bssid = ((IEEE80211_FTYPE_CTL != type) &&
            (!compare_ether_addr(priv->ieee80211->current_network.bssid,	
		       (fc & IEEE80211_FCTL_TODS)? hdr->addr1 : 
		       (fc & IEEE80211_FCTL_FROMDS )? hdr->addr2 : hdr->addr3))
            && (!pstats->bHwError) && (!pstats->bCRC)&& (!pstats->bICV));
#endif
    bpacket_toself =  bpacket_match_bssid & (!compare_ether_addr(praddr, priv->ieee80211->dev->dev_addr));
    if(WLAN_FC_GET_FRAMETYPE(fc)== IEEE80211_STYPE_BEACON)
    {
        bPacketBeacon = true;
    }
#ifndef _RTL8192_EXT_PATCH_
    if(WLAN_FC_GET_FRAMETYPE(fc) == IEEE80211_STYPE_BLOCKACK)
    {
        if ((!compare_ether_addr(praddr,dev->dev_addr)))
            bToSelfBA = true;
    }

#endif	
    if(bpacket_match_bssid)
    {
        priv->stats.numpacket_matchbssid++;
    }
    if(bpacket_toself){
        priv->stats.numpacket_toself++;
    }
#ifdef _RTL8192_EXT_PATCH_
    rtl8192_query_rxphystatus(priv, pstats, pdesc, pdrvinfo, bpacket_match_bssid,
            bpacket_toself ,bPacketBeacon);
    rtl8192_process_phyinfo(priv, tmp_buf,pstats,pnet);
    
#else
    rtl8192_process_phyinfo(priv, tmp_buf,&previous_stats, pstats);
    rtl8192_query_rxphystatus(priv, pstats, pdesc, pdrvinfo, &previous_stats, bpacket_match_bssid,
            bpacket_toself ,bPacketBeacon, bToSelfBA);
    rtl8192_record_rxdesc_forlateruse(pstats, &previous_stats);
#endif	

}




void UpdateReceivedRateHistogramStatistics8190(
	struct net_device *dev,
	struct ieee80211_rx_stats* pstats
	)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	u32 rcvType=1;   
	u32 rateIndex;
	u32 preamble_guardinterval;  
	    
	#if 0
	if (pRfd->queue_id == CMPK_RX_QUEUE_ID)
		return;
	#endif
	if(pstats->bCRC)
		rcvType = 2;
	else if(pstats->bICV)
		rcvType = 3;
	    
	if(pstats->bShortPreamble)
		preamble_guardinterval = 1;
	else
		preamble_guardinterval = 0;

	switch(pstats->rate)
	{
		case MGN_1M:    rateIndex = 0;  break;
	    	case MGN_2M:    rateIndex = 1;  break;
	    	case MGN_5_5M:  rateIndex = 2;  break;
	    	case MGN_11M:   rateIndex = 3;  break;
	    	case MGN_6M:    rateIndex = 4;  break;
	    	case MGN_9M:    rateIndex = 5;  break;
	    	case MGN_12M:   rateIndex = 6;  break;
	    	case MGN_18M:   rateIndex = 7;  break;
	    	case MGN_24M:   rateIndex = 8;  break;
	    	case MGN_36M:   rateIndex = 9;  break;
	    	case MGN_48M:   rateIndex = 10; break;
	    	case MGN_54M:   rateIndex = 11; break;
	    	case MGN_MCS0:  rateIndex = 12; break;
	    	case MGN_MCS1:  rateIndex = 13; break;
	    	case MGN_MCS2:  rateIndex = 14; break;
	    	case MGN_MCS3:  rateIndex = 15; break;
	    	case MGN_MCS4:  rateIndex = 16; break;
	    	case MGN_MCS5:  rateIndex = 17; break;
	    	case MGN_MCS6:  rateIndex = 18; break;
	    	case MGN_MCS7:  rateIndex = 19; break;
	    	case MGN_MCS8:  rateIndex = 20; break;
	    	case MGN_MCS9:  rateIndex = 21; break;
	    	case MGN_MCS10: rateIndex = 22; break;
	    	case MGN_MCS11: rateIndex = 23; break;
	    	case MGN_MCS12: rateIndex = 24; break;
	    	case MGN_MCS13: rateIndex = 25; break;
	    	case MGN_MCS14: rateIndex = 26; break;
	    	case MGN_MCS15: rateIndex = 27; break;
		default:        rateIndex = 28; break;
	}
	priv->stats.received_preamble_GI[preamble_guardinterval][rateIndex]++;
	priv->stats.received_rate_histogram[0][rateIndex]++; 
	priv->stats.received_rate_histogram[rcvType][rateIndex]++;
}

void rtl8192_rx(struct net_device *dev)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	struct ieee80211_hdr_1addr *ieee80211_hdr = NULL;
	bool unicast_packet = false;
	bool bLedBlinking=true;
	u16 fc=0, type=0;
	u32 skb_len = 0;
	struct ieee80211_rx_stats stats = {
		.signal = 0,
		.noise = -98,
		.rate = 0,
		.freq = IEEE80211_24GHZ_BAND,
	};
	unsigned int count = priv->rxringcount;

	stats.nic_type = NIC_8192E;

	while (count--) {
		rx_desc *pdesc = &priv->rx_ring[priv->rx_idx];
		struct sk_buff *skb = priv->rx_buf[priv->rx_idx];

		if (pdesc->OWN){
			return;
		} else {

			struct sk_buff *new_skb = NULL;
			if (!priv->ops->rx_query_status_descriptor(dev, &stats, pdesc, skb))
				goto done;

			pci_unmap_single(priv->pdev,
					*((dma_addr_t *)skb->cb), 
					priv->rxbuffersize, 
					PCI_DMA_FROMDEVICE);

			skb_put(skb, pdesc->Length);
			skb_reserve(skb, stats.RxDrvInfoSize + stats.RxBufShift);
			skb_trim(skb, skb->len - 4/*sCrcLng*/);
			ieee80211_hdr = (struct ieee80211_hdr_1addr *)skb->data;
			if(is_broadcast_ether_addr(ieee80211_hdr->addr1)) {
			}else if(is_multicast_ether_addr(ieee80211_hdr->addr1)){
			}else {
				/* unicast packet */
				unicast_packet = true;
			}
			fc = le16_to_cpu(ieee80211_hdr->frame_ctl);
			type = WLAN_FC_GET_TYPE(fc);
			if(type == IEEE80211_FTYPE_MGMT)
			{
				bLedBlinking = false;
			}
			if(bLedBlinking)
				if(priv->ieee80211->LedControlHandler)
				priv->ieee80211->LedControlHandler(dev, LED_CTL_RX);
			skb_len = skb->len;
			if(!ieee80211_rx(priv->ieee80211, skb, &stats)){
				dev_kfree_skb_any(skb);
			} else {
				priv->stats.rxok++;
				if(unicast_packet) {
					priv->stats.rxbytesunicast += skb_len;
				}
			}
#if 1
			new_skb = dev_alloc_skb(priv->rxbuffersize);
			if (unlikely(!new_skb))
			{
				printk("==========>can't alloc skb for rx\n");
				goto done;
			}
			skb=new_skb;
                        skb->dev = dev;
#endif
			priv->rx_buf[priv->rx_idx] = skb;
			*((dma_addr_t *) skb->cb) = pci_map_single(priv->pdev, skb_tail_pointer(skb), priv->rxbuffersize, PCI_DMA_FROMDEVICE);

		}
done:
		pdesc->BufferAddress = cpu_to_le32(*((dma_addr_t *)skb->cb));
		pdesc->OWN = 1;
		pdesc->Length = priv->rxbuffersize;
		if (priv->rx_idx == priv->rxringcount-1)
			pdesc->EOR = 1;
		priv->rx_idx = (priv->rx_idx + 1) % priv->rxringcount;
	}

}



void rtl8192_tx_resume(struct net_device *dev)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	struct ieee80211_device *ieee = priv->ieee80211;
	struct sk_buff *skb;
	int queue_index;

	for(queue_index = BK_QUEUE; queue_index < TXCMD_QUEUE;queue_index++) {
		while((!skb_queue_empty(&ieee->skb_waitQ[queue_index]))&&
				(priv->ieee80211->check_nic_enough_desc(dev,queue_index) > 0)) {
			skb = skb_dequeue(&ieee->skb_waitQ[queue_index]);
			ieee->softmac_data_hard_start_xmit(skb,dev,0/* rate useless now*/);
			#if 0
			if(queue_index!=MGNT_QUEUE) {
				ieee->stats.tx_packets++;
				ieee->stats.tx_bytes += skb->len;
			}
			#endif
		}
#ifdef ENABLE_AMSDU
		while((skb_queue_len(&priv->ieee80211->skb_aggQ[queue_index]) > 0)&&\
				(!(priv->ieee80211->queue_stop)) && \
				(priv->ieee80211->check_nic_enough_desc(dev,queue_index) > 0)){

			struct sk_buff_head pSendList;
			u8 dst[ETH_ALEN];
			cb_desc *tcb_desc = NULL;
			int qos_actived = priv->ieee80211->current_network.qos_data.active;
			struct sta_info *psta = NULL;
			u8 bIsSptAmsdu = false;

#ifdef WIFI_TEST 
			if (queue_index <= VO_QUEUE)
				queue_index = wmm_queue_select(priv, queue_index, priv->ieee80211->skb_aggQ);
#endif
			priv->ieee80211->amsdu_in_process = true;

			skb = skb_dequeue(&(priv->ieee80211->skb_aggQ[queue_index]));
			if(skb == NULL)
			{
				printk("In %s:Skb is NULL\n",__FUNCTION__);
				return;
			}
			tcb_desc = (pcb_desc)(skb->cb + MAX_DEV_ADDR_SIZE);
			if(tcb_desc->bFromAggrQ)
			{
#ifdef HAVE_NET_DEVICE_OPS				
				if(dev->netdev_ops->ndo_start_xmit)
					dev->netdev_ops->ndo_start_xmit(skb, dev);
#else
				dev->hard_start_xmit(skb, dev);
#endif				
				return;
			}

			memcpy(dst, skb->data, ETH_ALEN);
			if(priv->ieee80211->iw_mode == IW_MODE_ADHOC)
			{
				psta = GetStaInfo(priv->ieee80211, dst);
				if(psta) {
					if(psta->htinfo.bEnableHT)
						bIsSptAmsdu = true;
				}
			}
			else if(priv->ieee80211->iw_mode == IW_MODE_INFRA)
				bIsSptAmsdu = true;
			else
				bIsSptAmsdu = true;
			bIsSptAmsdu = true;

			bIsSptAmsdu = bIsSptAmsdu && priv->ieee80211->pHTInfo->bCurrent_AMSDU_Support && qos_actived;

			if(qos_actived &&       !is_broadcast_ether_addr(dst) &&
					!is_multicast_ether_addr(dst) &&
					bIsSptAmsdu)
			{
				skb_queue_head_init(&pSendList);
				if(AMSDU_GetAggregatibleList(priv->ieee80211, skb, &pSendList,queue_index))
				{
					struct sk_buff * pAggrSkb = AMSDU_Aggregation(priv->ieee80211, &pSendList);
					if(NULL != pAggrSkb)
#ifdef HAVE_NET_DEVICE_OPS				
						if(dev->netdev_ops->ndo_start_xmit)
							dev->netdev_ops->ndo_start_xmit(pAggrSkb, dev);
#else
						dev->hard_start_xmit(pAggrSkb, dev);
#endif				
				}
			}
			else
			{
				memset(skb->cb,0,sizeof(skb->cb));
				tcb_desc = (cb_desc *)(skb->cb + MAX_DEV_ADDR_SIZE);
				tcb_desc->bFromAggrQ = true;
#ifdef HAVE_NET_DEVICE_OPS				
				if(dev->netdev_ops->ndo_start_xmit)
					dev->netdev_ops->ndo_start_xmit(skb, dev);
#else
				dev->hard_start_xmit(skb, dev);
#endif				
			}
		}
#endif
#ifdef _RTL8192_EXT_PATCH_
		while((!skb_queue_empty(&priv->ieee80211->skb_meshaggQ[queue_index]) )&&\
			(priv->ieee80211->check_nic_enough_desc(dev,queue_index)> 0))
		{
			struct sk_buff_head pSendList;
			u8 dst[ETH_ALEN];
			cb_desc *tcb_desc = NULL;
			u8 IsHTEnable = false;
			int qos_actived = 1; 
			priv->ieee80211->mesh_amsdu_in_process = true;
			skb = skb_dequeue(&(priv->ieee80211->skb_meshaggQ[queue_index]));
			if(skb == NULL)
			{
				priv->ieee80211->mesh_amsdu_in_process = false;
				printk("In %s:Skb is NULL\n",__FUNCTION__);
				return;
			}
			tcb_desc = (pcb_desc)(skb->cb + MAX_DEV_ADDR_SIZE);
			if(tcb_desc->bFromAggrQ)
			{
				ieee80211_mesh_xmit(skb, dev);
				continue;
			}
			memcpy(dst, skb->data, ETH_ALEN);
			
#if 0
			ppeerMP_htinfo phtinfo = NULL;
			bool is_mesh = false;
			if(priv->mshobj->ext_patch_ieee80211_is_mesh)
				is_mesh = priv->mshobj->ext_patch_ieee80211_is_mesh(priv->ieee80211,dst);
			if(is_mesh){
				if(priv->ieee80211->ext_patch_ieee80211_get_peermp_htinfo)
				{
					phtinfo = priv->ieee80211->ext_patch_ieee80211_get_peermp_htinfo(ieee,dst);
					if(phtinfo == NULL)
					{
						RT_TRACE(COMP_ERR,"%s(): No htinfo\n",__FUNCTION__);
					}
					else
					{
						if(phtinfo->bEnableHT)
							IsHTEnable = true;
					}	
				}
			}
			else 
			{
				printk("===>%s():tx AMSDU data has not entry,dst: "MAC_FMT"\n",__FUNCTION__,MAC_ARG(dst));
				IsHTEnable = true;
			}
#else
			IsHTEnable = true;
#endif
			IsHTEnable = (IsHTEnable && ieee->pHTInfo->bCurrent_Mesh_AMSDU_Support && qos_actived);
			if( !is_broadcast_ether_addr(dst) && 
				!is_multicast_ether_addr(dst) &&
				IsHTEnable) 
			{
				skb_queue_head_init(&pSendList);
				if(msh_AMSDU_GetAggregatibleList(priv->ieee80211, skb, &pSendList,queue_index))
				{				
					struct sk_buff * pAggrSkb = msh_AMSDU_Aggregation(priv->ieee80211, &pSendList);
					if(NULL != pAggrSkb)
						ieee80211_mesh_xmit(pAggrSkb, dev);
				}else{
					priv->ieee80211->mesh_amsdu_in_process = false;
					return;
				}
			}
			else
			{
				memset(skb->cb,0,sizeof(skb->cb));
				tcb_desc = (cb_desc *)(skb->cb + MAX_DEV_ADDR_SIZE);
				tcb_desc->bFromAggrQ = true;
				ieee80211_mesh_xmit(skb, dev);
			}
		}
#endif		
	}
}

void rtl8192_irq_tx_tasklet(struct r8192_priv *priv)
{
       rtl8192_tx_resume(priv->ieee80211->dev);
}

void rtl8192_irq_rx_tasklet(struct r8192_priv *priv)
{
       rtl8192_rx(priv->ieee80211->dev);
       write_nic_dword(priv->ieee80211->dev, INTA_MASK,read_nic_dword(priv->ieee80211->dev, INTA_MASK) | IMR_RDU); 
}

/****************************************************************************
 ---------------------------- NIC START/CLOSE STUFF---------------------------
*****************************************************************************/
void rtl8192_cancel_deferred_work(struct r8192_priv* priv)
{
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)
	cancel_delayed_work(&priv->watch_dog_wq);
	cancel_delayed_work(&priv->update_beacon_wq);
#ifndef RTL8190P
	cancel_delayed_work(&priv->ieee80211->hw_sleep_wq);
#endif
#ifdef RTL8192SE
	cancel_delayed_work(&priv->ieee80211->update_assoc_sta_info_wq);
	cancel_delayed_work(&priv->ieee80211->check_tsf_wq);
#endif
#endif

#if LINUX_VERSION_CODE >=KERNEL_VERSION(2,6,22)
	cancel_work_sync(&priv->reset_wq);
	cancel_work_sync(&priv->qos_activate);
#elif ((LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)) && (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,20)))
	cancel_delayed_work(&priv->reset_wq);
	cancel_delayed_work(&priv->qos_activate);
#ifdef RTL8192SE
	cancel_delayed_work(&priv->ieee80211->update_assoc_sta_info_wq);
	cancel_delayed_work(&priv->ieee80211->check_tsf_wq);
#endif
#endif

}

#ifdef _RTL8192_EXT_PATCH_
int _rtl8192_up(struct net_device *dev,bool is_silent_reset)
#else
int _rtl8192_up(struct net_device *dev)
#endif
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	PRT_POWER_SAVE_CONTROL pPSC = (PRT_POWER_SAVE_CONTROL)(&(priv->ieee80211->PowerSaveControl));
	bool init_status = true;
	priv->bDriverIsGoingToUnload = false;
#ifdef _RTL8192_EXT_PATCH_
	if(priv->mesh_up){
		RT_TRACE(COMP_ERR,"%s(): since mesh0 is already up, ra0 is forbidden to open.\n",__FUNCTION__);
		return -1;
	}
	RT_TRACE(COMP_DOWN, "==========>%s()\n", __FUNCTION__);
	if(!is_silent_reset)
		priv->ieee80211->iw_mode = IW_MODE_INFRA;
	if(priv->up){
		RT_TRACE(COMP_ERR,"%s():%s is up,return\n",__FUNCTION__,DRV_NAME);
		return -1;
	}
#ifdef RTL8192SE        
	priv->ReceiveConfig =
				RCR_APPFCS | RCR_APWRMGT | /*RCR_ADD3 |*/
				RCR_AMF | RCR_ADF | RCR_APP_MIC | RCR_APP_ICV |
				RCR_AICV | RCR_ACRC32    |                               
				RCR_AB          | RCR_AM                |                               
				RCR_APM         |                                                               
				/*RCR_AAP               |*/                                                     
				RCR_APP_PHYST_STAFF | RCR_APP_PHYST_RXFF |      
				(priv->EarlyRxThreshold<<RCR_FIFO_OFFSET)       ;
#else
	priv->ReceiveConfig = RCR_ADD3  |
			RCR_AMF | RCR_ADF |             
			RCR_AICV |                      
			RCR_AB | RCR_AM | RCR_APM |     
			RCR_AAP | ((u32)7<<RCR_MXDMA_OFFSET) |
			((u32)7 << RCR_FIFO_OFFSET) | RCR_ONLYERLPKT;
#endif

	if(!priv->mesh_up)
	{
		RT_TRACE(COMP_INIT, "Bringing up iface");
		priv->bfirst_init = true;
		init_status = priv->ops->initialize_adapter(dev);
		if(init_status != true)
		{
			RT_TRACE(COMP_ERR,"ERR!!! %s(): initialization is failed!\n",__FUNCTION__);
			return -1;
		}
		RT_TRACE(COMP_INIT, "start adapter finished\n");
		RT_CLEAR_PS_LEVEL(pPSC, RT_RF_OFF_LEVL_HALT_NIC);
		priv->ieee80211->ieee_up=1;
		priv->bfirst_init = false;
#ifdef ENABLE_GPIO_RADIO_CTL
		if(priv->polling_timer_on == 0){
			check_rfctrl_gpio_timer((unsigned long)dev);
		}
#endif
		priv->ieee80211->current_network.channel = INIT_DEFAULT_CHAN;
		priv->ieee80211->current_mesh_network.channel = INIT_DEFAULT_CHAN;
		if((priv->mshobj->ext_patch_r819x_wx_set_mesh_chan) && (!is_silent_reset))
			priv->mshobj->ext_patch_r819x_wx_set_mesh_chan(dev,INIT_DEFAULT_CHAN);
		if((priv->mshobj->ext_patch_r819x_wx_set_channel) && (!is_silent_reset))
		{
			priv->mshobj->ext_patch_r819x_wx_set_channel(priv->ieee80211, INIT_DEFAULT_CHAN);
		}
		printk("%s():set chan %d\n",__FUNCTION__,INIT_DEFAULT_CHAN);
		priv->ieee80211->set_chan(dev, INIT_DEFAULT_CHAN); 
		dm_InitRateAdaptiveMask(dev);
		watch_dog_timer_callback((unsigned long) dev);
	}	
	else
	{
		priv->ieee80211->sync_scan_hurryup = 1;
	}
	priv->up=1; 
	priv->up_first_time = 0;
	if(!priv->ieee80211->proto_started) 
	{
#ifdef RTL8192E
		if(priv->ieee80211->eRFPowerState!=eRfOn)
			MgntActSet_RF_State(dev, eRfOn, priv->ieee80211->RfOffReason);	
#endif
		if(priv->ieee80211->state != IEEE80211_LINKED)
			ieee80211_softmac_start_protocol(priv->ieee80211, 0);
	}
	ieee80211_reset_queue(priv->ieee80211);
	if(!netif_queue_stopped(dev))
		netif_start_queue(dev);
	else
		netif_wake_queue(dev);
	RT_TRACE(COMP_DOWN, "<==========%s()\n", __FUNCTION__);
#else
	priv->up=1;
	priv->up_first_time = 0;
	priv->ieee80211->ieee_up=1;	
	RT_TRACE(COMP_INIT, "Bringing up iface");
	priv->bfirst_init = true;
	init_status = priv->ops->initialize_adapter(dev);
	if(init_status != true)
	{
		RT_TRACE(COMP_ERR,"ERR!!! %s(): initialization is failed!\n",__FUNCTION__);
		return -1;
	}
	RT_TRACE(COMP_INIT, "start adapter finished\n");
	RT_CLEAR_PS_LEVEL(pPSC, RT_RF_OFF_LEVL_HALT_NIC);
	priv->bfirst_init = false;
#ifdef RTL8192SE
	if(priv->ieee80211->eRFPowerState!=eRfOn)
		MgntActSet_RF_State(dev, eRfOn, priv->ieee80211->RfOffReason);	
#endif

#ifdef ENABLE_GPIO_RADIO_CTL
	if(priv->polling_timer_on == 0){
		check_rfctrl_gpio_timer((unsigned long)dev);
	}
#endif

	if(priv->ieee80211->state != IEEE80211_LINKED)
#ifndef CONFIG_MP
	ieee80211_softmac_start_protocol(priv->ieee80211);
#endif
	ieee80211_reset_queue(priv->ieee80211);
#ifndef CONFIG_MP
	watch_dog_timer_callback((unsigned long) dev);
#endif
	if(!netif_queue_stopped(dev))
		netif_start_queue(dev);
	else
		netif_wake_queue(dev);
#endif
	return 0;
}


int rtl8192_open(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	int ret;
	
	down(&priv->wx_sem);
	ret = rtl8192_up(dev);
	up(&priv->wx_sem);
	return ret;
	
}


int rtl8192_up(struct net_device *dev)
{
#ifndef _RTL8192_EXT_PATCH_
	struct r8192_priv *priv = ieee80211_priv(dev);

	if (priv->up == 1) return -1;
	return _rtl8192_up(dev);
#else	
	return _rtl8192_up(dev,false);
#endif	
}


int rtl8192_close(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	int ret;
	
	down(&priv->wx_sem);

	ret = rtl8192_down(dev,true);
	
	up(&priv->wx_sem);
	
	return ret;

}

int rtl8192_down(struct net_device *dev, bool shutdownrf)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	unsigned long flags = 0;
	u8 RFInProgressTimeOut = 0;

#ifdef _RTL8192_EXT_PATCH_
	if (priv->up == 0) 
		return -1;

	RT_TRACE(COMP_DOWN, "==========>%s()\n", __FUNCTION__);
#ifdef ENABLE_LPS
	if(priv->ieee80211->state == IEEE80211_LINKED)
		LeisurePSLeave(dev);
#endif
	/* FIXME */
	if (!netif_queue_stopped(dev))
		netif_stop_queue(dev);  
	if(!priv->mesh_up)
	{
		printk("===>%s():mesh is not up\n",__FUNCTION__);
		priv->bDriverIsGoingToUnload = true;	
		priv->up=0;  
		priv->ieee80211->ieee_up = 0;  
		/* mesh stack has also be closed, then disalbe the hardware function at 
		 * the same time */
		priv->ieee80211->wpa_ie_len = 0;
		if(priv->ieee80211->wpa_ie)
			kfree(priv->ieee80211->wpa_ie);
		priv->ieee80211->wpa_ie = NULL;
		CamResetAllEntry(dev);
		CamRestoreEachIFEntry(dev,1);	
		memset(priv->ieee80211->swcamtable,0,sizeof(SW_CAM_TABLE)*32);
		rtl8192_irq_disable(dev);
		rtl8192_cancel_deferred_work(priv);
#ifndef RTL8190P
		cancel_delayed_work(&priv->ieee80211->hw_wakeup_wq);
#endif
		deinit_hal_dm(dev);
		del_timer_sync(&priv->watch_dog_timer);	

		ieee80211_softmac_stop_protocol(priv->ieee80211, 0, true);
		SPIN_LOCK_PRIV_RFPS(&priv->rf_ps_lock);
		while(priv->RFChangeInProgress)
		{
			SPIN_UNLOCK_PRIV_RFPS(&priv->rf_ps_lock);
			if(RFInProgressTimeOut > 100)
			{
				SPIN_LOCK_PRIV_RFPS(&priv->rf_ps_lock);
				break;
			}
			printk("===>%s():RF is in progress, need to wait until rf chang is done.\n",__FUNCTION__);
			mdelay(1);
			RFInProgressTimeOut ++;
			SPIN_LOCK_PRIV_RFPS(&priv->rf_ps_lock);
		}
		printk("=====>%s(): priv->RFChangeInProgress = true\n",__FUNCTION__);
		priv->RFChangeInProgress = true;
		SPIN_UNLOCK_PRIV_RFPS(&priv->rf_ps_lock);
		priv->ops->stop_adapter(dev, false);
		SPIN_LOCK_PRIV_RFPS(&priv->rf_ps_lock);
		printk("=====>%s(): priv->RFChangeInProgress = false\n",__FUNCTION__);
		priv->RFChangeInProgress = false;
		SPIN_UNLOCK_PRIV_RFPS(&priv->rf_ps_lock);
		udelay(100);
		memset(&priv->ieee80211->current_network, 0 , offsetof(struct ieee80211_network, list));
		priv->ieee80211->wap_set = 0; 
		priv->ieee80211->current_network.channel = INIT_DEFAULT_CHAN;
#ifdef RTL8192SE_CONFIG_ASPM_OR_D3
		RT_ENABLE_ASPM(dev);
#endif
	} else {
		ieee80211_softmac_stop_protocol(priv->ieee80211, 0, true);
		memset(&priv->ieee80211->current_network, 0 , offsetof(struct ieee80211_network, list));
		priv->ieee80211->current_network.channel = INIT_DEFAULT_CHAN;
		priv->ieee80211->wap_set = 0; 
	}

	RT_TRACE(COMP_DOWN, "<==========%s()\n", __FUNCTION__);
	priv->up=0; 
#else
	if (priv->up == 0) return -1;

#ifdef ENABLE_LPS
	if(priv->ieee80211->state == IEEE80211_LINKED)
		LeisurePSLeave(dev);
#endif

	priv->bDriverIsGoingToUnload = true;
	priv->up=0;
	priv->ieee80211->ieee_up = 0;
	RT_TRACE(COMP_DOWN, "==========>%s()\n", __FUNCTION__);
	if (!netif_queue_stopped(dev))
		netif_stop_queue(dev);

	priv->ieee80211->wpa_ie_len = 0;
	if(priv->ieee80211->wpa_ie)
		kfree(priv->ieee80211->wpa_ie);
	priv->ieee80211->wpa_ie = NULL;
	CamResetAllEntry(dev);	
	memset(priv->ieee80211->swcamtable,0,sizeof(SW_CAM_TABLE)*32);
	rtl8192_irq_disable(dev);
#if 0	
	if(!priv->ieee80211->bSupportRemoteWakeUp) {
		MgntActSet_RF_State(dev, eRfOff, RF_CHANGE_BY_INIT);
		ulRegRead = read_nic_dword(dev, CPU_GEN);	
		ulRegRead|=CPU_GEN_SYSTEM_RESET;
		write_nic_dword(dev, CPU_GEN, ulRegRead);
	} else {
		write_nic_dword(dev, WFCRC0, 0xffffffff);
		write_nic_dword(dev, WFCRC1, 0xffffffff);
		write_nic_dword(dev, WFCRC2, 0xffffffff);
#ifdef RTL8190P
		ucRegRead = read_nic_byte(dev, GPO);
		ucRegRead |= BIT0;
		write_nic_byte(dev, GPO, ucRegRead);
#endif			
		write_nic_byte(dev, PMR, 0x5);
		write_nic_byte(dev, MacBlkCtrl, 0xa);
	}
#endif
	del_timer_sync(&priv->watch_dog_timer);	
	rtl8192_cancel_deferred_work(priv);
#ifndef RTL8190P
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)	
	cancel_delayed_work(&priv->ieee80211->hw_wakeup_wq);
#endif
#endif

	ieee80211_softmac_stop_protocol(priv->ieee80211,true);
	spin_lock_irqsave(&priv->rf_ps_lock,flags);
	while(priv->RFChangeInProgress)
	{
		spin_unlock_irqrestore(&priv->rf_ps_lock,flags);
		if(RFInProgressTimeOut > 100)
		{
			spin_lock_irqsave(&priv->rf_ps_lock,flags);
			break;
		}
		printk("===>%s():RF is in progress, need to wait until rf chang is done.\n",__FUNCTION__);
		mdelay(1);
		RFInProgressTimeOut ++;
		spin_lock_irqsave(&priv->rf_ps_lock,flags);
	}
	priv->RFChangeInProgress = true;
	spin_unlock_irqrestore(&priv->rf_ps_lock,flags);
	priv->ops->stop_adapter(dev, false);
	spin_lock_irqsave(&priv->rf_ps_lock,flags);
	priv->RFChangeInProgress = false;
	spin_unlock_irqrestore(&priv->rf_ps_lock,flags);
	udelay(100);
	memset(&priv->ieee80211->current_network, 0 , offsetof(struct ieee80211_network, list));
#ifdef RTL8192SE_CONFIG_ASPM_OR_D3
	RT_ENABLE_ASPM(dev);
#endif
	RT_TRACE(COMP_DOWN, "<==========%s()\n", __FUNCTION__);
#endif

#ifdef CONFIG_MP
	if (priv->bCckContTx) {
		printk("####RTL819X MP####stop single cck continious TX\n");
		mpt_StopCckCoNtTx(dev);
	} 
	if (priv->bOfdmContTx) {
		printk("####RTL819X MP####stop single ofdm continious TX\n");
		mpt_StopOfdmContTx(dev);
	} 
	if (priv->bSingleCarrier) {
		printk("####RTL819X MP####stop single carrier mode\n");
		MPT_ProSetSingleCarrier(dev, false);
	}
#endif
	return 0;
}

void rtl8192_commit(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);

#ifdef _RTL8192_EXT_PATCH_
	if ((priv->up == 0) && (priv->mesh_up == 0)) return ;
	ieee80211_softmac_stop_protocol(priv->ieee80211,0,true);
	rtl8192_irq_disable(dev);
	priv->ops->stop_adapter(dev, true);
	priv->up = 0;
	_rtl8192_up(dev,false);
#else
	if (priv->up == 0) return ;
	ieee80211_softmac_stop_protocol(priv->ieee80211,true);
	rtl8192_irq_disable(dev);
	priv->ops->stop_adapter(dev, true);
	_rtl8192_up(dev);
#endif
	
}

void rtl8192_restart(void *data)
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,20))
	struct r8192_priv *priv = container_of_work_rsl(data, struct r8192_priv, reset_wq);
	struct net_device *dev = priv->ieee80211->dev;
#else
	struct net_device *dev = (struct net_device *)data;
        struct r8192_priv *priv = ieee80211_priv(dev);
#endif

	down(&priv->wx_sem);
	
	rtl8192_commit(dev);
	
	up(&priv->wx_sem);
}

static void r8192_set_multicast(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	short promisc;

	
	
	promisc = (dev->flags & IFF_PROMISC) ? 1:0;
	
	if (promisc != priv->promisc) {
		;
	}
	
	priv->promisc = promisc;
	
}


int r8192_set_mac_adr(struct net_device *dev, void *mac)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	struct sockaddr *addr = mac;
	
	down(&priv->wx_sem);
	
	memcpy(dev->dev_addr, addr->sa_data, ETH_ALEN);
		
#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0))
	schedule_work(&priv->reset_wq);
#else
	schedule_task(&priv->reset_wq);
#endif	
	up(&priv->wx_sem);
	
	return 0;
}


/* based on ipw2200 driver */
int rtl8192_ioctl(struct net_device *dev, struct ifreq *rq, int cmd)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	struct iwreq *wrq = (struct iwreq *)rq;
	int ret=-1;
	struct ieee80211_device *ieee = priv->ieee80211;
	u32 key[4];
	u8 broadcast_addr[6] = {0xff,0xff,0xff,0xff,0xff,0xff};
	u8 zero_addr[6] = {0};
	struct iw_point *p = &wrq->u.data;
	struct ieee_param *ipw = NULL;

	down(&priv->wx_sem);


	if (p->length < sizeof(struct ieee_param) || !p->pointer){
		ret = -EINVAL;
		goto out;
	}

	ipw = (struct ieee_param *)kmalloc(p->length, GFP_KERNEL);
	if (ipw == NULL){
		ret = -ENOMEM;
		goto out;
	}
	if (copy_from_user(ipw, p->pointer, p->length)) {
		kfree(ipw);
		ret = -EFAULT;
		goto out;
	}

	switch (cmd) {
		case RTL_IOCTL_WPA_SUPPLICANT:
			if (ipw->cmd == IEEE_CMD_SET_ENCRYPTION)
			{
				if (ipw->u.crypt.set_tx)
				{
					if (strcmp(ipw->u.crypt.alg, "CCMP") == 0)
						ieee->pairwise_key_type = KEY_TYPE_CCMP;
					else if (strcmp(ipw->u.crypt.alg, "TKIP") == 0)
						ieee->pairwise_key_type = KEY_TYPE_TKIP;
					else if (strcmp(ipw->u.crypt.alg, "WEP") == 0)
					{
						if (ipw->u.crypt.key_len == 13)
							ieee->pairwise_key_type = KEY_TYPE_WEP104;
						else if (ipw->u.crypt.key_len == 5)
							ieee->pairwise_key_type = KEY_TYPE_WEP40;
					}
					else
						ieee->pairwise_key_type = KEY_TYPE_NA;

					if (ieee->pairwise_key_type)
					{
						if (memcmp(ieee->ap_mac_addr, zero_addr, 6) == 0)
							ieee->iw_mode = IW_MODE_ADHOC;

						memcpy((u8*)key, ipw->u.crypt.key, 16);
						EnableHWSecurityConfig8192(dev);
#ifdef _RTL8192_EXT_PATCH_
						set_swcam(dev, 4, ipw->u.crypt.idx, ieee->pairwise_key_type, (u8*)ieee->ap_mac_addr, 0, key,0);
#else
						set_swcam(dev, 4, ipw->u.crypt.idx, ieee->pairwise_key_type, (u8*)ieee->ap_mac_addr, 0, key);
#endif
						setKey(dev, 4, ipw->u.crypt.idx, ieee->pairwise_key_type, (u8*)ieee->ap_mac_addr, 0, key);
						if (ieee->iw_mode == IW_MODE_ADHOC){  
#ifdef _RTL8192_EXT_PATCH_
							set_swcam(dev, ipw->u.crypt.idx, ipw->u.crypt.idx, ieee->pairwise_key_type, (u8*)ieee->ap_mac_addr, 0, key,0);
#else
							set_swcam(dev, ipw->u.crypt.idx, ipw->u.crypt.idx, ieee->pairwise_key_type, (u8*)ieee->ap_mac_addr, 0, key);
#endif
							setKey(dev, ipw->u.crypt.idx, ipw->u.crypt.idx, ieee->pairwise_key_type, (u8*)ieee->ap_mac_addr, 0, key);
						}
					}
#ifdef RTL8192E
					if ((ieee->pairwise_key_type == KEY_TYPE_CCMP) && ieee->pHTInfo->bCurrentHTSupport){
						write_nic_byte(dev, 0x173, 1); 
					}
#endif

				}
				else 
				{
					memcpy((u8*)key, ipw->u.crypt.key, 16);
					if (strcmp(ipw->u.crypt.alg, "CCMP") == 0)
						ieee->group_key_type= KEY_TYPE_CCMP;
					else if (strcmp(ipw->u.crypt.alg, "TKIP") == 0)
						ieee->group_key_type = KEY_TYPE_TKIP;
					else if (strcmp(ipw->u.crypt.alg, "WEP") == 0)
					{
						if (ipw->u.crypt.key_len == 13)
							ieee->group_key_type = KEY_TYPE_WEP104;
						else if (ipw->u.crypt.key_len == 5)
							ieee->group_key_type = KEY_TYPE_WEP40;
					}
					else
						ieee->group_key_type = KEY_TYPE_NA;

					if (ieee->group_key_type)
					{
#ifdef _RTL8192_EXT_PATCH_
						set_swcam(	dev, 
								ipw->u.crypt.idx,
								ipw->u.crypt.idx,		
								ieee->group_key_type,	
								broadcast_addr,	
								0,		
								key,		
								0);
#else
						set_swcam(	dev, 
								ipw->u.crypt.idx,
								ipw->u.crypt.idx,		
								ieee->group_key_type,	
								broadcast_addr,	
								0,		
								key);		
#endif
						setKey(	dev, 
								ipw->u.crypt.idx,
								ipw->u.crypt.idx,		
								ieee->group_key_type,	
								broadcast_addr,	
								0,		
								key);		
					}
				}
			}
#ifdef JOHN_DEBUG
			{
				int i;
				printk("@@ wrq->u pointer = ");
				for(i=0;i<wrq->u.data.length;i++){
					if(i%10==0) printk("\n");
					printk( "%8x|", ((u32*)wrq->u.data.pointer)[i] );
				}
				printk("\n");
			}
#endif 
#ifdef _RTL8192_EXT_PATCH_
			ret = ieee80211_wpa_supplicant_ioctl(priv->ieee80211, &wrq->u.data,0);
#else
			ret = ieee80211_wpa_supplicant_ioctl(priv->ieee80211, &wrq->u.data);
#endif
			break; 

		default:
			ret = -EOPNOTSUPP;
			break;
	}

	kfree(ipw);
out:
	up(&priv->wx_sem);

	return ret;
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,18)
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
void rtl8192_interrupt(int irq, void *netdev, struct pt_regs *regs)
#else
irqreturn_t rtl8192_interrupt(int irq, void *netdev, struct pt_regs *regs)
#endif
#else
irqreturn_t rtl8192_interrupt(int irq, void *netdev)
#endif
{
    struct net_device *dev = (struct net_device *) netdev;
    struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
#ifdef _RTL8192_EXT_PATCH_
    struct net_device *meshdev = ((struct ieee80211_device *)netdev_priv_rsl(dev))->meshdev;
#endif
    unsigned long flags;
    u32 inta;
#ifdef RTL8192SE
    u32 intb;
    intb = 0;
#endif
    if(priv->irq_enabled == 0){
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
        return;
#else
        return IRQ_HANDLED;
#endif
    }

    spin_lock_irqsave(&priv->irq_th_lock,flags);

#ifdef RTL8192SE
    inta = read_nic_dword(dev, ISR) & priv->irq_mask[0];
#else
    inta = read_nic_dword(dev, ISR) ;
#endif
    write_nic_dword(dev,ISR,inta); 
#ifdef RTL8192SE
    intb = read_nic_dword(dev, ISR+4);
    write_nic_dword(dev, ISR+4, intb);
#endif
    priv->stats.shints++;
    if (!inta) {
        spin_unlock_irqrestore(&priv->irq_th_lock,flags);
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
        return;
#else
        return IRQ_HANDLED;  
#endif
        /* 
           most probably we can safely return IRQ_NONE,
           but for now is better to avoid problems
           */
    }

    if (inta == 0xffff) {
        spin_unlock_irqrestore(&priv->irq_th_lock,flags);
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
        return;
#else
        return IRQ_HANDLED;  
#endif
    }

    priv->stats.ints++;
#ifdef DEBUG_IRQ
    DMESG("NIC irq %x",inta);
#endif

#ifdef _RTL8192_EXT_PATCH_
    if (!netif_running(dev) && !netif_running(meshdev)) {
#else
    if (!netif_running(dev)) {
#endif
        spin_unlock_irqrestore(&priv->irq_th_lock,flags);
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
        return;
#else
        return IRQ_HANDLED;
#endif
    }

#ifdef RTL8192SE
    if(intb & IMR_TBDOK){
        RT_TRACE(COMP_INTR, "beacon ok interrupt!\n");
        priv->stats.txbeaconokint++;
    }

    if(intb & IMR_TBDER){
        RT_TRACE(COMP_INTR, "beacon ok interrupt!\n");
        priv->stats.txbeaconerr++;
    }
#else
    if(inta & IMR_TBDOK){
        RT_TRACE(COMP_INTR, "beacon ok interrupt!\n");
        priv->stats.txbeaconokint++;
    }

    if(inta & IMR_TBDER){
        RT_TRACE(COMP_INTR, "beacon ok interrupt!\n");
        priv->stats.txbeaconerr++;
    }
#endif

    if(inta & IMR_BDOK) {
        RT_TRACE(COMP_INTR, "beacon interrupt!\n");
        rtl8192_tx_isr(dev, BEACON_QUEUE);
    }

    if(inta  & IMR_MGNTDOK ) {
        RT_TRACE(COMP_INTR, "Manage ok interrupt!\n");
        priv->stats.txmanageokint++;
        rtl8192_tx_isr(dev,MGNT_QUEUE);
	 spin_unlock_irqrestore(&priv->irq_th_lock,flags);
         {
             if (priv->ieee80211->ack_tx_to_ieee){
                 if (rtl8192_is_tx_queue_empty(dev)){
                     priv->ieee80211->ack_tx_to_ieee = 0;
                     ieee80211_ps_tx_ack(priv->ieee80211, 1);
                 }
             }
         } 
	 spin_lock_irqsave(&priv->irq_th_lock,flags);
    }

    if (inta & IMR_COMDOK) {
        priv->stats.txcmdpktokint++;
        rtl8192_tx_isr(dev,TXCMD_QUEUE);
    }

    if (inta & IMR_HIGHDOK) {
        rtl8192_tx_isr(dev,HIGH_QUEUE);
    }

    if (inta & IMR_ROK){
#ifdef DEBUG_RX
        DMESG("Frame arrived !");
#endif
        priv->stats.rxint++;
	priv->InterruptLog.nIMR_ROK++;
        tasklet_schedule(&priv->irq_rx_tasklet);
    }

    if (inta & IMR_BcnInt) {
        RT_TRACE(COMP_INTR, "prepare beacon for interrupt!\n");
        tasklet_schedule(&priv->irq_prepare_beacon_tasklet);
    }

    if (inta & IMR_RDU) {
        RT_TRACE(COMP_INTR, "rx descriptor unavailable!\n");
        priv->stats.rxrdu++;
        write_nic_dword(dev,INTA_MASK,read_nic_dword(dev, INTA_MASK) & ~IMR_RDU); 
        tasklet_schedule(&priv->irq_rx_tasklet);
    }

    if (inta & IMR_RXFOVW) {
        RT_TRACE(COMP_INTR, "rx overflow !\n");
        priv->stats.rxoverflow++;
        tasklet_schedule(&priv->irq_rx_tasklet);
    }

    if (inta & IMR_TXFOVW) priv->stats.txoverflow++;

    if (inta & IMR_BKDOK) { 
        RT_TRACE(COMP_INTR, "BK Tx OK interrupt!\n");
        priv->stats.txbkokint++;
        priv->ieee80211->LinkDetectInfo.NumTxOkInPeriod++;
        rtl8192_tx_isr(dev,BK_QUEUE);
    }

    if (inta & IMR_BEDOK) { 
        RT_TRACE(COMP_INTR, "BE TX OK interrupt!\n");
        priv->stats.txbeokint++;
        priv->ieee80211->LinkDetectInfo.NumTxOkInPeriod++;
        rtl8192_tx_isr(dev,BE_QUEUE);
    }

    if (inta & IMR_VIDOK) { 
        RT_TRACE(COMP_INTR, "VI TX OK interrupt!\n");
        priv->stats.txviokint++;
        priv->ieee80211->LinkDetectInfo.NumTxOkInPeriod++;
        rtl8192_tx_isr(dev,VI_QUEUE);
    }

    if (inta & IMR_VODOK) { 
        priv->stats.txvookint++;
        RT_TRACE(COMP_INTR, "Vo TX OK interrupt!\n");
        priv->ieee80211->LinkDetectInfo.NumTxOkInPeriod++;
        rtl8192_tx_isr(dev,VO_QUEUE);
    }

    spin_unlock_irqrestore(&priv->irq_th_lock,flags);

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
    return;
#else
    return IRQ_HANDLED;
#endif
}

/****************************************************************************
     ---------------------------- PCI_STUFF---------------------------
*****************************************************************************/
#ifdef HAVE_NET_DEVICE_OPS
static const struct net_device_ops rtl8192_netdev_ops = {
	.ndo_open = rtl8192_open,
	.ndo_stop = rtl8192_close,
	.ndo_tx_timeout = tx_timeout,
	.ndo_do_ioctl = rtl8192_ioctl,
	.ndo_set_multicast_list = r8192_set_multicast,
	.ndo_set_mac_address = r8192_set_mac_adr,
	.ndo_validate_addr = eth_validate_addr,
	.ndo_change_mtu = eth_change_mtu,
	.ndo_start_xmit = ieee80211_xmit,
};
#endif

static int __devinit rtl8192_pci_probe(struct pci_dev *pdev,
			 const struct pci_device_id *id)
{
	unsigned long ioaddr = 0;
	struct net_device *dev = NULL;
	struct r8192_priv *priv= NULL;
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)
	struct rtl819x_ops *ops = (struct rtl819x_ops *)(id->driver_data);
#endif
	
#ifdef CONFIG_RTL8192_IO_MAP
	unsigned long pio_start, pio_len, pio_flags;
#else
	unsigned long pmem_start, pmem_len, pmem_flags;
#endif 
	int err = 0;
#ifdef _RTL8192_EXT_PATCH_
	int result;
	struct net_device *meshdev = NULL;
	struct meshdev_priv *mpriv;
	char meshifname[]="mesh0";
#endif	

	RT_TRACE(COMP_INIT,"Configuring chip resources");
	
	if( pci_enable_device (pdev) ){
		RT_TRACE(COMP_ERR,"Failed to enable PCI device");
		return -EIO;
	}

	pci_set_master(pdev);
	pci_set_dma_mask(pdev, 0xffffff00ULL);
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)
	pci_set_consistent_dma_mask(pdev,0xffffff00ULL);
#endif	
	dev = alloc_ieee80211(sizeof(struct r8192_priv));
	if (!dev)
		return -ENOMEM;
	
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,24)
	SET_MODULE_OWNER(dev);
#endif

	pci_set_drvdata(pdev, dev);	
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)
	SET_NETDEV_DEV(dev, &pdev->dev);
#endif
	priv = ieee80211_priv(dev);
	priv->ieee80211 = (struct ieee80211_device *)netdev_priv_rsl(dev);
	priv->pdev=pdev;
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)
	if((pdev->subsystem_vendor == PCI_VENDOR_ID_DLINK)&&(pdev->subsystem_device == 0x3304)){
		priv->ieee80211->bSupportRemoteWakeUp = 1;
	} else 
#endif
	{
		priv->ieee80211->bSupportRemoteWakeUp = 0;
	}

#ifdef CONFIG_RTL8192_IO_MAP
	pio_start = (unsigned long)pci_resource_start (pdev, 0);
	pio_len = (unsigned long)pci_resource_len (pdev, 0);
	pio_flags = (unsigned long)pci_resource_flags (pdev, 0);
 	
      	if (!(pio_flags & IORESOURCE_IO)) {
		RT_TRACE(COMP_ERR,"region #0 not a PIO resource, aborting");
		goto fail;
	}
	
	if( ! request_region( pio_start, pio_len, DRV_NAME ) ){
		RT_TRACE(COMP_ERR,"request_region failed!");
		goto fail;
	}
	
	ioaddr = pio_start;
	dev->base_addr = ioaddr; 
#else
	pmem_start = pci_resource_start(pdev, 1);
	pmem_len = pci_resource_len(pdev, 1);
	pmem_flags = pci_resource_flags (pdev, 1);
	
	if (!(pmem_flags & IORESOURCE_MEM)) {
		RT_TRACE(COMP_ERR,"region #1 not a MMIO resource, aborting");
		goto fail;
	}
	
	if (!request_mem_region(pmem_start, pmem_len, DRV_NAME)) {
		RT_TRACE(COMP_ERR,"request_mem_region failed!");
		goto fail;
	}
	
	
	ioaddr = (unsigned long)ioremap_nocache( pmem_start, pmem_len);	
	if( ioaddr == (unsigned long)NULL ){
		RT_TRACE(COMP_ERR,"ioremap failed!");
		goto fail1;
	}
	
	dev->mem_start = ioaddr; 
	dev->mem_end = ioaddr + pci_resource_len(pdev, 0); 
	
#endif 
#ifdef RTL8192SE
        pci_write_config_byte(pdev, 0x81,0);
        pci_write_config_byte(pdev,0x44,0);
        pci_write_config_byte(pdev,0x04,0x06);
        pci_write_config_byte(pdev,0x04,0x07);
#endif        

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)
	priv->ops = ops;
#else
#if defined RTL8190P || defined RTL8192E
	priv->ops = &rtl819xp_ops;
#else
	priv->ops = &rtl8192se_ops;
#endif
#endif

#ifdef RTL8190P
	rtl819xp_ops.nic_type = priv->card_8192 = NIC_8190P;
#else
	{
		u8 tmp = 0;
		pci_read_config_byte(pdev, 0x8, &tmp);
#ifdef RTL8192E
		if (tmp == HAL_HW_PCI_REVISION_ID_8192PCIE){
			printk("===============>NIC 8192E\n");
			rtl819xp_ops.nic_type = priv->card_8192 = NIC_8192E;
		}			
		else
#else 
		if (tmp == HAL_HW_PCI_REVISION_ID_8192SE){
			printk("===============>NIC 8192SE\n");
			priv->card_8192 = NIC_8192SE;
		}
		else
#endif
		{
			RT_TRACE(COMP_ERR, "UNKNOWN nic type(%4x:%4x)\n", pdev->vendor, pdev->device);
			priv->card_8192 = NIC_UNKNOWN;
			goto fail1;
		}
		
	}
#endif
	dev->irq = pdev->irq;
	priv->irq = 0;

#ifdef HAVE_NET_DEVICE_OPS
	dev->netdev_ops = &rtl8192_netdev_ops;
#else	
	dev->open = rtl8192_open;
	dev->stop = rtl8192_close;
	dev->tx_timeout = tx_timeout;
	dev->do_ioctl = rtl8192_ioctl;
	dev->set_multicast_list = r8192_set_multicast;
	dev->set_mac_address = r8192_set_mac_adr;
	dev->hard_start_xmit = ieee80211_xmit;
#endif	

#if WIRELESS_EXT >= 12
#if WIRELESS_EXT < 17
        dev->get_wireless_stats = r8192_get_wireless_stats;
#endif
        dev->wireless_handlers = (struct iw_handler_def *) &r8192_wx_handlers_def;
#endif
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)	
	dev->ethtool_ops = &rtl819x_ethtool_ops;
#endif

	dev->type = ARPHRD_ETHER;
	dev->watchdog_timeo = HZ*3;	

	if (dev_alloc_name(dev, ifname) < 0){
                RT_TRACE(COMP_INIT, "Oops: devname already taken! Trying wlan%%d...\n");
		dev_alloc_name(dev, ifname);
        }
	
	RT_TRACE(COMP_INIT, "Driver probe completed1\n");
	if(rtl8192_init(dev)!=0){ 
		RT_TRACE(COMP_ERR, "Initialization failed");
		goto fail1;
	}
	
	netif_carrier_off(dev);
	netif_stop_queue(dev);
	
	register_netdev(dev);
	RT_TRACE(COMP_INIT, "dev name=======> %s\n",dev->name);
	err = rtl_debug_module_init(priv, dev->name);
	if (err) {
		RT_TRACE(COMP_DBG, "failed to create debugfs files. Ignoring error: %d\n", err);	
	}
	rtl8192_proc_init_one(dev);
	
#ifdef ENABLE_GPIO_RADIO_CTL
	if(priv->polling_timer_on == 0){
		check_rfctrl_gpio_timer((unsigned long)dev);
	}
#endif
#ifdef _RTL8192_EXT_PATCH_
	meshdev = alloc_netdev(sizeof(struct meshdev_priv),meshifname,meshdev_init);
	netif_stop_queue(meshdev);
	memcpy(meshdev->dev_addr, dev->dev_addr, ETH_ALEN);
	DMESG("Card MAC address for meshdev is "MAC_FMT, MAC_ARG(meshdev->dev_addr));

	meshdev->base_addr = dev->base_addr;
	meshdev->irq = dev->irq;
	meshdev->mem_start = dev->mem_start;
	meshdev->mem_end = dev->mem_end;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,21)
	SET_NETDEV_DEV(meshdev, dev->dev.parent);
#endif

	if ((result = register_netdev(meshdev)))
	{
		printk("Error %i registering device %s",result, meshdev->name);
		goto fail;	
	}
	else
	{
		mpriv = (struct meshdev_priv *)netdev_priv_rsl(meshdev);
		priv->ieee80211->meshdev=meshdev;
		priv->ieee80211->meshstats=meshdev_stats(meshdev);
		priv->ieee80211->only_mesh = 1;  
		priv->ieee80211->p2pmode = 0;
		priv->ieee80211->is_server_eth0 = 0;
		priv->ieee80211->serverExtChlOffset = 0;
		priv->ieee80211->APExtChlOffset = 0;
		mpriv->ieee80211 = priv->ieee80211;
		mpriv->priv = priv;
	}
#endif
	
	RT_TRACE(COMP_INIT, "Driver probe completed\n");
	return 0;	

fail1:
#ifdef CONFIG_RTL8180_IO_MAP
		
	if( dev->base_addr != 0 ){
			
		release_region(dev->base_addr, 
	       pci_resource_len(pdev, 0) );
	}
#else
	if( dev->mem_start != (unsigned long)NULL ){
		iounmap( (void *)dev->mem_start );
		release_mem_region( pci_resource_start(pdev, 1), 
				    pci_resource_len(pdev, 1) );
	}
#endif 
	
fail:
	if(dev){
		
		if (priv->irq) {
			free_irq(dev->irq, dev);
			dev->irq=0;
		}
		free_ieee80211(dev);
	}
	
	pci_disable_device(pdev);
	
	DMESG("wlan driver load failed\n");
	pci_set_drvdata(pdev, NULL);
	return -ENODEV;
	
}

static void __devexit rtl8192_pci_disconnect(struct pci_dev *pdev)
{
	struct net_device *dev = pci_get_drvdata(pdev);
	struct r8192_priv *priv ;
#ifdef _RTL8192_EXT_PATCH_
	struct net_device *meshdev;
#endif

 	if(dev){
		
		unregister_netdev(dev);
		
		priv = ieee80211_priv(dev);
#ifdef _RTL8192_EXT_PATCH_
		if(priv && priv->mshobj)
		{
			if(priv->mshobj->ext_patch_remove_proc)
				priv->mshobj->ext_patch_remove_proc(priv);
			priv->ieee80211->ext_patch_ieee80211_start_protocol = 0;
			priv->ieee80211->ext_patch_ieee80211_stop_protocol = 0;
			priv->ieee80211->ext_patch_ieee80211_probe_req_1 = 0;
			priv->ieee80211->ext_patch_ieee80211_probe_req_2 = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_auth =0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_deauth =0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_peerlink_open = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_peerlink_confirm = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_peerlink_close = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_linkmetric_report= 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_linkmetric_req= 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_preq = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_prep=0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_perr = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_rann=0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_softmac_on_pathselect_pann=0;
			priv->ieee80211->ext_patch_ieee80211_ext_stop_scan_wq_set_channel = 0;
			priv->ieee80211->ext_patch_ieee80211_process_probe_response_1 = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_mgt_on_probe_req = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_mgt_update_expire = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_on_rx = 0;
			priv->ieee80211->ext_patch_get_beacon_get_probersp = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_get_hdrlen = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_get_mac_hdrlen = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_frame_get_mesh_hdrlen_llc = 0;
			priv->ieee80211->ext_patch_ieee80211_rx_is_valid_framectl = 0;
			priv->ieee80211->ext_patch_ieee80211_softmac_xmit_get_rate = 0;
			priv->ieee80211->ext_patch_ieee80211_tx_data = 0;
			priv->ieee80211->ext_patch_ieee80211_is_mesh = 0;
			priv->ieee80211->ext_patch_ieee80211_create_crypt_for_peer = 0;
			priv->ieee80211->ext_patch_ieee80211_get_peermp_htinfo = 0;
			priv->ieee80211->ext_patch_ieee80211_update_ratr_mask = 0;
#ifdef MESH_ATH_2
		        priv->ieee80211->ext_patch_ieee80211_send_ath_commit = 0;
		        priv->ieee80211->ext_patch_ieee80211_send_ath_confirm = 0;
		        priv->ieee80211->ext_patch_ieee80211_rx_ath_commit = 0;
		        priv->ieee80211->ext_patch_ieee80211_rx_ath_confirm = 0;
#endif
                        free_mshobj(&priv->mshobj);
		}
#endif 
#ifdef ENABLE_GPIO_RADIO_CTL
		del_timer_sync(&priv->gpio_polling_timer);
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)	
		cancel_delayed_work(&priv->gpio_change_rf_wq);
#endif
		priv->polling_timer_on = 0;
#endif
		rtl_debug_module_remove(priv);
		rtl8192_proc_remove_one(dev);
#ifdef _RTL8192_EXT_PATCH_
		rtl8192_down(dev,true);
		if(priv && priv->ieee80211->meshdev)
		{
			meshdev = priv->ieee80211->meshdev;
			priv->ieee80211->meshdev = NULL;
		
			if(meshdev){
				meshdev_down(meshdev);
				unregister_netdev(meshdev);
			}
		}
#else		
		rtl8192_down(dev,true);
#endif
		deinit_hal_dm(dev);
#ifdef RTL8192SE
#ifdef RTL8192SE_CONFIG_ASPM_OR_D3
		PlatformDisableASPM(dev);
#endif
		DeInitSwLeds(dev);
#endif
		if (priv->pFirmware)
		{
			vfree(priv->pFirmware);
			priv->pFirmware = NULL;
		}
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)
		destroy_workqueue(priv->priv_wq);
#endif
                {
                    u32 i;
                    rtl8192_free_rx_ring(dev);
                    for (i = 0; i < MAX_TX_QUEUE_COUNT; i++) {
                        rtl8192_free_tx_ring(dev, i);
                    }
                }

		if(priv->irq){
			
			printk("Freeing irq %d\n",dev->irq);
			free_irq(dev->irq, dev);
			priv->irq=0;
			
		}
#ifdef CONFIG_RTL8180_IO_MAP
		if( dev->base_addr != 0 ){
			
			release_region(dev->base_addr, 
				       pci_resource_len(pdev, 0) );
		}
#else
		if( dev->mem_start != (unsigned long)NULL ){
			iounmap( (void *)dev->mem_start );
			release_mem_region( pci_resource_start(pdev, 1), 
					    pci_resource_len(pdev, 1) );
		}
#endif /*end #ifdef RTL_IO_MAP*/
		free_ieee80211(dev);

	} else{
		priv=ieee80211_priv(dev);
        }

	pci_disable_device(pdev);
#if 1   
        pci_write_config_byte(pdev, 0x81,1);
        pci_write_config_byte(pdev,0x44,3);
#endif
	RT_TRACE(COMP_DOWN, "wlan driver removed\n");
}

#ifdef BUILT_IN_IEEE80211
/* fun with the built-in ieee80211 stack... */
extern int ieee80211_init(void);
extern int ieee80211_exit(void);
extern int ieee80211_crypto_init(void);
extern void ieee80211_crypto_deinit(void);
extern int ieee80211_crypto_tkip_init(void);
extern void ieee80211_crypto_tkip_exit(void);
extern int ieee80211_crypto_ccmp_init(void);
extern void ieee80211_crypto_ccmp_exit(void);
extern int ieee80211_crypto_wep_init(void);
extern void ieee80211_crypto_wep_exit(void);
#endif
#ifdef BUILT_IN_MSHCLASS
extern int msh_init(void);
extern int msh_exit(void);
#endif

static int __init rtl8192_pci_module_init(void)
{
	int ret;
	int error;

#ifdef BUILT_IN_CRYPTO
        ret = arc4_init();
        if (ret) {
                printk(KERN_ERR "arc4_init() failed %d\n", ret);
                return ret;
        }


        ret = michael_mic_init();
        if (ret) {
                printk(KERN_ERR "michael_mic_init() failed %d\n", ret);
                return ret;
        }

        ret = aes_init();
        if (ret) {
                printk(KERN_ERR "aes_init() failed %d\n", ret);
                return ret;
        }
#endif
#ifdef BUILT_IN_IEEE80211
	ret = ieee80211_init();
	if (ret) {
		printk(KERN_ERR "ieee80211_init() failed %d\n", ret);
		return ret;
	}
	ret = ieee80211_crypto_init();
	if (ret) {
		printk(KERN_ERR "ieee80211_crypto_init() failed %d\n", ret);
		return ret;
	}
	ret = ieee80211_crypto_tkip_init();
	if (ret) {
		printk(KERN_ERR "ieee80211_crypto_tkip_init() failed %d\n", ret);
		return ret;
	}
	ret = ieee80211_crypto_ccmp_init();
	if (ret) {
		printk(KERN_ERR "ieee80211_crypto_ccmp_init() failed %d\n", ret);
		return ret;
	}
	ret = ieee80211_crypto_wep_init();
	if (ret) {
		printk(KERN_ERR "ieee80211_crypto_wep_init() failed %d\n", ret);
		return ret;
	}
#endif
#ifdef BUILT_IN_MSHCLASS
	ret = msh_init();
	if (ret) {
		printk(KERN_ERR "msh_init() failed %d\n", ret);
		return ret;
	}
#endif
	printk(KERN_INFO "\nLinux kernel driver for RTL8192 based WLAN cards\n");
	printk(KERN_INFO "Copyright (c) 2007-2008, Realsil Wlan\n");
	RT_TRACE(COMP_INIT, "Initializing module");
	RT_TRACE(COMP_INIT, "Wireless extensions version %d", WIRELESS_EXT);

	error = rtl_create_debugfs_root();
	if (error) {
		RT_TRACE(COMP_DBG, "Create debugfs root fail: %d\n", error);
		goto err_out;
	}

	rtl8192_proc_module_init();
#if(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,22))
      if(0!=pci_module_init(&rtl8192_pci_driver))
#else
      if(0!=pci_register_driver(&rtl8192_pci_driver))
#endif
	{
		DMESG("No device found");
		/*pci_unregister_driver (&rtl8192_pci_driver);*/
		return -ENODEV;
	}
	return 0;
err_out:
        return error;

}

static void __exit rtl8192_pci_module_exit(void)
{
	pci_unregister_driver(&rtl8192_pci_driver);

	RT_TRACE(COMP_DOWN, "Exiting");
	rtl8192_proc_module_remove();
	rtl_remove_debugfs_root();
#ifdef BUILT_IN_IEEE80211
	ieee80211_crypto_tkip_exit();
	ieee80211_crypto_ccmp_exit();
	ieee80211_crypto_wep_exit();
	ieee80211_crypto_deinit();
	ieee80211_exit();
#endif	
#ifdef BUILT_IN_CRYPTO
        arc4_exit();
        michael_mic_exit();
        aes_fini();
#endif
#ifdef BUILT_IN_MSHCLASS
	msh_exit();
#endif

}

/***************************************************************************
     ------------------- HW RELATED STUFF----------------
****************************************************************************/
#ifdef RTL8192SE
u8
HalSetSysClk8192SE(
	struct net_device *dev,
	u8 Data
	)
{
#if 0
	write_nic_byte(dev, (SYS_CLKR + 1), Data);
	udelay(200);;
	return 1;
#else
	{
		u8				WaitCount = 100;
		bool bResult = false;

#ifdef TO_DO_LIST
		RT_DISABLE_FUNC(Adapter, DF_IO_BIT);

		do
		{
			if(pDevice->IOCount == 0)
				break;
			delay_us(10);
		}while(WaitCount -- > 0);

		if(WaitCount == 0)
		{ 
			RT_ENABLE_FUNC(Adapter, DF_IO_BIT);
			RT_TRACE(COMP_POWER, DBG_WARNING, ("HalSetSysClk8192SE(): Wait too long! Skip ....\n"));
			return false;
		}
		#endif
		write_nic_byte(dev,SYS_CLKR + 1,Data);

		udelay(400);


		{
			u8 TmpValue;
			TmpValue=read_nic_byte(dev,SYS_CLKR + 1);
			bResult = ((TmpValue&BIT7)== (Data & BIT7));
			if((Data &(BIT6|BIT7)) == false)
			{			
				WaitCount = 100;
				TmpValue = 0;
				while(1) 
				{
					WaitCount--;
					TmpValue=read_nic_byte(dev, SYS_CLKR + 1); 
					if((TmpValue &BIT6))
						break;
					printk("wait for BIT6 return value %x\n",TmpValue);	
					if(WaitCount==0)
						break;
					udelay(10);
				}
				if(WaitCount == 0)
					bResult = false;
				else
					bResult = true;
			}
		}
#ifdef TO_DO_LIST
		RT_ENABLE_FUNC(Adapter, DF_IO_BIT);
#endif
		RT_TRACE(COMP_PS,"HalSetSysClk8192SE():Value = %02X, return: %d\n", Data, bResult);
		return bResult;
	}
#endif
}

#ifndef _RTL8192_EXT_PATCH_
static u8 LegacyRateSet[12] = {0x02 , 0x04 , 0x0b , 0x16 , 0x0c , 0x12 , 0x18 , 0x24 , 0x30 , 0x48 , 0x60 , 0x6c};
void GetHwReg8192SE(struct net_device *dev,u8 variable,u8* val)
{
	switch(variable)
	{
		case HW_VAR_INIT_TX_RATE: 
			{
				u8 RateIdx = read_nic_byte(dev, TX_RATE_REG);
				if(RateIdx < 76)
					*((u8*)(val)) = (RateIdx<12)?(LegacyRateSet[RateIdx]):((RateIdx-12)|0x80);
				else
					*((u8*)(val)) = 0;
			}
			break;

		default:
			break;
	}
}
#endif
void SetHwReg8192SE(struct net_device *dev,u8 variable,u8* val)
{
	struct r8192_priv* priv = ieee80211_priv(dev);
	switch(variable)
	{
		case HW_VAR_AMPDU_MIN_SPACE:
		{
			u8	MinSpacingToSet;
			u8	SecMinSpace;

			MinSpacingToSet = *((u8*)val);
			if(MinSpacingToSet <= 7)
			{
				if((priv->ieee80211->current_network.capability & WLAN_CAPABILITY_PRIVACY) == 0)  
					SecMinSpace = 0;
				else if (priv->ieee80211->ieee80211_ap_sec_type && 
						(priv->ieee80211->ieee80211_ap_sec_type(priv->ieee80211) 
							 & (SEC_ALG_WEP|SEC_ALG_TKIP))) 
					SecMinSpace = 7;
				else
					SecMinSpace = 1;

				if(MinSpacingToSet < SecMinSpace)
					MinSpacingToSet = SecMinSpace;
				priv->ieee80211->MinSpaceCfg = ((priv->ieee80211->MinSpaceCfg&0xf8) |MinSpacingToSet);
				RT_TRACE(COMP_MLME, "Set HW_VAR_AMPDU_MIN_SPACE: %#x\n", priv->ieee80211->MinSpaceCfg);
				write_nic_byte(dev, AMPDU_MIN_SPACE, priv->ieee80211->MinSpaceCfg);	
			}
		}
		break;	
		case HW_VAR_SHORTGI_DENSITY:
		{
			u8	DensityToSet;
		
			DensityToSet = *((u8*)val);		
			priv->ieee80211->MinSpaceCfg|= (DensityToSet<<3);		
			RT_TRACE(COMP_MLME, "Set HW_VAR_SHORTGI_DENSITY: %#x\n", priv->ieee80211->MinSpaceCfg);
			write_nic_byte(dev, AMPDU_MIN_SPACE, priv->ieee80211->MinSpaceCfg);
			break;		
		}
		case HW_VAR_AMPDU_FACTOR:
		{
			u8	FactorToSet;
			u8	RegToSet;
			u8	FactorLevel[18] = {2, 4, 4, 7, 7, 13, 13, 13, 2, 7, 7, 13, 13, 15, 15, 15, 15, 0};
			u8	index = 0;
		
			FactorToSet = *((u8*)val);
			if(FactorToSet <= 3)
			{
				FactorToSet = (1<<(FactorToSet + 2));
				if(FactorToSet>0xf)
					FactorToSet = 0xf;

				for(index=0; index<17; index++)
				{
					if(FactorLevel[index] > FactorToSet)
						FactorLevel[index] = FactorToSet;
				}

				for(index=0; index<8; index++)
				{
					RegToSet = ((FactorLevel[index*2]) | (FactorLevel[index*2+1]<<4));
					write_nic_byte(dev, AGGLEN_LMT_L+index, RegToSet);
				}
				RegToSet = ((FactorLevel[16]) | (FactorLevel[17]<<4));
				write_nic_byte(dev, AGGLEN_LMT_H, RegToSet);

				RT_TRACE(COMP_MLME, "Set HW_VAR_AMPDU_FACTOR: %#x\n", FactorToSet);
			}
		}
		break;
		case HW_VAR_BASIC_RATE:
		{
			u16				BrateCfg = 0;
			u8				RateIndex = 0;

			
			rtl8192_config_rate(dev, &BrateCfg);

			if (priv->card_8192_version == VERSION_8192S_ACUT)
				priv->basic_rate = BrateCfg = BrateCfg & 0x150;
			else if (priv->card_8192_version == VERSION_8192S_BCUT)
				priv->basic_rate = BrateCfg = BrateCfg & 0x15f;
		
  	                if(priv->ieee80211->pHTInfo->IOTPeer == HT_IOT_PEER_CISCO && ((BrateCfg &0x150)==0))
			{
				BrateCfg |=0x010;
			}
			if(priv->ieee80211->pHTInfo->IOTAction & HT_IOT_ACT_WA_IOT_Broadcom)
			{	
				BrateCfg &= 0x1f0;
				printk("HW_VAR_BASIC_RATE, HT_IOT_ACT_WA_IOT_Broadcom, BrateCfg = 0x%x\n", BrateCfg);
			}
			write_nic_byte(dev, RRSR, BrateCfg&0xff);
			write_nic_byte(dev, RRSR+1, (BrateCfg>>8)&0xff);

			while(BrateCfg > 0x1)
			{
				BrateCfg = (BrateCfg >> 1);
				RateIndex++;
			}
			write_nic_byte(dev, INIRTSMCS_SEL, RateIndex);
		}
		break;
		case HW_VAR_RETRY_LIMIT:
		{
			u8 RetryLimit = ((u8*)(val))[0];
			
			priv->ShortRetryLimit = RetryLimit;
			priv->LongRetryLimit = RetryLimit;
			
			write_nic_word(dev, RETRY_LIMIT, 
							RetryLimit << RETRY_LIMIT_SHORT_SHIFT | \
							RetryLimit << RETRY_LIMIT_LONG_SHIFT);
		}					
		break;
		case HW_VAR_BEACON_INTERVAL:
		{
			write_nic_word(dev, BCN_INTERVAL, *((u16*)val));
			PHY_SetBeaconHwReg(dev, *((u16*)val));
		}
		break;
		
		default:
			break;
	}
}

void SetBeaconRelatedRegisters8192SE(struct net_device *dev)
{
	struct r8192_priv *priv = (struct r8192_priv *)ieee80211_priv(dev);
	struct ieee80211_network *net = &priv->ieee80211->current_network;
	u16			BcnTimeCfg = 0;
	u16			BcnCW = 6, BcnIFS = 0xf;
	u16			AtimWindow = 2;	
	int			OpMode = priv->ieee80211->iw_mode;
	u16			BcnInterval = net->beacon_interval;
	write_nic_word(dev, ATIMWND, AtimWindow);
	
	write_nic_word(dev, BCN_INTERVAL, BcnInterval);
	PHY_SetBeaconHwReg( dev, BcnInterval);

	write_nic_word(dev, BCN_DRV_EARLY_INT, 10<<4);

	write_nic_word(dev, BCN_DMATIME, 256); 

	write_nic_byte(dev, BCN_ERR_THRESH, 100); 

		
	switch(OpMode)
	{
		case IW_MODE_ADHOC:
			BcnTimeCfg |= (BcnCW<<BCN_TCFG_CW_SHIFT);
			break;
		default:
			printk("Invalid Operation Mode!!\n");
			break;
	}

	BcnTimeCfg |= BcnIFS<<BCN_TCFG_IFS;


	{
		u8 u1Temp = (u8)(BcnInterval);
		write_nic_dword(dev, WFM5, 0xF1000000 |((u16)( u1Temp) << 8));
		ChkFwCmdIoDone(dev);
	}
}

void UpdateHalRATRTableIndex(struct net_device *dev)
{
	struct r8192_priv* priv = ieee80211_priv(dev);
	struct ieee80211_device* ieee = priv->ieee80211;
	u8		bitmap = 0;
	int		i;

	for (i = 0; i < PEER_MAX_ASSOC; i++) {
		if (NULL != ieee->peer_assoc_list[i]) {
			bitmap |= BIT0 << ieee->peer_assoc_list[i]->ratr_index;
		}
	}

	priv->RATRTableBitmap = bitmap;
	return;
}

bool rtl8192se_check_ht_cap(struct net_device* dev, struct sta_info *sta, 
		struct ieee80211_network* net)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_device *ieee = priv->ieee80211;
	PHT_CAPABILITY_ELE  pHTCapIE = NULL;
	PHT_INFORMATION_ELE  pPeerHTInfo = NULL;
	u8 ExtChlOffset=0;
	u8	*pMcsFilter = NULL;
	u16	nMaxAMSDUSize = 0;	
	static u8	EWC11NHTCap[] = {0x00, 0x90, 0x4c, 0x33};	
	static u8 	EWC11NHTInfo[] = {0x00, 0x90, 0x4c, 0x34};

	if ((ieee->mode != WIRELESS_MODE_N_24G) && 
			(ieee->mode != WIRELESS_MODE_N_5G)) {
		printk("%s():i am G mode ,do not need to check Cap IE\n",
				__FUNCTION__);
		if (net->mode == IEEE_N_5G)
			sta->wireless_mode = IEEE_A;
		else if (net->mode == IEEE_N_24G) {
			if (net->rates_ex_len > 0)
				sta->wireless_mode = IEEE_G;
			else
				sta->wireless_mode = IEEE_B;
		} else
			sta->wireless_mode = net->mode;
		return false;
	}
	if ((ieee->mode ==WIRELESS_MODE_N_24G) 
		&& ieee->pHTInfo->bRegSuppCCK== false) {
		if(net->mode == IEEE_B){
			sta->wireless_mode = net->mode;
			printk("%s(): peer is B MODE return\n", __FUNCTION__);
			return false;
		}
	}
	if(net->bssht.bdHTCapLen  != 0)
	{
		sta->htinfo.bEnableHT = true;
		sta->htinfo.bCurRxReorderEnable = ieee->pHTInfo->bRegRxReorderEnable;
		if(net->mode == IEEE_A)
			sta->wireless_mode = IEEE_N_5G;
		else
			sta->wireless_mode = IEEE_N_24G;
	} else {
		printk("%s(): have no HTCap IE, mode is %d\n",__FUNCTION__,net->mode);
		sta->wireless_mode = net->mode;
		sta->htinfo.bEnableHT = false;
		return true;
	}

	if (!memcmp(net->bssht.bdHTCapBuf ,EWC11NHTCap, sizeof(EWC11NHTCap)))
		pHTCapIE = (PHT_CAPABILITY_ELE)(&(net->bssht.bdHTCapBuf[4]));
	else
		pHTCapIE = (PHT_CAPABILITY_ELE)(net->bssht.bdHTCapBuf);

	if (!memcmp(net->bssht.bdHTInfoBuf, EWC11NHTInfo, sizeof(EWC11NHTInfo)))
		pPeerHTInfo = (PHT_INFORMATION_ELE)(&net->bssht.bdHTInfoBuf[4]);
	else		
		pPeerHTInfo = (PHT_INFORMATION_ELE)(net->bssht.bdHTInfoBuf);
	
	ExtChlOffset=((ieee->pHTInfo->bRegBW40MHz == false)?HT_EXTCHNL_OFFSET_NO_EXT:
					(ieee->current_network.channel<=6)?
					HT_EXTCHNL_OFFSET_UPPER:HT_EXTCHNL_OFFSET_LOWER);
	printk("******** STA wireless mode %d\n", sta->wireless_mode);
		
	if (ieee->pHTInfo->bRegSuppCCK)
		sta->htinfo.bSupportCck = (pHTCapIE->DssCCk==1)?true:false;
	else {
		if(pHTCapIE->DssCCk==1)
			return false;
	}

	sta->htinfo.MimoPs= pHTCapIE->MimoPwrSave;

	printk("******** PEER MP MimoPs %d\n", sta->htinfo.MimoPs);
	if(ieee->pHTInfo->bRegBW40MHz)
		sta->htinfo.bBw40MHz= (pHTCapIE->ChlWidth==1)?true:false;
	else
		sta->htinfo.bBw40MHz = false;

	if((pPeerHTInfo->ExtChlOffset) != ExtChlOffset)
		sta->htinfo.bBw40MHz = false;
	
	ieee->Peer_bCurBW40M = sta->htinfo.bBw40MHz;
	printk("******** PEER MP bCurBW40M %d\n", sta->htinfo.bBw40MHz);
	if(ieee->pHTInfo->bRegBW40MHz == true)
		sta->htinfo.bCurTxBW40MHz = sta->htinfo.bBw40MHz;

	printk("******** PEER MP bCurTxBW40MHz %d\n", sta->htinfo.bCurTxBW40MHz);
	sta->htinfo.bCurShortGI20MHz= 
		((ieee->pHTInfo->bRegShortGI20MHz)?((pHTCapIE->ShortGI20Mhz==1)?true:false):false);
	sta->htinfo.bCurShortGI40MHz= 
		((ieee->pHTInfo->bRegShortGI40MHz)?((pHTCapIE->ShortGI40Mhz==1)?true:false):false);
	
	printk("******** PEER MP bCurShortGI20MHz %d, bCurShortGI40MHz %d\n",sta->htinfo.bCurShortGI20MHz,sta->htinfo.bCurShortGI40MHz);
	nMaxAMSDUSize = (pHTCapIE->MaxAMSDUSize==0)?3839:7935;
	if(ieee->pHTInfo->nAMSDU_MaxSize >= nMaxAMSDUSize)	
		sta->htinfo.AMSDU_MaxSize = nMaxAMSDUSize;
	else
		sta->htinfo.AMSDU_MaxSize = ieee->pHTInfo->nAMSDU_MaxSize;

	printk("****************AMSDU_MaxSize=%d\n",sta->htinfo.AMSDU_MaxSize);
		
	if(ieee->pHTInfo->AMPDU_Factor >= pHTCapIE->MaxRxAMPDUFactor)
		sta->htinfo.AMPDU_Factor = pHTCapIE->MaxRxAMPDUFactor;
	else
		sta->htinfo.AMPDU_Factor = ieee->pHTInfo->AMPDU_Factor;

	if(ieee->pHTInfo->MPDU_Density >= pHTCapIE->MPDUDensity)
		sta->htinfo.MPDU_Density = pHTCapIE->MPDUDensity;
	else
		sta->htinfo.MPDU_Density = ieee->pHTInfo->MPDU_Density;

	HTFilterMCSRate(ieee, pHTCapIE->MCS, sta->htinfo.McsRateSet);
	if(sta->htinfo.MimoPs == 0)  
		pMcsFilter = MCS_FILTER_1SS;
	else
		pMcsFilter = MCS_FILTER_ALL;

	sta->htinfo.HTHighestOperaRate = HTGetHighestMCSRate(ieee, sta->htinfo.McsRateSet, pMcsFilter);
	printk("******** PEER MP HTHighestOperaRate %x\n",sta->htinfo.HTHighestOperaRate);

	return true;
	
}

#if LINUX_VERSION_CODE >=KERNEL_VERSION(2,6,20)
void rtl8192se_check_tsf_wq(struct work_struct * work)
{
	struct delayed_work *dwork = container_of(work,struct delayed_work,work);
	struct ieee80211_device *ieee = container_of(dwork, struct ieee80211_device, check_tsf_wq);
	struct net_device *dev = ieee->dev;
#else
void rtl8192se_check_tsf_wq(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_device *ieee = priv->ieee80211;
#endif
	u32	CurrTsfHigh,CurrTsfLow;
	u32	TargetTsfHigh,TargetTsfLow;
					
	CurrTsfHigh = read_nic_dword(dev, TSFR+4);
	CurrTsfLow = (u32)(ieee->CurrTsf & 0xffff);
	TargetTsfHigh = (u32)(ieee->TargetTsf >> 32);
	TargetTsfLow = (u32)(ieee->TargetTsf & 0xffff);

	printk("Current TSF Low = %x, Hight = %x\n",CurrTsfLow,CurrTsfHigh);
	printk("Target TSF Low = %x, Hight = %x\n",TargetTsfLow,TargetTsfHigh);

	ieee->CurrTsf |= (u64)CurrTsfHigh << 32;

	if(ieee->CurrTsf < ieee->TargetTsf)
	{
		down(&ieee->wx_sem);

		ieee80211_stop_protocol(ieee,true);

		ieee->ssid_set = 1;

		ieee80211_start_protocol(ieee);

		up(&ieee->wx_sem);
	}
}

#if LINUX_VERSION_CODE >=KERNEL_VERSION(2,6,20)
void rtl8192se_update_peer_ratr_table_wq(struct work_struct * work)
{
	struct delayed_work *dwork = container_of(work,struct delayed_work,work);
	struct ieee80211_device *ieee = container_of(dwork, struct ieee80211_device, update_assoc_sta_info_wq);
        struct net_device *dev = ieee->dev;
        struct r8192_priv *priv = ieee80211_priv(dev);
#else
void rtl8192se_update_peer_ratr_table_wq(struct net_device *dev)
{
        struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_device *ieee = priv->ieee80211;
#endif
	int idx = 0;
	for(idx=0; idx<PEER_MAX_ASSOC; idx++)
	{	
		if(NULL != priv->ieee80211->peer_assoc_list[idx])
		{
			u8 * addr = priv->ieee80211->peer_assoc_list[idx]->macaddr;
			printk("%s: STA:%x:%x:%x:%x:%x:%x\n",__FUNCTION__,addr[0],addr[1],addr[2],addr[3],addr[4],addr[5]);
			rtl8192se_update_ratr_table(dev,priv->ieee80211->peer_assoc_list[idx]->htinfo.McsRateSet,priv->ieee80211->peer_assoc_list[idx]);
		}
	}
	UpdateHalRATRTableIndex(dev);

	if(ieee->Peer_bCurBW40M)
		HTSetConnectBwMode(ieee, HT_CHANNEL_WIDTH_20_40, (ieee->current_network.channel<=6)?HT_EXTCHNL_OFFSET_UPPER:HT_EXTCHNL_OFFSET_LOWER);  
	else
		HTSetConnectBwMode(ieee, HT_CHANNEL_WIDTH_20, (ieee->current_network.channel<=6)?HT_EXTCHNL_OFFSET_UPPER:HT_EXTCHNL_OFFSET_LOWER);  
}
#endif

u8 QueryIsShort(u8 TxHT, u8 TxRate, cb_desc *tcb_desc)
{
	u8   tmp_Short;

	tmp_Short = (TxHT==1)?((tcb_desc->bUseShortGI)?1:0):((tcb_desc->bUseShortPreamble)?1:0);
#ifdef RTL8192SE
	if(TxHT==1 && TxRate != DESC92S_RATEMCS15)
#elif defined RTL8192E || defined RTL8190P
	if(TxHT==1 && TxRate != DESC90_RATEMCS15)
#endif
		tmp_Short = 0;

	return tmp_Short;
}

#if (defined RTL8190P || defined RTL8192E) 
static void rtl8192_read_eeprom_info(struct net_device* dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);

	u8			tempval;
#ifdef RTL8192E
	u8			ICVer8192, ICVer8256;
#endif
	u16			i,usValue, IC_Version;
	u16			EEPROMId;
#ifdef RTL8190P
   	u8			offset;
    	u8      		EepromTxPower[100];
#endif
	u8 bMac_Tmp_Addr[6] = {0x00, 0xe0, 0x4c, 0x00, 0x00, 0x01};
	RT_TRACE(COMP_INIT, "====> rtl8192_read_eeprom_info\n");

	  
  
	EEPROMId = eprom_read(dev, 0);
	if( EEPROMId != RTL8190_EEPROM_ID )
	{
		RT_TRACE(COMP_ERR, "EEPROM ID is invalid:%x, %x\n", EEPROMId, RTL8190_EEPROM_ID); 
		priv->AutoloadFailFlag=true;
	}
	else
	{
		priv->AutoloadFailFlag=false;
	}
	
	if(!priv->AutoloadFailFlag)
	{
		priv->eeprom_vid = eprom_read(dev, (EEPROM_VID >> 1));
		priv->eeprom_did = eprom_read(dev, (EEPROM_DID >> 1));

		usValue = eprom_read(dev, (u16)(EEPROM_Customer_ID>>1)) >> 8 ;
		priv->eeprom_CustomerID = (u8)( usValue & 0xff);	
		usValue = eprom_read(dev, (EEPROM_ICVersion_ChannelPlan>>1));
		priv->eeprom_ChannelPlan = usValue&0xff;
		IC_Version = ((usValue&0xff00)>>8);

#ifdef RTL8190P
		priv->card_8192_version = (VERSION_8190)(IC_Version);
#elif defined  RTL8192E
		ICVer8192 = (IC_Version&0xf);		
		ICVer8256 = ((IC_Version&0xf0)>>4);
		RT_TRACE(COMP_INIT, "\nICVer8192 = 0x%x\n", ICVer8192);
		RT_TRACE(COMP_INIT, "\nICVer8256 = 0x%x\n", ICVer8256);
		if(ICVer8192 == 0x2)	
		{
			if(ICVer8256 == 0x5) 
				priv->card_8192_version= VERSION_8190_BE;
		}
#endif
		switch(priv->card_8192_version)
		{
			case VERSION_8190_BD:
			case VERSION_8190_BE:
				break;
			default:
				priv->card_8192_version = VERSION_8190_BD;
				break;
		}
		RT_TRACE(COMP_INIT, "\nIC Version = 0x%x\n", priv->card_8192_version);
	}
	else
	{
		priv->card_8192_version = VERSION_8190_BD;
		priv->eeprom_vid = 0;
		priv->eeprom_did = 0;
		priv->eeprom_CustomerID = 0;
		priv->eeprom_ChannelPlan = 0;
		RT_TRACE(COMP_INIT, "\nIC Version = 0x%x\n", 0xff);
	}
	
	RT_TRACE(COMP_INIT, "EEPROM VID = 0x%4x\n", priv->eeprom_vid);
	RT_TRACE(COMP_INIT, "EEPROM DID = 0x%4x\n", priv->eeprom_did);
	RT_TRACE(COMP_INIT,"EEPROM Customer ID: 0x%2x\n", priv->eeprom_CustomerID);
	
	if(!priv->AutoloadFailFlag)
	{
		for(i = 0; i < 6; i += 2)
		{
			usValue = eprom_read(dev, (u16) ((EEPROM_NODE_ADDRESS_BYTE_0+i)>>1));
			*(u16*)(&dev->dev_addr[i]) = usValue;
		}
	} else {
		memcpy(dev->dev_addr, bMac_Tmp_Addr, 6);		
		#if 0
		for(i = 0; i < 6; i++)
		{
			dev->PermanentAddress[i] = sMacAddr[i];
			write_nic_byte(dev, IDR0+i, sMacAddr[i]);
		}
		#endif
	}

	RT_TRACE(COMP_INIT, "Permanent Address = %02x-%02x-%02x-%02x-%02x-%02x\n", 
			dev->dev_addr[0], dev->dev_addr[1], 
			dev->dev_addr[2], dev->dev_addr[3], 
			dev->dev_addr[4], dev->dev_addr[5]);  
	
	if(priv->card_8192_version > VERSION_8190_BD) {
		priv->bTXPowerDataReadFromEEPORM = true;
	} else {
		priv->bTXPowerDataReadFromEEPORM = false;
	}

	priv->rf_type = RTL819X_DEFAULT_RF_TYPE;

	if(priv->card_8192_version > VERSION_8190_BD)
	{
		if(!priv->AutoloadFailFlag)
		{
			tempval = (eprom_read(dev, (EEPROM_RFInd_PowerDiff>>1))) & 0xff;
			priv->EEPROMLegacyHTTxPowerDiff = tempval & 0xf;	

			if (tempval&0x80)	
				priv->rf_type = RF_1T2R;
			else
				priv->rf_type = RF_2T4R;
		}
		else
		{
			priv->EEPROMLegacyHTTxPowerDiff = 0x04;
		}
		RT_TRACE(COMP_INIT, "EEPROMLegacyHTTxPowerDiff = %d\n", 
			priv->EEPROMLegacyHTTxPowerDiff);
		
		if(!priv->AutoloadFailFlag)
		{
			priv->EEPROMThermalMeter = (u8)(((eprom_read(dev, (EEPROM_ThermalMeter>>1))) & 0xff00)>>8);
		}
		else
		{
			priv->EEPROMThermalMeter = EEPROM_Default_ThermalMeter;
		}
		RT_TRACE(COMP_INIT, "ThermalMeter = %d\n", priv->EEPROMThermalMeter);
		priv->TSSI_13dBm = priv->EEPROMThermalMeter *100;
		
		if(priv->epromtype == EEPROM_93C46)
		{
		if(!priv->AutoloadFailFlag)
		{
				usValue = eprom_read(dev, (EEPROM_TxPwDiff_CrystalCap>>1));
				priv->EEPROMAntPwDiff = (usValue&0x0fff);
				priv->EEPROMCrystalCap = (u8)((usValue&0xf000)>>12);
		}
		else
		{
				priv->EEPROMAntPwDiff = EEPROM_Default_AntTxPowerDiff;
				priv->EEPROMCrystalCap = EEPROM_Default_TxPwDiff_CrystalCap;
		}
			RT_TRACE(COMP_INIT, "EEPROMAntPwDiff = %d\n", priv->EEPROMAntPwDiff);
			RT_TRACE(COMP_INIT, "EEPROMCrystalCap = %d\n", priv->EEPROMCrystalCap);
		
		for(i=0; i<14; i+=2)
		{
			if(!priv->AutoloadFailFlag)
			{
				usValue = eprom_read(dev, (u16) ((EEPROM_TxPwIndex_CCK+i)>>1) );
			}
			else
			{
				usValue = EEPROM_Default_TxPower;
			}
			*((u16*)(&priv->EEPROMTxPowerLevelCCK[i])) = usValue;
			RT_TRACE(COMP_INIT,"CCK Tx Power Level, Index %d = 0x%02x\n", i, priv->EEPROMTxPowerLevelCCK[i]);
			RT_TRACE(COMP_INIT, "CCK Tx Power Level, Index %d = 0x%02x\n", i+1, priv->EEPROMTxPowerLevelCCK[i+1]);
		}
		for(i=0; i<14; i+=2)
		{
			if(!priv->AutoloadFailFlag)
			{
				usValue = eprom_read(dev, (u16) ((EEPROM_TxPwIndex_OFDM_24G+i)>>1) );
			}
			else
			{
				usValue = EEPROM_Default_TxPower;
			}
			*((u16*)(&priv->EEPROMTxPowerLevelOFDM24G[i])) = usValue;
			RT_TRACE(COMP_INIT, "OFDM 2.4G Tx Power Level, Index %d = 0x%02x\n", i, priv->EEPROMTxPowerLevelOFDM24G[i]);
			RT_TRACE(COMP_INIT, "OFDM 2.4G Tx Power Level, Index %d = 0x%02x\n", i+1, priv->EEPROMTxPowerLevelOFDM24G[i+1]);
		}
		}
		else if(priv->epromtype== EEPROM_93C56)
		{
#ifdef RTL8190P
			if(!priv->AutoloadFailFlag)
			{
				priv->EEPROMAntPwDiff = EEPROM_Default_AntTxPowerDiff;
				priv->EEPROMCrystalCap = (u8)(((eprom_read(dev, (EEPROM_C56_CrystalCap>>1))) & 0xf000)>>12);
			}
			else
			{
				priv->EEPROMAntPwDiff = EEPROM_Default_AntTxPowerDiff;
				priv->EEPROMCrystalCap = EEPROM_Default_TxPwDiff_CrystalCap;
			}
			RT_TRACE(COMP_INIT,"EEPROMAntPwDiff = %d\n", priv->EEPROMAntPwDiff);
			RT_TRACE(COMP_INIT, "EEPROMCrystalCap = %d\n", priv->EEPROMCrystalCap);

			if(!priv->AutoloadFailFlag)
			{
				for(i = 0; i < 12; i+=2)
				{
					if (i <6)
						offset = EEPROM_C56_RfA_CCK_Chnl1_TxPwIndex + i;
					else
						offset = EEPROM_C56_RfC_CCK_Chnl1_TxPwIndex + i - 6;
					usValue = eprom_read(dev, (offset>>1));
					*((u16*)(&EepromTxPower[i])) = usValue;
				}

				for(i = 0; i < 12; i++)
				{
					if (i <= 2)
						priv->EEPROMRfACCKChnl1TxPwLevel[i] = EepromTxPower[i];
					else if ((i >=3 )&&(i <= 5))
						priv->EEPROMRfAOfdmChnlTxPwLevel[i-3] = EepromTxPower[i];
					else if ((i >=6 )&&(i <= 8))
						priv->EEPROMRfCCCKChnl1TxPwLevel[i-6] = EepromTxPower[i];
					else
						priv->EEPROMRfCOfdmChnlTxPwLevel[i-9] = EepromTxPower[i];						
				}
			}
			else
			{
				priv->EEPROMRfACCKChnl1TxPwLevel[0] = EEPROM_Default_TxPowerLevel;
				priv->EEPROMRfACCKChnl1TxPwLevel[1] = EEPROM_Default_TxPowerLevel;
				priv->EEPROMRfACCKChnl1TxPwLevel[2] = EEPROM_Default_TxPowerLevel;

				priv->EEPROMRfAOfdmChnlTxPwLevel[0] = EEPROM_Default_TxPowerLevel;
				priv->EEPROMRfAOfdmChnlTxPwLevel[1] = EEPROM_Default_TxPowerLevel;
				priv->EEPROMRfAOfdmChnlTxPwLevel[2] = EEPROM_Default_TxPowerLevel;

				priv->EEPROMRfCCCKChnl1TxPwLevel[0] = EEPROM_Default_TxPowerLevel;
				priv->EEPROMRfCCCKChnl1TxPwLevel[1] = EEPROM_Default_TxPowerLevel;
				priv->EEPROMRfCCCKChnl1TxPwLevel[2] = EEPROM_Default_TxPowerLevel;

				priv->EEPROMRfCOfdmChnlTxPwLevel[0] = EEPROM_Default_TxPowerLevel;
				priv->EEPROMRfCOfdmChnlTxPwLevel[1] = EEPROM_Default_TxPowerLevel;
				priv->EEPROMRfCOfdmChnlTxPwLevel[2] = EEPROM_Default_TxPowerLevel;
			}
			RT_TRACE(COMP_INIT, "priv->EEPROMRfACCKChnl1TxPwLevel[0] = 0x%x\n", priv->EEPROMRfACCKChnl1TxPwLevel[0]);
			RT_TRACE(COMP_INIT, "priv->EEPROMRfACCKChnl1TxPwLevel[1] = 0x%x\n", priv->EEPROMRfACCKChnl1TxPwLevel[1]);
			RT_TRACE(COMP_INIT, "priv->EEPROMRfACCKChnl1TxPwLevel[2] = 0x%x\n", priv->EEPROMRfACCKChnl1TxPwLevel[2]);
			RT_TRACE(COMP_INIT, "priv->EEPROMRfAOfdmChnlTxPwLevel[0] = 0x%x\n", priv->EEPROMRfAOfdmChnlTxPwLevel[0]);
			RT_TRACE(COMP_INIT, "priv->EEPROMRfAOfdmChnlTxPwLevel[1] = 0x%x\n", priv->EEPROMRfAOfdmChnlTxPwLevel[1]);
			RT_TRACE(COMP_INIT, "priv->EEPROMRfAOfdmChnlTxPwLevel[2] = 0x%x\n", priv->EEPROMRfAOfdmChnlTxPwLevel[2]);
			RT_TRACE(COMP_INIT, "priv->EEPROMRfCCCKChnl1TxPwLevel[0] = 0x%x\n", priv->EEPROMRfCCCKChnl1TxPwLevel[0]);
			RT_TRACE(COMP_INIT, "priv->EEPROMRfCCCKChnl1TxPwLevel[1] = 0x%x\n", priv->EEPROMRfCCCKChnl1TxPwLevel[1]);
			RT_TRACE(COMP_INIT, "priv->EEPROMRfCCCKChnl1TxPwLevel[2] = 0x%x\n", priv->EEPROMRfCCCKChnl1TxPwLevel[2]);
			RT_TRACE(COMP_INIT, "priv->EEPROMRfCOfdmChnlTxPwLevel[0] = 0x%x\n", priv->EEPROMRfCOfdmChnlTxPwLevel[0]);			
			RT_TRACE(COMP_INIT, "priv->EEPROMRfCOfdmChnlTxPwLevel[1] = 0x%x\n", priv->EEPROMRfCOfdmChnlTxPwLevel[1]);
			RT_TRACE(COMP_INIT, "priv->EEPROMRfCOfdmChnlTxPwLevel[2] = 0x%x\n", priv->EEPROMRfCOfdmChnlTxPwLevel[2]);
#endif

		}
		if(priv->epromtype == EEPROM_93C46)
		{
			for(i=0; i<14; i++)
			{
				priv->TxPowerLevelCCK[i] = priv->EEPROMTxPowerLevelCCK[i];
				priv->TxPowerLevelOFDM24G[i] = priv->EEPROMTxPowerLevelOFDM24G[i];
			}
			priv->LegacyHTTxPowerDiff = priv->EEPROMLegacyHTTxPowerDiff;
			priv->AntennaTxPwDiff[0] = (priv->EEPROMAntPwDiff & 0xf);
			priv->AntennaTxPwDiff[1] = ((priv->EEPROMAntPwDiff & 0xf0)>>4);
			priv->AntennaTxPwDiff[2] = ((priv->EEPROMAntPwDiff & 0xf00)>>8);
			priv->CrystalCap = priv->EEPROMCrystalCap;
			priv->ThermalMeter[0] = (priv->EEPROMThermalMeter & 0xf);
			priv->ThermalMeter[1] = ((priv->EEPROMThermalMeter & 0xf0)>>4);
		}
		else if(priv->epromtype == EEPROM_93C56)
		{

			for(i=0; i<3; i++)	
			{
				priv->TxPowerLevelCCK_A[i]  = priv->EEPROMRfACCKChnl1TxPwLevel[0];
				priv->TxPowerLevelOFDM24G_A[i] = priv->EEPROMRfAOfdmChnlTxPwLevel[0];
				priv->TxPowerLevelCCK_C[i] =  priv->EEPROMRfCCCKChnl1TxPwLevel[0];
				priv->TxPowerLevelOFDM24G_C[i] = priv->EEPROMRfCOfdmChnlTxPwLevel[0];
			}
			for(i=3; i<9; i++)	
			{
				priv->TxPowerLevelCCK_A[i]  = priv->EEPROMRfACCKChnl1TxPwLevel[1];
				priv->TxPowerLevelOFDM24G_A[i] = priv->EEPROMRfAOfdmChnlTxPwLevel[1];
				priv->TxPowerLevelCCK_C[i] =  priv->EEPROMRfCCCKChnl1TxPwLevel[1];
				priv->TxPowerLevelOFDM24G_C[i] = priv->EEPROMRfCOfdmChnlTxPwLevel[1];
			}
			for(i=9; i<14; i++)	
			{
				priv->TxPowerLevelCCK_A[i]  = priv->EEPROMRfACCKChnl1TxPwLevel[2];
				priv->TxPowerLevelOFDM24G_A[i] = priv->EEPROMRfAOfdmChnlTxPwLevel[2];
				priv->TxPowerLevelCCK_C[i] =  priv->EEPROMRfCCCKChnl1TxPwLevel[2];
				priv->TxPowerLevelOFDM24G_C[i] = priv->EEPROMRfCOfdmChnlTxPwLevel[2];
			}
			for(i=0; i<14; i++)
				RT_TRACE(COMP_INIT, "priv->TxPowerLevelCCK_A[%d] = 0x%x\n", i, priv->TxPowerLevelCCK_A[i]);
			for(i=0; i<14; i++)
				RT_TRACE(COMP_INIT,"priv->TxPowerLevelOFDM24G_A[%d] = 0x%x\n", i, priv->TxPowerLevelOFDM24G_A[i]);
			for(i=0; i<14; i++)
				RT_TRACE(COMP_INIT, "priv->TxPowerLevelCCK_C[%d] = 0x%x\n", i, priv->TxPowerLevelCCK_C[i]);
			for(i=0; i<14; i++)
				RT_TRACE(COMP_INIT, "priv->TxPowerLevelOFDM24G_C[%d] = 0x%x\n", i, priv->TxPowerLevelOFDM24G_C[i]);
			priv->LegacyHTTxPowerDiff = priv->EEPROMLegacyHTTxPowerDiff;
			priv->AntennaTxPwDiff[0] = 0;
			priv->AntennaTxPwDiff[1] = 0;
			priv->AntennaTxPwDiff[2] = 0;
			priv->CrystalCap = priv->EEPROMCrystalCap;
			priv->ThermalMeter[0] = (priv->EEPROMThermalMeter & 0xf);
			priv->ThermalMeter[1] = ((priv->EEPROMThermalMeter & 0xf0)>>4);
		}
	}

	if(priv->rf_type == RF_1T2R)
	{		
		RT_TRACE(COMP_INIT, "\n1T2R config\n");
	}
	else if (priv->rf_type == RF_2T4R)
	{
		RT_TRACE(COMP_INIT, "\n2T4R config\n");
	}

	init_rate_adaptive(dev);
	
	
	priv->rf_chip= RF_8256;

	if(priv->RegChannelPlan == 0xf)
	{
		priv->ChannelPlan = priv->eeprom_ChannelPlan;
	}
	else
	{
		priv->ChannelPlan = priv->RegChannelPlan;
	}

	if( priv->eeprom_vid == 0x1186 &&  priv->eeprom_did == 0x3304 )
	{
		priv->CustomerID =  RT_CID_DLINK;
	}
	
	switch(priv->eeprom_CustomerID)
	{
		case EEPROM_CID_DEFAULT:
			priv->CustomerID = RT_CID_DEFAULT;
			break;
		case EEPROM_CID_CAMEO:
			priv->CustomerID = RT_CID_819x_CAMEO;
			break;
		case  EEPROM_CID_RUNTOP:
			priv->CustomerID = RT_CID_819x_RUNTOP;
			break;
		case EEPROM_CID_NetCore:
			priv->CustomerID = RT_CID_819x_Netcore;
			break;	
		case EEPROM_CID_TOSHIBA:        
			priv->CustomerID = RT_CID_TOSHIBA;
			if(priv->eeprom_ChannelPlan&0x80)
				priv->ChannelPlan = priv->eeprom_ChannelPlan&0x7f;
			else
				priv->ChannelPlan = 0x0;
			RT_TRACE(COMP_INIT, "Toshiba ChannelPlan = 0x%x\n", 
				priv->ChannelPlan);
			break;
		case EEPROM_CID_Nettronix:
			priv->ScanDelay = 100;	
			priv->CustomerID = RT_CID_Nettronix;
			break;			
		case EEPROM_CID_Pronet:
			priv->CustomerID = RT_CID_PRONET;
			break;
		case EEPROM_CID_DLINK:
			priv->CustomerID = RT_CID_DLINK;
			break;

		case EEPROM_CID_WHQL:


			
			break;
		default:
			break;
	}

	if(priv->ChannelPlan > CHANNEL_PLAN_LEN - 1)
		priv->ChannelPlan = 0; 
#ifdef ENABLE_DOT11D
	priv->ChannelPlan = COUNTRY_CODE_WORLD_WIDE_13;
#endif

#ifdef TO_DO_LIST
	switch(priv->CustomerID)
	{
		case RT_CID_DEFAULT:
#ifdef RTL8190P
			priv->LedStrategy = HW_LED;
#elif defined RTL8192E
			priv->LedStrategy = SW_LED_MODE1;
#endif
			break;

		case RT_CID_819x_CAMEO:
			priv->LedStrategy = SW_LED_MODE2;
			break;

		case RT_CID_819x_RUNTOP:
			priv->LedStrategy = SW_LED_MODE3;
			break;

		case RT_CID_819x_Netcore:
			priv->LedStrategy = SW_LED_MODE4;
			break;

		case RT_CID_Nettronix:
			priv->LedStrategy = SW_LED_MODE5;
			break;

		case RT_CID_PRONET:
			priv->LedStrategy = SW_LED_MODE6;
			break;

		case RT_CID_TOSHIBA:   

		default:
#ifdef RTL8190P
			priv->LedStrategy = HW_LED;
#elif defined RTL8192E
			priv->LedStrategy = SW_LED_MODE1;
#endif
			break;
	}
	RT_TRACE(COMP_INIT, "LedStrategy = %d \n", priv->LedStrategy);
#endif
	RT_TRACE(COMP_INIT, "RegChannelPlan(%d)\n", priv->RegChannelPlan);
	RT_TRACE(COMP_INIT, "ChannelPlan = %d \n", priv->ChannelPlan);
	RT_TRACE(COMP_TRACE, "<==== ReadAdapterInfo\n");
		
	return ;
}

void rtl8192_get_eeprom_size(struct net_device* dev)
{
	u16 curCR = 0;
	struct r8192_priv *priv = ieee80211_priv(dev);
	RT_TRACE(COMP_INIT, "===========>%s()\n", __FUNCTION__);	
	curCR = read_nic_dword(dev, EPROM_CMD);
	RT_TRACE(COMP_INIT, "read from Reg Cmd9346CR(%x):%x\n", EPROM_CMD, curCR);
	priv->epromtype = (curCR & EPROM_CMD_9356SEL) ? EEPROM_93C56 : EEPROM_93C46;
	RT_TRACE(COMP_INIT, "<===========%s(), epromtype:%d\n", __FUNCTION__, priv->epromtype);
	rtl8192_read_eeprom_info(dev);
}

void rtl8192_hwconfig(struct net_device* dev)
{
	u32 regRATR = 0, regRRSR = 0;
	u8 regBwOpMode = 0, regTmp = 0;
	struct r8192_priv *priv = ieee80211_priv(dev);

	switch(priv->ieee80211->mode)
	{
	case WIRELESS_MODE_B:
		regBwOpMode = BW_OPMODE_20MHZ;
		regRATR = RATE_ALL_CCK;
		regRRSR = RATE_ALL_CCK;
		break;
	case WIRELESS_MODE_A:
		regBwOpMode = BW_OPMODE_5G |BW_OPMODE_20MHZ;
		regRATR = RATE_ALL_OFDM_AG;
		regRRSR = RATE_ALL_OFDM_AG;
		break;
	case WIRELESS_MODE_G:
		regBwOpMode = BW_OPMODE_20MHZ;
		regRATR = RATE_ALL_CCK | RATE_ALL_OFDM_AG;
		regRRSR = RATE_ALL_CCK | RATE_ALL_OFDM_AG;
		break;
	case WIRELESS_MODE_AUTO:
	case WIRELESS_MODE_N_24G:
		regBwOpMode = BW_OPMODE_20MHZ;
			regRATR = RATE_ALL_CCK | RATE_ALL_OFDM_AG | RATE_ALL_OFDM_1SS | RATE_ALL_OFDM_2SS;
			regRRSR = RATE_ALL_CCK | RATE_ALL_OFDM_AG;
		break;
	case WIRELESS_MODE_N_5G:
		regBwOpMode = BW_OPMODE_5G;
		regRATR = RATE_ALL_OFDM_AG | RATE_ALL_OFDM_1SS | RATE_ALL_OFDM_2SS;
		regRRSR = RATE_ALL_OFDM_AG;
		break;
	default:
		regBwOpMode = BW_OPMODE_20MHZ;
		regRATR = RATE_ALL_CCK | RATE_ALL_OFDM_AG;
		regRRSR = RATE_ALL_CCK | RATE_ALL_OFDM_AG;
		break;
	}

	write_nic_byte(dev, BW_OPMODE, regBwOpMode);
	{
		u32 ratr_value = 0;
		ratr_value = regRATR;
		if (priv->rf_type == RF_1T2R)
		{
			ratr_value &= ~(RATE_ALL_OFDM_2SS);
		}
		write_nic_dword(dev, RATR0, ratr_value);
		write_nic_byte(dev, UFWP, 1);
	}	
	regTmp = read_nic_byte(dev, 0x313);
	regRRSR = ((regTmp) << 24) | (regRRSR & 0x00ffffff);
	write_nic_dword(dev, RRSR, regRRSR);

	write_nic_word(dev, RETRY_LIMIT, 
			priv->ShortRetryLimit << RETRY_LIMIT_SHORT_SHIFT | \
			priv->LongRetryLimit << RETRY_LIMIT_LONG_SHIFT);


		
}

bool rtl8192_adapter_start(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	u32 ulRegRead;
	bool rtStatus = true;
	u8 tmpvalue;
#ifdef RTL8192E
	u8 ICVersion,SwitchingRegulatorOutput;
#endif
	bool bfirmwareok = true;
#ifdef RTL8190P
	u8 ucRegRead;
#endif
	u32 tmpRegA, tmpRegC, TempCCk;
	int i = 0;
	u32 retry_times = 0;
	
	RT_TRACE(COMP_INIT, "====>%s()\n", __FUNCTION__);
	priv->being_init_adapter = true;	
start:	
        rtl8192_pci_resetdescring(dev);
	priv->Rf_Mode = RF_OP_By_SW_3wire;
#ifdef RTL8192E
        if(priv->ResetProgress == RESET_TYPE_NORESET)
        {
            write_nic_byte(dev, ANAPAR, 0x37);
            mdelay(500);
        }
#endif
	priv->pFirmware->firmware_status = FW_STATUS_0_INIT;

	if(priv->RegRfOff == true)
		priv->ieee80211->eRFPowerState = eRfOff;

	ulRegRead = read_nic_dword(dev, CPU_GEN);	
	if(priv->pFirmware->firmware_status == FW_STATUS_0_INIT)
	{	
		ulRegRead |= CPU_GEN_SYSTEM_RESET;
	}else if(priv->pFirmware->firmware_status == FW_STATUS_5_READY)
		ulRegRead |= CPU_GEN_FIRMWARE_RESET;	
	else
		RT_TRACE(COMP_ERR, "ERROR in %s(): undefined firmware state(%d)\n", __FUNCTION__,   priv->pFirmware->firmware_status);

#ifdef RTL8190P
	ulRegRead &= (~(CPU_GEN_GPIO_UART));	
#endif
	
	write_nic_dword(dev, CPU_GEN, ulRegRead);

#ifdef RTL8192E

	ICVersion = read_nic_byte(dev, IC_VERRSION);
	if(ICVersion >= 0x4) 
	{
		SwitchingRegulatorOutput = read_nic_byte(dev, SWREGULATOR);
		if(SwitchingRegulatorOutput  != 0xb8)
		{
			write_nic_byte(dev, SWREGULATOR, 0xa8);
			mdelay(1);
			write_nic_byte(dev, SWREGULATOR, 0xb8);
		}
	}
#endif
	RT_TRACE(COMP_INIT, "BB Config Start!\n");
	rtStatus = rtl8192_BBConfig(dev);
	if(rtStatus != true)
	{
		RT_TRACE(COMP_ERR, "BB Config failed\n");
		return rtStatus;
	}
	RT_TRACE(COMP_INIT,"BB Config Finished!\n");

	priv->LoopbackMode = RTL819X_NO_LOOPBACK;
	if(priv->ResetProgress == RESET_TYPE_NORESET)
	{
	ulRegRead = read_nic_dword(dev, CPU_GEN);	
	if(priv->LoopbackMode == RTL819X_NO_LOOPBACK)
	{
		ulRegRead = ((ulRegRead & CPU_GEN_NO_LOOPBACK_MSK) | CPU_GEN_NO_LOOPBACK_SET);
	}
	else if (priv->LoopbackMode == RTL819X_MAC_LOOPBACK )
	{
		ulRegRead |= CPU_CCK_LOOPBACK;
	}
	else
	{
		RT_TRACE(COMP_ERR,"Serious error: wrong loopback mode setting\n");	
	}

	write_nic_dword(dev, CPU_GEN, ulRegRead);
		
	udelay(500);
	}
	rtl8192_hwconfig(dev);
	write_nic_byte(dev, CMDR, CR_RE|CR_TE);

#ifdef RTL8190P
	write_nic_byte(dev, PCIF, ((MXDMA2_NoLimit<<MXDMA2_RX_SHIFT) | \
				(MXDMA2_NoLimit<<MXDMA2_TX_SHIFT) | \
				(1<<MULRW_SHIFT)));
#elif defined RTL8192E
	write_nic_byte(dev, PCIF, ((MXDMA2_NoLimit<<MXDMA2_RX_SHIFT) |\
				(MXDMA2_NoLimit<<MXDMA2_TX_SHIFT) ));
#endif
	write_nic_dword(dev, MAC0, ((u32*)dev->dev_addr)[0]);
	write_nic_word(dev, MAC4, ((u16*)(dev->dev_addr + 4))[0]);
	write_nic_dword(dev, RCR, priv->ReceiveConfig);

#ifdef TO_DO_LIST 
	if(priv->bInHctTest)
	{
		write_nic_dword(dev, RQPN1,  NUM_OF_PAGE_IN_FW_QUEUE_BK_DTM << RSVD_FW_QUEUE_PAGE_BK_SHIFT |\
				NUM_OF_PAGE_IN_FW_QUEUE_BE_DTM << RSVD_FW_QUEUE_PAGE_BE_SHIFT | \
				NUM_OF_PAGE_IN_FW_QUEUE_VI_DTM << RSVD_FW_QUEUE_PAGE_VI_SHIFT | \
				NUM_OF_PAGE_IN_FW_QUEUE_VO_DTM <<RSVD_FW_QUEUE_PAGE_VO_SHIFT);												
		write_nic_dword(dev, RQPN2, NUM_OF_PAGE_IN_FW_QUEUE_MGNT << RSVD_FW_QUEUE_PAGE_MGNT_SHIFT);
		write_nic_dword(dev, RQPN3, APPLIED_RESERVED_QUEUE_IN_FW| \
				NUM_OF_PAGE_IN_FW_QUEUE_BCN<<RSVD_FW_QUEUE_PAGE_BCN_SHIFT|\
				NUM_OF_PAGE_IN_FW_QUEUE_PUB_DTM<<RSVD_FW_QUEUE_PAGE_PUB_SHIFT);
	}
	else
#endif
	{
		write_nic_dword(dev, RQPN1,  NUM_OF_PAGE_IN_FW_QUEUE_BK << RSVD_FW_QUEUE_PAGE_BK_SHIFT |\
					NUM_OF_PAGE_IN_FW_QUEUE_BE << RSVD_FW_QUEUE_PAGE_BE_SHIFT | \
					NUM_OF_PAGE_IN_FW_QUEUE_VI << RSVD_FW_QUEUE_PAGE_VI_SHIFT | \
					NUM_OF_PAGE_IN_FW_QUEUE_VO <<RSVD_FW_QUEUE_PAGE_VO_SHIFT);												
		write_nic_dword(dev, RQPN2, NUM_OF_PAGE_IN_FW_QUEUE_MGNT << RSVD_FW_QUEUE_PAGE_MGNT_SHIFT);
		write_nic_dword(dev, RQPN3, APPLIED_RESERVED_QUEUE_IN_FW| \
					NUM_OF_PAGE_IN_FW_QUEUE_BCN<<RSVD_FW_QUEUE_PAGE_BCN_SHIFT|\
					NUM_OF_PAGE_IN_FW_QUEUE_PUB<<RSVD_FW_QUEUE_PAGE_PUB_SHIFT);
	}

	rtl8192_tx_enable(dev);
	rtl8192_rx_enable(dev);
	ulRegRead = (0xFFF00000 & read_nic_dword(dev, RRSR))  | RATE_ALL_OFDM_AG | RATE_ALL_CCK;
	write_nic_dword(dev, RRSR, ulRegRead);
	write_nic_dword(dev, RATR0+4*7, (RATE_ALL_OFDM_AG | RATE_ALL_CCK));
#ifdef _RTL8192_EXT_PATCH_
	write_nic_dword(dev, RATR0, 0xff7);
	write_nic_dword(dev, RATR0+4*1, 0x8f0f0000);
	write_nic_dword(dev, RATR0+4*2, 0x0f0f0000);
	write_nic_dword(dev, RATR0+4*3, 0x8d0ff000);
	write_nic_dword(dev, RATR0+4*4, 0x0d0ff000);
	write_nic_dword(dev, RATR0+4*5, 0x8f0ff007);
	write_nic_dword(dev, RATR0+4*6, 0x0f0ff007);
	write_nic_byte(dev, UFWP, 1);
#endif

	write_nic_byte(dev, ACK_TIMEOUT, 0x30);

	if(priv->ResetProgress == RESET_TYPE_NORESET)
	rtl8192_SetWirelessMode(dev, priv->ieee80211->mode);
	CamResetAllEntry(dev);
	{
		u8 SECR_value = 0x0;
		SECR_value |= SCR_TxEncEnable;
		SECR_value |= SCR_RxDecEnable;
		SECR_value |= SCR_NoSKMC;
		write_nic_byte(dev, SECR, SECR_value);
	}
	write_nic_word(dev, ATIMWND, 2);
	write_nic_word(dev, BCN_INTERVAL, 100);
	{	
		int i;
		for (i=0; i<QOS_QUEUE_NUM; i++)
		write_nic_dword(dev, WDCAPARA_ADD[i], 0x005e4332);
	}
	write_nic_byte(dev, 0xbe, 0xc0);

	rtl8192_phy_configmac(dev);

	if (priv->card_8192_version > (u8) VERSION_8190_BD) {
		rtl8192_phy_getTxPower(dev);
		rtl8192_phy_setTxPower(dev, priv->chan);
	}
	
	tmpvalue = read_nic_byte(dev, IC_VERRSION);
	priv->IC_Cut= tmpvalue;
	RT_TRACE(COMP_INIT, "priv->IC_Cut= 0x%x\n", priv->IC_Cut);
	if(priv->IC_Cut>= IC_VersionCut_D)
	{
		if (priv->IC_Cut== IC_VersionCut_D) {
			RT_TRACE(COMP_INIT, "D-cut\n");
		} else if (priv->IC_Cut== IC_VersionCut_E) {
			RT_TRACE(COMP_INIT, "E-cut\n");
		}
	} else {
		RT_TRACE(COMP_INIT, "Before C-cut\n");
	}
		
	RT_TRACE(COMP_INIT, "Load Firmware!\n");
	bfirmwareok = init_firmware(dev);
	if (!bfirmwareok) {
		if (retry_times < 10) {
			retry_times++;
			goto start;
		} else {
			rtStatus = false;
			goto end;
		}
	}
	RT_TRACE(COMP_INIT, "Load Firmware finished!\n");
	if (priv->ResetProgress == RESET_TYPE_NORESET) {
		RT_TRACE(COMP_INIT, "RF Config Started!\n");
		rtStatus = rtl8192_phy_RFConfig(dev);
		if (rtStatus != true) {
			RT_TRACE(COMP_ERR, "RF Config failed\n");
			return rtStatus;
		}	
		RT_TRACE(COMP_INIT, "RF Config Finished!\n");
	}
	rtl8192_phy_updateInitGain(dev);

	rtl8192_setBBreg(dev, rFPGA0_RFMOD, bCCKEn, 0x1);
	rtl8192_setBBreg(dev, rFPGA0_RFMOD, bOFDMEn, 0x1);

#ifdef RTL8192E
	write_nic_byte(dev, 0x87, 0x0);
#endif
#ifdef RTL8190P
	ucRegRead = read_nic_byte(dev, GPE);
	ucRegRead |= BIT0;
	write_nic_byte(dev, GPE, ucRegRead);

	ucRegRead = read_nic_byte(dev, GPO);
	ucRegRead &= ~BIT0;
	write_nic_byte(dev, GPO, ucRegRead);
#endif

#ifdef ENABLE_IPS
	if(priv->RegRfOff == true)
	{ 
		RT_TRACE((COMP_INIT|COMP_RF|COMP_POWER), "%s(): Turn off RF for RegRfOff ----------\n",__FUNCTION__);
		MgntActSet_RF_State(dev, eRfOff, RF_CHANGE_BY_SW);
#if 0
	for(eRFPath = 0; eRFPath <pHalData->NumTotalRFPath; eRFPath++)
		PHY_SetRFReg(dev, (RF90_RADIO_PATH_E)eRFPath, 0x4, 0xC00, 0x0);
#endif
	}
	else if(priv->ieee80211->RfOffReason > RF_CHANGE_BY_PS)
	{ 
		RT_TRACE((COMP_INIT|COMP_RF|COMP_POWER), "%s(): Turn off RF for RfOffReason(%d) ----------\n", __FUNCTION__,priv->ieee80211->RfOffReason);
		MgntActSet_RF_State(dev, eRfOff, priv->ieee80211->RfOffReason);
	}
	else if(priv->ieee80211->RfOffReason >= RF_CHANGE_BY_IPS)
	{ 
		RT_TRACE((COMP_INIT|COMP_RF|COMP_POWER), "%s(): Turn off RF for RfOffReason(%d) ----------\n", __FUNCTION__,priv->ieee80211->RfOffReason);
		MgntActSet_RF_State(dev, eRfOff, priv->ieee80211->RfOffReason);
	}
	else
	{
		RT_TRACE((COMP_INIT|COMP_RF|COMP_POWER), "%s(): RF-ON \n",__FUNCTION__);
		priv->ieee80211->eRFPowerState = eRfOn;
		priv->ieee80211->RfOffReason = 0; 


	}
#endif

#ifdef RTL8192E
	if(priv->ieee80211->FwRWRF)
		priv->Rf_Mode = RF_OP_By_FW;
	else
		priv->Rf_Mode = RF_OP_By_SW_3wire;
#else
	priv->Rf_Mode = RF_OP_By_SW_3wire;
#endif

#ifdef RTL8190P
	if (priv->ResetProgress == RESET_TYPE_NORESET) {
		dm_initialize_txpower_tracking(dev);

		tmpRegA= rtl8192_QueryBBReg(dev,rOFDM0_XATxIQImbalance,bMaskDWord);
		tmpRegC= rtl8192_QueryBBReg(dev,rOFDM0_XCTxIQImbalance,bMaskDWord);

		if (priv->rf_type == RF_2T4R){
			for (i = 0; i<TxBBGainTableLength; i++) {
				if (tmpRegA == priv->txbbgain_table[i].txbbgain_value) {
					priv->rfa_txpowertrackingindex= (u8)i;
					priv->rfa_txpowertrackingindex_real= (u8)i;
					priv->rfa_txpowertracking_default = priv->rfa_txpowertrackingindex;
					break;
				}
			}
		}
		for (i = 0; i<TxBBGainTableLength; i++) {
			if(tmpRegC == priv->txbbgain_table[i].txbbgain_value)
			{
				priv->rfc_txpowertrackingindex= (u8)i;
				priv->rfc_txpowertrackingindex_real= (u8)i;
				priv->rfc_txpowertracking_default = priv->rfc_txpowertrackingindex;
				break;
			}
		}
		TempCCk = rtl8192_QueryBBReg(dev, rCCK0_TxFilter1, bMaskByte2);				

		for (i = 0 ; i < CCKTxBBGainTableLength ; i++) {
			if (TempCCk == priv->cck_txbbgain_table[i].ccktxbb_valuearray[0]) {
				priv->CCKPresentAttentuation_20Mdefault =(u8) i;
				break;
			}
		}
		priv->CCKPresentAttentuation_40Mdefault = 0;
		priv->CCKPresentAttentuation_difference = 0;
		priv->CCKPresentAttentuation = priv->CCKPresentAttentuation_20Mdefault;
		RT_TRACE(COMP_POWER_TRACKING, "priv->rfa_txpowertrackingindex_initial = %d\n", priv->rfa_txpowertrackingindex);
		RT_TRACE(COMP_POWER_TRACKING, "priv->rfa_txpowertrackingindex_real__initial = %d\n", priv->rfa_txpowertrackingindex_real);
		RT_TRACE(COMP_POWER_TRACKING, "priv->rfc_txpowertrackingindex_initial = %d\n", priv->rfc_txpowertrackingindex);
		RT_TRACE(COMP_POWER_TRACKING, "priv->rfc_txpowertrackingindex_real_initial = %d\n", priv->rfc_txpowertrackingindex_real);
		RT_TRACE(COMP_POWER_TRACKING, "priv->CCKPresentAttentuation_difference_initial = %d\n", priv->CCKPresentAttentuation_difference);
		RT_TRACE(COMP_POWER_TRACKING, "priv->CCKPresentAttentuation_initial = %d\n", priv->CCKPresentAttentuation);
	}
#elif defined RTL8192E
	if(priv->ResetProgress == RESET_TYPE_NORESET)
	{
		dm_initialize_txpower_tracking(dev);

		if(priv->IC_Cut>= IC_VersionCut_D)
		{
			tmpRegA= rtl8192_QueryBBReg(dev,rOFDM0_XATxIQImbalance,bMaskDWord);
			tmpRegC= rtl8192_QueryBBReg(dev,rOFDM0_XCTxIQImbalance,bMaskDWord);
			for(i = 0; i<TxBBGainTableLength; i++)
			{
				if(tmpRegA == priv->txbbgain_table[i].txbbgain_value)
				{
					priv->rfa_txpowertrackingindex= (u8)i;
					priv->rfa_txpowertrackingindex_real= (u8)i;
					priv->rfa_txpowertracking_default = priv->rfa_txpowertrackingindex;
					break;
				}
			}

			TempCCk = rtl8192_QueryBBReg(dev, rCCK0_TxFilter1, bMaskByte2);				

			for(i=0 ; i<CCKTxBBGainTableLength ; i++)
			{
				if(TempCCk == priv->cck_txbbgain_table[i].ccktxbb_valuearray[0])
				{
					priv->CCKPresentAttentuation_20Mdefault =(u8) i;
					break;
				}
			}
			priv->CCKPresentAttentuation_40Mdefault = 0;
			priv->CCKPresentAttentuation_difference = 0;
			priv->CCKPresentAttentuation = priv->CCKPresentAttentuation_20Mdefault;
			RT_TRACE(COMP_POWER_TRACKING, "priv->rfa_txpowertrackingindex_initial = %d\n", priv->rfa_txpowertrackingindex);
			RT_TRACE(COMP_POWER_TRACKING, "priv->rfa_txpowertrackingindex_real__initial = %d\n", priv->rfa_txpowertrackingindex_real);
			RT_TRACE(COMP_POWER_TRACKING, "priv->CCKPresentAttentuation_difference_initial = %d\n", priv->CCKPresentAttentuation_difference);
			RT_TRACE(COMP_POWER_TRACKING, "priv->CCKPresentAttentuation_initial = %d\n", priv->CCKPresentAttentuation);
			priv->btxpower_tracking = false;
		}
	}
#endif
	rtl8192_irq_enable(dev);
end:	
	priv->being_init_adapter = false;
	return rtStatus;

}
	 
void rtl8192_net_update(struct net_device *dev)
{

	struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_network *net;
	u16 BcnTimeCfg = 0, BcnCW = 6, BcnIFS = 0xf;
	u16 rate_config = 0;
	net = &priv->ieee80211->current_network;
	rtl8192_config_rate(dev, &rate_config);	
	 priv->basic_rate = rate_config &= 0x15f;
	write_nic_dword(dev,BSSIDR,((u32*)net->bssid)[0]);
	write_nic_word(dev,BSSIDR+4,((u16*)net->bssid)[2]);

	if (priv->ieee80211->iw_mode == IW_MODE_ADHOC)
	{
		write_nic_word(dev, ATIMWND, 2);
		write_nic_word(dev, BCN_DMATIME, 256);	
		write_nic_word(dev, BCN_INTERVAL, net->beacon_interval);
		write_nic_word(dev, BCN_DRV_EARLY_INT, 10);
		write_nic_byte(dev, BCN_ERR_THRESH, 100);

		BcnTimeCfg |= (BcnCW<<BCN_TCFG_CW_SHIFT);
	 	BcnTimeCfg |= BcnIFS<<BCN_TCFG_IFS;

		write_nic_word(dev, BCN_TCFG, BcnTimeCfg);
	}
	

}

void rtl8192_update_ratr_table(struct net_device* dev)
{
	struct r8192_priv* priv = ieee80211_priv(dev);
	struct ieee80211_device* ieee = priv->ieee80211;
	u8* pMcsRate = ieee->dot11HTOperationalRateSet;
	u32 ratr_value = 0;
	u8 rate_index = 0;

	rtl8192_config_rate(dev, (u16*)(&ratr_value));
	ratr_value |= (*(u16*)(pMcsRate)) << 12;
	switch (ieee->mode)
	{
		case IEEE_A:
			ratr_value &= 0x00000FF0;
			break;
		case IEEE_B:
			ratr_value &= 0x0000000F;
			break;
		case IEEE_G:
			ratr_value &= 0x00000FF7;
			break;
		case IEEE_N_24G:
		case IEEE_N_5G:
			if (ieee->pHTInfo->PeerMimoPs == 0) 
				ratr_value &= 0x0007F007;
			else{
				if (priv->rf_type == RF_1T2R)
					ratr_value &= 0x000FF007;
				else
					ratr_value &= 0x0F81F007;
			}
			break;
		default:
			break; 
	}
	ratr_value &= 0x0FFFFFFF;
	if(ieee->pHTInfo->bCurTxBW40MHz && ieee->pHTInfo->bCurShortGI40MHz){
		ratr_value |= 0x80000000;
	}else if(!ieee->pHTInfo->bCurTxBW40MHz && ieee->pHTInfo->bCurShortGI20MHz){
		ratr_value |= 0x80000000;
	}	
	write_nic_dword(dev, RATR0+rate_index*4, ratr_value);
	write_nic_byte(dev, UFWP, 1);
}

void rtl8192_link_change(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_device* ieee = priv->ieee80211;

	if (ieee->state == IEEE80211_LINKED) {
		rtl8192_net_update(dev);
		rtl8192_update_ratr_table(dev);
		if ((KEY_TYPE_WEP40 == ieee->pairwise_key_type) || (KEY_TYPE_WEP104 == ieee->pairwise_key_type))
			EnableHWSecurityConfig8192(dev);
	} else {
		write_nic_byte(dev, 0x173, 0);
	}
#ifdef _RTL8192_EXT_PATCH_
	if (ieee->iw_mode == IW_MODE_MESH) {
		u16 BcnTimeCfg = 0, BcnCW = 6, BcnIFS = 0xf;
		write_nic_word(dev, ATIMWND, 2);
		write_nic_word(dev, BCN_DMATIME, 256);	
		write_nic_word(dev, BCN_INTERVAL, 100);
		write_nic_word(dev, BCN_DRV_EARLY_INT, 10);
		write_nic_byte(dev, BCN_ERR_THRESH, 100);

		BcnTimeCfg |= (BcnCW<<BCN_TCFG_CW_SHIFT);
		BcnTimeCfg |= BcnIFS<<BCN_TCFG_IFS;

		write_nic_word(dev, BCN_TCFG, BcnTimeCfg);
	}
#endif

	rtl8192_update_msr(dev);

	if (ieee->iw_mode == IW_MODE_INFRA || ieee->iw_mode == IW_MODE_ADHOC) {
		u32 reg = 0;
		reg = read_nic_dword(dev, RCR);
		if (priv->ieee80211->state == IEEE80211_LINKED)
			priv->ReceiveConfig = reg |= RCR_CBSSID;
		else
			priv->ReceiveConfig = reg &= ~RCR_CBSSID;
		write_nic_dword(dev, RCR, reg);
	}
}

void  rtl8192_tx_fill_cmd_desc(struct net_device* dev, tx_desc_cmd * entry, 
		cb_desc * cb_desc, struct sk_buff* skb)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    dma_addr_t mapping = pci_map_single(priv->pdev, skb->data, skb->len, PCI_DMA_TODEVICE);

    memset(entry,0,12);
    entry->LINIP = cb_desc->bLastIniPkt;
    entry->FirstSeg = 1;
    entry->LastSeg = 1; 
    if(cb_desc->bCmdOrInit == DESC_PACKET_TYPE_INIT) {
        entry->CmdInit = DESC_PACKET_TYPE_INIT;
    } else {
	tx_desc* entry_tmp = (tx_desc*)entry;
        entry_tmp->CmdInit = DESC_PACKET_TYPE_NORMAL;
        entry_tmp->Offset = sizeof(TX_FWINFO_8190PCI) + 8;
        entry_tmp->PktSize = (u16)(cb_desc->pkt_size + entry_tmp->Offset);
        entry_tmp->QueueSelect = QSLT_CMD;
        entry_tmp->TxFWInfoSize = 0x08;
        entry_tmp->RATid = (u8)DESC_PACKET_TYPE_INIT;
    }
    entry->TxBufferSize = skb->len;
    entry->TxBuffAddr = cpu_to_le32(mapping);
    entry->OWN = 1;
}

#if defined RTL8190P || defined RTL8192E
u8 MRateToHwRate8190Pci(u8 rate)
{
	u8  ret = DESC90_RATE1M;

	switch(rate) {
		case MGN_1M:	ret = DESC90_RATE1M;		break;
		case MGN_2M:	ret = DESC90_RATE2M;		break;
		case MGN_5_5M:	ret = DESC90_RATE5_5M;	break;
		case MGN_11M:	ret = DESC90_RATE11M;	break;
		case MGN_6M:	ret = DESC90_RATE6M;		break;
		case MGN_9M:	ret = DESC90_RATE9M;		break;
		case MGN_12M:	ret = DESC90_RATE12M;	break;
		case MGN_18M:	ret = DESC90_RATE18M;	break;
		case MGN_24M:	ret = DESC90_RATE24M;	break;
		case MGN_36M:	ret = DESC90_RATE36M;	break;
		case MGN_48M:	ret = DESC90_RATE48M;	break;
		case MGN_54M:	ret = DESC90_RATE54M;	break;

		case MGN_MCS0:	ret = DESC90_RATEMCS0;	break;
		case MGN_MCS1:	ret = DESC90_RATEMCS1;	break;
		case MGN_MCS2:	ret = DESC90_RATEMCS2;	break;
		case MGN_MCS3:	ret = DESC90_RATEMCS3;	break;
		case MGN_MCS4:	ret = DESC90_RATEMCS4;	break;
		case MGN_MCS5:	ret = DESC90_RATEMCS5;	break;
		case MGN_MCS6:	ret = DESC90_RATEMCS6;	break;
		case MGN_MCS7:	ret = DESC90_RATEMCS7;	break;
		case MGN_MCS8:	ret = DESC90_RATEMCS8;	break;
		case MGN_MCS9:	ret = DESC90_RATEMCS9;	break;
		case MGN_MCS10:	ret = DESC90_RATEMCS10;	break;
		case MGN_MCS11:	ret = DESC90_RATEMCS11;	break;
		case MGN_MCS12:	ret = DESC90_RATEMCS12;	break;
		case MGN_MCS13:	ret = DESC90_RATEMCS13;	break;
		case MGN_MCS14:	ret = DESC90_RATEMCS14;	break;
		case MGN_MCS15:	ret = DESC90_RATEMCS15;	break;
		case (0x80|0x20): ret = DESC90_RATEMCS32; break;

		default:       break;
	}
	return ret;
}
#endif

void  rtl8192_tx_fill_desc(struct net_device* dev, tx_desc * pdesc, cb_desc * cb_desc, struct sk_buff* skb)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    dma_addr_t mapping = pci_map_single(priv->pdev, skb->data, skb->len, PCI_DMA_TODEVICE);
    TX_FWINFO_8190PCI *pTxFwInfo = NULL;
    pTxFwInfo = (PTX_FWINFO_8190PCI)skb->data;
    memset(pTxFwInfo,0,sizeof(TX_FWINFO_8190PCI));
    pTxFwInfo->TxHT = (cb_desc->data_rate&0x80)?1:0;
    pTxFwInfo->TxRate = MRateToHwRate8190Pci((u8)cb_desc->data_rate);
    pTxFwInfo->EnableCPUDur = cb_desc->bTxEnableFwCalcDur;
    pTxFwInfo->Short	= QueryIsShort(pTxFwInfo->TxHT, pTxFwInfo->TxRate, cb_desc);

    if(cb_desc->bAMPDUEnable) {
        pTxFwInfo->AllowAggregation = 1;
        pTxFwInfo->RxMF = cb_desc->ampdu_factor;
        pTxFwInfo->RxAMD = cb_desc->ampdu_density;
    } else {
        pTxFwInfo->AllowAggregation = 0;
        pTxFwInfo->RxMF = 0;
        pTxFwInfo->RxAMD = 0;
    }

    pTxFwInfo->RtsEnable =	(cb_desc->bRTSEnable)?1:0;
    pTxFwInfo->CtsEnable =	(cb_desc->bCTSEnable)?1:0;
    pTxFwInfo->RtsSTBC =	(cb_desc->bRTSSTBC)?1:0;
    pTxFwInfo->RtsHT=		(cb_desc->rts_rate&0x80)?1:0;
    pTxFwInfo->RtsRate =		MRateToHwRate8190Pci((u8)cb_desc->rts_rate);
    pTxFwInfo->RtsBandwidth = 0;
    pTxFwInfo->RtsSubcarrier = cb_desc->RTSSC;
    pTxFwInfo->RtsShort =	(pTxFwInfo->RtsHT==0)?(cb_desc->bRTSUseShortPreamble?1:0):(cb_desc->bRTSUseShortGI?1:0);
    if(priv->CurrentChannelBW == HT_CHANNEL_WIDTH_20_40)
    {
        if(cb_desc->bPacketBW)
        {
            pTxFwInfo->TxBandwidth = 1;
#ifdef RTL8190P
            pTxFwInfo->TxSubCarrier = 3;
#else
            pTxFwInfo->TxSubCarrier = 0;	
#endif
        }
        else
        {
            pTxFwInfo->TxBandwidth = 0;
            pTxFwInfo->TxSubCarrier = priv->nCur40MhzPrimeSC;
        }
    } else {
        pTxFwInfo->TxBandwidth = 0;
        pTxFwInfo->TxSubCarrier = 0;
    }

    if (0)
    {
   	    TX_FWINFO_T 	Tmp_TxFwInfo;
	    memcpy((void*)(&Tmp_TxFwInfo), (void*)(pTxFwInfo), sizeof(TX_FWINFO_8190PCI));
	    printk("&&&&&&&&&&&&&&&&&&&&&&====>print out fwinf\n");
	    printk("===>enable fwcacl:%d\n", Tmp_TxFwInfo.EnableCPUDur);
	    printk("===>RTS STBC:%d\n", Tmp_TxFwInfo.RtsSTBC);
	    printk("===>RTS Subcarrier:%d\n", Tmp_TxFwInfo.RtsSubcarrier);
	    printk("===>Allow Aggregation:%d\n", Tmp_TxFwInfo.AllowAggregation);
	    printk("===>TX HT bit:%d\n", Tmp_TxFwInfo.TxHT);
	    printk("===>Tx rate:%d\n", Tmp_TxFwInfo.TxRate);
	    printk("===>Received AMPDU Density:%d\n", Tmp_TxFwInfo.RxAMD);
	    printk("===>Received MPDU Factor:%d\n", Tmp_TxFwInfo.RxMF);
	    printk("===>TxBandwidth:%d\n", Tmp_TxFwInfo.TxBandwidth);
	    printk("===>TxSubCarrier:%d\n", Tmp_TxFwInfo.TxSubCarrier);

        printk("<=====**********************out of print\n");

    }

    memset((u8*)pdesc,0,12);
    pdesc->LINIP = 0;
    pdesc->CmdInit = 1;
    pdesc->Offset = sizeof(TX_FWINFO_8190PCI) + 8; 
    pdesc->PktSize = (u16)skb->len-sizeof(TX_FWINFO_8190PCI);

    pdesc->SecCAMID= 0;
    pdesc->RATid = cb_desc->RATRIndex;


    pdesc->NoEnc = 1;
    pdesc->SecType = 0x0;
    if (cb_desc->bHwSec) {
        static u8 tmp =0;
        if (!tmp) {
            printk("==>================hw sec\n");
            tmp = 1;
        }
        switch (priv->ieee80211->pairwise_key_type) {
            case KEY_TYPE_WEP40:
            case KEY_TYPE_WEP104:
                pdesc->SecType = 0x1;
                pdesc->NoEnc = 0;
                break;
            case KEY_TYPE_TKIP:
                pdesc->SecType = 0x2;
                pdesc->NoEnc = 0;
                break;
            case KEY_TYPE_CCMP:
                pdesc->SecType = 0x3;
                pdesc->NoEnc = 0;
                break;
            case KEY_TYPE_NA:
                pdesc->SecType = 0x0;
                pdesc->NoEnc = 1;
                break;
        }
    }

    pdesc->PktId = 0x0;

    pdesc->QueueSelect = MapHwQueueToFirmwareQueue(cb_desc->queue_index, cb_desc->priority);
    pdesc->TxFWInfoSize = sizeof(TX_FWINFO_8190PCI);

    pdesc->DISFB = cb_desc->bTxDisableRateFallBack;
    pdesc->USERATE = cb_desc->bTxUseDriverAssingedRate;

    pdesc->FirstSeg =1;
    pdesc->LastSeg = 1;
    pdesc->TxBufferSize = skb->len;

    pdesc->TxBuffAddr = cpu_to_le32(mapping);
}

bool rtl8192_rx_query_status_desc(struct net_device* dev, struct ieee80211_rx_stats*  stats, 
		rx_desc *pdesc, struct sk_buff* skb)
{
	struct r8192_priv *priv = ieee80211_priv(dev);

	stats->bICV = pdesc->ICV;
	stats->bCRC = pdesc->CRC32;
	stats->bHwError = pdesc->CRC32 | pdesc->ICV;

	stats->Length = pdesc->Length;
	if(stats->Length < 24)
		stats->bHwError |= 1;

	if (stats->bHwError) {
		stats->bShift = false;

		if (pdesc->CRC32) {
			if (pdesc->Length <500)
				priv->stats.rxcrcerrmin++;
			else if (pdesc->Length >1000)
				priv->stats.rxcrcerrmax++;
			else
				priv->stats.rxcrcerrmid++;
		}
		return false;
	} else {
		prx_fwinfo pDrvInfo = NULL;
		stats->RxDrvInfoSize = pdesc->RxDrvInfoSize;
		stats->RxBufShift = ((pdesc->Shift)&0x03);
		stats->Decrypted = !pdesc->SWDec;

		pDrvInfo = (rx_fwinfo *)(skb->data + stats->RxBufShift);

		stats->rate = HwRateToMRate90((bool)pDrvInfo->RxHT, (u8)pDrvInfo->RxRate);
		stats->bShortPreamble = pDrvInfo->SPLCP;

		UpdateReceivedRateHistogramStatistics8190(dev, stats);

		stats->bIsAMPDU = (pDrvInfo->PartAggr==1);
		stats->bFirstMPDU = (pDrvInfo->PartAggr==1) && (pDrvInfo->FirstAGGR==1);

		stats->TimeStampLow = pDrvInfo->TSFL;
		stats->TimeStampHigh = read_nic_dword(dev, TSFR+4);

		UpdateRxPktTimeStamp8190(dev, stats);

		if((stats->RxBufShift + stats->RxDrvInfoSize) > 0)
			stats->bShift = 1;

		stats->RxIs40MHzPacket = pDrvInfo->BW;

#ifdef _RTL8192_EXT_PATCH_
		if((priv->ieee80211->iw_mode == IW_MODE_MESH) 
				&& (priv->mshobj->ext_patch_translate_rxsignalstuff819xpci))
			priv->mshobj->ext_patch_translate_rxsignalstuff819xpci(dev,skb, stats, pdesc, pDrvInfo);       
#endif

		TranslateRxSignalStuff819xpci(dev,skb, stats, pdesc, pDrvInfo);

		if(pDrvInfo->FirstAGGR==1 || pDrvInfo->PartAggr == 1)
			RT_TRACE(COMP_RXDESC, "pDrvInfo->FirstAGGR = %d, pDrvInfo->PartAggr = %d\n", 
					pDrvInfo->FirstAGGR, pDrvInfo->PartAggr);
		skb_trim(skb, skb->len - 4/*sCrcLng*/);


		stats->packetlength = stats->Length-4;
		stats->fraglength = stats->packetlength;
		stats->fragoffset = 0;
		stats->ntotalfrag = 1;
		return true;		
	}
}

void rtl8192_rtx_disable(struct net_device *dev, bool reset)
{
	u8 cmd;
	struct r8192_priv *priv = ieee80211_priv(dev);
	int i;

	cmd=read_nic_byte(dev,CMDR);
	write_nic_byte(dev, CMDR, cmd &~ \
			(CR_TE|CR_RE));
	mdelay(30);

	for(i = 0; i < MAX_QUEUE_SIZE; i++) {
		skb_queue_purge(&priv->ieee80211->skb_waitQ [i]);
	}
	for(i = 0; i < MAX_QUEUE_SIZE; i++) {
		skb_queue_purge(&priv->ieee80211->skb_aggQ [i]);
	}
#ifdef _RTL8192_EXT_PATCH_	
	for(i = 0; i < MAX_QUEUE_SIZE; i++) {
		skb_queue_purge(&priv->ieee80211->skb_meshaggQ [i]);
	}
#endif

	skb_queue_purge(&priv->skb_queue);
	return;
}
#endif

void check_rfctrl_gpio_timer(unsigned long data)
{
	struct r8192_priv* priv = ieee80211_priv((struct net_device *)data);

	priv->polling_timer_on = 1;

	queue_delayed_work_rsl(priv->priv_wq,&priv->gpio_change_rf_wq,0);

	mod_timer(&priv->gpio_polling_timer, jiffies + MSECS(IEEE80211_WATCH_DOG_TIME));
}

#ifdef RTL8192SE
bool NicIFEnableNIC(struct net_device* dev)
{
	bool init_status = true;
	struct r8192_priv* priv = ieee80211_priv(dev);
	PRT_POWER_SAVE_CONTROL pPSC = (PRT_POWER_SAVE_CONTROL)(&(priv->ieee80211->PowerSaveControl));


	printk("===========>%s()\n",__FUNCTION__);
	priv->bfirst_init = true;
	init_status = priv->ops->initialize_adapter(dev);
	if (init_status != true) {
		RT_TRACE(COMP_ERR,"ERR!!! %s(): initialization is failed!\n",__FUNCTION__);
		return -1;
	}
	RT_TRACE(COMP_INIT, "start adapter finished\n");
	RT_CLEAR_PS_LEVEL(pPSC, RT_RF_OFF_LEVL_HALT_NIC);
	priv->bfirst_init = false;

	rtl8192_irq_enable(dev);
	priv->bdisable_nic = false;
	return init_status;
}

RT_STATUS NicIFDisableNIC(struct net_device* dev)
{
	RT_STATUS	status = RT_STATUS_SUCCESS;
	struct r8192_priv* priv = ieee80211_priv(dev);
	u8 tmp_state = 0;
	printk("=========>%s()\n",__FUNCTION__);
	tmp_state = priv->ieee80211->state;
#ifdef _RTL8192_EXT_PATCH_
	ieee80211_softmac_stop_protocol(priv->ieee80211, 0, false);
#else
	ieee80211_softmac_stop_protocol(priv->ieee80211,false);
#endif
	priv->ieee80211->state = tmp_state;
	rtl8192_cancel_deferred_work(priv);
	rtl8192_irq_disable(dev);


	if(priv->bDriverIsGoingToUnload)
	write_nic_byte(dev,0x560,0x0);
	PHY_SetRtl8192seRfHalt(dev);
	priv->bdisable_nic = true;	

	return status;
}
#endif

#ifdef RTL8192SE
/*
*	Description:
*		Set RateAdaptive Mask
*	/param 	Adapter		Pionter to Adapter entity
*	/param	bMulticast	TURE if broadcast or multicast, used for softAP basic rate
*	/param	macId		macID to set
*	/param 	wirelessMode	wireless mode of associated AP/client
*	/return	void
*	
*/
#ifdef _RTL8192_EXT_PATCH_
void UpdateHalRAMask8192SE(
	struct net_device* dev,
	bool bMulticast,
	u8   macId,
	u8*  MacAddr,
	u8   wirelessMode,
	u8   rssi_level)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_device *ieee = priv->ieee80211;
	PRT_HIGH_THROUGHPUT	pHTInfo =ieee->pHTInfo;
	u32	ratr_bitmap, RateSet;
	u8	shortGI_rate = 0;
	u32	tmp_ratr_value = 0;
	u32	mask=0, band = 0;
	u8	bShortGI = 0;

	rtl8192_config_rate(dev, (u16*)(&RateSet));
	RateSet |= (*((u16*)(ieee->dot11HTOperationalRateSet))) << 12;
	ratr_bitmap = RateSet;
	
	switch (wirelessMode)
	{
		case WIRELESS_MODE_B:
		{
			band |= WIRELESS_11B;
			ratr_bitmap &= 0x0000000d;
		}
		break;

		case WIRELESS_MODE_G:
		{
			band |= (WIRELESS_11G | WIRELESS_11B);
			if(rssi_level == 1)
				ratr_bitmap &= 0x00000f00;
			else if(rssi_level == 2)
				ratr_bitmap &= 0x00000ff0;
			else
				ratr_bitmap &= 0x00000ff5;
		}
		break;
			
		case WIRELESS_MODE_A:
		{
			band |= BIT2;
			ratr_bitmap &= 0x00000ff0;
		}
		break;
			
		case WIRELESS_MODE_N_24G:
		case WIRELESS_MODE_N_5G:
		{
			band |= (WIRELESS_11N| WIRELESS_11G| WIRELESS_11B);
			if(macId == 0)	
			{
				if(ieee->pHTInfo->PeerMimoPs == MIMO_PS_STATIC)
				{
					if(rssi_level == 1)
						ratr_bitmap &= 0x00070000;
					else if(rssi_level == 2)
						ratr_bitmap &= 0x0007f000;
					else
						ratr_bitmap &= 0x0007f005;
				}
				else
				{
					if (	priv->rf_type == RF_1T2R ||
						priv->rf_type == RF_1T1R	)
					{
						if (pHTInfo->bCurTxBW40MHz)
						{
							if(rssi_level == 1)
								ratr_bitmap &= 0x000f0000;
							else if(rssi_level == 2)
								ratr_bitmap &= 0x000ff000;
							else
								ratr_bitmap &= 0x000ff015;
						}
						else
						{
							if(rssi_level == 1)
								ratr_bitmap &= 0x000f0000;
							else if(rssi_level == 2)
								ratr_bitmap &= 0x000ff000;
							else
								ratr_bitmap &= 0x000ff005;
						}	
					}
					else
					{
						if (pHTInfo->bCurTxBW40MHz)
						{
							if(rssi_level == 1)
								ratr_bitmap &= 0x0f0f0000;
							else if(rssi_level == 2)
								ratr_bitmap &= 0x0f0ff000;
							else
								ratr_bitmap &= 0x0f0ff015;
						}
						else
						{
							if(rssi_level == 1)
								ratr_bitmap &= 0x0f0f0000;
							else if(rssi_level == 2)
								ratr_bitmap &= 0x0f0ff000;
							else
								ratr_bitmap &= 0x0f0ff005;
						}
					}
				}

				if( (pHTInfo->bCurTxBW40MHz && pHTInfo->bCurShortGI40MHz) ||
					(!pHTInfo->bCurTxBW40MHz && pHTInfo->bCurShortGI20MHz)	)
				{
					bShortGI = true;

					tmp_ratr_value = (ratr_bitmap>>12);
					for(shortGI_rate=15; shortGI_rate>0; shortGI_rate--)
					{
						if((1<<shortGI_rate) & tmp_ratr_value)
							break;
					}	
					shortGI_rate = (shortGI_rate<<12)|(shortGI_rate<<8)|(shortGI_rate<<4)|(shortGI_rate);
					write_nic_byte(dev, SG_RATE, shortGI_rate);
				}
			}
			else if(macId == 1)
			{
				if ( priv->rf_type == RF_1T2R || priv->rf_type == RF_1T1R )
				{
					if (pHTInfo->bCurBW40MHz)
					{
						ratr_bitmap &= 0x000ff015;
					}
					else
					{
						ratr_bitmap &= 0x000ff005;
					}
				}
				else
				{
					if (pHTInfo->bCurBW40MHz)
					{
						ratr_bitmap &= 0x0f0ff015;
					}
					else
					{
						ratr_bitmap &= 0x0f0ff005;
					}				
				}
			}
			else
			{
				if(ieee->iw_mode == IW_MODE_MESH)
				{
					if(ieee->ext_patch_ieee80211_update_ratr_mask)
						ieee->ext_patch_ieee80211_update_ratr_mask(dev,MacAddr,rssi_level,&ratr_bitmap,&bShortGI);
				}				
			}
		}
		break;

		default:
		{
			band |= (WIRELESS_11N| WIRELESS_11G| WIRELESS_11B);
			if(priv->rf_type == RF_1T2R)
			{
				ratr_bitmap &= 0x000ff0ff;
			}
			else
			{
				ratr_bitmap &= 0x0f0ff0ff;
			}
		}
	}

	if (priv->card_8192_version >= VERSION_8192S_BCUT)
		ratr_bitmap &= 0x0FFFFFFF;
	else if (priv->card_8192_version == VERSION_8192S_ACUT)
		ratr_bitmap &= 0x0FFFFFF0;	

	if(bShortGI)
		ratr_bitmap |= 0x10000000;
	
	if(macId == 0)
	{
		if(pHTInfo->IOTAction & HT_IOT_ACT_WA_IOT_Broadcom)
		{
			ratr_bitmap &= 0xfffffff0; 
			RT_TRACE(COMP_RATE, "UpdateHalRATRTable8192SE(), for HT_IOT_ACT_WA_IOT_Broadcom, ratr_value = 0x%x\n", ratr_bitmap);
		}
		if(pHTInfo->IOTAction & HT_IOT_ACT_DISABLE_SHORT_GI)
		{
			ratr_bitmap &=0x0fffffff;
		}		
	}
	mask |= (bMulticast ? 1 : 0)<<9 | (macId & 0x1f)<<4 | (band & 0xf);

	RT_TRACE(COMP_RATE, "UpdateHalRAMask92SE(): mask = %x, bitmap = %x\n", mask, ratr_bitmap);
	write_nic_dword(dev, 0x2c4, ratr_bitmap);
	write_nic_dword(dev, WFM5, (FW_RA_UPDATE_MASK | (mask << 8)));

}
#else
void
UpdateHalRAMask8192SE(
	struct net_device* dev,
	bool				bMulticast,
	u8				macId, 
	u8*				MacAddr, 
	u8*				pEntry, 
	u8				rssi_level)

{
	struct r8192_priv* 	priv = ieee80211_priv(dev);
	PRT_HIGH_THROUGHPUT	pHTInfo = priv->ieee80211->pHTInfo;
	WIRELESS_MODE		WirelessMode = WIRELESS_MODE_G;
	u32			ratr_bitmap, RateSet;
	u8			shortGI_rate = 0, MimoPs = 0, ratr_index = 8;
	u32			tmp_ratr_value = 0;
	u32			mask=0, band = 0;
	bool			bShortGI = false, bCurTxBW40MHz = 0;
	struct 	ieee80211_device* ieee = priv->ieee80211;
	u8* 	pMcsRate = ieee->dot11HTOperationalRateSet;

	if(macId == 0)
	{
		MimoPs = pHTInfo->PeerMimoPs;
		WirelessMode = priv->ieee80211->mode;
		bCurTxBW40MHz = pHTInfo->bCurTxBW40MHz;
	}	
	else if (macId == 1)
	{
		WirelessMode = WIRELESS_MODE_B;
	}
	else
	{
#ifdef DO_DO_LIST
		if(pEntry == NULL)		
		{
			printk("Doesn't have match Entry\n");
			return;
		}
	
		MimoPs = pEntry->HTInfo.MimoPs;

		if(IS_WIRELESS_MODE_G(Adapter) && (pEntry->WirelessMode == WIRELESS_MODE_N_24G))
			WirelessMode = pMgntInfo->dot11CurrentWirelessMode;
		else	
			WirelessMode = pEntry->WirelessMode;
		
		bCurTxBW40MHz = pEntry->HTInfo.bBw40MHz;
#endif		
	}
	rtl8192_config_rate(dev, (u16*)&RateSet);
	RateSet |= (*(u16*)(pMcsRate)) << 12;
	ratr_bitmap = RateSet;
	switch (WirelessMode)
	{
		case WIRELESS_MODE_B:
		{
			band |= WIRELESS_11B;
			ratr_index = RATR_INX_WIRELESS_B;
			ratr_bitmap &= 0x0000000d;
		}
		break;

		case WIRELESS_MODE_G:
		case (WIRELESS_MODE_G |WIRELESS_MODE_B):
		{
			band |= (WIRELESS_11G | WIRELESS_11B);
			ratr_index = RATR_INX_WIRELESS_GB;
			
			if(rssi_level == 1)
				ratr_bitmap &= 0x00000f00;
			else if(rssi_level == 2)
				ratr_bitmap &= 0x00000ff0;
			else
				ratr_bitmap &= 0x00000ff5;
		}
		break;
			
		case WIRELESS_MODE_A:
		{
			band |= WIRELESS_11A;
			ratr_index = RATR_INX_WIRELESS_A;
			ratr_bitmap &= 0x00000ff0;
		}
		break;
			
		case WIRELESS_MODE_N_24G:
		case WIRELESS_MODE_N_5G:
		{
			band |= (WIRELESS_11N| WIRELESS_11G| WIRELESS_11B);
			ratr_index = RATR_INX_WIRELESS_NGB;

			if(MimoPs == MIMO_PS_STATIC)
				{
					if(rssi_level == 1)
						ratr_bitmap &= 0x00070000;
					else if(rssi_level == 2)
						ratr_bitmap &= 0x0007f000;
					else
						ratr_bitmap &= 0x0007f005;
				}
				else
				{
				if (	priv->rf_type == RF_1T2R || priv->rf_type == RF_1T1R	)
					{
					if (bCurTxBW40MHz)
						{
							if(rssi_level == 1)
								ratr_bitmap &= 0x000f0000;
							else if(rssi_level == 2)
								ratr_bitmap &= 0x000ff000;
							else
								ratr_bitmap &= 0x000ff015;
						}
						else
						{
							if(rssi_level == 1)
								ratr_bitmap &= 0x000f0000;
							else if(rssi_level == 2)
								ratr_bitmap &= 0x000ff000;
							else
								ratr_bitmap &= 0x000ff005;
						}	
					}
					else
					{
					if (bCurTxBW40MHz)
						{
							if(rssi_level == 1)
								ratr_bitmap &= 0x0f0f0000;
							else if(rssi_level == 2)
								ratr_bitmap &= 0x0f0ff000;
							else
								ratr_bitmap &= 0x0f0ff015;
						}
						else
						{
							if(rssi_level == 1)
								ratr_bitmap &= 0x0f0f0000;
							else if(rssi_level == 2)
								ratr_bitmap &= 0x0f0ff000;
							else
								ratr_bitmap &= 0x0f0ff005;
						}
					}
				}
				if( (pHTInfo->bCurTxBW40MHz && pHTInfo->bCurShortGI40MHz) ||
					(!pHTInfo->bCurTxBW40MHz && pHTInfo->bCurShortGI20MHz)	)
				{
				if(macId == 0)
					bShortGI = true;
				else
					bShortGI = false;
			}
		}
		break;

		default:
			band |= (WIRELESS_11N| WIRELESS_11G| WIRELESS_11B);
			ratr_index = RATR_INX_WIRELESS_NGB;
			
			if(priv->rf_type == RF_1T2R)
				ratr_bitmap &= 0x000ff0ff;
			else
				ratr_bitmap &= 0x0f0ff0ff;
			break;
	}

	if (priv->card_8192_version >= VERSION_8192S_BCUT)
		ratr_bitmap &= 0x0FFFFFFF;
	else if (priv->card_8192_version == VERSION_8192S_ACUT)
		ratr_bitmap &= 0x0FFFFFF0;	

	if(bShortGI)
	{
		ratr_bitmap |= 0x10000000;
		tmp_ratr_value = (ratr_bitmap>>12);
		for(shortGI_rate=15; shortGI_rate>0; shortGI_rate--)
		{
			if((1<<shortGI_rate) & tmp_ratr_value)
				break;
		}	
		shortGI_rate = (shortGI_rate<<12)|(shortGI_rate<<8)|(shortGI_rate<<4)|(shortGI_rate);
		write_nic_byte(dev, SG_RATE, shortGI_rate);
	}	
	
	if(macId == 0)	{
		if(priv->ieee80211->pHTInfo->IOTAction & HT_IOT_ACT_WA_IOT_Broadcom)
			ratr_bitmap &= 0xfffffff0; 
		if(priv->ieee80211->pHTInfo->IOTAction & HT_IOT_ACT_DISABLE_SHORT_GI)
			ratr_bitmap &=0x0fffffff;
	}		

		
	mask |= (bMulticast ? 1 : 0)<<9 | (macId & 0x1f)<<4 | (band & 0xf);

	RT_TRACE(COMP_RATE, "UpdateHalRAMask92SE(): mask = %x, bitmap = %x ratr_index = %x\n", mask, ratr_bitmap, ratr_index);
	write_nic_dword(dev, 0x2c4, ratr_bitmap);
	write_nic_dword(dev, WFM5, (FW_RA_UPDATE_MASK | (mask << 8)));

}
#endif
#endif

/***************************************************************************
     ------------------- module init / exit stubs ----------------
****************************************************************************/
module_init(rtl8192_pci_module_init);
module_exit(rtl8192_pci_module_exit);


MODULE_DESCRIPTION("Linux driver for Realtek RTL819x WiFi cards");
MODULE_AUTHOR(DRV_COPYRIGHT " " DRV_AUTHOR);
#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0))
MODULE_VERSION(DRV_VERSION);
#endif
MODULE_LICENSE("GPL");

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 9)
module_param(ifname, charp, S_IRUGO|S_IWUSR );
module_param(hwwep,int, S_IRUGO|S_IWUSR);
module_param(channels,int, S_IRUGO|S_IWUSR);
#else
MODULE_PARM(ifname, "s");
MODULE_PARM(hwwep,"i");
MODULE_PARM(channels,"i");
#endif

MODULE_PARM_DESC(ifname," Net interface name, wlan%d=default");
MODULE_PARM_DESC(hwwep," Try to use hardware WEP support(default use hw. set 0 to use software security)");
MODULE_PARM_DESC(channels," Channel bitmask for specific locales. NYI");
