/******************************************************************************
 * Copyright(c) 2008 - 2010 Realtek Corporation. All rights reserved.
 *
 * Based on the r8180 driver, which is:
 * Copyright 2004-2005 Andrea Merello <andreamrl@tiscali.it>, et al.
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
******************************************************************************/
#include "rtl_core.h"
#include "r8192S_phy.h"
#include "r8192S_phyreg.h"
#include "r8192S_rtl6052.h"
#include "r8192S_Efuse.h"
#include "r8192E_dm.h"
#include "rtl_wx.h"

extern int WDCAPARA_ADD[];
static void rtl8192se_config_hw_for_load_fail(struct net_device* dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	u16			i;
	u8 			sMacAddr[6] = {0x00, 0xE0, 0x4C, 0x81, 0x92, 0x00};
	u8			rf_path, index;

	RT_TRACE(COMP_INIT, "====> rtl8192se_config_hw_for_load_fail\n");

	write_nic_byte(dev, SYS_ISO_CTRL+1, 0xE8); 
	mdelay(10);
	write_nic_byte(dev, PMC_FSM, 0x02); 
	
	priv->eeprom_vid= 0;
	priv->eeprom_did= 0;		
	priv->eeprom_ChannelPlan= 0;
	priv->eeprom_CustomerID= 0;	

       get_random_bytes(&sMacAddr[5], 1);
	for(i = 0; i < 6; i++)
		dev->dev_addr[i] = sMacAddr[i];			


	priv->rf_type= RTL819X_DEFAULT_RF_TYPE;	
	priv->rf_chip = RF_6052;

#if (EEPROM_OLD_FORMAT_SUPPORT == 1)
	for(i=0; i<14; i++)
	{
		priv->EEPROMTxPowerLevelCCK[i] = (u8)(EEPROM_Default_TxPower & 0xff);
		RT_TRACE(COMP_INIT, "CCK 2.4G Tx Pwr Index %d = 0x%02x\n", 
		i, priv->EEPROMTxPowerLevelCCK[i]);
	}			

	for(i=0; i<14; i++)
	{
		priv->EEPROMTxPowerLevelOFDM24G[i] = (u8)(EEPROM_Default_TxPower & 0xff);
		RT_TRACE(COMP_INIT, "OFDM 2.4G Tx Pwr Index %d = 0x%02x\n", 
		i, priv->EEPROMTxPowerLevelOFDM24G[i]);				
	}	

	for(i=0; i<14; i++)
	{			
		priv->TxPowerLevelOFDM24G[i] = priv->EEPROMTxPowerLevelOFDM24G[i];
		priv->TxPowerLevelCCK[i] = priv->EEPROMTxPowerLevelCCK[i];
	}	
	for(i=0; i<6; i++)
	{
		priv->EEPROMHT2T_TxPwr[i] = EEPROM_Default_HT2T_TxPwr;
	}
	
#else
	for (rf_path = 0; rf_path < 2; rf_path++)
	{
		for (i = 0; i < 3; i++)
		{
			priv->RfCckChnlAreaTxPwr[rf_path][i] = 
			priv->RfOfdmChnlAreaTxPwr1T[rf_path][i] = 
			priv->RfOfdmChnlAreaTxPwr2T[rf_path][i] = 
			EEPROM_Default_TxPowerLevel;
		}
	}	
				
	for (rf_path = 0; rf_path < 2; rf_path++)
	{
		for(i=0; i<14; i++)	
		{
			if (i < 3)			
				index = 0;
#ifdef _RTL8192_EXT_PATCH_	
			else if (i < 9)		
#else
			else if (i < 8)		
#endif
				index = 1;
			else				
				index = 2;

			priv->RfTxPwrLevelCck[rf_path][i]  = 
			priv->RfCckChnlAreaTxPwr[rf_path][index] = 
			priv->RfTxPwrLevelOfdm1T[rf_path][i]  = 
			priv->RfOfdmChnlAreaTxPwr1T[rf_path][index] = 
			priv->RfTxPwrLevelOfdm2T[rf_path][i]  = 
			priv->RfOfdmChnlAreaTxPwr2T[rf_path][index] = 
			(u8)(EEPROM_Default_TxPower & 0xff);				

			if (rf_path == 0)
			{
				priv->TxPowerLevelOFDM24G[i] = (u8)(EEPROM_Default_TxPower & 0xff);
				priv->TxPowerLevelCCK[i] = (u8)(EEPROM_Default_TxPower & 0xff);
			}
		}
		
	}
	
	RT_TRACE(COMP_INIT, "All TxPwr = 0x%x\n", EEPROM_Default_TxPower);

	for(i=0; i<14; i++)	
	{			
		priv->TxPwrHt20Diff[RF90_PATH_A][i] = DEFAULT_HT20_TXPWR_DIFF;
		priv->TxPwrHt20Diff[RF90_PATH_B][i] = DEFAULT_HT20_TXPWR_DIFF;

		priv->TxPwrLegacyHtDiff[0][i] = EEPROM_Default_LegacyHTTxPowerDiff;
		priv->TxPwrLegacyHtDiff[1][i] = EEPROM_Default_LegacyHTTxPowerDiff;
	}
	
	priv->TxPwrSafetyFlag = 0;
#endif
	
	priv->EEPROMTxPowerDiff = EEPROM_Default_LegacyHTTxPowerDiff;
	priv->LegacyHTTxPowerDiff = priv->EEPROMTxPowerDiff;
	RT_TRACE(COMP_INIT, "TxPowerDiff = %#x\n", priv->EEPROMTxPowerDiff);

#ifndef _RTL8192_EXT_PATCH_	
	for (rf_path = 0; rf_path < 2; rf_path++)
	{
		for (i = 0; i < 3; i++)
		{
			priv->EEPROMPwrGroup[rf_path][i] = 0;
		}
	}

	for (rf_path = 0; rf_path < 2; rf_path++)
	{
		for(i=0; i<14; i++)
		{
			if (i < 3)			
				index = 0;
			else if (i < 8)		
				index = 1;
			else				
				index = 2;
			priv->PwrGroupHT20[rf_path][i] = (priv->EEPROMPwrGroup[rf_path][index]&0xf);
			priv->PwrGroupHT40[rf_path][i] = ((priv->EEPROMPwrGroup[rf_path][index]&0xf0)>>4);
		}
	}
	priv->EEPROMRegulatory = 0;

#endif

	priv->EEPROMTSSI_A = EEPROM_Default_TSSI;
	priv->EEPROMTSSI_B = EEPROM_Default_TSSI;			

	for(i=0; i<6; i++)
	{
		priv->EEPROMHT2T_TxPwr[i] = EEPROM_Default_HT2T_TxPwr;
	}

	
	priv->EEPROMThermalMeter = EEPROM_Default_ThermalMeter;
	priv->ThermalMeter[0] = (priv->EEPROMThermalMeter&0x1f);	
	priv->TSSI_13dBm = priv->EEPROMThermalMeter *100;

	priv->BluetoothCoexist = EEPROM_Default_BlueToothCoexist;
	
	priv->EEPROMCrystalCap = EEPROM_Default_CrystalCap;
	priv->CrystalCap = priv->EEPROMCrystalCap;

	priv->eeprom_ChannelPlan = 0;
	priv->eeprom_version = 1;		
	priv->bTXPowerDataReadFromEEPORM = false;

	priv->rf_type = RTL819X_DEFAULT_RF_TYPE;	
	priv->rf_chip = RF_6052;
	priv->eeprom_CustomerID = 0;
	RT_TRACE(COMP_INIT, "EEPROM Customer ID: 0x%2x\n", priv->eeprom_CustomerID);

			
	priv->EEPROMBoardType = EEPROM_Default_BoardType;	
	RT_TRACE(COMP_INIT, "BoardType = %#x\n", priv->EEPROMBoardType);

#ifdef _RTL8192_EXT_PATCH_	
	priv->LedStrategy = SW_LED_MODE0;
#else
	priv->LedStrategy = SW_LED_MODE7;
#endif

	
	RT_TRACE(COMP_INIT,"<==== rtl8192se_config_hw_for_load_fail\n");
}

static void rtl8192se_get_IC_Inferiority(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	u8  Efuse_ID;

	priv->IC_Class = IC_INFERIORITY_A; 
	if((priv->epromtype == EEPROM_BOOT_EFUSE) && !priv->AutoloadFailFlag) 
	{
		Efuse_ID = EFUSE_Read1Byte(dev, EFUSE_IC_ID_OFFSET);

		if(Efuse_ID == 0xfe)
		{
			priv->IC_Class = IC_INFERIORITY_B;

		}
	}
}

#ifdef _RTL8192_EXT_PATCH_	
void HalCustomizedBehavior8192S(struct net_device* dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	switch(priv->CustomerID)
	{
		case RT_CID_DEFAULT:
			priv->LedStrategy = SW_LED_MODE7;	
			if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8171 &&
				priv->eeprom_svid == 0x1A3B && priv->eeprom_smid == 0x1A07)
			{
				priv->RegWirelessMode = WIRELESS_MODE_G;
			}
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8172 &&
					priv->eeprom_svid == 0x1A3B && priv->eeprom_smid == 0x1A04)
			{
				priv->RegWirelessMode = WIRELESS_MODE_G;	
			}
			break;
			
		case RT_CID_TOSHIBA:
			priv->ieee80211->current_network.channel = 10;
			priv->LedStrategy = SW_LED_MODE7;		
			if(priv->eeprom_smid >= 0x7000 && priv->eeprom_smid < 0x8000)
				priv->RegWirelessMode = WIRELESS_MODE_G;
			break;

		case RT_CID_CCX:
			priv->DMFlag |= (HAL_DM_DIG_DISABLE | HAL_DM_HIPWR_DISABLE);
			break;

		case RT_CID_819x_Lenovo:
			priv->LedStrategy = SW_LED_MODE7;
			break;
			
		case RT_CID_819x_QMI:
			priv->LedStrategy = SW_LED_MODE8;			
			break;

		case RT_CID_819x_MSI:	
			priv->LedStrategy = SW_LED_MODE9;			
			break;		

		case RT_CID_WHQL:
			break;
	
		default:
			RT_TRACE(COMP_INIT,"Unkown hardware Type \n");
			break;
	}
}
#else	
void
HalCustomizedBehavior8192S(struct net_device* dev)
{
	struct r8192_priv* priv = ieee80211_priv(dev);
	priv->ieee80211->bForcedShowRateStill = false;
	switch(priv->CustomerID)
	{
		case RT_CID_DEFAULT:
			priv->LedStrategy = SW_LED_MODE7;
			if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8171 &&
				priv->eeprom_svid == 0x1A3B && priv->eeprom_smid == 0x1A07)
			{
				priv->RegWirelessMode = WIRELESS_MODE_G;
				priv->ieee80211->mode = WIRELESS_MODE_G;
				priv->ieee80211->bForcedBgMode = true;
				priv->ieee80211->bForcedShowRateStill = true;
			}
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8172 &&
					priv->eeprom_svid == 0x1A3B && priv->eeprom_smid == 0x1A04)
			{
				priv->RegWirelessMode = WIRELESS_MODE_G;	
				priv->ieee80211->mode = WIRELESS_MODE_G;
				priv->ieee80211->bForcedBgMode = true;
				priv->ieee80211->bForcedShowRateStill = true;
			}
			else if(priv->eeprom_svid == 0x1A3B && priv->eeprom_smid == 0x1104)
			{
				priv->ieee80211->bForcedShowRateStill = true;
			}
			else if(priv->eeprom_svid == 0x1A3B && priv->eeprom_smid == 0x1107)
			{
				priv->ieee80211->bForcedShowRateStill = true;
			}
			
			break;
			
		case RT_CID_TOSHIBA:
			priv->ieee80211->current_network.channel = 10;
			priv->LedStrategy = SW_LED_MODE7;
			priv->EEPROMRegulatory = 1;		
			if(priv->eeprom_smid >=  0x7000 && priv->eeprom_smid < 0x8000){
				priv->RegWirelessMode = WIRELESS_MODE_G;
				priv->ieee80211->mode = WIRELESS_MODE_G;
				priv->ieee80211->bForcedBgMode = true;
			}
			break;
		case RT_CID_CCX:
			priv->DMFlag |= (HAL_DM_DIG_DISABLE | HAL_DM_HIPWR_DISABLE);
			break;

		case RT_CID_819x_Lenovo:
			priv->LedStrategy = SW_LED_MODE7;
			break;

		case RT_CID_819x_QMI:
			priv->LedStrategy = SW_LED_MODE8;			
			break;

		case RT_CID_819x_MSI:	
			priv->LedStrategy = SW_LED_MODE9;			
			break;
			
		case RT_CID_WHQL:
			;
			break;
	
		default:
			RT_TRACE(COMP_INIT,"Unkown hardware Type \n");
			break;
	}
}
#endif


static	void rtl8192se_read_eeprom_info(struct net_device* dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	u16			i,usValue;
	u16			EEPROMId;
#if (EEPROM_OLD_FORMAT_SUPPORT == 1)
	u8			tmpBuffer[30];	
#endif
	u8			tempval;
	u8			hwinfo[HWSET_MAX_SIZE_92S];
	u8			rf_path, index;	

	RT_TRACE(COMP_INIT, "====> rtl8192se_read_eeprom_info\n");

	if (priv->epromtype== EEPROM_93C46)
	{	
		write_nic_byte(dev, SYS_ISO_CTRL+1, 0xE8); 
		mdelay(10);
		write_nic_byte(dev, PMC_FSM, 0x02); 

		RT_TRACE(COMP_INIT, "EEPROM\n");
		for(i = 0; i < HWSET_MAX_SIZE_92S; i += 2)
		{
			usValue = eprom_read(dev, (u16) (i>>1));
			*((u16*)(&hwinfo[i])) = usValue;					
		}	
	}
	else if (priv->epromtype == EEPROM_BOOT_EFUSE)
	{	
		RT_TRACE(COMP_INIT, "EFUSE\n");

		EFUSE_ShadowMapUpdate(dev);

		memcpy( hwinfo, &priv->EfuseMap[EFUSE_INIT_MAP][0], HWSET_MAX_SIZE_92S);		
	}


	EEPROMId = *((u16 *)&hwinfo[0]);
	if( EEPROMId != RTL8190_EEPROM_ID )
	{
		RT_TRACE(COMP_ERR, "EEPROM ID(%#x) is invalid!!\n", EEPROMId); 
		priv->AutoloadFailFlag=true;
	}
	else
	{
		RT_TRACE(COMP_EPROM, "Autoload OK\n"); 
		priv->AutoloadFailFlag=false;
	}	

	if (priv->AutoloadFailFlag == true)
	{
		rtl8192se_config_hw_for_load_fail(dev);
		return;
	}

	rtl8192se_get_IC_Inferiority(dev);
	
	priv->eeprom_vid		= *(u16 *)&hwinfo[EEPROM_VID];
	priv->eeprom_did         = *(u16 *)&hwinfo[EEPROM_DID];
	priv->eeprom_svid		= *(u16 *)&hwinfo[EEPROM_SVID];
	priv->eeprom_smid		= *(u16 *)&hwinfo[EEPROM_SMID];
	priv->eeprom_version 	= *(u16 *)&hwinfo[EEPROM_Version];

	RT_TRACE(COMP_EPROM, "EEPROMId = 0x%4x\n", EEPROMId);
	RT_TRACE(COMP_EPROM, "EEPROM VID = 0x%4x\n", priv->eeprom_vid);
	RT_TRACE(COMP_EPROM, "EEPROM DID = 0x%4x\n", priv->eeprom_did);
	RT_TRACE(COMP_EPROM, "EEPROM SVID = 0x%4x\n", priv->eeprom_svid);
	RT_TRACE(COMP_EPROM, "EEPROM SMID = 0x%4x\n", priv->eeprom_smid);

	priv->EEPROMOptional = *(u8 *)&hwinfo[EEPROM_Optional]; 
    	priv->ShowRateMode = 2;
	priv->ieee80211->bForcedShowRxRate = false;

	if(priv->ShowRateMode == 0) {
	    if((priv->EEPROMOptional & BIT3) == 0x08/*0000_1000*/) {
		priv->ieee80211->bForcedShowRxRate = true;
	    }
	} else if(priv->ShowRateMode == 2){
		  priv->ieee80211->bForcedShowRxRate = true;
	}
	
	for(i = 0; i < 6; i += 2)
	{
		usValue = *(u16 *)&hwinfo[EEPROM_MAC_ADDR+i];
		*((u16*)(&dev->dev_addr[i])) = usValue;
	}
	for (i=0;i<6;i++)
		write_nic_byte(dev, MACIDR0+i, dev->dev_addr[i]); 	

	RT_TRACE(COMP_EPROM, "ReadAdapterInfo8192S(), Permanent Address = %02x-%02x-%02x-%02x-%02x-%02x\n", 
	dev->dev_addr[0], dev->dev_addr[1], dev->dev_addr[2], dev->dev_addr[3], 
	dev->dev_addr[4], dev->dev_addr[5]); 	

#if (EEPROM_OLD_FORMAT_SUPPORT == 1)
	for(i = 0; i < EEPROM_TX_PWR_INDEX_RANGE; i += 2)
	{
		usValue = *(u16 *)&hwinfo[EEPROM_TxPowerBase+i];
		*((u16 *)(&tmpBuffer[i])) = usValue;					
	}
	for(i=0; i<14; i++)
	{
		priv->EEPROMTxPowerLevelCCK[i] = (u8)tmpBuffer[i];
		priv->EEPROMTxPowerLevelOFDM24G[i] = (u8)tmpBuffer[i+14];
	}
		

	for(i=0; i<14; i++)
	{
		priv->TxPowerLevelOFDM24G[i] = priv->EEPROMTxPowerLevelOFDM24G[i];
		priv->TxPowerLevelCCK[i] = priv->EEPROMTxPowerLevelCCK[i];
		
		RT_TRACE(COMP_EPROM, "CH%d CCK Tx PWR IDX = 0x%02x\n", i, priv->EEPROMTxPowerLevelCCK[i]);
		RT_TRACE(COMP_EPROM, "CH%d OFDM Tx PWR IDX = 0x%02x\n", i, priv->EEPROMTxPowerLevelOFDM24G[i]);
	}

	for(i = 0; i < 6; i += 2)
	{
		usValue = *(u16 *)&hwinfo[EEPROM_HT2T_CH1_A+i];
		*((u16*)(&priv->EEPROMHT2T_TxPwr[i])) = usValue;
	}		
	for(i=0; i<6; i++)
	{
		RT_TRACE(COMP_EPROM, "EEPROMHT2T_TxPwr, Index %d = 0x%02x\n", i, priv->EEPROMHT2T_TxPwr[i]);					
	}
	
#else	

	for (rf_path = 0; rf_path < 2; rf_path++)
	{
		for (i = 0; i < 3; i++)
		{
			priv->RfCckChnlAreaTxPwr[rf_path][i] = 
			hwinfo[EEPROM_TxPowerBase+rf_path*3+i];

			priv->RfOfdmChnlAreaTxPwr1T[rf_path][i] = 
			hwinfo[EEPROM_TxPowerBase+6+rf_path*3+i];

			priv->RfOfdmChnlAreaTxPwr2T[rf_path][i] = 
			hwinfo[EEPROM_TxPowerBase+12+rf_path*3+i];
		}
	}

	for (rf_path = 0; rf_path < 2; rf_path++)
	{
		for (i = 0; i < 3; i++)
		{
			RT_TRACE(COMP_EPROM,"CCK RF-%d CHan_Area-%d = 0x%x\n",  rf_path, i,
			priv->RfCckChnlAreaTxPwr[rf_path][i]);
			RT_TRACE(COMP_EPROM, "OFDM-1T RF-%d CHan_Area-%d = 0x%x\n",  rf_path, i,
			priv->RfOfdmChnlAreaTxPwr1T[rf_path][i]);
			RT_TRACE(COMP_EPROM,"OFDM-2T RF-%d CHan_Area-%d = 0x%x\n",  rf_path, i,
			priv->RfOfdmChnlAreaTxPwr2T[rf_path][i]);			
		}

		for(i=0; i<14; i++)	
		{
			if (i < 3)			
				index = 0;
#ifdef _RTL8192_EXT_PATCH_	
			else if (i < 9)		
#else
			else if (i < 8)		
#endif
				index = 1;
			else				
				index = 2;

			priv->RfTxPwrLevelCck[rf_path][i]  = 
			priv->RfCckChnlAreaTxPwr[rf_path][index];
			priv->RfTxPwrLevelOfdm1T[rf_path][i]  = 
			priv->RfOfdmChnlAreaTxPwr1T[rf_path][index];
			priv->RfTxPwrLevelOfdm2T[rf_path][i]  = 
			priv->RfOfdmChnlAreaTxPwr2T[rf_path][index];

			if (rf_path == 0)
			{
				priv->TxPowerLevelOFDM24G[i] = priv->RfTxPwrLevelOfdm1T[rf_path][i] ;
				priv->TxPowerLevelCCK[i] = priv->RfTxPwrLevelCck[rf_path][i];					
                    }
		}

		for(i=0; i<14; i++)
		{
			RT_TRACE(COMP_EPROM, "Rf-%d TxPwr CH-%d CCK OFDM_1T OFDM_2T= 0x%x/0x%x/0x%x\n", 
			rf_path, i, priv->RfTxPwrLevelCck[rf_path][i], 
			priv->RfTxPwrLevelOfdm1T[rf_path][i] ,
			priv->RfTxPwrLevelOfdm2T[rf_path][i] );
		}
	}	

#ifndef _RTL8192_EXT_PATCH_	
	for (rf_path = 0; rf_path < 2; rf_path++)
	{
		for (i = 0; i < 3; i++)
		{
			priv->EEPROMPwrGroup[rf_path][i] = hwinfo[EEPROM_TxPWRGroup+rf_path*3+i];
		}
	}

	for (rf_path = 0; rf_path < 2; rf_path++)
	{
		for(i=0; i<14; i++)
		{
			if (i < 3)			
				index = 0;
			else if (i < 8)		
				index = 1;
			else				
				index = 2;
			priv->PwrGroupHT20[rf_path][i] = (priv->EEPROMPwrGroup[rf_path][index]&0xf);
			priv->PwrGroupHT40[rf_path][i] = ((priv->EEPROMPwrGroup[rf_path][index]&0xf0)>>4);
			RT_TRACE(COMP_INIT, "RF-%d PwrGroupHT20[%d] = 0x%x\n", rf_path, i, priv->PwrGroupHT20[rf_path][i]);
			RT_TRACE(COMP_INIT, "RF-%d PwrGroupHT40[%d] = 0x%x\n", rf_path, i, priv->PwrGroupHT40[rf_path][i]);
		}
	}
#endif

	for(i=0; i<14; i++)	
	{
		if (i < 3)			
			index = 0;
#ifdef _RTL8192_EXT_PATCH_	
			else if (i < 9)		
#else
			else if (i < 8)		
#endif
			index = 1;
		else				
			index = 2;
		
		tempval = (*(u8 *)&hwinfo[EEPROM_TX_PWR_HT20_DIFF+index])&0xff;
		priv->TxPwrHt20Diff[RF90_PATH_A][i] = (tempval&0xF);
		priv->TxPwrHt20Diff[RF90_PATH_B][i] = ((tempval>>4)&0xF);

		if (i < 3)			
			index = 0;
#ifdef _RTL8192_EXT_PATCH_	
			else if (i < 9)		
#else
			else if (i < 8)		
#endif
			index = 0x11;
		else				
			index = 1;

		tempval = (*(u8 *)&hwinfo[EEPROM_TX_PWR_OFDM_DIFF+index])&0xff;
		priv->TxPwrLegacyHtDiff[RF90_PATH_A][i] = (tempval&0xF);
		priv->TxPwrLegacyHtDiff[RF90_PATH_B][i] = ((tempval>>4)&0xF);

		tempval = (*(u8 *)&hwinfo[TX_PWR_SAFETY_CHK]);
		priv->TxPwrSafetyFlag = (tempval&0x01);		
	}
	
#ifndef _RTL8192_EXT_PATCH_	
	priv->EEPROMRegulatory = 0;
	if(priv->eeprom_version >= 2)
	{
		if(priv->eeprom_version >= 4)
			priv->EEPROMRegulatory = (hwinfo[EEPROM_Regulatory]&0x7);	
		else
			priv->EEPROMRegulatory = (hwinfo[EEPROM_Regulatory]&0x1);	
	}
	RT_TRACE(COMP_INIT, "EEPROMRegulatory = 0x%x\n", priv->EEPROMRegulatory);
#endif
	for(i=0; i<14; i++)
		RT_TRACE(COMP_EPROM, "RF-A Ht20 to HT40 Diff[%d] = 0x%x\n", i, priv->TxPwrHt20Diff[RF90_PATH_A][i]);
	for(i=0; i<14; i++)
		RT_TRACE(COMP_EPROM, "RF-A Legacy to Ht40 Diff[%d] = 0x%x\n", i, priv->TxPwrLegacyHtDiff[RF90_PATH_A][i]);
	for(i=0; i<14; i++)
		RT_TRACE(COMP_EPROM, "RF-B Ht20 to HT40 Diff[%d] = 0x%x\n", i, priv->TxPwrHt20Diff[RF90_PATH_B][i]);
	for(i=0; i<14; i++)
		RT_TRACE(COMP_EPROM, "RF-B Legacy to HT40 Diff[%d] = 0x%x\n", i, priv->TxPwrLegacyHtDiff[RF90_PATH_B][i]);
#endif	
	RT_TRACE(COMP_EPROM, "TxPwrSafetyFlag = %d\n", priv->TxPwrSafetyFlag);

	tempval = (*(u8 *)&hwinfo[EEPROM_RFInd_PowerDiff])&0xff;
	priv->EEPROMTxPowerDiff = tempval;	
#ifdef _RTL8192_EXT_PATCH_	
	priv->LegacyHTTxPowerDiff = priv->EEPROMTxPowerDiff;
#else
	priv->LegacyHTTxPowerDiff = priv->TxPwrLegacyHtDiff[RF90_PATH_A][0];
#endif

	RT_TRACE(COMP_EPROM, "TxPowerDiff = %#x\n", priv->EEPROMTxPowerDiff);

	usValue = *(u16 *)&hwinfo[EEPROM_TSSI_A];
	priv->EEPROMTSSI_A = (u8)((usValue&0xff00)>>8);
	usValue = *(u8 *)&hwinfo[EEPROM_TSSI_B];
	priv->EEPROMTSSI_B = (u8)(usValue&0xff);
	RT_TRACE(COMP_EPROM, "TSSI_A = %#x, TSSI_B = %#x\n", 
			priv->EEPROMTSSI_A, priv->EEPROMTSSI_B);
		
	tempval = *(u8 *)&hwinfo[EEPROM_ThermalMeter];
	priv->EEPROMThermalMeter = tempval;			
	RT_TRACE(COMP_EPROM, "ThermalMeter = %#x\n", priv->EEPROMThermalMeter);
	priv->ThermalMeter[0] =(priv->EEPROMThermalMeter&0x1f);
	priv->TSSI_13dBm = priv->EEPROMThermalMeter *100;
	
	tempval = *(u8 *)&hwinfo[EEPROM_BLUETOOTH_COEXIST];
	priv->EEPROMBluetoothCoexist = ((tempval&0x2)>>1);	
	priv->BluetoothCoexist = priv->EEPROMBluetoothCoexist;
	RT_TRACE(COMP_EPROM, "BlueTooth Coexistance = %#x\n", priv->BluetoothCoexist);

	tempval = (*(u8 *)&hwinfo[EEPROM_CrystalCap])>>4;
	priv->EEPROMCrystalCap =tempval;		
	RT_TRACE(COMP_EPROM, "CrystalCap = %#x\n", priv->EEPROMCrystalCap);
	priv->CrystalCap = priv->EEPROMCrystalCap;	
	
	priv->eeprom_ChannelPlan = *(u8 *)&hwinfo[EEPROM_ChannelPlan];
#ifdef _RTL8192_EXT_PATCH_	
	priv->eeprom_version = *(u16 *)&hwinfo[EEPROM_Version];
#endif
	priv->bTXPowerDataReadFromEEPORM = true;
	RT_TRACE(COMP_EPROM, "EEPROM ChannelPlan = 0x%4x\n", priv->eeprom_ChannelPlan);
	
	tempval = *(u8*)&hwinfo[EEPROM_BoardType];  
	if (tempval == 0)	
		priv->rf_type= RF_2T2R;
	else if (tempval == 1)	 
		priv->rf_type = RF_1T2R;
	else if (tempval == 2)	 
		priv->rf_type = RF_1T2R;
	else if (tempval == 3)	 
		priv->rf_type = RF_1T1R;

	priv->ieee80211->RF_Type = priv->rf_type;
	priv->ieee80211->b1x1RecvCombine = false;
	if (priv->rf_type == RF_1T2R)
	{
		tempval = read_nic_byte(dev, 0x07);
		if (!(tempval & BIT0))
		{
			priv->ieee80211->b1x1RecvCombine = true;
			RT_TRACE(COMP_INIT, "RF_TYPE=1T2R but only 1SS\n");
		}
	}
	priv->ieee80211->b1SSSupport = 	priv->ieee80211->b1x1RecvCombine;
	
	priv->rf_chip = RF_6052;

	priv->eeprom_CustomerID = *(u8 *)&hwinfo[EEPROM_CustomID];

	RT_TRACE(COMP_EPROM, "EEPROM Customer ID: 0x%2x, rf_chip:%x\n", priv->eeprom_CustomerID, priv->rf_chip);
	
	priv->ieee80211->b_customer_lenovo_id = false;
	
	switch(priv->eeprom_CustomerID)
	{	
		case EEPROM_CID_DEFAULT:
			if(priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0xE020){
				priv->CustomerID = RT_CID_819x_Lenovo;	
				priv->ieee80211->b_customer_lenovo_id = true;
                        }
			else if(priv->eeprom_svid == 0x1462 && priv->eeprom_smid == 0x6897)
				priv->CustomerID = RT_CID_819x_MSI;
			else if(priv->eeprom_svid == 0x1462 && priv->eeprom_smid == 0x3821)
				priv->CustomerID = RT_CID_819x_MSI;			
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8171 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0x8186)
				priv->CustomerID = RT_CID_819x_Acer;
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8171 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0x8187)
				priv->CustomerID = RT_CID_819x_Acer;
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8171 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0x8156)
				priv->CustomerID = RT_CID_819x_Acer;
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8171 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0x8157)
				priv->CustomerID = RT_CID_819x_Acer;
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8172 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0xE021)
				priv->CustomerID = RT_CID_819x_Acer;
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8172 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0xE022)
				priv->CustomerID = RT_CID_819x_Acer;
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8172 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0x8158)
				priv->CustomerID = RT_CID_819x_Acer;
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8172 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0x8159)
				priv->CustomerID = RT_CID_819x_Acer;
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8174 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0x8186)
				priv->CustomerID = RT_CID_819x_Acer;
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8174 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0x8187)
				priv->CustomerID = RT_CID_819x_Acer;
				else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8174 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0x8156)
				priv->CustomerID = RT_CID_819x_Acer;
			else if(	priv->eeprom_vid == 0x10EC && priv->eeprom_did == 0x8174 &&
					priv->eeprom_svid == 0x10EC && priv->eeprom_smid == 0x8157)
				priv->CustomerID = RT_CID_819x_Acer;
			else
			priv->CustomerID = RT_CID_DEFAULT;
			break;
			
		case EEPROM_CID_TOSHIBA:       
			priv->CustomerID = RT_CID_TOSHIBA;
			break;

		case EEPROM_CID_QMI:
			priv->CustomerID = RT_CID_819x_QMI;
			break;
			
		case EEPROM_CID_WHQL:
#ifdef TO_DO_LIST			
			priv->bInHctTest = true;
			priv->bSupportTurboMode = false;
			priv->bAutoTurboBy8186 = false;
			priv->PowerSaveControl.bInactivePs = false;
			priv->PowerSaveControl.bIPSModeBackup = false;
			priv->PowerSaveControl.bLeisurePs = false;
			priv->keepAliveLevel = 0;	
			priv->bUnloadDriverwhenS3S4 = false;
#endif
			break;
				
		default:
			priv->CustomerID = RT_CID_DEFAULT;
			break;
				
	}
	
	priv->LedStrategy = SW_LED_MODE0;
#ifdef _RTL8192_EXT_PATCH_	
	HalCustomizedBehavior8192S(dev);
#endif

	
	RT_TRACE(COMP_INIT, "<==== rtl8192se_read_eeprom_info\n");
}

void rtl8192se_get_eeprom_size(struct net_device* dev)
{
	struct r8192_priv* priv = ieee80211_priv(dev);
	struct ieee80211_device* ieee = priv->ieee80211;
	u8 curCR = 0;
	curCR = read_nic_byte(dev, EPROM_CMD);
	PHY_RFShadowRefresh(dev);
	if (curCR & BIT4){
		RT_TRACE(COMP_EPROM, "Boot from EEPROM\n");
		priv->epromtype = EEPROM_93C46;
	}
	else{
		RT_TRACE(COMP_EPROM, "Boot from EFUSE\n");
		priv->epromtype = EEPROM_BOOT_EFUSE;
	}
	if (curCR & BIT5){
		RT_TRACE(COMP_EPROM,"Autoload OK\n"); 
		priv->AutoloadFailFlag=false;		
		rtl8192se_read_eeprom_info(dev);
	}
	else{
		RT_TRACE(COMP_INIT, "AutoLoad Fail reported from CR9346!!\n"); 
		priv->AutoloadFailFlag=true;		
		rtl8192se_config_hw_for_load_fail(dev);		

		if (priv->epromtype == EEPROM_BOOT_EFUSE)
		{
#if (RTL92SE_FPGA_VERIFY == 0)
			EFUSE_ShadowMapUpdate(dev);
#endif
		}
	}			
#ifdef TO_DO_LIST
	if(Adapter->bInHctTest)
	{
		pMgntInfo->PowerSaveControl.bInactivePs = false;
		pMgntInfo->PowerSaveControl.bIPSModeBackup = false;
		pMgntInfo->PowerSaveControl.bLeisurePs = false;
		pMgntInfo->keepAliveLevel = 0;
	}
	
	switch(pHalData->eeprom_CustomerID)
	{
		case EEPROM_CID_DEFAULT:
			pMgntInfo->CustomerID = RT_CID_DEFAULT;
			break;
		case EEPROM_CID_TOSHIBA:       
			pMgntInfo->CustomerID = RT_CID_TOSHIBA;
			break;
		default:
			break;
	}
	
#ifdef _RTL8192_EXT_PATCH_	
	if(pHalData->eeprom_svid == 0x10EC && pHalData->eeprom_smid == 0xE020)
#else
	if(pHalData->EEPROMSVID == 0x10EC && pHalData->EEPROMSMID == 0xE020)
#endif
		pMgntInfo->CustomerID = RT_CID_819x_Lenovo;
#endif	
#ifdef ENABLE_DOT11D
	priv->ChannelPlan = COUNTRY_CODE_WORLD_WIDE_13;
#endif

	if(priv->ChannelPlan == COUNTRY_CODE_GLOBAL_DOMAIN) {
		GET_DOT11D_INFO(ieee)->bEnabled = 1;
		RT_TRACE(COMP_INIT, "%s: Enable dot11d when RT_CHANNEL_DOMAIN_GLOBAL_DOAMIN!\n", __FUNCTION__);
	}
	
	RT_TRACE(COMP_INIT, "RegChannelPlan(%d) EEPROMChannelPlan(%d)", \
			priv->RegChannelPlan, priv->eeprom_ChannelPlan);
	RT_TRACE(COMP_INIT, "ChannelPlan = %d\n" , priv->ChannelPlan);
#ifndef _RTL8192_EXT_PATCH_	
	HalCustomizedBehavior8192S(dev);
#endif
	priv->LedStrategy = SW_LED_MODE7;
}

#if (RTL92SE_FPGA_VERIFY == 1)
static void MacConfigBeforeFwDownload(struct net_device* dev)
{
	struct r8192_priv* priv = ieee80211_priv(dev);
	u8				i;
	u8				tmpU1b;
	u16				tmpU2b;
	u32				addr;
	
	RT_TRACE(COMP_INIT, "Set some register before enable NIC\r\n");

	tmpU1b = read_nic_byte(dev, 0x562);
	tmpU1b |= 0x08;
	write_nic_byte(dev, 0x562, tmpU1b);
	tmpU1b &= ~(BIT3);
	write_nic_byte(dev, 0x562, tmpU1b);
	
	tmpU1b = read_nic_byte(dev, SYS_FUNC_EN+1);
	tmpU1b &= 0x73;
	write_nic_byte(dev, SYS_FUNC_EN+1, tmpU1b);

	tmpU1b = read_nic_byte(dev, SYS_CLKR);	
	tmpU1b &= 0xfa;
	write_nic_byte(dev, SYS_CLKR, tmpU1b);

	RT_TRACE(COMP_INIT, "Delay 1000ms before reset NIC. I dont know how long should we delay!!!!!\r\n");	
	ssleep(1);

	write_nic_byte(dev, SYS_CLKR, SYS_CLKSEL_80M);
	
	tmpU1b = read_nic_byte(dev, SPS1_CTRL);	
	write_nic_byte(dev, SPS1_CTRL, (tmpU1b|SPS1_LDEN));
	
	tmpU1b = read_nic_byte(dev, AFE_MISC);	
	write_nic_byte(dev, AFE_MISC, (tmpU1b|AFE_BGEN));

	tmpU1b = read_nic_byte(dev, LDOA15_CTRL);	
	write_nic_byte(dev, LDOA15_CTRL, (tmpU1b|LDA15_EN));

	tmpU1b = read_nic_byte(dev, SPS1_CTRL);	
	write_nic_byte(dev, SPS1_CTRL, (tmpU1b|SPS1_SWEN));

	tmpU1b = read_nic_byte(dev, AFE_MISC);	
	write_nic_byte(dev, AFE_MISC, (tmpU1b|AFE_MBEN));

	tmpU2b = read_nic_word(dev, SYS_ISO_CTRL);	
	write_nic_word(dev, SYS_ISO_CTRL, (tmpU2b|ISO_PWC_DV2RP));

	tmpU2b = read_nic_word(dev, SYS_ISO_CTRL);	
	write_nic_word(dev, SYS_ISO_CTRL, (tmpU2b &(~ISO_PWC_RV2RP)));

	tmpU2b = read_nic_word(dev, AFE_XTAL_CTRL);	
	write_nic_word(dev, AFE_XTAL_CTRL, (tmpU2b &(~XTAL_GATE_AFE)));

	tmpU1b = read_nic_byte(dev, AFE_PLL_CTRL);	
	write_nic_byte(dev, AFE_PLL_CTRL, (tmpU1b|APLL_EN));

	write_nic_byte(dev, SYS_ISO_CTRL, 0xEE);

	tmpU2b = read_nic_word(dev, SYS_CLKR);	
	write_nic_word(dev, SYS_CLKR, (tmpU2b|SYS_MAC_CLK_EN));

	tmpU2b = read_nic_word(dev, SYS_FUNC_EN);	
	write_nic_word(dev, SYS_FUNC_EN, (tmpU2b|FEN_DCORE|FEN_MREGEN));

	tmpU2b = read_nic_word(dev, SYS_CLKR);	
	write_nic_word(dev, SYS_CLKR, ((tmpU2b|SYS_FWHW_SEL)&(~SYS_SWHW_SEL)));

	write_nic_byte(dev, RF_CTRL, 0);
	write_nic_byte(dev, RF_CTRL, 7);

	write_nic_word(dev, CMDR, 0x37FC);	
	
#if 1
	write_nic_byte(dev, 0x6, 0x30);
	write_nic_byte(dev, 0x49, 0xf0);

	write_nic_byte(dev, 0x4b, 0x81);

	write_nic_byte(dev, 0xb5, 0x21);

	write_nic_byte(dev, 0xdc, 0xff);
	write_nic_byte(dev, 0xdd, 0xff);	
	write_nic_byte(dev, 0xde, 0xff);
	write_nic_byte(dev, 0xdf, 0xff);

	write_nic_byte(dev, 0x11a, 0x00);
	write_nic_byte(dev, 0x11b, 0x00);

	for (i = 0; i < 32; i++)
		write_nic_byte(dev, INIMCS_SEL+i, 0x1b);	

	write_nic_byte(dev, 0x236, 0xff);
	
	write_nic_byte(dev, 0x503, 0x22);

	if(priv->bIntelBridgeExist) {
		write_nic_byte(dev, 0x560, 0x40);
#ifndef _RTL8192_EXT_PATCH_	
	} else {
		write_nic_byte(dev, 0x560, 0x00);
#endif
	}

	write_nic_byte(dev, DBG_PORT, 0x91);	
#endif

#if TODO_LIST 
	write_nic_dword(dev, RCDA, 
	pHalData->RxDescMemory[RX_CMD_QUEUE].PhysicalAddressLow);
#endif
	write_nic_dword(dev, RDQDA, priv->rx_ring_dma);
	rtl8192_tx_enable(dev);
	
	RT_TRACE(COMP_INIT, "<---MacConfig8192SE()\n");

}	/* MacConfigBeforeFwDownload */
#else
void gen_RefreshLedState(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	PLED_8190 pLed0 = &(priv->SwLed0);	

	if(priv->bfirst_init)
	{
		printk("gen_RefreshLedState first init\n");
		return;
	}

	if(priv->ieee80211->RfOffReason == RF_CHANGE_BY_IPS )
	{
		SwLedOn(dev, pLed0);
	}
	else		
	{
		SwLedOff(dev, pLed0);		
	}

}	
static void MacConfigBeforeFwDownload(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);	
	u8				i;
	u8				tmpU1b;
	u16				tmpU2b;
	u8				PollingCnt = 20;

	RT_TRACE(COMP_INIT, "--->MacConfigBeforeFwDownload()\n");
	if(priv->bfirst_init)
	{
		tmpU1b = read_nic_byte(dev, SYS_FUNC_EN+1);
		tmpU1b &= 0xFE;
		write_nic_byte(dev, SYS_FUNC_EN+1, tmpU1b);
		udelay(1);
		write_nic_byte(dev, SYS_FUNC_EN+1, tmpU1b|BIT0);
	}
	tmpU1b = read_nic_byte(dev, (SYS_CLKR + 1));
	if(tmpU1b & BIT7)
	{
		tmpU1b &= ~(BIT6 | BIT7);
		if(!HalSetSysClk8192SE(dev, tmpU1b))
			return; 
	}
        write_nic_byte(dev, AFE_PLL_CTRL, 0x0);
        write_nic_byte(dev, LDOA15_CTRL, 0x34);

	write_nic_byte(dev, RPWM, 0x0);

	tmpU1b = read_nic_byte(dev, SYS_FUNC_EN+1);
	tmpU1b &= 0x73;
	write_nic_byte(dev, SYS_FUNC_EN+1, tmpU1b);
	mdelay(1);
	
	write_nic_byte(dev, CMDR, 0);
	write_nic_byte(dev, TCR, 0);

#if (DEMO_BOARD_SUPPORT == 0)
	tmpU1b = read_nic_byte(dev, SPS1_CTRL);
	tmpU1b &= 0xfc;
	write_nic_byte(dev, SPS1_CTRL, tmpU1b);
#endif

	tmpU1b = read_nic_byte(dev, 0x562);
	tmpU1b |= 0x08;
	write_nic_byte(dev, 0x562, tmpU1b);
	tmpU1b &= ~(BIT3);
	write_nic_byte(dev, 0x562, tmpU1b);
	


	

	RT_TRACE(COMP_INIT, "Enable AFE clock source\r\n");	
	tmpU1b = read_nic_byte(dev, AFE_XTAL_CTRL);	
	write_nic_byte(dev, AFE_XTAL_CTRL, (tmpU1b|0x01));
	udelay(2000);	
	tmpU1b = read_nic_byte(dev, AFE_XTAL_CTRL+1);	
	write_nic_byte(dev, AFE_XTAL_CTRL+1, (tmpU1b&0xfb));


	RT_TRACE(COMP_INIT, "Enable AFE Macro Block's Bandgap\r\n");	
	tmpU1b = read_nic_byte(dev, AFE_MISC);	
	write_nic_byte(dev, AFE_MISC, (tmpU1b|BIT0));
	mdelay(1);

	RT_TRACE(COMP_INIT, "Enable AFE Mbias\r\n");	
	tmpU1b = read_nic_byte(dev, AFE_MISC);	
	write_nic_byte(dev, AFE_MISC, (tmpU1b|0x02));
	mdelay(1);
	
	tmpU1b = read_nic_byte(dev, LDOA15_CTRL);	
	write_nic_byte(dev, LDOA15_CTRL, (tmpU1b|BIT0));



	tmpU2b = read_nic_word(dev, SYS_ISO_CTRL);	
	write_nic_word(dev, SYS_ISO_CTRL, (tmpU2b|BIT11));


	tmpU2b = read_nic_word(dev, SYS_FUNC_EN);
#ifdef _RTL8192_EXT_PATCH_	
	write_nic_word(dev, SYS_FUNC_EN, tmpU2b |= BIT13);
#else
	write_nic_word(dev, SYS_FUNC_EN, (tmpU2b |BIT13));
#endif


	write_nic_byte(dev, SYS_ISO_CTRL+1, 0x68);

	udelay(200);
	tmpU1b = read_nic_byte(dev, AFE_PLL_CTRL);	
	write_nic_byte(dev, AFE_PLL_CTRL, (tmpU1b|BIT0|BIT4));

#if 1 
	udelay(100);
	write_nic_byte(dev, AFE_PLL_CTRL, (tmpU1b|BIT0|BIT4|BIT6));
	udelay(10);
	write_nic_byte(dev, AFE_PLL_CTRL, (tmpU1b|BIT0|BIT4));
	udelay(10);
#endif
	tmpU1b = read_nic_byte(dev, AFE_PLL_CTRL+1);	
	write_nic_byte(dev, AFE_PLL_CTRL+1, (tmpU1b|BIT0));
	mdelay(1);

	write_nic_byte(dev, SYS_ISO_CTRL, 0xA6);

	tmpU2b = read_nic_word(dev, SYS_CLKR);	
	write_nic_word(dev, SYS_CLKR, (tmpU2b|BIT12|BIT11));

	tmpU2b = read_nic_word(dev, SYS_FUNC_EN);	
	write_nic_word(dev, SYS_FUNC_EN, (tmpU2b|BIT11));

	tmpU1b = read_nic_byte(dev, SYS_FUNC_EN+1);
	write_nic_byte(dev, SYS_FUNC_EN+1, tmpU1b&~(BIT7));
	
	write_nic_word(dev, SYS_FUNC_EN, (tmpU2b|BIT11|BIT15));

	 tmpU2b = read_nic_word(dev, SYS_CLKR);	
	write_nic_word(dev, SYS_CLKR, (tmpU2b&(~BIT2)));

	tmpU1b = read_nic_byte(dev, (SYS_CLKR + 1));
	tmpU1b = ((tmpU1b | BIT7) & (~BIT6));
	if(!HalSetSysClk8192SE(dev, tmpU1b))
		return; 

#if 0	
	tmpU2b = read_nic_word(dev, SYS_CLKR);	
	write_nic_word(dev, SYS_CLKR, ((tmpU2b|BIT15)&(~BIT14)));
#endif

	write_nic_word(dev, CMDR, 0x07FC);
	
#if 1
	write_nic_byte(dev, 0x6, 0x30);
	write_nic_byte(dev, 0x49, 0xf0);

	write_nic_byte(dev, 0x4b, 0x81);

	write_nic_byte(dev, 0xb5, 0x21);

	write_nic_byte(dev, 0xdc, 0xff);
	write_nic_byte(dev, 0xdd, 0xff);	
	write_nic_byte(dev, 0xde, 0xff);
	write_nic_byte(dev, 0xdf, 0xff);

	write_nic_byte(dev, 0x11a, 0x00);
	write_nic_byte(dev, 0x11b, 0x00);

	for (i = 0; i < 32; i++)
		write_nic_byte(dev, INIMCS_SEL+i, 0x1b);	

	write_nic_byte(dev, 0x236, 0xff);
	
	write_nic_byte(dev, 0x503, 0x22);
	if (priv->pci_bridge_vendor & (PCI_BRIDGE_VENDOR_INTEL | PCI_BRIDGE_VENDOR_SIS)) {
		write_nic_byte(dev, 0x560, 0x40);
	} else {
		write_nic_byte(dev, 0x560, 0x00);
	}

	write_nic_byte(dev, DBG_PORT, 0x91);	
#endif

	write_nic_dword(dev, RDQDA, priv->rx_ring_dma);
#if 0
	write_nic_dword(dev, RCDA, 
	pHalData->RxDescMemory[RX_CMD_QUEUE].PhysicalAddressLow);
#endif	
	rtl8192_tx_enable(dev);

	write_nic_word(dev, CMDR, 0x37FC);
	do {
		tmpU1b = read_nic_byte(dev, TCR);
		if((tmpU1b & TXDMA_INIT_VALUE) == TXDMA_INIT_VALUE)
			break;	

		udelay(5);
	} while(PollingCnt--);	
	
	if(PollingCnt <= 0 )
	{
		RT_TRACE(COMP_ERR, "MacConfigBeforeFwDownloadASIC(): Polling TXDMA_INIT_VALUE timeout!! Current TCR(%#x)\n", tmpU1b);
		tmpU1b = read_nic_byte(dev, CMDR);			
		write_nic_byte(dev, CMDR, tmpU1b&(~TXDMA_EN));
		udelay(2);
		write_nic_byte(dev, CMDR, tmpU1b|TXDMA_EN);
	}

	gen_RefreshLedState(dev);

	RT_TRACE(COMP_INIT, "<---MacConfigBeforeFwDownload()\n");

}	/* MacConfigBeforeFwDownload */
#endif

static void MacConfigAfterFwDownload(struct net_device* dev)
{
	u8				i;
	u16				tmpU2b;
	struct r8192_priv* priv = ieee80211_priv(dev);

	
#ifdef _RTL8192_EXT_PATCH_	
	write_nic_word(dev, CMDR, 
	BBRSTn|BB_GLB_RSTn|SCHEDULE_EN|MACRXEN|MACTXEN|DDMA_EN|FW2HW_EN|
	RXDMA_EN|TXDMA_EN|HCI_RXDMA_EN|HCI_TXDMA_EN);
#else
	write_nic_byte(dev, CMDR, 
	(u8)(BBRSTn|BB_GLB_RSTn|SCHEDULE_EN|MACRXEN|MACTXEN|DDMA_EN|FW2HW_EN|
	RXDMA_EN|TXDMA_EN|HCI_RXDMA_EN|HCI_TXDMA_EN));
#endif
	write_nic_dword(dev, TCR, 
	read_nic_dword(dev, TCR)|TXDMAPRE2FULL);
	write_nic_dword(dev, RCR, priv->ReceiveConfig);

#if 0
	for (i=0;i<6;i++)
	write_nic_byte(dev, MACIDR0+i, dev->dev_addr[i]); 	
#endif
	write_nic_word(dev, SIFS_CCK, 0x0a0a); 
	write_nic_word(dev, SIFS_OFDM, 0x1010);
	write_nic_byte(dev, ACK_TIMEOUT, 0x40);
	
	write_nic_word(dev, BCN_INTERVAL, 100);
	write_nic_word(dev, ATIMWND, 2);	
#ifdef _ENABLE_SW_BEACON
        write_nic_word(dev, BCN_DRV_EARLY_INT, BIT15);
#endif        

#if 0
	write_nic_dword(dev, RQPN1,  
	NUM_OF_PAGE_IN_FW_QUEUE_BK<<0 | NUM_OF_PAGE_IN_FW_QUEUE_BE<<8 |\
	NUM_OF_PAGE_IN_FW_QUEUE_VI<<16 | NUM_OF_PAGE_IN_FW_QUEUE_VO<<24);												
	write_nic_dword(dev, RQPN2, 
	NUM_OF_PAGE_IN_FW_QUEUE_HCCA << 0 | NUM_OF_PAGE_IN_FW_QUEUE_CMD << 8|\
	NUM_OF_PAGE_IN_FW_QUEUE_MGNT << 16 |NUM_OF_PAGE_IN_FW_QUEUE_HIGH << 24);
	write_nic_dword(dev, RQPN3, 
	NUM_OF_PAGE_IN_FW_QUEUE_BCN<<0 | NUM_OF_PAGE_IN_FW_QUEUE_PUB<<8);
	write_nic_byte(dev, LD_RQPN, BIT7);
#endif




	write_nic_byte(dev, RXDMA, 
							read_nic_byte(dev, RXDMA)|BIT6);

	if (priv->card_8192_version== VERSION_8192S_ACUT)
		write_nic_byte(dev, RRSR, 0xf0);
#ifdef _RTL8192_EXT_PATCH_	
	else if (priv->card_8192_version == VERSION_8192S_BCUT)
		write_nic_byte(dev, RRSR, 0xff);
#endif
	write_nic_byte(dev, RRSR+1, 0x01);
	write_nic_byte(dev, RRSR+2, 0x00);

	for (i = 0; i < 8; i++)
	{

		if (priv->card_8192_version == VERSION_8192S_ACUT)
			write_nic_dword(dev, ARFR0+i*4, 0x1f0ff0f0);
		else if (priv->card_8192_version == VERSION_8192S_BCUT)
			write_nic_dword(dev, ARFR0+i*4, 0x1f0ff0f0);
	}

	write_nic_byte(dev, AGGLEN_LMT_H, 0x0f);
	write_nic_word(dev, AGGLEN_LMT_L, 0x7442);
	write_nic_word(dev, AGGLEN_LMT_L+2, 0xddd7);
	write_nic_word(dev, AGGLEN_LMT_L+4, 0xd772);
	write_nic_word(dev, AGGLEN_LMT_L+6, 0xfffd);

	write_nic_dword(dev, DARFRC, 0x04010000);
	write_nic_dword(dev, DARFRC+4, 0x09070605);
	write_nic_dword(dev, RARFRC, 0x04010000);
	write_nic_dword(dev, RARFRC+4, 0x09070605);

	
	
	write_nic_word(dev, SG_RATE, 0xFFFF);


	write_nic_word(dev, NAV_PROT_LEN, 0x0080);	
	write_nic_byte(dev, CFEND_TH, 0xFF);	
	write_nic_byte(dev, AMPDU_MIN_SPACE, 0x07);
	write_nic_byte(dev, TXOP_STALL_CTRL, 0x00);
	

	/*write_nic_byte(dev, PCIF, ((MXDMA2_NoLimit<<MXDMA2_RX_SHIFT) | \
											(MXDMA2_NoLimit<<MXDMA2_TX_SHIFT) | \
											(1<<MULRW_SHIFT)));*/

	write_nic_byte(dev, RXDRVINFO_SZ, 4);  

	tmpU2b= read_nic_byte(dev, SYS_FUNC_EN);
	write_nic_byte(dev, SYS_FUNC_EN, tmpU2b | BIT13);  
	tmpU2b= read_nic_byte(dev, SYS_ISO_CTRL);
	write_nic_byte(dev, SYS_ISO_CTRL, tmpU2b & (~BIT8));  

	if (priv->epromtype == EEPROM_BOOT_EFUSE)	
	{	
		u8	tempval;		
		
		tempval = read_nic_byte(dev, SYS_ISO_CTRL+1); 
		tempval &= 0xFE;
		write_nic_byte(dev, SYS_ISO_CTRL+1, tempval); 


		
		write_nic_byte(dev, EFUSE_CTRL+3, 0x72); 
		RT_TRACE(COMP_INIT, "EFUSE CONFIG OK\n");
	}
	RT_TRACE(COMP_INIT, "MacConfigAfterFwDownload OK\n");

}	/* MacConfigAfterFwDownload */

static void rtl8192se_HalDetectPwrDownMode(struct net_device*dev)
{
    u8 tmpvalue;
    struct r8192_priv *priv = ieee80211_priv(dev);	
    EFUSE_ShadowRead(dev, 1, 0x78, (u32 *)&tmpvalue);

    if (tmpvalue & BIT0) {
        priv->pwrdown = true;
    } else {
        priv->pwrdown = false;
    }
}

void HwConfigureRTL8192SE(struct net_device *dev)
{

	struct r8192_priv* priv = ieee80211_priv(dev);
	
	u8	regBwOpMode = 0;
	u32	regRATR = 0, regRRSR = 0;
	u8	regTmp = 0;


	switch(priv->ieee80211->mode)
	{
	case WIRELESS_MODE_B:
		regBwOpMode = BW_OPMODE_20MHZ;
		regRATR = RATE_ALL_CCK;
		regRRSR = RATE_ALL_CCK;
		break;
	case WIRELESS_MODE_A:
		regBwOpMode = BW_OPMODE_5G |BW_OPMODE_20MHZ;
		regRATR = RATE_ALL_OFDM_AG;
		regRRSR = RATE_ALL_OFDM_AG;
		break;
	case WIRELESS_MODE_G:
		regBwOpMode = BW_OPMODE_20MHZ;
		regRATR = RATE_ALL_CCK | RATE_ALL_OFDM_AG;
		regRRSR = RATE_ALL_CCK | RATE_ALL_OFDM_AG;
		break;
	case WIRELESS_MODE_AUTO:
	case WIRELESS_MODE_N_24G:
			regBwOpMode = BW_OPMODE_20MHZ;
			regRATR = RATE_ALL_CCK | RATE_ALL_OFDM_AG | RATE_ALL_OFDM_1SS | RATE_ALL_OFDM_2SS;
			regRRSR = RATE_ALL_CCK | RATE_ALL_OFDM_AG;
		break;
	case WIRELESS_MODE_N_5G:
		regBwOpMode = BW_OPMODE_5G;
		regRATR = RATE_ALL_OFDM_AG | RATE_ALL_OFDM_1SS | RATE_ALL_OFDM_2SS;
		regRRSR = RATE_ALL_OFDM_AG;
		break;
	default:
		regBwOpMode = BW_OPMODE_20MHZ;
		regRATR = RATE_ALL_CCK | RATE_ALL_OFDM_AG;
		regRRSR = RATE_ALL_CCK | RATE_ALL_OFDM_AG;
		break;
	}

	regTmp = read_nic_byte(dev, INIRTSMCS_SEL);
#if (RTL8192SU_DISABLE_CCK_RATE == 1)
	regRRSR = ((regRRSR & 0x000ffff0)<<8) | regTmp;
#else
	regRRSR = ((regRRSR & 0x000fffff)<<8) | regTmp;
#endif
	write_nic_dword(dev, INIRTSMCS_SEL, regRRSR);

	write_nic_byte(dev, BW_OPMODE, regBwOpMode);
	priv->ieee80211->SetHwRegHandler(dev, HW_VAR_RETRY_LIMIT, (u8*)(&priv->ShortRetryLimit));

	write_nic_byte(dev, MLT, 0x8f);


		
#if 1
	switch(priv->rf_type)
	{
		case RF_1T2R:
		case RF_1T1R:
			RT_TRACE(COMP_INIT, "Initializeadapter: RF_Type%s\n", priv->rf_type==RF_1T1R? "(1T1R)":"(1T2R)");
                priv->ieee80211->MinSpaceCfg = (MAX_MSS_DENSITY_1T<<3);						
			break;
		case RF_2T2R:
		case RF_2T2R_GREEN:
			RT_TRACE(COMP_INIT, "Initializeadapter:RF_Type(2T2R)\n");
                priv->ieee80211->MinSpaceCfg = (MAX_MSS_DENSITY_2T<<3);			
			break;
	}
	write_nic_byte(dev, AMPDU_MIN_SPACE, priv->ieee80211->MinSpaceCfg);
#else
	priv->ieee80211->MinSpaceCfg = 0x90;	
	SetHwReg8192SE(dev, HW_VAR_AMPDU_MIN_SPACE, (u8*)(&priv->ieee80211->MinSpaceCfg));
#endif
}

void 
RF_RECOVERY(struct net_device*dev)
{
	u8 offset = 0x25;
	for(;offset<0x29;offset++)
	{
		PHY_RFShadowCompareFlagSet(dev, (RF90_RADIO_PATH_E)0, offset,true);
		if(PHY_RFShadowCompare(dev, (RF90_RADIO_PATH_E)0, offset))
		{
			PHY_RFShadowRecorverFlagSet(dev, (RF90_RADIO_PATH_E)0, offset, true);
			PHY_RFShadowRecorver( dev, (RF90_RADIO_PATH_E)0, offset);
		}
	}
}

bool rtl8192se_adapter_start(struct net_device* dev)
{ 	
	struct r8192_priv *priv = ieee80211_priv(dev);	
	bool rtStatus 	= true;	
	u8				tmpU1b;
	u8				eRFPath;
	u8				fw_download_times = 1;
	u8				i=0;
	RT_TRACE(COMP_INIT, "rtl8192se_adapter_start()\n");
	priv->being_init_adapter = true;	
#ifdef RTL8192SE_CONFIG_ASPM_OR_D3
	RT_DISABLE_ASPM(dev);
#endif
start:
	rtl8192_pci_resetdescring(dev);
	MacConfigBeforeFwDownload(dev);

	priv->card_8192_version 
	= (VERSION_8192S)((read_nic_dword(dev, PMC_FSM)>>16)&0xF);

	printk("=================> NIC version : %s\n", ((read_nic_dword(dev, PMC_FSM)>>15)&0x1)?"C-cut":"B-cut");

	rtStatus = FirmwareDownload92S((struct net_device*)dev); 
	if(rtStatus != true)
	{
		if(fw_download_times <= 10){
			RT_TRACE(COMP_INIT, "rtl8192se_adapter_start(): Download Firmware failed %d times, Download again!!\n",fw_download_times);
			fw_download_times = fw_download_times + 1;
			goto start;
		}else{
			RT_TRACE(COMP_INIT, "rtl8192se_adapter_start(): Download Firmware failed 10, end!!\n");
			goto end;
		}
	}

	MacConfigAfterFwDownload(dev);

	priv->FwCmdIOMap = 	read_nic_word(dev, LBUS_MON_ADDR);
	priv->FwCmdIOParam = read_nic_dword(dev, LBUS_ADDR_MASK);

	
#if (RTL8192S_DISABLE_FW_DM == 1)
	write_nic_dword(dev, WFM5, FW_DM_DISABLE); 
	ChkFwCmdIoDone(dev);
	write_nic_dword(dev, WFM5, FW_TXANT_SWITCH_DISABLE); 
	ChkFwCmdIoDone(dev);
#endif

#if (HAL_MAC_ENABLE == 1)
	RT_TRACE(COMP_INIT, "MAC Config Start!\n");
	if (PHY_MACConfig8192S(dev) != true)
	{
		RT_TRACE(COMP_ERR, "MAC Config failed\n");
		return rtStatus;
	}
	RT_TRACE(COMP_INIT, "MAC Config Finished!\n");
#endif	

	write_nic_dword(dev, CMDR, 0x37FC); 

#if (HAL_BB_ENABLE == 1)
	RT_TRACE(COMP_INIT, "BB Config Start!\n");
	if (PHY_BBConfig8192S(dev) != true)
	{
		RT_TRACE(COMP_INIT, "BB Config failed\n");
		return rtStatus;
	}
	RT_TRACE(COMP_INIT, "BB Config Finished!\n");
#endif	


	priv->Rf_Mode = RF_OP_By_SW_3wire;
#if (HAL_RF_ENABLE == 1)		
	RT_TRACE(COMP_INIT, "RF Config started!\n");

#if (RTL92SE_FPGA_VERIFY == 0)
	write_nic_byte(dev, AFE_XTAL_CTRL+1, 0xDB);
	if(priv->card_8192_version== VERSION_8192S_ACUT)
		write_nic_byte(dev, SPS1_CTRL+3, 0x07);
	else
		write_nic_byte(dev, RF_CTRL, 0x07);
#endif	
	if(PHY_RFConfig8192S(dev) != true)
	{
		RT_TRACE(COMP_ERR, "RF Config failed\n");
		return rtStatus;
	}
	RT_TRACE(COMP_INIT, "RF Config Finished!\n");	
#endif	


	priv->RfRegChnlVal[0] = rtl8192_phy_QueryRFReg(dev, (RF90_RADIO_PATH_E)0, RF_CHNLBW, bRFRegOffsetMask);
	priv->RfRegChnlVal[1] = rtl8192_phy_QueryRFReg(dev, (RF90_RADIO_PATH_E)1, RF_CHNLBW, bRFRegOffsetMask);

	rtl8192_setBBreg(dev, rFPGA0_RFMOD, bCCKEn, 0x1);
	rtl8192_setBBreg(dev, rFPGA0_RFMOD, bOFDMEn, 0x1);
	
	HwConfigureRTL8192SE(dev);

	if(priv->ResetProgress == RESET_TYPE_NORESET)
		rtl8192_SetWirelessMode(dev, priv->ieee80211->mode);
	CamResetAllEntry(dev);
	{
		u8 SECR_value = 0x0;
		SECR_value |= SCR_TxEncEnable;
		SECR_value |= SCR_RxDecEnable;
		SECR_value |= SCR_NoSKMC;
		write_nic_byte(dev, SECR, SECR_value);
	}

	{
		int i;
		for (i=0; i<4; i++)
		 write_nic_dword(dev, WDCAPARA_ADD[i], 0x5e4322); 
	}
	{
		PHY_GetHWRegOriginalValue(dev);
#ifndef CONFIG_MP
		rtl8192_phy_setTxPower(dev, priv->chan);
#endif
	}

	rtl8192se_HalDetectPwrDownMode(dev);
#if 1
	if(priv->RegRfOff == true)
	{ 
		RT_TRACE((COMP_INIT|COMP_RF), "InitializeAdapter8190(): Turn off RF for RegRfOff ----------\n");
		MgntActSet_RF_State(dev, eRfOff, RF_CHANGE_BY_SW);

		for(eRFPath = 0; eRFPath <priv->NumTotalRFPath; eRFPath++)
			rtl8192_phy_SetRFReg(dev, (RF90_RADIO_PATH_E)eRFPath, 0x4, 0xC00, 0x0);
	
	}
	else if(priv->ieee80211->RfOffReason > RF_CHANGE_BY_PS)
	{ 
		RT_TRACE((COMP_INIT|COMP_RF), "InitializeAdapter8190(): Turn off RF for RfOffReason(%d) ----------\n", priv->ieee80211->RfOffReason);
		MgntActSet_RF_State(dev, eRfOff, priv->ieee80211->RfOffReason);
	}
	else
	{
            if(priv->bHwRadioOff == false){
		priv->ieee80211->eRFPowerState = eRfOn;
		priv->ieee80211->RfOffReason = 0; 
		if(priv->ieee80211->LedControlHandler)
			priv->ieee80211->LedControlHandler(dev, LED_CTL_POWER_ON);
	}		
	}		
#endif


	
	{
		int i;
		for (i=0;i<6;i++)
			write_nic_byte(dev, MACIDR0+i, dev->dev_addr[i]); 	
	}

	tmpU1b = read_nic_byte(dev, MAC_PINMUX_CFG);
	write_nic_byte(dev, MAC_PINMUX_CFG, tmpU1b&(~BIT3));
	
	if(priv->CustomerID == RT_CID_CCX)
	{
		RT_TRACE(COMP_INIT ,"InitializeAdapter8192SE(): Set FW Cmd FW_TX_FEEDBACK_CCX_ENABLE\n");
		write_nic_dword(dev, WFM5, FW_TX_FEEDBACK_CCX_ENABLE); 
		ChkFwCmdIoDone(dev);
		
		write_nic_dword(dev, WFM5, FW_HIGH_PWR_DISABLE); 
		ChkFwCmdIoDone(dev);
		write_nic_dword(dev, WFM5, FW_DIG_HALT);
		ChkFwCmdIoDone(dev);

		write_nic_byte(dev, 0xC50, 0x1C);
		write_nic_byte(dev, 0xC58, 0x1C);
	}
	
	if(priv->pFirmware->FirmwareVersion >= 0x35)
	{
		priv->ieee80211->SetFwCmdHandler(dev, FW_CMD_RA_INIT);
	}
       else if(priv->pFirmware->FirmwareVersion >= 0x34) 
	{
		write_nic_dword(dev, WFM5, FW_RA_INIT); 
		ChkFwCmdIoDone(dev);
	}
	else
	{
	write_nic_dword(dev, WFM5, FW_RA_RESET); 
	ChkFwCmdIoDone(dev);
	write_nic_dword(dev, WFM5, FW_RA_ACTIVE); 
	ChkFwCmdIoDone(dev);
	write_nic_dword(dev, WFM5, FW_RA_REFRESH); 
		ChkFwCmdIoDone(dev);
        }
	
	

		PHY_SwitchEphyParameter(dev);
	RF_RECOVERY(dev);

	priv->SilentResetRxSoltNum = 4;	
	priv->SilentResetRxSlotIndex = 0;
	for( i=0; i < MAX_SILENT_RESET_RX_SLOT_NUM; i++ )
	{
		priv->SilentResetRxStuckEvent[i] = 0;
	}

	if(priv->BluetoothCoexist)
	{
		printk("Write reg 0x%x = 1 for Bluetooth Co-existance\n", SYSF_CFG);
		write_nic_byte(dev, SYSF_CFG, 0x1);
	}		
	
	priv->bIgnoreSilentReset = true;
	
	rtl8192_irq_enable(dev);
end:
	priv->being_init_adapter = false;
	return rtStatus;

	
}

void rtl8192se_net_update(struct net_device *dev)
{

	struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_network *net = &priv->ieee80211->current_network;
	u16 rate_config = 0;
	u32 regTmp = 0;
	u8 rateIndex = 0;
	u8	RetryLimit = 0x30;
	u16 cap = net->capability;

	priv->short_preamble = cap & WLAN_CAPABILITY_SHORT_PREAMBLE;
	
	{
	rtl8192_config_rate(dev, &rate_config);	
	if (priv->card_8192_version== VERSION_8192S_ACUT)
		priv->basic_rate = rate_config  = rate_config & 0x150;
	else if (priv->card_8192_version == VERSION_8192S_BCUT)
		priv->basic_rate= rate_config = rate_config & 0x15f;

#if 1	
  	if(priv->ieee80211->pHTInfo->IOTPeer == HT_IOT_PEER_CISCO && ((rate_config &0x150)==0))
	{
		rate_config |=0x010;
	}
	if(priv->ieee80211->pHTInfo->IOTPeer & HT_IOT_ACT_WA_IOT_Broadcom)
	{	
		rate_config &= 0x1f0;
		printk("HW_VAR_BASIC_RATE, HT_IOT_ACT_WA_IOT_Broadcom, BrateCfg = 0x%x\n", rate_config);
	}

			write_nic_byte(dev, RRSR, rate_config&0xff);
			write_nic_byte(dev, RRSR+1, (rate_config>>8)&0xff);

			while(rate_config > 0x1)
			{
				rate_config = (rate_config>> 1);
				rateIndex++;
			}
			write_nic_byte(dev, INIRTSMCS_SEL, rateIndex);

			regTmp = (priv->nCur40MhzPrimeSC) << 5;
			if (priv->short_preamble)
				regTmp |= 0x80;
			write_nic_byte(dev, RRSR+2, regTmp);
#endif
	}

	write_nic_dword(dev,BSSIDR,((u32*)net->bssid)[0]);
	write_nic_word(dev,BSSIDR+4,((u16*)net->bssid)[2]);

	if (priv->ieee80211->iw_mode == IW_MODE_ADHOC){
		RetryLimit = HAL_RETRY_LIMIT_AP_ADHOC;
	} else {
		RetryLimit = (priv->CustomerID == RT_CID_CCX) ? 7 : HAL_RETRY_LIMIT_INFRA;
	}	
	priv->ieee80211->SetHwRegHandler(dev, HW_VAR_RETRY_LIMIT, (u8*)(&RetryLimit));
		
	if (priv->ieee80211->iw_mode == IW_MODE_ADHOC){
		priv->ieee80211->SetHwRegHandler( dev, HW_VAR_BEACON_INTERVAL, (u8*)(&net->beacon_interval));
	}
			
	rtl8192_update_cap(dev, cap);
}

#ifdef _RTL8192_EXT_PATCH_
void rtl8192se_mesh_net_update(struct net_device *dev)
{

	struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_network *net = &priv->ieee80211->current_mesh_network;
	u16 rate_config = 0;
	u32 regTmp = 0;
	u8 rateIndex = 0;
	u8	retrylimit = 0x7;
	u16 cap = net->capability;
	/* At the peer mesh mode, the peer MP shall recognize the short preamble */
	priv->short_preamble = 1;
	
	if (priv->card_8192_version== VERSION_8192S_ACUT)
		priv->basic_rate = rate_config  = 0x150;
	else if (priv->card_8192_version == VERSION_8192S_BCUT)
		priv->basic_rate= rate_config = 0x15f;

	write_nic_byte(dev, RRSR, rate_config&0xff);
	write_nic_byte(dev, RRSR+1, (rate_config>>8)&0xff);

	while(rate_config > 0x1)
	{
		rate_config = (rate_config>> 1);
		rateIndex++;
	}
	write_nic_byte(dev, INIRTSMCS_SEL, rateIndex);

	regTmp = (priv->nCur40MhzPrimeSC) << 5;
	if (priv->short_preamble)
		regTmp |= 0x80;
	write_nic_byte(dev, RRSR+2, regTmp);


	write_nic_word(dev, BCN_INTERVAL, net->beacon_interval);
	PHY_SetBeaconHwReg( dev, net->beacon_interval);
	rtl8192_update_cap(dev, cap);
	
	priv->ShortRetryLimit = 
		priv->LongRetryLimit = retrylimit;
			
	write_nic_word(dev,RETRY_LIMIT, \
			retrylimit << RETRY_LIMIT_SHORT_SHIFT | \
			retrylimit << RETRY_LIMIT_LONG_SHIFT);	
}
#endif

void rtl8192se_link_change(struct net_device *dev)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	struct ieee80211_device* ieee = priv->ieee80211;
	u32 reg = 0;
	reg = read_nic_dword(dev, RCR);
#ifdef _RTL8192_EXT_PATCH_
	printk("===>%s():ieee->iw_mode is %d\n",__FUNCTION__,ieee->iw_mode);
	if (ieee->state == IEEE80211_LINKED) {
		if(ieee->pHTInfo->IOTAction & HT_IOT_ACT_DISABLE_HIGH_POWER)
			ieee->SetFwCmdHandler(dev, FW_CMD_HIGH_PWR_DISABLE);
		else
			ieee->SetFwCmdHandler(dev, FW_CMD_HIGH_PWR_ENABLE);
		rtl8192se_net_update(dev);
		if(ieee->bUseRAMask){
			ieee->UpdateHalRAMaskHandler(
									dev,
									false,
									0,
									NULL,
									ieee->mode,
									0);
			priv->rssi_level = 0;
		}
		else{
			rtl8192se_update_ratr_table(dev,ieee->dot11HTOperationalRateSet,NULL);
		}
		priv->ReceiveConfig = reg |= RCR_CBSSID;
	} else if ((ieee->mesh_state == IEEE80211_MESH_LINKED) && ieee->only_mesh) {
		rtl8192se_mesh_net_update(dev);
		priv->ReceiveConfig = reg &= ~RCR_CBSSID;
	} else{
		priv->ReceiveConfig = reg &= ~RCR_CBSSID;
	}
	write_nic_dword(dev, RCR, reg);
#else
	if (ieee->state == IEEE80211_LINKED) {
		if(priv->DM_Type == DM_Type_ByFW) {
		if(ieee->pHTInfo->IOTAction & HT_IOT_ACT_DISABLE_HIGH_POWER)
			ieee->SetFwCmdHandler(dev, FW_CMD_HIGH_PWR_DISABLE);
		else
			ieee->SetFwCmdHandler(dev, FW_CMD_HIGH_PWR_ENABLE);	
		}

		rtl8192se_net_update(dev);
		rtl8192se_update_ratr_table(dev,ieee->dot11HTOperationalRateSet,NULL);
		priv->ReceiveConfig = reg |= RCR_CBSSID;
	} else {
		priv->ReceiveConfig = reg &= ~RCR_CBSSID;
	}
	write_nic_dword(dev, RCR, reg);
#endif	
	rtl8192_update_msr(dev);
	{		
		u32	temp = read_nic_dword(dev, TCR);
		write_nic_dword(dev, TCR, temp&(~BIT8));
		write_nic_dword(dev, TCR, temp|BIT8);
	}
	
}

u8 MRateToHwRate8192SE(struct net_device*dev, u8 rate)
{
	u8	ret = DESC92S_RATE1M;
	u16	max_sg_rate;
	static	u16	multibss_sg_old = 0x1234;
	u16	multibss_sg;
		
	switch(rate)
	{
	case MGN_1M:	ret = DESC92S_RATE1M;		break;
	case MGN_2M:	ret = DESC92S_RATE2M;		break;
	case MGN_5_5M:	ret = DESC92S_RATE5_5M;	break;
	case MGN_11M:	ret = DESC92S_RATE11M;	break;
	case MGN_6M:	ret = DESC92S_RATE6M;		break;
	case MGN_9M:	ret = DESC92S_RATE9M;		break;
	case MGN_12M:	ret = DESC92S_RATE12M;	break;
	case MGN_18M:	ret = DESC92S_RATE18M;	break;
	case MGN_24M:	ret = DESC92S_RATE24M;	break;
	case MGN_36M:	ret = DESC92S_RATE36M;	break;
	case MGN_48M:	ret = DESC92S_RATE48M;	break;
	case MGN_54M:	ret = DESC92S_RATE54M;	break;

	case MGN_MCS0:		ret = DESC92S_RATEMCS0;	break;
	case MGN_MCS1:		ret = DESC92S_RATEMCS1;	break;
	case MGN_MCS2:		ret = DESC92S_RATEMCS2;	break;
	case MGN_MCS3:		ret = DESC92S_RATEMCS3;	break;
	case MGN_MCS4:		ret = DESC92S_RATEMCS4;	break;
	case MGN_MCS5:		ret = DESC92S_RATEMCS5;	break;
	case MGN_MCS6:		ret = DESC92S_RATEMCS6;	break;
	case MGN_MCS7:		ret = DESC92S_RATEMCS7;	break;
	case MGN_MCS8:		ret = DESC92S_RATEMCS8;	break;
	case MGN_MCS9:		ret = DESC92S_RATEMCS9;	break;
	case MGN_MCS10:	ret = DESC92S_RATEMCS10;	break;
	case MGN_MCS11:	ret = DESC92S_RATEMCS11;	break;
	case MGN_MCS12:	ret = DESC92S_RATEMCS12;	break;
	case MGN_MCS13:	ret = DESC92S_RATEMCS13;	break;
	case MGN_MCS14:	ret = DESC92S_RATEMCS14;	break;
	case MGN_MCS15:	ret = DESC92S_RATEMCS15;	break;	

	case MGN_MCS0_SG:	
	case MGN_MCS1_SG:
	case MGN_MCS2_SG:	
	case MGN_MCS3_SG:	
	case MGN_MCS4_SG:	
	case MGN_MCS5_SG:
	case MGN_MCS6_SG:	
	case MGN_MCS7_SG:	
	case MGN_MCS8_SG:	
	case MGN_MCS9_SG:
	case MGN_MCS10_SG:
	case MGN_MCS11_SG:	
	case MGN_MCS12_SG:	
	case MGN_MCS13_SG:	
	case MGN_MCS14_SG:
	case MGN_MCS15_SG:	
			ret = DESC92S_RATEMCS15_SG;
			max_sg_rate = rate&0xf;
			multibss_sg = max_sg_rate | (max_sg_rate<<4) | (max_sg_rate<<8) | (max_sg_rate<<12);
			if (multibss_sg_old != multibss_sg)
			{
				write_nic_dword(dev, SG_RATE, multibss_sg);
				multibss_sg_old = multibss_sg;
			}
			break;


	case (0x80|0x20): 	ret = DESC92S_RATEMCS32; break;

	default:				ret = DESC92S_RATEMCS15;	break;

	}

	return ret;
}

void  rtl8192se_tx_fill_desc(struct net_device* dev, tx_desc * pDesc, cb_desc * cb_desc, struct sk_buff* skb)
{
	u8				*pSeq;
	u16				Temp;
	struct r8192_priv* priv = ieee80211_priv(dev);

	struct ieee80211_hdr_1addr * header = NULL;

	dma_addr_t mapping = pci_map_single(priv->pdev, skb->data, skb->len, PCI_DMA_TODEVICE);

	u16 fc=0, stype=0;
	header = (struct ieee80211_hdr_1addr *)(((u8*)skb->data));
	fc = header->frame_ctl;
	stype = WLAN_FC_GET_STYPE(fc);
	memset((void*)pDesc, 0, 32);		

	{
		
#ifdef _RTL8192_EXT_PATCH_
		if(priv->ieee80211->bUseRAMask){
			if(cb_desc->macId < 32)
			{
				pDesc->MacID = cb_desc->macId;
				pDesc->Rsvd_MacID = cb_desc->macId;
			}
		}
#endif			
		pDesc->TXHT		= (cb_desc->data_rate&0x80)?1:0;	

#if (RTL92SE_FPGA_VERIFY == 0)
		if (priv->card_8192_version== VERSION_8192S_ACUT)
		{
			if (cb_desc->data_rate== MGN_1M || cb_desc->data_rate == MGN_2M || 
				cb_desc->data_rate == MGN_5_5M || cb_desc->data_rate == MGN_11M)
			{
				cb_desc->data_rate = MGN_12M;
			}
		}
#endif			
		pDesc->TxRate	= MRateToHwRate8192SE(dev,cb_desc->data_rate);
		pDesc->TxShort	= QueryIsShort(((cb_desc->data_rate&0x80)?1:0), MRateToHwRate8192SE(dev,cb_desc->data_rate), cb_desc);

		if(cb_desc->bAMPDUEnable)
		{			
			pDesc->AggEn = 1;
		}
		else
		{			
			pDesc->AggEn = 0;
		}

		{
			pSeq = (u8 *)(skb->data+22);
			Temp = pSeq[0];
			Temp <<= 12;			
			Temp |= (*(u16 *)pSeq)>>4;
			pDesc->Seq = Temp;
		}
		
		pDesc->RTSEn	= (cb_desc->bRTSEnable && cb_desc->bCTSEnable==false)?1:0;				
		pDesc->CTS2Self	= (cb_desc->bCTSEnable)?1:0;		
		pDesc->RTSSTBC	= (cb_desc->bRTSSTBC)?1:0;
		pDesc->RTSHT	= (cb_desc->rts_rate&0x80)?1:0;

#if (RTL92SE_FPGA_VERIFY == 0)
		if (priv->card_8192_version== VERSION_8192S_ACUT)
		{
			if (cb_desc->rts_rate == MGN_1M || cb_desc->rts_rate == MGN_2M || 
				cb_desc->rts_rate == MGN_5_5M || cb_desc->rts_rate == MGN_11M)
			{
				cb_desc->rts_rate = MGN_12M;
			}
		}
#endif	
		pDesc->RTSRate	= MRateToHwRate8192SE(dev,cb_desc->rts_rate);
		pDesc->RTSRate	= MRateToHwRate8192SE(dev,MGN_24M);
		pDesc->RTSBW	= 0;
		pDesc->RTSSC	= cb_desc->RTSSC;
		pDesc->RTSShort	= (pDesc->RTSHT==0)?(cb_desc->bRTSUseShortPreamble?1:0):(cb_desc->bRTSUseShortGI?1:0);
		if(priv->CurrentChannelBW == HT_CHANNEL_WIDTH_20_40)
		{
			if(cb_desc->bPacketBW)
			{
				pDesc->TxBw		= 1;
				pDesc->TXSC		= 0;
			}
			else
			{				
				pDesc->TxBw		= 0;
				pDesc->TXSC		= priv->nCur40MhzPrimeSC;
			}
		}
		else
		{
			pDesc->TxBw		= 0;
			pDesc->TXSC		= 0;
		}

		pDesc->LINIP = 0;
		pDesc->Offset = 32;
		pDesc->PktSize = (u16)skb->len;		
		
		pDesc->RaBRSRID = cb_desc->RATRIndex;
#if 0		
printk("*************TXDESC:\n");
printk("\tTxRate: %d\n", pDesc->TxRate);
printk("\tAMPDUEn: %d\n", pDesc->AggEn);
printk("\tTxBw: %d\n", pDesc->TxBw);
printk("\tTXSC: %d\n", pDesc->TXSC);
printk("\tPktSize: %d\n", pDesc->PktSize);
printk("\tRatrIdx: %d\n", pDesc->RaBRSRID);
#endif
		 if (cb_desc->bHwSec) {
       		 static u8 tmp =0;
       		 if (!tmp) {
            		 tmp = 1;
	        	}
#ifdef _RTL8192_EXT_PATCH_
			if(cb_desc->mesh_pkt == 0)
#endif	
			{
				switch (priv->ieee80211->pairwise_key_type) {
					case KEY_TYPE_WEP40:
					case KEY_TYPE_WEP104:
						pDesc->SecType = 0x1;
						break;
					case KEY_TYPE_TKIP:
						pDesc->SecType = 0x2;
						break;
					case KEY_TYPE_CCMP:
						pDesc->SecType = 0x3;
						break;
					case KEY_TYPE_NA:
						pDesc->SecType = 0x0;
						break;
				}
			}
#ifdef _RTL8192_EXT_PATCH_
			else if(cb_desc->mesh_pkt == 1)
			{
				switch (priv->ieee80211->mesh_pairwise_key_type) {
					case KEY_TYPE_WEP40:
					case KEY_TYPE_WEP104:
						pDesc->SecType = 0x1;
						break;
					case KEY_TYPE_TKIP:
						pDesc->SecType = 0x2;
						break;
					case KEY_TYPE_CCMP:
						pDesc->SecType = 0x3;
						break;
					case KEY_TYPE_NA:
						pDesc->SecType = 0x0;
						break;
				}
			}
#endif			
		}

		pDesc->PktID			= 0x0;		
		pDesc->QueueSel		= MapHwQueueToFirmwareQueue(cb_desc->queue_index, cb_desc->priority); 
		
		pDesc->DataRateFBLmt	= 0x1F;		
		pDesc->DISFB	= cb_desc->bTxDisableRateFallBack;
		pDesc->UserRate	= cb_desc->bTxUseDriverAssingedRate;

		if (pDesc->UserRate == true && pDesc->TXHT == true)		
			RF_ChangeTxPath(dev, cb_desc->data_rate);

	}
	

	pDesc->FirstSeg	= 1;
	pDesc->LastSeg	= 1;
	
	pDesc->TxBufferSize= (u16)skb->len;	
	
	pDesc->TxBuffAddr = cpu_to_le32(mapping);

}

void  rtl8192se_tx_fill_cmd_desc(struct net_device* dev, tx_desc_cmd * entry, cb_desc * cb_desc, struct sk_buff* skb)
{
    struct r8192_priv *priv = ieee80211_priv(dev);
    dma_addr_t mapping = pci_map_single(priv->pdev, skb->data, skb->len, PCI_DMA_TODEVICE);
	memset((void*)entry, 0, 32); 	
	
	entry->LINIP = cb_desc->bLastIniPkt;
	entry->FirstSeg = 1;
	entry->LastSeg = 1;
	
	entry->TxBufferSize= (u16)(skb->len);
	entry->TxBufferAddr = cpu_to_le32(mapping);
	entry->PktSize = (u16)(skb->len);
	
	{
		entry->OWN = 1;
	}
}

u8 HwRateToMRate92S(bool bIsHT,	u8 rate)
{
	u8	ret_rate = 0x02;

	if (!bIsHT) {
		switch (rate) {
		case DESC92S_RATE1M:		
			ret_rate = MGN_1M;		
			break;
		case DESC92S_RATE2M:		
			ret_rate = MGN_2M;		
			break;
		case DESC92S_RATE5_5M:		
			ret_rate = MGN_5_5M;		
			break;
		case DESC92S_RATE11M:		
			ret_rate = MGN_11M;		
			break;
		case DESC92S_RATE6M:		
			ret_rate = MGN_6M;		
			break;
		case DESC92S_RATE9M:		
			ret_rate = MGN_9M;		
			break;
		case DESC92S_RATE12M:		
			ret_rate = MGN_12M;		
			break;
		case DESC92S_RATE18M:		
			ret_rate = MGN_18M;		
			break;
		case DESC92S_RATE24M:		
			ret_rate = MGN_24M;		
			break;
		case DESC92S_RATE36M:		
			ret_rate = MGN_36M;		
			break;
		case DESC92S_RATE48M:		
			ret_rate = MGN_48M;		
			break;
		case DESC92S_RATE54M:		
			ret_rate = MGN_54M;		
			break;
		default:							
			ret_rate = 0xff;
			break;
		}
	} else {
		switch (rate) {
		case DESC92S_RATEMCS0:	
			ret_rate = MGN_MCS0;		
			break;
		case DESC92S_RATEMCS1:	
			ret_rate = MGN_MCS1;		
			break;
		case DESC92S_RATEMCS2:	
			ret_rate = MGN_MCS2;		
			break;
		case DESC92S_RATEMCS3:	
			ret_rate = MGN_MCS3;		
			break;
		case DESC92S_RATEMCS4:	
			ret_rate = MGN_MCS4;		
			break;
		case DESC92S_RATEMCS5:	
			ret_rate = MGN_MCS5;		
			break;
		case DESC92S_RATEMCS6:	
			ret_rate = MGN_MCS6;		
			break;
		case DESC92S_RATEMCS7:	
			ret_rate = MGN_MCS7;		
			break;
		case DESC92S_RATEMCS8:	
			ret_rate = MGN_MCS8;		
			break;
		case DESC92S_RATEMCS9:	
			ret_rate = MGN_MCS9;		
			break;
		case DESC92S_RATEMCS10:	
			ret_rate = MGN_MCS10;	
			break;
		case DESC92S_RATEMCS11:	
			ret_rate = MGN_MCS11;	
			break;
		case DESC92S_RATEMCS12:	
			ret_rate = MGN_MCS12;	
			break;
		case DESC92S_RATEMCS13:	
			ret_rate = MGN_MCS13;	
			break;
		case DESC92S_RATEMCS14:	
			ret_rate = MGN_MCS14;	
			break;
		case DESC92S_RATEMCS15:	
			ret_rate = MGN_MCS15;	
			break;
		case DESC92S_RATEMCS32:	
			ret_rate = (0x80|0x20);	
			break;
		default:							
			ret_rate = 0xff;
			break;
		}

	}	
	return ret_rate;
}

bool rtl8192se_rx_query_status_desc(struct net_device* dev, struct ieee80211_rx_stats*  stats, rx_desc *pdesc, struct sk_buff* skb)
{
	struct r8192_priv* priv = ieee80211_priv(dev);
	struct ieee80211_device* ieee = priv->ieee80211;
	u32	PHYStatus	= pdesc->PHYStatus;
	rx_fwinfo*		pDrvInfo;
	stats->Length 		= (u16)pdesc->Length;	
	stats->RxDrvInfoSize = (u8)pdesc->DrvInfoSize*8;
	stats->RxBufShift 	= (u8)((pdesc->Shift)&0x03);      
	stats->bICV 			= (u16)pdesc->ICVError;
	stats->bCRC 			= (u16)pdesc->CRC32;
	stats->bHwError 		= (u16)(pdesc->CRC32|pdesc->ICVError);	
	stats->Decrypted 	= !pdesc->SWDec;
	stats->rate = (u8)pdesc->RxMCS;
	stats->bShortPreamble= (u16)pdesc->SPLCP;
	stats->bIsAMPDU 		= (bool)(pdesc->PAGGR==1);
	stats->bFirstMPDU 	= (bool)((pdesc->PAGGR==1) && (pdesc->FAGGR==1));
	stats->TimeStampLow 	= pdesc->TSFL;
	stats->RxIs40MHzPacket= (bool)pdesc->BandWidth;
	if(IS_UNDER_11N_AES_MODE(ieee))
	{
		if(stats->bICV && !stats->bCRC)
		{
			stats->bICV = false;
			stats->bHwError = false;
		}
	}

	
	if(stats->Length > 0x2000 || stats->Length < 24)
	{
		RT_TRACE(COMP_ERR, "Err RX pkt len = 0x%x\n", stats->Length);
		stats->bHwError |= 1;
	}
	UpdateReceivedRateHistogramStatistics8190(dev, stats);

	if(!stats->bHwError)
		stats->rate = HwRateToMRate92S((bool)(pdesc->RxHT), (u8)(pdesc->RxMCS));
	else
	{
		stats->rate = MGN_1M;
		return false;
	}

	UpdateRxPktTimeStamp8190(dev, stats);	

	if((stats->RxBufShift + stats->RxDrvInfoSize) > 0)
		stats->bShift = 1;	

	if (PHYStatus == true)
	{
		pDrvInfo = (rx_fwinfo*)(skb->data + stats->RxBufShift);
			
		TranslateRxSignalStuff819xpci(dev, skb, stats, pdesc, pDrvInfo); 

	}
	return true;	
}

void rtl8192se_rtx_disable(struct net_device *dev, bool bReset)
{
	struct r8192_priv *priv = ieee80211_priv(dev);
	PRT_POWER_SAVE_CONTROL	pPSC = (PRT_POWER_SAVE_CONTROL)(&(priv->ieee80211->PowerSaveControl));
        int i;
	u8	u1bTmp;

	RT_TRACE(COMP_INIT, "==> rtl8192se_rtx_disable()\n");
	
	priv->ieee80211->state = IEEE80211_NOLINK;
	rtl8192_update_msr(dev);
	if(priv->ieee80211->RfOffReason == RF_CHANGE_BY_IPS && priv->LedStrategy == SW_LED_MODE8)	
	{
		SET_RTL8192SE_RF_SLEEP(dev);
		return;
	}
	if(priv->bDriverIsGoingToUnload)
	write_nic_byte(dev,0x560,0x0);
	u1bTmp = read_nic_byte(dev, LDOV12D_CTRL);
	u1bTmp |= BIT0;
	write_nic_byte(dev, LDOV12D_CTRL, u1bTmp);
	write_nic_byte(dev, SPS1_CTRL, 0x0);
        write_nic_byte(dev, TXPAUSE, 0xFF);
	write_nic_word(dev, CMDR, 0x57FC);
	udelay(100);
	write_nic_word(dev, CMDR, 0x77FC);
	write_nic_byte(dev, PHY_CCA, 0x0);
	udelay(10);
	write_nic_word(dev, CMDR, 0x37FC);
	udelay(10);
	write_nic_word(dev, CMDR, 0x77FC);			
	udelay(10);
	write_nic_word(dev, CMDR, 0x57FC);
	write_nic_word(dev, CMDR, 0x0000);
	u1bTmp = read_nic_byte(dev, (SYS_CLKR + 1));
	
	if(u1bTmp & BIT7)
	{
		u1bTmp &= ~(BIT6 | BIT7);					
		if(!HalSetSysClk8192SE(dev, u1bTmp))
		{
			printk("Switch ctrl path fail\n");
			return;
		}
	}
	
	if(priv->ieee80211->RfOffReason==RF_CHANGE_BY_IPS )
	{
		write_nic_byte(dev, 0x03, 0xF9);
	}
	else		
	{
		printk("Save max pwr\n");
		write_nic_byte(dev, 0x03, 0x71);
	}
	write_nic_byte(dev, SYS_CLKR+1, 0x70);
	write_nic_byte(dev, AFE_PLL_CTRL+1, 0x68);
	write_nic_byte(dev,  AFE_PLL_CTRL, 0x00);	
	write_nic_byte(dev, LDOA15_CTRL, 0x34);
	write_nic_byte(dev, AFE_XTAL_CTRL, 0x0E);
	RT_SET_PS_LEVEL(pPSC, RT_RF_OFF_LEVL_HALT_NIC);
	udelay(100);

	udelay(20);
	if (!bReset) {
		mdelay(20);
	}	
	
        for(i = 0; i < MAX_QUEUE_SIZE; i++) {
                skb_queue_purge(&priv->ieee80211->skb_waitQ [i]);
        }
        for(i = 0; i < MAX_QUEUE_SIZE; i++) {
                skb_queue_purge(&priv->ieee80211->skb_aggQ [i]);
        }
#ifdef _RTL8192_EXT_PATCH_	
		for(i = 0; i < MAX_QUEUE_SIZE; i++) {
                skb_queue_purge(&priv->ieee80211->skb_meshaggQ [i]);
        }
#endif

	skb_queue_purge(&priv->skb_queue);
	RT_TRACE(COMP_INIT, "<== HaltAdapter8192SE()\n");
	return;
}

u8 GetFreeRATRIndex8192SE (struct net_device* dev)
{
	struct r8192_priv* priv = ieee80211_priv(dev);
	u8 bitmap = priv->RATRTableBitmap;
	u8 ratr_index = 0;
	for(	;ratr_index<7; ratr_index++)
	{
		if((bitmap & BIT0) == 0)
			{
				priv->RATRTableBitmap |= BIT0<<ratr_index;
				return ratr_index;
			}
		bitmap = bitmap >>1;
	}
	return ratr_index;
}

void rtl8192se_update_ratr_table(struct net_device* dev,u8* pMcsRate,struct sta_info* pEntry)
{
	struct r8192_priv* priv = ieee80211_priv(dev);
	struct ieee80211_device* ieee = priv->ieee80211;
	u32 ratr_value = 0;
	u8 ratr_index = 0;
	u8 bNMode = 0;
	u16 shortGI_rate = 0;
	u32 tmp_ratr_value = 0;
	u8 MimoPs;
	WIRELESS_MODE WirelessMode;
	u8 bCurTxBW40MHz, bCurShortGI40MHz, bCurShortGI20MHz;
	
	if(ieee->iw_mode == IW_MODE_ADHOC){	

		if(pEntry == NULL){
			printk("Doesn't have match Entry\n");
			return;
		}	

		if(pEntry->ratr_index != 8)
			ratr_index = pEntry->ratr_index;
		else
		        ratr_index = GetFreeRATRIndex8192SE(dev);
		
		if(ratr_index == 7){
			RT_TRACE(COMP_RATE, "Ratrtable are full");
			return;
		}
		MimoPs = pEntry->htinfo.MimoPs;

		if((ieee->mode == WIRELESS_MODE_G) && (pEntry->wireless_mode == WIRELESS_MODE_N_24G))
			WirelessMode = ieee->mode;
		else	
			WirelessMode = pEntry->wireless_mode;

		bCurTxBW40MHz = pEntry->htinfo.bCurTxBW40MHz;
		bCurShortGI40MHz = pEntry->htinfo.bCurShortGI40MHz;
		bCurShortGI20MHz = pEntry->htinfo.bCurShortGI20MHz;		
		pEntry->ratr_index = ratr_index;
	}
	else  
	{
		ratr_index = 0;
		WirelessMode = ieee->mode;
		MimoPs = ieee->pHTInfo->PeerMimoPs;
		bCurTxBW40MHz = ieee->pHTInfo->bCurTxBW40MHz;
		bCurShortGI40MHz = ieee->pHTInfo->bCurShortGI40MHz;
		bCurShortGI20MHz = ieee->pHTInfo->bCurShortGI20MHz;					
	}

	rtl8192_config_rate(dev, (u16*)(&ratr_value));
	ratr_value |= (*(u16*)(pMcsRate)) << 12;
	switch (WirelessMode)
	{
		case IEEE_A:
			ratr_value &= 0x00000FF0;
			break;
		case IEEE_B:
			ratr_value &= 0x0000000D;
			break;
		case IEEE_G:
			ratr_value &= 0x00000FF5;
			break;
		case IEEE_N_24G:
		case IEEE_N_5G:
			bNMode = 1;
			if (MimoPs == 0) 
				ratr_value &= 0x0007F005;
			else{
				if (priv->rf_type == RF_1T2R ||priv->rf_type  == RF_1T1R || (ieee->pHTInfo->IOTAction & HT_IOT_ACT_DISABLE_TX_2SS)){
					if ((bCurTxBW40MHz) && !(ieee->pHTInfo->IOTAction & HT_IOT_ACT_DISABLE_TX_40_MHZ))
						ratr_value &= 0x000FF015;
					else
						ratr_value &= 0x000ff005;
				}else{
					if ((bCurTxBW40MHz) && !(ieee->pHTInfo->IOTAction & HT_IOT_ACT_DISABLE_TX_40_MHZ))
						ratr_value &= 0x0f0ff015;
					else
						ratr_value &= 0x0f0ff005;
					}
			}
			break;
		default:
			printk("====>%s(), mode is not correct:%x\n", __FUNCTION__,WirelessMode);
			break; 
	}
	if (priv->card_8192_version>= VERSION_8192S_BCUT)
		ratr_value &= 0x0FFFFFFF;
	else if (priv->card_8192_version == VERSION_8192S_ACUT)
		ratr_value &= 0x0FFFFFF0;	
	
	if (((ieee->pHTInfo->IOTAction & HT_IOT_ACT_DISABLE_SHORT_GI)==0) &&
		bNMode && ((bCurTxBW40MHz && bCurShortGI40MHz) ||
	    (!bCurTxBW40MHz && bCurShortGI20MHz)))
	{
		ratr_value |= 0x10000000;  
		tmp_ratr_value = (ratr_value>>12);
		for(shortGI_rate=15; shortGI_rate>0; shortGI_rate--)
		{
			if((1<<shortGI_rate) & tmp_ratr_value)
				break;
		}	
		shortGI_rate = (shortGI_rate<<12)|(shortGI_rate<<8)|\
			       (shortGI_rate<<4)|(shortGI_rate);
		write_nic_byte(dev, SG_RATE, shortGI_rate);
	}

	if(ieee->pHTInfo->IOTAction & HT_IOT_ACT_WA_IOT_Broadcom)
	{
		ratr_value &= 0xfffffff0; 
		printk("UpdateHalRATRTable8192SE(), for HT_IOT_ACT_WA_IOT_Broadcom, ratr_value = 0x%x\n", ratr_value);
	}
	
	write_nic_dword(dev, ARFR0+ratr_index*4, ratr_value);
	printk("===========%s: %x\n", __FUNCTION__, read_nic_dword(dev, ARFR0));
	if (ratr_value & 0xfffff000){
		printk("===>set to N mode\n");
		rtl8192se_set_fw_cmd(dev, FW_CMD_RA_REFRESH_N);
	}
	else{
		printk("===>set to B/G mode\n");
		rtl8192se_set_fw_cmd(dev, FW_CMD_RA_REFRESH_BG);
	}
}

int r8192se_resume_firm(struct net_device *dev)
{
	write_nic_byte(dev, 0x42, 0xFF);
	write_nic_word(dev, 0x40, 0x77FC);
	write_nic_word(dev, 0x40, 0x57FC);
	write_nic_word(dev, 0x40, 0x37FC);
	write_nic_word(dev, 0x40, 0x77FC);
	
	udelay(100);

	write_nic_word(dev, 0x40, 0x57FC);
	write_nic_word(dev, 0x40, 0x37FC);
	write_nic_byte(dev, 0x42, 0x00);

	return 0;
}

void PHY_SetRtl8192seRfHalt(struct net_device* dev)
{
	struct r8192_priv* priv = ieee80211_priv(dev);
	PRT_POWER_SAVE_CONTROL	pPSC = (PRT_POWER_SAVE_CONTROL)(&(priv->ieee80211->PowerSaveControl));

	u8 u1bTmp;
	if(priv->ieee80211->RfOffReason == RF_CHANGE_BY_IPS && priv->LedStrategy == SW_LED_MODE8)	
	{
		SET_RTL8192SE_RF_SLEEP(dev);
		return;
	}
	printk("PHY_SetRtl8192seRfHalt save BB/RF\n");
	u1bTmp = read_nic_byte(dev, LDOV12D_CTRL);
	u1bTmp |= BIT0;
	write_nic_byte(dev, LDOV12D_CTRL, u1bTmp);
	write_nic_byte(dev, SPS1_CTRL, 0x0);
	write_nic_byte(dev, TXPAUSE, 0xFF);
	write_nic_word(dev, CMDR, 0x57FC);
	udelay(100);
	write_nic_word(dev, CMDR, 0x77FC);
	write_nic_byte(dev, PHY_CCA, 0x0);
	udelay(10);
	write_nic_word(dev, CMDR, 0x37FC);
	udelay(10);
	write_nic_word(dev, CMDR, 0x77FC);			
	udelay(10);
	write_nic_word(dev, CMDR, 0x57FC);
	write_nic_word(dev, CMDR, 0x0000);
	u1bTmp = read_nic_byte(dev, (SYS_CLKR + 1));
	
	if (u1bTmp & BIT7) {
		u1bTmp &= ~(BIT6 | BIT7);					
		if(!HalSetSysClk8192SE(dev, u1bTmp)) {
			printk("Switch ctrl path fail\n");
			return;
		}
	}

	if(priv->ieee80211->RfOffReason==RF_CHANGE_BY_IPS  && !priv->bDriverIsGoingToUnload)
	{
		write_nic_byte(dev, 0x03, 0xF9);
	} else		
	{
		printk("Save max pwr\n");
		write_nic_byte(dev, 0x03, 0x71);
	}
	write_nic_byte(dev, SYS_CLKR+1, 0x70);
	write_nic_byte(dev, AFE_PLL_CTRL+1, 0x68);
	write_nic_byte(dev,  AFE_PLL_CTRL, 0x00);	
	write_nic_byte(dev, LDOA15_CTRL, 0x34);
	write_nic_byte(dev, AFE_XTAL_CTRL, 0x0E);
	RT_SET_PS_LEVEL(pPSC, RT_RF_OFF_LEVL_HALT_NIC);
	udelay(100);
	udelay(20);
}	


